import React, { useEffect, useState } from "react";
import { StepType } from "../../../types";
import DefaultEmptyTaskpane from "../DefaultTaskpane/DefaultEmptyTaskpane";
import DefaultTaskpane from "../DefaultTaskpane/DefaultTaskpane";
import DefaultTaskpaneBody from "../DefaultTaskpane/DefaultTaskpaneBody";
import DefaultTaskpaneHeader from "../DefaultTaskpane/DefaultTaskpaneHeader";
import Row from "../../spacing/Row";
import Col from "../../spacing/Col";
import Select from "../../elements/Select";
import DropdownItem from "../../elements/DropdownItem";
import { getDisplayColumnHeader, getNewColumnHeader } from "../../../utils/columnHeaders";
import useSendEditOnClick from "../../../hooks/useSendEditOnClick";
import TextButton from "../../elements/TextButton";
import Input from "../../elements/Input";
import '../../../../css/taskpanes/SplitTextToColumns/SplitTextToColumns.css';
import DefaultTaskpaneFooter from "../DefaultTaskpane/DefaultTaskpaneFooter";
import MultiSelectButtonItem from "../../elements/MulitSelectButtonItem";
import { toggleInArray } from "../../../utils/arrays";
import Spacer from "../../spacing/Spacer";
const delimiters = { ',': 'Comma', '-': 'Dash', '\t': 'Tab', ' ': 'Space' };
const getDefaultParams = (startingColumnID, sheetDataArray, sheetIndex) => {
    var _a;
    if (sheetDataArray.length === 0 || sheetDataArray[sheetIndex] === undefined) {
        return undefined;
    }
    let columnID = undefined;
    if (startingColumnID !== undefined && Object.keys(sheetDataArray[sheetIndex].columnIDsMap).includes(startingColumnID)) {
        // If the startingColumnID exists in the sheet, then use it. 
        columnID = startingColumnID;
    }
    else {
        // Otherwise use the first column if there is a column. Otherwise, undefined
        columnID = Object.keys(((_a = sheetDataArray[sheetIndex]) === null || _a === void 0 ? void 0 : _a.columnIDsMap) || {})[0];
    }
    return {
        sheet_index: sheetIndex,
        column_id: columnID,
        delimiters: [],
        new_column_header_suffix: getNewColumnHeader()
    };
};
/*
    This taskpane allows users to split a column into multiple columns
    by separating on a delimeter
*/
const SplitTextToColumnsTaskpane = (props) => {
    var _a, _b;
    const { params, setParams, loading, edit, editApplied, result } = useSendEditOnClick(getDefaultParams(props.startingColumnID, props.sheetDataArray, props.selectedSheetIndex), StepType.SplitTextToColumns, props.mitoAPI, props.analysisData);
    const [preview, setPreview] = useState([]);
    // When the startingColumnID is updated outside of the taskpane, set it as the column getting split
    useEffect(() => {
        setParams(prevParams => {
            const newParams = getDefaultParams(props.startingColumnID, props.sheetDataArray, props.selectedSheetIndex);
            if (newParams) {
                return newParams;
            }
            return prevParams;
        });
    }, [props.startingColumnID]);
    useEffect(() => {
        void loadSplitTextToColumnsPreview();
    }, [params]);
    async function loadSplitTextToColumnsPreview() {
        if (params !== undefined && params.column_id !== undefined && params.delimiters.length > 0) {
            const _splitTextToColumnsPreviewArray = await props.mitoAPI.getSplitTextToColumnsPreview(params);
            if (_splitTextToColumnsPreviewArray !== undefined) {
                setPreview(_splitTextToColumnsPreviewArray);
            }
            else {
                setPreview([]);
            }
        }
        else {
            setPreview([]);
        }
    }
    if (params === undefined || params.column_id === undefined) {
        return (React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState }));
    }
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: "Split Text to Columns", setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Dataframe")),
                React.createElement(Col, null,
                    React.createElement(Select, { width: 'medium-large', value: props.dfNames[params.sheet_index], 
                        // Safe to cast as dfNames are strings
                        onChange: (newSheet) => {
                            setParams(prevParams => {
                                const newSheetIndex = props.dfNames.indexOf(newSheet);
                                const newParams = getDefaultParams(undefined, props.sheetDataArray, newSheetIndex);
                                if (newParams) {
                                    return newParams;
                                }
                                return Object.assign(Object.assign({}, prevParams), { sheet_index: newSheetIndex });
                            });
                        } }, props.dfNames.map(dfName => {
                        return (React.createElement(DropdownItem, { key: dfName, title: dfName }));
                    })))),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Column")),
                React.createElement(Col, null,
                    React.createElement(Select, { width: 'medium-large', 
                        // When undoing right after adding a column, the params.column_id has not yet updated yet, but the sheetData has updated,
                        // so we add a placeholder that is displayed for the fraction of a second before the column_id updates. This avoids a 
                        // sheet crashing bug!
                        value: getDisplayColumnHeader(((_a = props.sheetDataArray[params.sheet_index]) === null || _a === void 0 ? void 0 : _a.columnIDsMap[params.column_id]) || 'select a column'), searchable: true }, Object.entries(((_b = props.sheetDataArray[params.sheet_index]) === null || _b === void 0 ? void 0 : _b.columnIDsMap) || {}).map(([columnID, columnHeader]) => {
                        return (React.createElement(DropdownItem, { key: columnID, title: getDisplayColumnHeader(columnHeader), onClick: () => {
                                setParams(prevParams => {
                                    return Object.assign(Object.assign({}, prevParams), { column_id: columnID });
                                });
                            } }));
                    })))),
            React.createElement(Row, { justify: "space-between" },
                React.createElement(Col, { span: 6 },
                    React.createElement("p", { className: 'text-header-3' }, "Delimiters")),
                React.createElement(Col, { className: "light-gray-container element-width-medium-large" },
                    Object.entries(delimiters).map(([delimiter, delimiterTitle]) => {
                        return (React.createElement(MultiSelectButtonItem, { key: delimiterTitle, id: delimiter, title: delimiterTitle, checked: params.delimiters.includes(delimiter), onToggle: (delimiter) => {
                                setParams(prevParams => {
                                    const newDelimiters = [...prevParams.delimiters];
                                    toggleInArray(newDelimiters, delimiter);
                                    return Object.assign(Object.assign({}, prevParams), { delimiters: newDelimiters });
                                });
                            } }));
                    }),
                    React.createElement(Input, { value: params.delimiters.filter(params_delimiter => !Object.keys(delimiters).includes(params_delimiter))[0], placeholder: "Custom Delimiter", className: 'mt-5px', onChange: (e) => {
                            const newValue = e.target.value;
                            setParams(prevParams => {
                                const newDelimiters = [...prevParams.delimiters].filter(delimiter => Object.keys(delimiters).includes(delimiter));
                                if (newValue !== '') {
                                    newDelimiters.push(newValue);
                                }
                                return Object.assign(Object.assign({}, prevParams), { delimiters: newDelimiters });
                            });
                        } }))),
            React.createElement("div", null,
                React.createElement(Row, null,
                    React.createElement("p", { className: 'text-header-3' }, "Columns Preview")),
                preview.length > 0 &&
                    React.createElement(Row, { style: { width: '100%', overflowX: 'auto' }, suppressTopBottomMargin: true },
                        React.createElement("table", { className: "preview-table", cellSpacing: "0" },
                            React.createElement("tbody", null, preview.map((rowData, idx) => {
                                return (React.createElement("tr", { className: 'preview-table-table-row', key: idx }, rowData.map((cellData, idx) => {
                                    return (React.createElement("td", { className: 'preview-table-table-data', key: idx }, '' + cellData));
                                })));
                            })))),
                preview.length === 0 &&
                    React.createElement(Row, { style: { width: '100%' }, justify: 'center' },
                        React.createElement("p", { className: 'mt-10px' }, "Select a delimiter to preview the split")))),
        React.createElement(DefaultTaskpaneFooter, null,
            React.createElement(TextButton, { variant: 'dark', width: 'block', onClick: () => edit(prevParams => {
                    return Object.assign(Object.assign({}, prevParams), { 
                        // Prepare for the user splitting again by creating a new column suffix,
                        // so that the column headers don't overlap
                        new_column_header_suffix: getNewColumnHeader() });
                }), disabled: params.delimiters.length === 0, disabledTooltip: "Select at least one delimiter" }, !editApplied
                ? `Split on delimiter${params.delimiters.length > 1 ? 's' : ''}`
                : (loading
                    ? 'Splitting column ...'
                    : `Split on delimiter${params.delimiters.length > 1 ? 's' : ''}`)),
            editApplied &&
                React.createElement("p", { className: 'text-subtext-1' },
                    "Created ", result === null || result === void 0 ? void 0 :
                    result.num_cols_created,
                    " new columns"),
            !editApplied &&
                React.createElement(Spacer, { px: 18 }))));
};
export default SplitTextToColumnsTaskpane;
//# sourceMappingURL=SplitTextToColumnsTaskpane.js.map