// Copyright (c) Mito
import React, { useEffect, useState } from 'react';
/*
    Dot, dot, dots. They count, so that you can display something as loading.
*/
const LoadingDots = () => {
    // We use a count to track the number of ...s to display.
    // 0 -> '', 1 -> '.', 2 -> '..', 3 -> '...'. Wraps % 4.
    const [indicatorState, setIndicatorState] = useState(1);
    // Schedule a change to update the loading indicator, every .5 seconds
    useEffect(() => {
        const interval = setInterval(() => {
            setIndicatorState(indicatorState => indicatorState + 1);
        }, 500);
        return () => clearInterval(interval);
    }, []);
    const someNumberOfDots = '.'.repeat(indicatorState % 4);
    return (React.createElement(React.Fragment, null, someNumberOfDots));
};
export default LoadingDots;
//# sourceMappingURL=LoadingDots.js.map