# Seabed

[![tests](https://github.com/noaa-ocs-modeling/seabed/workflows/tests/badge.svg)](https://github.com/noaa-ocs-modeling/seabed/actions?query=workflow%3Atests)
[![build](https://github.com/noaa-ocs-modeling/seabed/workflows/build/badge.svg)](https://github.com/noaa-ocs-modeling/seabed/actions?query=workflow%3Abuild)
[![version](https://img.shields.io/pypi/v/seabed)](https://pypi.org/project/seabed)
[![license](https://img.shields.io/github/license/noaa-ocs-modeling/seabed)](https://creativecommons.org/share-your-work/public-domain/cc0)
[![style](https://sourceforge.net/p/oitnb/code/ci/default/tree/_doc/_static/oitnb.svg?format=raw)](https://sourceforge.net/p/oitnb/code)

parses seabed descriptions from https://www.ngdc.noaa.gov/geosamples/surveydisplay.jsp

## Usage

#### retrieve a list of survey names from the NGBC web page

```python
from seabed import NGDCSeabedDescriptions

surveys = NGDCSeabedDescriptions.all_surveys()

print(surveys)
```

```
['409', '468', '492', '516 516-77', '516 OTTS  2', '516 OTTS 1', '742-10-1-71', '742-10-2-71', '742-10-2-72', '742-10-2-73', '742-10-4-72', '742-10-5-73', '742-20-1-71', '745-26-70 491', '745-38-70 491', '745-41-70 491', 'AHP 1-=10-93', 'AHP-10-5-91', 'AHP-10-6-75', 'AHP-40-1-77', 'AHP-40-2-7', 'AHP-5-2-74', 'AHP-5-4-75', 'AHP-74 437', 'AHP-75 508', 'C33X2 429', 'CHART 13229', 'D00140', 'D00141', 'D00142', 'D218 10-2-78', 'D218 10-3-78', 'DA-10-1-68', 'DA-10-1-71', 'DA-10-1-73', 'DA-10-1-80 N100', 'DA-10-1A-80 N100', 'DA-10-2-71', 'DA-10-2-77', 'DA-10-3-6-65', 'DA-10-4-71', 'DA-10-7-69', 'DA-2 448', 'DA-2.5-1-77', 'DA-2.5-2-77', 'DA-2.5-3-77', 'DA-20-1-77', 'DA-20-1-83, DA-20-2-83', 'DA-20-1-85', 'DA-20-2-85', 'DA-20-3-83 S0902', 'DA-43-72', 'DA-5-3-69', 'DA-50-1-84', 'DA-50-1-85', 'DA-50-2-84', 'DA-50-2-85', 'DA-50-3-84', 'DA-50-3-85', 'DA-50-4-85', 'DA-50-5-85', 'DA-50-6-85', 'DA-50-7-85', 'DA-50-8-85', 'DI-87-13 M540', 'F00240', 'F00244', 'F00250', 'F00251', 'F00267', 'F00350', 'F00407', 'F00431', 'F00432', 'F00448', 'F00575', 'F00598', 'F00601', 'F00629', 'F00632', 'F00638', 'F00642', 'F00643', 'F00646', 'F00647', 'F00668', 'F00719', 'F00722', 'F00738', 'F00739', 'F00740', 'F00741', 'F00742', 'F00743', 'F00744', 'F00747', 'F00748', 'F00749', 'F00773', 'F00785', 'F00797', 'F241-NEW-RIVER', 'FA 10-5-76', 'FA-1-1-79', 'FA-10-2-88', 'FA-10-3-76', 'FA-20-1-75', 'FA-20-1-77', 'FA-20-3-73 460', 'FA-2A-72', 'FA-5-1-80', 'G302 5-1-78', 'G302 5-8-77', 'H00258', 'H00581', 'H00917', 'H00991', 'H00999', 'H01047', 'H01148A', 'H01148B', 'H01156', 'H01184', 'H01232A', 'H01232B', 'H01232C', 'H01233A', 'H01233B', 'H01234A', 'H01234B', 'H01280B', 'H01289B', 'H01289C', 'H01291', 'H01331A', 'H01377A', 'H01388A', 'H01390', 'H01416', 'H01489', 'H01491A', 'H01491B', 'H01513A', 'H01513B', 'H01541', 'H01542A', 'H01570', 'H01592A', 'H01603B', 'H01603C', 'H01618A', 'H01637B', 'H01641', 'H01721', 'H01761', 'H01770', 'H01774', 'H01777', 'H01819', 'H01821', 'H01822', 'H01828', 'H01846', 'H01848', 'H01850', 'H01853', 'H01854', 'H01855', 'H01858', 'H01859', 'H01867', 'H01887', 'H01909', 'H01910', 'H01911', 'H01912', 'H01913', 'H01914', 'H01915', 'H01916', 'H01917', 'H01946', 'H01948', 'H01954', 'H01996', 'H02008', 'H02010', 'H02011', 'H02049', 'H02072', 'H02079', 'H02080', 'H02096', 'H02103', 'H02136', 'H02137', 'H02138', 'H02139', 'H02142', 'H02157', 'H02159', 'H02170', 'H02171', 'H02172', 'H02173', 'H02175', 'H02211', 'H02215', 'H02216', 'H02241', 'H02277', 'H02295', 'H02341', 'H02342', 'H02368', 'H02369', 'H02370', 'H02416', 'H02452', 'H02461', 'H02477', 'H02499', 'H02503', 'H02508', 'H02557', 'H02558', 'H02604', 'H02619', 'H02628', 'H02658', 'H02663', 'H02715A', 'H02782', 'H02857', 'H02858', 'H02869', 'H02920C', 'H02922', 'H02961', 'H02962', 'H02971', 'H02981B', 'H02996', 'H02997', 'H02998', 'H03013', 'H03015', 'H03024', 'H03042', 'H03178', 'H03181', 'H03186', 'H03190', 'H03193', 'H03194', 'H03203', 'H03211', 'H03291', 'H03303', 'H03305', 'H03390', 'H03409', 'H03410', 'H03411', 'H03416', 'H03417', 'H03427', 'H03431', 'H03432', 'H03519', 'H03532', 'H03533', 'H03539', 'H03540', 'H03547', 'H03550', 'H03551', 'H03553', 'H03569', 'H03574', 'H03578', 'H03579', 'H03654', 'H03674', 'H03678', 'H03679', 'H03682', 'H03691', 'H03692', 'H03696', 'H03704', 'H03706', 'H03713', 'H03714', 'H03715', 'H03724', 'H03725', 'H03781', 'H03787', 'H03789', 'H03795', 'H03796', 'H03800', 'H03802', 'H03806', 'H03807', 'H03808', 'H03809', 'H03816', 'H03818', 'H03819A', 'H03819B', 'H03880', 'H03931', 'H03932', 'H03933', 'H03940', 'H03954', 'H03958', 'H03959', 'H03961', 'H03998', 'H04000', 'H04002', 'H04009', 'H04021', 'H04084', 'H04139', 'H04148', 'H04156', 'H04158', 'H04160', 'H04161', 'H04171', 'H04188', 'H04191', 'H04208A', 'H04208B', 'H04212', 'H04219', 'H04222', 'H04251', 'H04261A', 'H04325', 'H04326', 'H04331', 'H04374', 'H04381', 'H04389', 'H04391', 'H04393', 'H04394', 'H04397', 'H04398', 'H04431', 'H04432', 'H04441', 'H04443A', 'H04445', 'H04446', 'H04450', 'H04469', 'H04471', 'H04475', 'H04478', 'H04483', 'H04484', 'H04490', 'H04491', 'H04496', 'H04498', 'H04499', 'H04500', 'H04502', 'H04506', 'H04509', 'H04510', 'H04514A', 'H04515', 'H04516', 'H04517A', 'H04521', 'H04524', 'H04525A', 'H04526', 'H04527', 'H04528', 'H04529', 'H04530', 'H04534', 'H04535', 'H04536', 'H04537', 'H04538', 'H04539', 'H04540', 'H04541', 'H04548', 'H04552', 'H04553', 'H04594', 'H04597A', 'H04597B', 'H04600', 'H04601', 'H04602', 'H04603', 'H04605', 'H04608', 'H04614', 'H04622A', 'H04623A', 'H04624', 'H04625', 'H04626A', 'H04627', 'H04630', 'H04631', 'H04632', 'H04640', 'H04641', 'H04648', 'H04649', 'H04654', 'H04673', 'H04690', 'H04691', 'H04692', 'H04693', 'H04697', 'H04698', 'H04701', 'H04702', 'H04703', 'H04704', 'H04705', 'H04706', 'H04707', 'H04708', 'H04709', 'H04717', 'H04718', 'H04719', 'H04721', 'H04730', 'H04731', 'H04759', 'H04760', 'H04761A', 'H04762', 'H04767', 'H04773', 'H04774', 'H04792', 'H04793', 'H04811', 'H04818', 'H04825', 'H04830', 'H04836', 'H04838', 'H04842', 'H04844', 'H04845A', 'H04846', 'H04847', 'H04854', 'H04856', 'H04866', 'H04867', 'H04871', 'H04900', 'H04910', 'H04913', 'H04914', 'H04923', 'H04933', 'H04934', 'H04948', 'H04949', 'H04950', 'H04952', 'H04953', 'H04954', 'H04956', 'H04963', 'H04968', 'H04969', 'H04970', 'H04971', 'H04972', 'H04973', 'H04993', 'H05000', 'H05015', 'H05321', 'H05643', 'H05644', 'H05672', 'H05728', 'H05737', 'H05738', 'H05739', 'H05740', 'H05744', 'H05745', 'H05759', 'H05761', 'H05762', 'H05763', 'H05948', 'H05949', 'H05964', 'H05965', 'H05966', 'H05967', 'H05970', 'H05971', 'H05972', 'H05973', 'H05974', 'H05977', 'H05978', 'H05979', 'H05980', 'H06109', 'H06110', 'H06111', 'H06112', 'H06139', 'H06146', 'H06150', 'H06160', 'H06175', 'H06176', 'H06183', 'H06212', 'H06229', 'H06233', 'H06234', 'H06235', 'H06241', 'H06255', 'H06256', 'H06257', 'H06265', 'H06274', 'H06277', 'H06278', 'H06279', 'H06286', 'H06287', 'H06288', 'H06303', 'H06319', 'H06377', 'H06378', 'H06379', 'H06380', 'H06381', 'H06382', 'H06383', 'H06386', 'H06387', 'H06388', 'H06389', 'H06412', 'H06413', 'H06414', 'H06464', 'H06465', 'H06466', 'H06467', 'H06478', 'H06484', 'H06499A', 'H06499B', 'H06503', 'H06504', 'H06505', 'H06506', 'H06507', 'H06509', 'H06510', 'H06568', 'H06569', 'H06570', 'H06571', 'H06572', 'H06573', 'H06610', 'H06611', 'H06695', 'H06696', 'H06697', 'H06698', 'H06700', 'H06845', 'H06846', 'H06847', 'H06848', 'H06850', 'H06865', 'H06866', 'H06867', 'H06868', 'H06869', 'H06870', 'H06872', 'H06874', 'H06875', 'H06879', 'H06883', 'H06910', 'H06914', 'H06915', 'H06916', 'H06917', 'H06918', 'H06920', 'H06924', 'H06933', 'H06937', 'H06939', 'H06940', 'H06987', 'H06988', 'H06990', 'H06991', 'H06999', 'H07000', 'H07004', 'H07005', 'H07006', 'H07007', 'H07013', 'H07014', 'H07015', 'H07016', 'H07017', 'H07018', 'H07023', 'H07026', 'H07033', 'H07038', 'H07039', 'H07040', 'H07042', 'H07050', 'H07051', 'H07052', 'H07053', 'H07078', 'H07079', 'H07081', 'H07084', 'H07125', 'H07182', 'H07183', 'H07595', 'H07605', 'H07626', 'H07644', 'H07645', 'H07646', 'H07647', 'H07648', 'H07649', 'H07653', 'H07654', 'H07707', 'H07708', 'H07710', 'H07711', 'H07722', 'H07726', 'H07727', 'H07731', 'H07733', 'H07734', 'H07735', 'H07736', 'H07737', 'H07738', 'H07739', 'H07740', 'H07770', 'H07788', 'H07818', 'H07825', 'H07888', 'H07889', 'H07890', 'H07891', 'H07912', 'H07972', 'H07973', 'H07974', 'H07975', 'H07976', 'H07977', 'H07992', 'H08004', 'H08051', 'H08052', 'H08053', 'H08054', 'H08055', 'H08056', 'H08057', 'H08061', 'H08065A', 'H08065B', 'H08066', 'H08112', 'H08140', 'H08141', 'H08142', 'H08143', 'H08144', 'H08145', 'H08146', 'H08204', 'H08205', 'H08228', 'H08233', 'H08234', 'H08235', 'H08236', 'H08237', 'H08238', 'H08239', 'H08240', 'H08305', 'H08306', 'H08307', 'H08308', 'H08309', 'H08311', 'H08325', 'H08331', 'H08333', 'H08386', 'H08387', 'H08393', 'H08432', 'H08433', 'H08434', 'H08438', 'H08439', 'H08444', 'H08455', 'H08456', 'H08457', 'H08473', 'H08474', 'H08475', 'H08476', 'H08485', 'H08486', 'H08487', 'H08488', 'H08537', 'H08576', 'H08580', 'H08582', 'H08583', 'H08595', 'H08606', 'H08621', 'H08655', 'H08656', 'H08657', 'H08661', 'H08662', 'H08663', 'H08664', 'H08672', 'H08674', 'H08678', 'H08679', 'H08680', 'H08681', 'H08682', 'H08684', 'H08686', 'H08687', 'H08717', 'H08721', 'H08761', 'H08762', 'H08763', 'H08778', 'H08780', 'H08789', 'H08792', 'H08799', 'H08812', 'H08815', 'H08816', 'H08818', 'H08819', 'H08820', 'H08821', 'H08822', 'H08823', 'H08824', 'H08825', 'H08826', 'H08827', 'H08828', 'H08830', 'H08831', 'H08832', 'H08834', 'H08835', 'H08836', 'H08838', 'H08841', 'H08843', 'H08845', 'H08846', 'H08847', 'H08856', 'H08859', 'H08860', 'H08861', 'H08874', 'H08875', 'H08881', 'H08882', 'H08886', 'H08887', 'H08888', 'H08891', 'H08899', 'H08901', 'H08902', 'H08903', 'H08905', 'H08926', 'H08927', 'H08928', 'H08929', 'H08930', 'H08933', 'H08945', 'H08946', 'H08947', 'H08948', 'H08949', 'H08950', 'H08951', 'H08952', 'H08953', 'H08954', 'H08955', 'H08956', 'H08957', 'H08958', 'H08959', 'H08960', 'H08961', 'H08962', 'H08964', 'H08965', 'H08967', 'H08978', 'H08979', 'H08980', 'H08984', 'H08985', 'H08986', 'H08987', 'H08988', 'H08990', 'H08996', 'H08997', 'H09000', 'H09001', 'H09003', 'H09004', 'H09006', 'H09008', 'H09009', 'H09010', 'H09011', 'H09012', 'H09013', 'H09014', 'H09015', 'H09017', 'H09018', 'H09019', 'H09027A', 'H09028', 'H09030', 'H09031', 'H09032', 'H09040', 'H09041', 'H09042', 'H09043', 'H09044', 'H09045', 'H09046', 'H09047', 'H09049', 'H09050', 'H09051', 'H09052', 'H09053', 'H09054', 'H09055', 'H09056', 'H09057', 'H09058', 'H09059', 'H09060', 'H09061', 'H09062', 'H09063', 'H09064', 'H09066', 'H09067', 'H09068', 'H09069', 'H09070', 'H09071', 'H09072', 'H09073', 'H09077', 'H09078', 'H09079', 'H09080', 'H09081', 'H09082', 'H09084', 'H09085', 'H09086', 'H09087', 'H09088', 'H09089', 'H09090', 'H09091', 'H09092', 'H09093', 'H09094', 'H09095', 'H09096', 'H09100', 'H09101', 'H09102', 'H09104', 'H09105', 'H09106', 'H09107', 'H09108', 'H09109', 'H09110', 'H09111', 'H09112', 'H09113', 'H09114', 'H09115', 'H09116', 'H09117', 'H09118', 'H09119', 'H09120', 'H09121', 'H09122', 'H09123', 'H09124', 'H09125', 'H09126', 'H09127', 'H09128', 'H09131', 'H09132', 'H09133', 'H09134', 'H09135', 'H09136', 'H09137', 'H09138', 'H09139', 'H09140', 'H09141', 'H09142', 'H09143', 'H09144', 'H09145', 'H09150', 'H09151', 'H09153', 'H09154', 'H09155', 'H09156', 'H09157', 'H09158', 'H09159', 'H09160', 'H09161', 'H09167', 'H09168', 'H09169', 'H09171', 'H09177', 'H09181', 'H09182', 'H09183', 'H09184', 'H09186', 'H09188', 'H09189', 'H09190', 'H09191', 'H09192', 'H09193', 'H09194', 'H09195', 'H09196', 'H09197', 'H09198', 'H09201', 'H09202', 'H09203', 'H09204', 'H09205', 'H09206', 'H09207', 'H09209', 'H09211', 'H09212', 'H09213', 'H09214', 'H09215', 'H09217', 'H09218', 'H09219', 'H09220', 'H09221', 'H09222', 'H09223', 'H09224', 'H09225', 'H09226', 'H09229', 'H09230', 'H09231', 'H09232', 'H09233', 'H09234', 'H09235', 'H09236', 'H09237', 'H09241', 'H09244', 'H09245', 'H09246', 'H09248', 'H09249', 'H09250', 'H09251', 'H09252', 'H09253', 'H09254', 'H09260', 'H09261', 'H09262', 'H09264', 'H09265', 'H09266', 'H09267', 'H09268', 'H09269', 'H09271', 'H09272', 'H09273', 'H09274', 'H09275', 'H09276', 'H09277', 'H09278', 'H09279', 'H09285', 'H09286', 'H09287', 'H09288', 'H09289', 'H09290', 'H09291', 'H09292', 'H09299', 'H09301', 'H09302', 'H09303', 'H09304', 'H09305', 'H09306', 'H09307', 'H09308A', 'H09308B', 'H09310', 'H09311', 'H09312', 'H09314', 'H09315', 'H09316', 'H09320', 'H09321', 'H09322', 'H09323', 'H09324', 'H09325', 'H09327', 'H09328', 'H09329', 'H09330', 'H09331', 'H09332', 'H09333', 'H09334', 'H09335', 'H09336B', 'H09338', 'H09343', 'H09344', 'H09346', 'H09350', 'H09351', 'H09352', 'H09353', 'H09356', 'H09357', 'H09358', 'H09360', 'H09361A', 'H09361B', 'H09363', 'H09364', 'H09365', 'H09366', 'H09367', 'H09369', 'H09370', 'H09371', 'H09372', 'H09373', 'H09375', 'H09376', 'H09377', 'H09378', 'H09379', 'H09380', 'H09381', 'H09382', 'H09383', 'H09384', 'H09385', 'H09386', 'H09387', 'H09388', 'H09389', 'H09391', 'H09392', 'H09393', 'H09394', 'H09395', 'H09396', 'H09398', 'H09399', 'H09400', 'H09401', 'H09402', 'H09403', 'H09404', 'H09405', 'H09407', 'H09408', 'H09409', 'H09410', 'H09414', 'H09415', 'H09416', 'H09417', 'H09419', 'H09421', 'H09422', 'H09423', 'H09424', 'H09426', 'H09427', 'H09428', 'H09429', 'H09430', 'H09431', 'H09432', 'H09433', 'H09435', 'H09436', 'H09437', 'H09441', 'H09442', 'H09444', 'H09445', 'H09446', 'H09447', 'H09449', 'H09450', 'H09451', 'H09453', 'H09454', 'H09455', 'H09456', 'H09457', 'H09459', 'H09460', 'H09461', 'H09462', 'H09463', 'H09464', 'H09465', 'H09467', 'H09468', 'H09469', 'H09470', 'H09471', 'H09472', 'H09473', 'H09474', 'H09476', 'H09481', 'H09482A', 'H09483', 'H09485', 'H09486', 'H09487', 'H09489', 'H09490', 'H09491', 'H09492', 'H09493', 'H09494', 'H09495', 'H09496', 'H09497', 'H09498', 'H09499', 'H09501', 'H09507', 'H09509', 'H09510', 'H09511', 'H09514', 'H09515', 'H09516', 'H09517', 'H09518', 'H09519', 'H09520', 'H09521', 'H09522', 'H09523', 'H09524', 'H09525', 'H09526', 'H09527', 'H09528', 'H09529', 'H09530', 'H09539', 'H09540', 'H09541', 'H09543', 'H09544', 'H09545', 'H09547', 'H09551', 'H09554', 'H09555', 'H09557', 'H09562', 'H09563', 'H09564', 'H09565', 'H09566', 'H09570', 'H09571', 'H09572', 'H09578', 'H09579', 'H09580', 'H09581', 'H09582', 'H09583', 'H09584', 'H09585', 'H09586', 'H09588', 'H09589', 'H09590', 'H09592', 'H09593', 'H09594', 'H09597', 'H09599', 'H09601', 'H09602', 'H09603', 'H09604', 'H09605', 'H09606', 'H09607', 'H09609', 'H09612', 'H09613', 'H09614', 'H09615', 'H09616', 'H09617', 'H09618', 'H09619', 'H09620', 'H09621', 'H09622', 'H09623', 'H09624', 'H09625', 'H09626', 'H09628', 'H09629', 'H09630', 'H09634', 'H09636', 'H09637', 'H09639', 'H09640', 'H09641', 'H09642', 'H09643', 'H09644', 'H09645', 'H09646', 'H09647', 'H09648', 'H09649', 'H09650', 'H09651', 'H09652', 'H09653', 'H09655', 'H09656', 'H09657', 'H09659', 'H09661', 'H09663', 'H09665', 'H09666', 'H09667', 'H09668', 'H09669', 'H09670', 'H09671', 'H09672', 'H09673', 'H09674', 'H09675', 'H09678', 'H09679', 'H09682', 'H09684', 'H09686', 'H09687', 'H09688', 'H09690', 'H09695', 'H09696', 'H09697', 'H09698', 'H09699', 'H09705', 'H09706', 'H09707', 'H09708', 'H09711', 'H09712', 'H09716', 'H09717', 'H09719', 'H09724', 'H09725', 'H09726', 'H09727', 'H09728', 'H09729', 'H09730', 'H09732', 'H09733', 'H09734', 'H09735', 'H09737', 'H09740', 'H09741', 'H09742', 'H09743', 'H09746', 'H09747', 'H09748', 'H09751', 'H09752', 'H09754', 'H09755', 'H09756', 'H09757', 'H09761', 'H09762', 'H09763', 'H09765', 'H09768', 'H09769', 'H09770', 'H09771', 'H09773', 'H09774', 'H09775', 'H09776', 'H09777', 'H09781', 'H09782', 'H09783', 'H09784', 'H09785', 'H09786', 'H09787', 'H09789', 'H09790', 'H09791', 'H09792', 'H09793', 'H09794', 'H09795', 'H09797', 'H09798', 'H09799', 'H09800', 'H09801', 'H09802', 'H09803', 'H09804', 'H09805', 'H09806', 'H09807', 'H09808', 'H09810', 'H09811', 'H09812', 'H09819', 'H09820', 'H09821', 'H09834', 'H09838', 'H09842', 'H09843', 'H09846', 'H09849', 'H09859', 'H09860', 'H09861', 'H09862', 'H09864', 'H09866', 'H09867', 'H09868', 'H09872', 'H09879', 'H09883', 'H09885', 'H09886', 'H09895', 'H09908', 'H09909', 'H09912', 'H09915', 'H09920', 'H09924', 'H09925', 'H09928', 'H09929', 'H09930', 'H09931', 'H09934', 'H09935', 'H09937', 'H09938', 'H09939', 'H09943', 'H09944', 'H09954', 'H09957', 'H09963', 'H09964', 'H09968', 'H09971', 'H09974', 'H09975', 'H09983', 'H09984', 'H09986', 'H09987', 'H09988', 'H09989', 'H09994', 'H09995', 'H09996', 'H09999', 'H10000', 'H10001', 'H10002', 'H10003', 'H10005', 'H10006', 'H10007', 'H10008', 'H10009', 'H10012', 'H10013', 'H10014', 'H10015', 'H10016', 'H10017', 'H10018', 'H10022', 'H10027', 'H10029', 'H10030', 'H10032', 'H10033', 'H10038', 'H10040', 'H10042', 'H10047', 'H10048', 'H10050', 'H10051', 'H10053', 'H10055', 'H10056', 'H10057', 'H10058', 'H10059', 'H10060', 'H10061', 'H10063', 'H10064', 'H10065', 'H10067', 'H10068', 'H10069', 'H10070', 'H10071', 'H10072', 'H10073', 'H10074', 'H10077', 'H10080', 'H10081', 'H10082', 'H10086', 'H10091', 'H10092', 'H10097', 'H10098', 'H10099', 'H10101', 'H10102', 'H10104', 'H10105', 'H10106', 'H10109', 'H10110', 'H10111', 'H10112', 'H10114', 'H10115', 'H10117', 'H10118', 'H10120', 'H10121', 'H10122', 'H10123', 'H10124', 'H10125', 'H10126', 'H10127', 'H10128', 'H10130', 'H10131', 'H10132', 'H10133', 'H10134', 'H10136', 'H10138', 'H10146', 'H10151A', 'H10152', 'H10154', 'H10155', 'H10157', 'H10158', 'H10159', 'H10160', 'H10161', 'H10163', 'H10164', 'H10165', 'H10166', 'H10167', 'H10168', 'H10170', 'H10171', 'H10172', 'H10173', 'H10174', 'H10175', 'H10176', 'H10177', 'H10178', 'H10179', 'H10180', 'H10182', 'H10184', 'H10185', 'H10186', 'H10188', 'H10190', 'H10191', 'H10192', 'H10194', 'H10197', 'H10198', 'H10199', 'H10200', 'H10201', 'H10202', 'H10203', 'H10204', 'H10205', 'H10206', 'H10207', 'H10209', 'H10211', 'H10213', 'H10214', 'H10215', 'H10216', 'H10217', 'H10218', 'H10219', 'H10220', 'H10222', 'H10223', 'H10225', 'H10226', 'H10227', 'H10228', 'H10230', 'H10231', 'H10235', 'H10236', 'H10237', 'H10238', 'H10239', 'H10240', 'H10241', 'H10242', 'H10243', 'H10244', 'H10245', 'H10246', 'H10247', 'H10248', 'H10249', 'H10251', 'H10253', 'H10254', 'H10255', 'H10256', 'H10257', 'H10258', 'H10259', 'H10260', 'H10261', 'H10262', 'H10264', 'H10265', 'H10266', 'H10267', 'H10268', 'H10269', 'H10271', 'H10272', 'H10273', 'H10274', 'H10275', 'H10276', 'H10277', 'H10278', 'H10279', 'H10280', 'H10281', 'H10282', 'H10283', 'H10284', 'H10285', 'H10286', 'H10287', 'H10288', 'H10289', 'H10290', 'H10291', 'H10293', 'H10294', 'H10295', 'H10296', 'H10297', 'H10298', 'H10300', 'H10301', 'H10302', 'H10304', 'H10305', 'H10307', 'H10308', 'H10310', 'H10311', 'H10312', 'H10313', 'H10314', 'H10318', 'H10319', 'H10320', 'H10321', 'H10322', 'H10324', 'H10325', 'H10326', 'H10327', 'H10328', 'H10329', 'H10330', 'H10332', 'H10333', 'H10334', 'H10335', 'H10336', 'H10337', 'H10338', 'H10340', 'H10341', 'H10344', 'H10345', 'H10352', 'H10355', 'H10356', 'H10357', 'H10358', 'H10359', 'H10360', 'H10361', 'H10362', 'H10363', 'H10364', 'H10365', 'H10366', 'H10367', 'H10368', 'H10369', 'H10370', 'H10371', 'H10374', 'H10376', 'H10377', 'H10379', 'H10380', 'H10381', 'H10382', 'H10384', 'H10385', 'H10386', 'H10388', 'H10390', 'H10391', 'H10392', 'H10395', 'H10396', 'H10397', 'H10399', 'H10400', 'H10401', 'H10402', 'H10405', 'H10406', 'H10407', 'H10408', 'H10411', 'H10412', 'H10414', 'H10415', 'H10416', 'H10417', 'H10419', 'H10420', 'H10425', 'H10426', 'H10429', 'H10436', 'H10449', 'H10450', 'H10454', 'H10455', 'H10457', 'H10459', 'H10460', 'H10462', 'H10468', 'H10469', 'H10470', 'H10472', 'H10473', 'H10474', 'H10477', 'H10478', 'H10479', 'H10481', 'H10482', 'H10484', 'H10486', 'H10487', 'H10488', 'H10490', 'H10491', 'H10492', 'H10493', 'H10497', 'H10499', 'H10500', 'H10501', 'H10502', 'H10503', 'H10507', 'H10512', 'H10513', 'H10514', 'H10515', 'H10516', 'H10517', 'H10521', 'H10522', 'H10523', 'H10524', 'H10525', 'H10526', 'H10527', 'H10528', 'H10531', 'H10532', 'H10536', 'H10543', 'H10544', 'H10546', 'H10549', 'H10550', 'H10551', 'H10552', 'H10553', 'H10554', 'H10557', 'H10576', 'H10577', 'H10580', 'H10581', 'H10582', 'H10591', 'H10592', 'H10593', 'H10594', 'H10595', 'H10596', 'H10597', 'H10599', 'H10600', 'H10601', 'H10602', 'H10603', 'H10604', 'H10606', 'H10607', 'H10609', 'H10619', 'H10620', 'H10622', 'H10624', 'H10627', 'H10629', 'H10630', 'H10631', 'H10642', 'H10643', 'H10656', 'H10667', 'H10669', 'H10670', 'H10671', 'H10672', 'H10673', 'H10674', 'H10676', 'H10677', 'H10678', 'H10679', 'H10680', 'H10681', 'H10682', 'H10684', 'H10685', 'H10687', 'H10688', 'H10689', 'H10690', 'H10692', 'H10693', 'H10694', 'H10695', 'H10696', 'H10697', 'H10698', 'H10699', 'H10700', 'H10701', 'H10702', 'H10703', 'H10704', 'H10705', 'H10709', 'H10710', 'H10712', 'H10713', 'H10714', 'H10715', 'H10716', 'H10717', 'H10718', 'H10719', 'H10721', 'H10722', 'H10723', 'H10724', 'H10725', 'H10726', 'H10727', 'H10729', 'H10730', 'H10731', 'H10732', 'H10733', 'H10734A', 'H10734B', 'H10735', 'H10736', 'H10737', 'H10738', 'H10739', 'H10740', 'H10742', 'H10743', 'H10744', 'H10746', 'H10751', 'H10753', 'H10754', 'H10755', 'H10756', 'H10757', 'H10759', 'H10760', 'H10761', 'H10762', 'H10764', 'H10765', 'H10766', 'H10767', 'H10768', 'H10769', 'H10770', 'H10773', 'H10774', 'H10775', 'H10776', 'H10777', 'H10778', 'H10779', 'H10780', 'H10782', 'H10783', 'H10784', 'H10785', 'H10786', 'H10787', 'H10789', 'H10790', 'H10791', 'H10792', 'H10793', 'H10794', 'H10795', 'H10796', 'H10797', 'H10798', 'H10799', 'H10800', 'H10801', 'H10806', 'H10807', 'H10808', 'H10809', 'H10810', 'H10811', 'H10812', 'H10813', 'H10814', 'H10815', 'H10816', 'H10818', 'H10820', 'H10823', 'H10824', 'H10825', 'H10826', 'H10827', 'H10828', 'H10829', 'H10830', 'H10831', 'H10832', 'H10837', 'H10838', 'H10839', 'H10840', 'H10841', 'H10842', 'H10843', 'H10844', 'H10845', 'H10846', 'H10847', 'H10849', 'H10852', 'H10853', 'H10855', 'H10856', 'H10857', 'H10858', 'H10859', 'H10860', 'H10861', 'H10862', 'H10863', 'H10864', 'H10865', 'H10866', 'H10869', 'H10870', 'H10877', 'H10878', 'H10879', 'H10880', 'H10881', 'H10882', 'H10883', 'H10885', 'H10887', 'H10901', 'H10902', 'H10905', 'H10911', 'H10917', 'H10918', 'H10919', 'H10920', 'H10921', 'H10922', 'H10923', 'H10926', 'H10927', 'H10928', 'H10929', 'H10930', 'H10931', 'H10932', 'H10933', 'H10935', 'H10936', 'H10937', 'H10938', 'H10939', 'H10940', 'H10944', 'H10946', 'H10953', 'H10954', 'H10964', 'H10968', 'H10969', 'H10994', 'H10998', 'H11010', 'H11011', 'H11022', 'H11023', 'H11028', 'H11035', 'H11036', 'H11043', 'H11044', 'H11070', 'H11081', 'H11104', 'H11197', 'H11198', 'H11206', 'H11207', 'H11241', 'H11318', 'H11459', 'H11460', 'H11461', 'H11462', 'H11555', 'H11621', 'H11650', 'H11710', 'H11713', 'H11818', 'H11831', 'H11918', 'H11930', 'H12003', 'H12016', 'H12017', 'H12023', 'H12042', 'H12048', 'H12049', 'H12054', 'H12055', 'H12056', 'H12060', 'H12061', 'H12062', 'H12069', 'H12082', 'H12091', 'H12093', 'H12094', 'H12120', 'H12133', 'H12143', 'H12154', 'H12155', 'H12157', 'H12160', 'H12161', 'H12164', 'H12165', 'H12166', 'H12167', 'H12168', 'H12169', 'H12170', 'H12177', 'H12180', 'H12183', 'H12185', 'H12191', 'H12192', 'H12193', 'H12194', 'H12196', 'H12197', 'H12198', 'H12200', 'H12201', 'H12202', 'H12203', 'H12226', 'H12228', 'H12229', 'H12232', 'H12236', 'H12237', 'H12241', 'H12257', 'H12258', 'H12262', 'H12265', 'H12266', 'H12267', 'H12274', 'H12275', 'H12277', 'H12279', 'H12280', 'H12281', 'H12289', 'H12290', 'H12292', 'H12298', 'H12299', 'H12304', 'H12305', 'H12306', 'H12307', 'H12309', 'H12311', 'H12312', 'H12313', 'H12317', 'H12318', 'H12320', 'H12321', 'H12322', 'H12324', 'H12325', 'H12326', 'H12327', 'H12328', 'H12330', 'H12332', 'H12334', 'H12335', 'H12336', 'H12337', 'H12338', 'H12339', 'H12341', 'H12343', 'H12346', 'H12348', 'H12349', 'H12350', 'H12351', 'H12352', 'H12353', 'H12354', 'H12355', 'H12356', 'H12357', 'H12358', 'H12359', 'H12360', 'H12361', 'H12367', 'H12368', 'H12369', 'H12370', 'H12371', 'H12372', 'H12376', 'H12395', 'H12397', 'H12398', 'H12399', 'H12400', 'H12401', 'H12402', 'H12403', 'H12404', 'H12405', 'H12407', 'H12411', 'H12412', 'H12415', 'H12419', 'H12420', 'H12421', 'H12424', 'H12425', 'H12426', 'H12428', 'H12429', 'H12430', 'H12431', 'H12434', 'H12436', 'H12439', 'H12440', 'H12441', 'H12442', 'H12443', 'H12444', 'H12445', 'H12446', 'H12447', 'H12448', 'H12449', 'H12450', 'H12451', 'H12452', 'H12454', 'H12455', 'H12467', 'H12468', 'H12469', 'H12471', 'H12472', 'H12473', 'H12474', 'H12475', 'H12477', 'H12478', 'H12485', 'H12494', 'H12495', 'H12501', 'H12502', 'H12503', 'H12505', 'H12508', 'H12509', 'H12510', 'H12518', 'H12519', 'H12521', 'H12522', 'H12525', 'H12526', 'H12527', 'H12528', 'H12529', 'H12530', 'H12531', 'H12532', 'H12533', 'H12536', 'H12543', 'H12544', 'H12545', 'H12546', 'H12547', 'H12548', 'H12553', 'H12554', 'H12555', 'H12556', 'H12557', 'H12558', 'H12579', 'H12581', 'H12587', 'H12588', 'H12589', 'H12590', 'H12591', 'H12592', 'H12593', 'H12595', 'H12596', 'H12597', 'H12598', 'H12599', 'H12600', 'H12602', 'H12603', 'H12604', 'H12607', 'H12610', 'H12614', 'H12625', 'H12626', 'H12630', 'H12631', 'H12632', 'H12634', 'H12635', 'H12636', 'H12655', 'H12656', 'H12657', 'H12662', 'H12668', 'H12676', 'H12677', 'H12678', 'H12679', 'H12680', 'H12681', 'H12686', 'H12687', 'H12688', 'H12689', 'H12690', 'H12691', 'H12692', 'H12693', 'H12694', 'H12708', 'H12709', 'H12710', 'H12711', 'H12712', 'H12714', 'H12715', 'H12716', 'H12720', 'H12721', 'H12722', 'H12724', 'H12727', 'H12728', 'H12729', 'H12730', 'H12731', 'H12733', 'H12734', 'H12735', 'H12736', 'H12737', 'H12738', 'H12739', 'H12740', 'H12741', 'H12742', 'H12743', 'H12744', 'H12748', 'H12749', 'H12750', 'H12751', 'H12752', 'H12753', 'H12754', 'H12758', 'H12760', 'H12761', 'H12762', 'H12763', 'H12765', 'H12780', 'H12781', 'H12782', 'H12786', 'H12787', 'H12788', 'H12789', 'H12790', 'H12791', 'H12798', 'H12799', 'H12801', 'H12802', 'H12811', 'H12812', 'H12813', 'H12827', 'H12829', 'H12830', 'H12838', 'H12839', 'H12840', 'H12841', 'H12843', 'H12847', 'H12848', 'H12849', 'H12850', 'H12851', 'H12854', 'H12856', 'H12857', 'H12858', 'H12859', 'H12865', 'H12868', 'H12869', 'H12870', 'H12871', 'H12875', 'H12876', 'H12877', 'H12878', 'H12879', 'H12880', 'H12881', 'H12882', 'H12884', 'H12885', 'H12886', 'H12887', 'H12893', 'H12894', 'H12895', 'H12896', 'H12897', 'H12898', 'H12905', 'H12906', 'H12907', 'H12908', 'H12910', 'H12911', 'H12913', 'H12916', 'H12917', 'H12918', 'H12919', 'H12920', 'H12921', 'H12922', 'H12923', 'H12924', 'H12925', 'H12926', 'H12929', 'H12930', 'H12931', 'H12932', 'H12934', 'H12937', 'H12938', 'H12939', 'H12940', 'H12941', 'H12942', 'H12943', 'H12944', 'H12945', 'H12948', 'H12949', 'H12950', 'H12951', 'H12953', 'H12954', 'H12955', 'H12968', 'H12969', 'H12976', 'H12977', 'H12991', 'H12993', 'H12994', 'H12996', 'H12997', 'H12998', 'H12999', 'H13000', 'H13001', 'H13003', 'H13006', 'H13007', 'H13009', 'H13011', 'H13014', 'H13015', 'H13016', 'H13022', 'H13023', 'H13024', 'H13027', 'H13031', 'H13034', 'H13035', 'H13036', 'H13037', 'H13038', 'H13039', 'H13042', 'H13044', 'H13045', 'H13047', 'H13048', 'H13054', 'H13055', 'H13056', 'H13057', 'H13070', 'H13072', 'H13073', 'H13075', 'H13079', 'H13080', 'H13081', 'H13090', 'H13092', 'H13100', 'H13101', 'H13102', 'H13103', 'H13105', 'H13106', 'H13112', 'H13113', 'H13114', 'H13115', 'H13116', 'H13120', 'H13121', 'H13122', 'H13133', 'H13134', 'H13135', 'H13136', 'H13138', 'H13141', 'H13147', 'H13154', 'H13155', 'H13160', 'H13161', 'H13162', 'H13163', 'H13165', 'H13168', 'H13169', 'H13170', 'H13171', 'H13173', 'H13174', 'H13175', 'H13176', 'H13178', 'H13180', 'H13181', 'H13182', 'H13184', 'H13185', 'H13186', 'H13200', 'H13202', 'H13204', 'H13238', 'H13239', 'H13240', 'H13241', 'H13242', 'H13243', 'H13244', 'H13245', 'H13258', 'H13298', 'H13312', 'H13327', 'HFP-10-4-73', 'HFP-10-6-85', 'HFP-2-20-80', 'HFP-20-2-80', 'HFP-3-77 516', 'HFP-746-7-73', 'HFP-746-8-73', 'HO-10-1-67', 'HO-10-2-67', 'HO-10-4-67', 'HSB-10-1-77', 'HSB-10-1-82', 'HSB-10-3-78', 'HSB-10-4-81', 'HSB-10-4-82', 'HSB-10-4-83', 'HSB-10-811', 'HSB-10-9-82', 'HSB-20-5-81', 'HSB-40-4-76', 'HSB-92 B249', 'HSL-10-1-72', 'HSL-1257-001 474', 'KE-12-76 517', 'KE-16-76 517', 'KE-4-76 517', 'KE-7-76 517', 'KE-76-1 517', 'LA-1264-10-2-76', 'LJ-10-2-65', 'MA-10-1-69', 'MA-10-2-69', 'MA-10-2-70', 'MA-10-3-69', 'MA-12-72', 'MA-33-72', 'MA-460-72', 'MA-47-74', 'MI-10-2-72', 'MI-10-2-81', 'MI-10-2-82', 'MI-10-3-76', 'MI-10-3-82', 'MI-10-3-84', 'MI-10-4-82', 'MI-20-3-72', 'MI-20-3-78', 'MI-20-6-78', 'MI-40-1-72', 'MI-40-2-72', 'MI-5-1-70', 'MI-76 423', 'MI-79 K104', 'MI-80 K104', 'MI-80-2-83', 'MI-80-4-72', 'MI-80-8-76', 'O328', 'PE 10-5-84', 'PE-10-1-70', 'PE-10-1-72', 'PE-10-1-74', 'PE-10-1-85', 'PE-10-2-67', 'PE-10-2-76', 'PE-10-2-85', 'PE-10-5-82', 'PE-10-5-84', 'PE-20-1-74', 'PE-20-1-76', 'PE-20-1-84', 'PE-20-2-64', 'PE-20-2A-67', 'PE-40-1-73', 'PE-40-1-84', 'PE-5-1-67', 'PE-80-1-70', 'PF-10-1-68', 'PF-10-3-69', 'PHP-11-79', 'PHP-22-81', 'PHP-23-81', 'PHP-24-80', 'PHP-29-80', 'PHP-30-80', 'PHP-60-81', 'PMC/SP-8-71 PF-2.5-1-71', 'PMC/SP-9-71', 'RA-10-1-73', 'RA-10-1B-76', 'RA-10-2-73', 'RA-10-2-78', 'RA-10-2A-71', 'RA-10-4-74', 'RA-10-5-72', 'RA-10-7-71', 'RA-20-1-73', 'RA-20-2-76', 'RA-20-4-95', 'RA-40-3B-71', 'RA-80-1-73', 'RH-83 K667', 'RU-6-5-99', 'RU-6-9-99', 'SI301 WH-83', 'SP-AMC-1-HFP-7 5-4-77', 'SP-AMC-1-HFP-77 5-1-77', 'SP-AMC-1-HFP-77 5-2-77', 'SP-AMC-1-HFP-77 5-3-77', 'SP-AMC-3-AHP-76 CHART 11491', 'SP-AMC-4-77', 'SP-PMC-4-DA-75', 'W00224', 'W00244', 'W00288', 'W00289', 'W00307', 'W00448', 'W00450', 'W00492', 'W00501', 'W00502', 'W00503', 'W00504', 'W00505', 'W00506', 'W216', 'WH-10-06-91 K220', 'WH-10-1-73', 'WH-10-1-75', 'WH-10-15-70', 'WH-10-2-73', 'WH-10-2S-75', 'WH-10-5-76', 'WH-10-9-77', 'WH-12.5-1-65', 'WH-20-1-70', 'WH-20-1-76', 'WH-20-1-80', 'WH-20-2-65', 'WH-20-2-71', 'WH-20-2-82', 'WH-20-3-75', 'WH-20-4-73', 'WH-20-5-71', 'WH-20-5W-70', 'WH-20-82 K104', 'WH-29-80 X115', 'WH-34-84', 'WH-35-80', 'WH-36-80 X115', 'WH-37-81 Z137', 'WH-38-1981 L137', 'WH-38-81', 'WH-40-1-74', 'WH-40-1-82', 'WH-43-81 Z137', 'WH-49-80 X115', 'WH-53-83 J217', 'WH-61-80 X115', 'WH-83', 'X278']
```

#### get seabed descriptions for the first 5 surveys, within specified bounds

```python
import numpy

from seabed import NGDCSeabedDescriptions

# define bounds
bounds = numpy.array([[-77, 39], [-75, 40]])

# retrieve a list of the first 5 surveys
first_5_surveys = NGDCSeabedDescriptions.all_surveys()[:5]

# intialize a Seabed Description object with specific surveys and bounds
seabed_descriptions = NGDCSeabedDescriptions(surveys=first_5_surveys, bounds=bounds)

print(f'surveys: {seabed_descriptions.surveys}')
print(f'bounds: {seabed_descriptions.bounds}')
print(f'descriptions: {seabed_descriptions.descriptions}')
print(f'data: {seabed_descriptions.data}')
```

```
surveys: ['409', '468', '492', '516 516-77', '516 OTTS  2']
bounds: [-77  39 -75  40]
descriptions: ['MUD BLACK', 'MUD DARK BROWN', 'MUD HARD BLACK,SHELLS', 'MUD SOFT BLACK', 'MUD SOFT BLACK,SHELLS', 'MUD SOFT BROWN,SHELLS', 'MUD SOFT GRAY,SAND', 'SAND BROWN,SHELLS', 'SAND BROWN,SHELLS BROKEN', 'SAND COARSE GRAY', 'SAND FINE BLACK', 'SAND FINE BROWN', 'SAND FINE BROWN,MUD', 'SAND FINE BROWN,MUD,SHELLS BROKEN', 'SAND FINE BROWN,SHELLS', 'SAND FINE GRAY']
data:
    Survey         Sample  ...       Device                    geometry
52     492  SD00015949.01  ...  2LB SAMPLER  POINT (-75.00750 39.17361)
53     492  SD00015950.01  ...  2LB SAMPLER  POINT (-75.01000 39.15472)
54     492  SD00015951.01  ...  2LB SAMPLER  POINT (-75.00722 39.14111)
55     492  SD00015952.01  ...  2LB SAMPLER  POINT (-75.00806 39.12528)
56     492  SD00015953.01  ...  2LB SAMPLER  POINT (-75.02611 39.12583)
57     492  SD00015954.01  ...  2LB SAMPLER  POINT (-75.02778 39.14167)
58     492  SD00015955.01  ...  2LB SAMPLER  POINT (-75.02694 39.15972)
59     492  SD00015956.01  ...  2LB SAMPLER  POINT (-75.04083 39.15806)
60     492  SD00015957.01  ...  2LB SAMPLER  POINT (-75.04139 39.14028)
61     492  SD00015958.01  ...  2LB SAMPLER  POINT (-75.04167 39.12500)
62     492  SD00015959.01  ...  2LB SAMPLER  POINT (-75.04167 39.10778)
63     492  SD00015960.01  ...  2LB SAMPLER  POINT (-75.02306 39.10861)
64     492  SD00015961.01  ...  2LB SAMPLER  POINT (-75.00778 39.10778)
65     492  SD00015962.01  ...  2LB SAMPLER  POINT (-75.02500 39.09167)
66     492  SD00015963.01  ...  2LB SAMPLER  POINT (-75.00833 39.09139)
67     492  SD00015964.01  ...  2LB SAMPLER  POINT (-75.05833 39.19111)
68     492  SD00015965.01  ...  2LB SAMPLER  POINT (-75.04333 39.19167)
69     492  SD00015966.01  ...  2LB SAMPLER  POINT (-75.02528 39.19167)
70     492  SD00015967.01  ...  2LB SAMPLER  POINT (-75.01167 39.19056)
71     492  SD00015968.01  ...  2LB SAMPLER  POINT (-75.04167 39.17500)
82     492  SD00015979.01  ...  2LB SAMPLER  POINT (-75.01833 39.16833)
88     492  SD00015986.01  ...  2LB SAMPLER  POINT (-75.06333 39.18000)
89     492  SD00015987.01  ...  2LB SAMPLER  POINT (-75.06167 39.16333)
90     492  SD00015988.01  ...  2LB SAMPLER  POINT (-75.05667 39.16167)
91     492  SD00015989.01  ...  2LB SAMPLER  POINT (-75.05500 39.13167)
92     492  SD00015990.01  ...  2LB SAMPLER  POINT (-75.00667 39.06167)
93     492  SD00015991.01  ...  2LB SAMPLER  POINT (-75.00667 39.07167)
94     492  SD00015992.01  ...  2LB SAMPLER  POINT (-75.02500 39.07500)
95     492  SD00015993.01  ...  2LB SAMPLER  POINT (-75.03667 39.09167)
96     492  SD00015994.01  ...  2LB SAMPLER  POINT (-75.05833 39.10333)
97     492  SD00015995.01  ...  2LB SAMPLER  POINT (-75.05833 39.09167)
98     492  SD00015996.01  ...  2LB SAMPLER  POINT (-75.04000 39.07500)
99     492  SD00015997.01  ...  2LB SAMPLER  POINT (-75.04000 39.05833)
100    492  SD00015998.01  ...  2LB SAMPLER  POINT (-75.00833 39.04167)
121    492  SD00016019.01  ...  2LB SAMPLER  POINT (-75.01194 39.04139)
122    492  SD00016020.01  ...  2LB SAMPLER  POINT (-75.02389 39.04194)
123    492  SD00016021.01  ...  2LB SAMPLER  POINT (-75.04000 39.04139)
124    492  SD00016022.01  ...  2LB SAMPLER  POINT (-75.05806 39.04167)
125    492  SD00016023.01  ...  2LB SAMPLER  POINT (-75.05694 39.12333)
126    492  SD00016024.01  ...  2LB SAMPLER  POINT (-75.03556 39.05750)
127    492  SD00016025.01  ...  2LB SAMPLER  POINT (-75.05694 39.07639)

[41 rows x 14 columns]
```
