# openmv核心算法imlib的移植


### 项目信息

1、相关函数使用参考代码将会放在reference文件夹内，主要是openmv的参考代码。

2、项目结构
~~~ bash
├── bug_report     #bug报告
├── include
├── LICENSE
├── Makefile
├── readme.md
├── reference     #imlib使用参考代码
├── src           #源码文件
└── test
~~~

### 相关工作

1、修改内存管理

2、做相关指令移植工作

3、添加rgb888的支持

4、完成imlib的相关库函数



### 移植要点

1、尽量在原openmv imlib库上做兼容修改。

2、尽量保持最小的修改。

3、尽量保持代码风格统一。

4、当需要添加新的模块程序时，如果不是必须，请新建源文件进行添加。

5、fb_alloc内存区使用要小心，更改了fb_alloc的内存释放fb_free()接口，方便做程序的移植。

以上要点可以在保持原汁原味的opemv风格下，添加我们自己的相关代码。好处是当openmv代码更新时可以最快的速度更新到我们自己代码中，
做到代码共享。


### 移植进度

1、完成了xalloc内存管理的移植。（动态内存的移植）

2、完成了fb_alloc内存管理的移植。（栈内存的移植）

3、完成了大部分的rgb888的支持添加，对imlib_draw_image()函数的rgb888支持工作还在进行中，目前需要测试后才能继续做支持添加工作。

4、正在进行相关测试。测试参考代码将会放在examples文件夹内。

5、目前的主要测试工作是rgb888的支持测试，测试imlib库对rgb888支持的一些缺陷，然后做修补工作。

6、添加了一些简易函数的实现，方便该库进行单独的移植和使用

### 准备进行的工作

1、png图片的打开和编解码操作

2、jpeg 图片的打开和编解码操作


### 如何使用

进入 test 文件。
~~~ bash
make 

./imlib_base_test
~~~


### 使用注意

1、目前imlib库的图片输入输出只进行了bpm的移植。其他的正在移植工作中。

2、测试出现问题后，可以写到bug_report文件夹内，作者看到后会进行处理。

3、imlib算法内原生支持rgb565,有关rgb565的算法可以直接测试使用。

4、目前该库只支持了 bmp 图片格式的实现，其他格式的图片打开请持续关注该项目。

5、如果想要参与该项目，可以提交PR或者联系作者，作者将会将其添加到项目管理者内，让合作更加顺畅。

# 如果对项目有疑问，请重新阅读上述内容。如果还有疑问，请仔细阅读项目代码。如果再有疑问，请仔细阅读并背诵项目代码。





