/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.util;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.ValueVector;

public class ArrowBinarySearch {
    public static <V extends ValueVector> int binarySearch(V v, VectorValueComparator<V> vectorValueComparator, V v2, int n) {
        vectorValueComparator.attachVectors(v2, v);
        int n2 = 0;
        int n3 = v.getValueCount() - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = vectorValueComparator.compare(n, n4);
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(BigIntVector bigIntVector, long l) {
        int n = 0;
        int n2 = bigIntVector.getValueCount() - 1;
        while (n <= n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Long.compare(l, bigIntVector.get(n3));
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }
}

