/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.model;

import com.raphtory.arrowcore.implementation.ArrowPropertyIterator;
import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VertexHistoryIterator;
import com.raphtory.arrowcore.implementation.VertexIterator;
import com.raphtory.arrowcore.model.Edge;
import com.raphtory.arrowcore.model.Entity;

public class Vertex
extends Entity {
    protected VertexIterator _vertexIterator;
    protected int _nIncomingEdges;
    protected int _nOutgoingEdges;
    protected long _incomingEdgePtr = -1L;
    protected long _outgoingEdgePtr = -1L;

    public Vertex(RaphtoryArrowPartition raphtoryArrowPartition, EntityFieldAccessor[] entityFieldAccessorArray, VersionedEntityPropertyAccessor[] versionedEntityPropertyAccessorArray) {
        super(raphtoryArrowPartition, entityFieldAccessorArray, versionedEntityPropertyAccessorArray);
    }

    @Override
    public void decRefCount() {
        if (--this._refCount == 0) {
            this.reset();
            this._rap.putVertex(this);
        }
    }

    public int nIncomingEdges() {
        return this._nIncomingEdges;
    }

    public int nOutgoingEdges() {
        return this._nOutgoingEdges;
    }

    public long getIncomingEdgePtr() {
        return this._incomingEdgePtr;
    }

    public long getOutgoingEdgePtr() {
        return this._outgoingEdgePtr;
    }

    public EdgeIterator getIncomingEdges() {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.getIncomingEdges();
    }

    public EdgeIterator getOutgoingEdges() {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.getOutgoingEdges();
    }

    public EdgeIterator getAllEdges() {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.getAllEdges();
    }

    @Override
    public void clear() {
        super.clear();
        this._nIncomingEdges = 0;
        this._nOutgoingEdges = 0;
        this._incomingEdgePtr = -1L;
        this._outgoingEdgePtr = -1L;
    }

    @Override
    public void recycle() {
        super.recycle();
        this._nIncomingEdges = 0;
        this._nOutgoingEdges = 0;
        this._incomingEdgePtr = -1L;
        this._outgoingEdgePtr = -1L;
    }

    @Override
    public void reset(long l, long l2, boolean bl, long l3) {
        super.reset(l, l2, bl, l3);
    }

    public void resetEdgeData(long l, long l2, int n, int n2) {
        this._incomingEdgePtr = l;
        this._outgoingEdgePtr = l2;
        this._nIncomingEdges = n;
        this._nOutgoingEdges = n2;
    }

    protected Edge makeClone(Edge edge) {
        Edge edge2 = this._rap.getEdge();
        edge.makeClone(edge2);
        return edge2;
    }

    public Vertex makeClone(Vertex vertex) {
        super.makeClone(vertex);
        vertex._nIncomingEdges = this._nIncomingEdges;
        vertex._nOutgoingEdges = this._nOutgoingEdges;
        return vertex;
    }

    public String toString() {
        return "Vertex: " + this._globalId;
    }

    public ArrowPropertyIterator getPropertyHistory(int n) {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.getPropertyHistory(n);
    }

    public EdgeIterator findAllOutgoingEdges(long l, boolean bl) {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.findAllOutgoingEdges(l, bl);
    }

    public EdgeIterator findAllIncomingEdges(long l, boolean bl) {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.findAllIncomingEdges(l, bl);
    }

    public VertexHistoryIterator getVertexHistory() {
        if (this._vertexIterator == null) {
            this._vertexIterator = this._rap.getNewAllVerticesIterator();
        }
        this._vertexIterator.reset(this._localId);
        return this._vertexIterator.getVertexHistory();
    }
}

