/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.model.Vertex;
import java.util.ArrayList;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class VertexArrowStore {
    protected VertexPartition _partition;
    protected VectorSchemaRoot _vertexRoot;
    protected BigIntVector _globalIds;
    protected BitVector _initialValues;
    protected BigIntVector _creationTimes;
    protected BigIntVector _oldestPoints;
    protected IntVector _nIncomingEdges;
    protected IntVector _nOutgoingEdges;
    protected BigIntVector _incomingEdges;
    protected BigIntVector _outgoingEdges;
    protected IntVector _historyPtr;
    protected IntVector _sortedHStart;
    protected IntVector _sortedHEnd;
    protected SchemaFieldAccessor[] _accessors;
    protected int _nAccessors;

    public static ArrayList<Field> createVertexFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("global_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("initial_value", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("creation_time", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("oldest_point", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("n_incoming_edges", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("n_outgoing_edges", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("incoming_edges_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("outgoing_edges_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("history_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("sortedhstart", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("sortedhend", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    protected void init(VertexPartition vertexPartition, VectorSchemaRoot vectorSchemaRoot, SchemaFieldAccessor[] schemaFieldAccessorArray) {
        this._partition = vertexPartition;
        this._vertexRoot = vectorSchemaRoot;
        this._accessors = schemaFieldAccessorArray;
        int n = this._nAccessors = this._accessors == null ? 0 : this._accessors.length;
        if (vectorSchemaRoot != null) {
            this._globalIds = (BigIntVector)this._vertexRoot.getVector("global_id");
            this._initialValues = (BitVector)this._vertexRoot.getVector("initial_value");
            this._creationTimes = (BigIntVector)this._vertexRoot.getVector("creation_time");
            this._oldestPoints = (BigIntVector)this._vertexRoot.getVector("oldest_point");
            this._nIncomingEdges = (IntVector)this._vertexRoot.getVector("n_incoming_edges");
            this._nOutgoingEdges = (IntVector)this._vertexRoot.getVector("n_outgoing_edges");
            this._incomingEdges = (BigIntVector)this._vertexRoot.getVector("incoming_edges_ptr");
            this._outgoingEdges = (BigIntVector)this._vertexRoot.getVector("outgoing_edges_ptr");
            this._historyPtr = (IntVector)this._vertexRoot.getVector("history_ptr");
            this._sortedHStart = (IntVector)this._vertexRoot.getVector("sortedhstart");
            this._sortedHEnd = (IntVector)this._vertexRoot.getVector("sortedhend");
        } else {
            this._globalIds = null;
            this._initialValues = null;
            this._creationTimes = null;
            this._oldestPoints = null;
            this._nIncomingEdges = null;
            this._nOutgoingEdges = null;
            this._incomingEdges = null;
            this._outgoingEdges = null;
            this._historyPtr = null;
            this._sortedHStart = null;
            this._sortedHEnd = null;
        }
    }

    public boolean addVertex(int n, Vertex vertex) {
        boolean bl;
        int n2 = n;
        boolean bl2 = bl = this._globalIds.isSet(n2) == 0;
        if (bl) {
            this._globalIds.set(n2, vertex.getGlobalId());
            this._historyPtr.set(n2, -1);
        }
        this._initialValues.set(n2, vertex.getInitialValue() ? 1 : 0);
        this._creationTimes.set(n2, vertex.getCreationTime());
        this._oldestPoints.set(n2, vertex.getOldestPoint());
        this._incomingEdges.set(n2, vertex.getIncomingEdgePtr());
        this._outgoingEdges.set(n2, vertex.getOutgoingEdgePtr());
        this._nIncomingEdges.set(n2, vertex.nIncomingEdges());
        this._nOutgoingEdges.set(n2, vertex.nOutgoingEdges());
        for (int i = 0; i < this._nAccessors; ++i) {
            this._accessors[i].store(vertex.getField(i), n);
        }
        return bl;
    }

    protected Vertex retrieveVertex(int n, Vertex vertex) {
        vertex.reset(this._partition._getLocalVertexIdByRow(n), this._globalIds.get(n), this._initialValues.get(n) != 0, this._creationTimes.get(n));
        vertex.resetEdgeData(this._incomingEdges.get(n), this._outgoingEdges.get(n), this._nIncomingEdges.get(n), this._nOutgoingEdges.get(n));
        if (this._historyPtr.isSet(n) != 0) {
            vertex.resetHistoryData(this._historyPtr.get(n));
        }
        for (int i = 0; i < this._nAccessors; ++i) {
            this._accessors[i].load(vertex.getField(i), n);
        }
        return vertex;
    }

    public int getHistoryPtr(int n) {
        if (this._historyPtr.isSet(n) != 0) {
            return this._historyPtr.get(n);
        }
        return -1;
    }

    public void setHistoryPtr(int n, int n2) {
        this._historyPtr.set(n, n2);
    }
}

