/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeArrowStore;
import com.raphtory.arrowcore.implementation.EdgeHistoryIterator;
import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.GlobalEntityIdStore;
import com.raphtory.arrowcore.implementation.LocalEntityIdStore;
import com.raphtory.arrowcore.implementation.NonversionedField;
import com.raphtory.arrowcore.implementation.PropertyStore;
import com.raphtory.arrowcore.implementation.RaphtoryStatistics;
import com.raphtory.arrowcore.implementation.RaphtoryThreadPool;
import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VersionedProperty;
import com.raphtory.arrowcore.implementation.VersionedPropertyStore;
import com.raphtory.arrowcore.implementation.VertexArrowStore;
import com.raphtory.arrowcore.implementation.VertexHistoryIterator;
import com.raphtory.arrowcore.implementation.VertexIterator;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import com.raphtory.arrowcore.model.Edge;
import com.raphtory.arrowcore.model.PropertySchema;
import com.raphtory.arrowcore.model.Vertex;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class RaphtoryArrowPartition {
    private final ThreadLocal<ArrayList<Vertex>> _vertexPool = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<ArrayList<Edge>> _edgePool = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<EntityFieldAccessor[]> _vertexAccessorsPool = ThreadLocal.withInitial(this::createVertexEntityFieldAccessors);
    private final ThreadLocal<EntityFieldAccessor[]> _edgeAccessorsPool = ThreadLocal.withInitial(this::createEdgeEntityFieldAccessors);
    protected final PropertySchema _propertySchema;
    private final EdgePartitionManager _emgr;
    private final VertexPartitionManager _vmgr;
    private final GlobalEntityIdStore _globalEntityIdStore;
    private final LocalEntityIdStore _localEntityIdStore;
    private final int _nRaphtoryPartitions;
    private final int _raphtoryPartitionId;
    protected final Schema _arrowEdgeSchema;
    protected final Schema _arrowVertexSchema;
    protected final boolean _syncIDMap;
    protected final int _vertexPartitionSize;
    protected final int _vertexPartitionSize_shift;
    protected final int _vertexPartitionSize_divisor;
    protected final int _vertexPartitionSize_mask;
    protected final int _edgePartitionSize;
    protected final int _edgePartitionSize_shift;
    protected final int _edgePartitionSize_divisor;
    protected final int _edgePartitionSize_mask;
    private final RaphtoryStatistics _stats;

    public RaphtoryArrowPartition(RaphtoryArrowPartitionConfig raphtoryArrowPartitionConfig) {
        this._propertySchema = raphtoryArrowPartitionConfig._propertySchema;
        this._raphtoryPartitionId = raphtoryArrowPartitionConfig._raphtoryPartitionId;
        this._nRaphtoryPartitions = raphtoryArrowPartitionConfig._nRaphtoryPartitions;
        System.getProperties().setProperty("arrow.enable_unsafe_memory_access", raphtoryArrowPartitionConfig._disableBoundsCheck ? "true" : "false");
        System.getProperties().setProperty("arrow.enable_null_check_for_get", raphtoryArrowPartitionConfig._disableBoundsCheck ? "false" : "true");
        this._syncIDMap = raphtoryArrowPartitionConfig._syncIDMap;
        this._globalEntityIdStore = new GlobalEntityIdStore();
        this._localEntityIdStore = new LocalEntityIdStore(raphtoryArrowPartitionConfig._arrowDir, raphtoryArrowPartitionConfig._nLocalEntityIdMaps, raphtoryArrowPartitionConfig._localEntityIdMapSize);
        this._arrowEdgeSchema = this.createEdgeSchema();
        this._arrowVertexSchema = this.createVertexSchema();
        this._vertexPartitionSize = RaphtoryArrowPartition.roundUpToPowerOfTwo(raphtoryArrowPartitionConfig._vertexPartitionSize);
        this._vertexPartitionSize_shift = Integer.numberOfTrailingZeros(this._vertexPartitionSize);
        this._vertexPartitionSize_divisor = 1 << this._vertexPartitionSize_shift;
        this._vertexPartitionSize_mask = this._vertexPartitionSize_divisor - 1;
        this._edgePartitionSize = RaphtoryArrowPartition.roundUpToPowerOfTwo(raphtoryArrowPartitionConfig._edgePartitionSize);
        this._edgePartitionSize_shift = Integer.numberOfTrailingZeros(this._edgePartitionSize);
        this._edgePartitionSize_divisor = 1 << this._edgePartitionSize_shift;
        this._edgePartitionSize_mask = this._edgePartitionSize_divisor - 1;
        this._emgr = new EdgePartitionManager(this, new File(raphtoryArrowPartitionConfig._arrowDir), RaphtoryThreadPool.THREAD_POOL);
        this._vmgr = new VertexPartitionManager(this, new File(raphtoryArrowPartitionConfig._arrowDir), RaphtoryThreadPool.THREAD_POOL);
        this._stats = new RaphtoryStatistics(this);
    }

    public void close() {
        this._emgr.saveFiles();
        this._vmgr.saveFiles();
        this._emgr.close();
        this._vmgr.close();
        this._globalEntityIdStore.close();
        this._localEntityIdStore.close();
    }

    private Schema createEdgeSchema() {
        ArrayList<VersionedProperty> arrayList;
        int n;
        List<Field> list = EdgeArrowStore.createEdgeFields();
        ArrayList<NonversionedField> arrayList2 = this._propertySchema.nonversionedEdgeProperties();
        if (arrayList2 != null) {
            int n2 = arrayList2.size();
            for (n = 0; n < n2; ++n) {
                NonversionedField nonversionedField = arrayList2.get(n);
                nonversionedField.setParentSchemaFieldIndex(list.size());
                nonversionedField.addToSchema(list);
            }
        }
        if ((arrayList = this._propertySchema.versionedEdgeProperties()) != null) {
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                VersionedProperty versionedProperty = arrayList.get(i);
                versionedProperty.setPrevPtrFieldIndexInEntity(list.size());
                Field field = new Field("prop_prev_ptr_" + i, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
                list.add(field);
            }
        }
        return new Schema(list);
    }

    private Schema createVertexSchema() {
        ArrayList<VersionedProperty> arrayList;
        int n;
        ArrayList<Field> arrayList2 = VertexArrowStore.createVertexFields();
        ArrayList<NonversionedField> arrayList3 = this._propertySchema.nonversionedVertexProperties();
        if (arrayList3 != null) {
            int n2 = arrayList3.size();
            for (n = 0; n < n2; ++n) {
                NonversionedField nonversionedField = arrayList3.get(n);
                nonversionedField.setParentSchemaFieldIndex(arrayList2.size());
                nonversionedField.addToSchema(arrayList2);
            }
        }
        if ((arrayList = this._propertySchema.versionedVertexProperties()) != null) {
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                VersionedProperty versionedProperty = arrayList.get(i);
                versionedProperty.setPrevPtrFieldIndexInEntity(arrayList2.size());
                Field field = new Field("prop_prev_ptr_" + i, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
                arrayList2.add(field);
            }
        }
        return new Schema(arrayList2);
    }

    public PropertySchema getPropertySchema() {
        return this._propertySchema;
    }

    public EdgePartitionManager getEdgeMgr() {
        return this._emgr;
    }

    public VertexPartitionManager getVertexMgr() {
        return this._vmgr;
    }

    public GlobalEntityIdStore getGlobalEntityIdStore() {
        return this._globalEntityIdStore;
    }

    public LocalEntityIdStore getLocalEntityIdStore() {
        return this._localEntityIdStore;
    }

    public int getNRaphtoryPartitions() {
        return this._nRaphtoryPartitions;
    }

    public int getRaphtoryPartitionId() {
        return this._raphtoryPartitionId;
    }

    public EntityFieldAccessor[] getTmpVertexEntityFieldAccessors() {
        return this._vertexAccessorsPool.get();
    }

    public EntityFieldAccessor[] getTmpEdgeEntityFieldAccessors() {
        return this._edgeAccessorsPool.get();
    }

    protected VersionedPropertyStore createSchemaPropertyAccessor(VectorSchemaRoot vectorSchemaRoot, VersionedProperty versionedProperty) {
        return versionedProperty.getNewSchemaFieldAccessor(vectorSchemaRoot);
    }

    protected SchemaFieldAccessor[] createSchemaFieldAccessors(VectorSchemaRoot vectorSchemaRoot, ArrayList<NonversionedField> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        SchemaFieldAccessor[] schemaFieldAccessorArray = new SchemaFieldAccessor[n];
        for (int i = 0; i < schemaFieldAccessorArray.length; ++i) {
            NonversionedField nonversionedField = arrayList.get(i);
            schemaFieldAccessorArray[i] = nonversionedField.getNewSchemaFieldAccessor(vectorSchemaRoot);
        }
        return schemaFieldAccessorArray;
    }

    protected EntityFieldAccessor[] createVertexEntityFieldAccessors() {
        return this.createEntityFieldAccessors(this._propertySchema.nonversionedVertexProperties());
    }

    protected EntityFieldAccessor[] createEdgeEntityFieldAccessors() {
        return this.createEntityFieldAccessors(this._propertySchema.nonversionedEdgeProperties());
    }

    protected EntityFieldAccessor[] createEntityFieldAccessors(ArrayList<NonversionedField> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        EntityFieldAccessor[] entityFieldAccessorArray = new EntityFieldAccessor[n];
        for (int i = 0; i < n; ++i) {
            NonversionedField nonversionedField = arrayList.get(i);
            entityFieldAccessorArray[i] = nonversionedField.getNewEntityFieldAccessor();
        }
        return entityFieldAccessorArray;
    }

    protected Schema getVertexPropertySchema(int n) {
        VersionedProperty versionedProperty = this._propertySchema.versionedVertexProperties().get(n);
        List<Field> list = PropertyStore.createBasePropertySchema();
        versionedProperty.addToSchema(list);
        return new Schema(list);
    }

    protected Schema getEdgePropertySchema(int n) {
        VersionedProperty versionedProperty = this._propertySchema.versionedEdgeProperties().get(n);
        List<Field> list = PropertyStore.createBasePropertySchema();
        versionedProperty.addToSchema(list);
        return new Schema(list);
    }

    protected VersionedEntityPropertyAccessor[] createVertexEntityPropertyAccessors() {
        return this.createEntityPropertyAccessors(this._propertySchema.versionedVertexProperties());
    }

    protected VersionedEntityPropertyAccessor[] createEdgeEntityPropertyAccessors() {
        return this.createEntityPropertyAccessors(this._propertySchema.versionedEdgeProperties());
    }

    protected VersionedEntityPropertyAccessor[] createEntityPropertyAccessors(ArrayList<VersionedProperty> arrayList) {
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        VersionedEntityPropertyAccessor[] versionedEntityPropertyAccessorArray = new VersionedEntityPropertyAccessor[n];
        for (int i = 0; i < n; ++i) {
            versionedEntityPropertyAccessorArray[i] = arrayList.get(i).getNewEntityFieldAccessor(i);
        }
        return versionedEntityPropertyAccessorArray;
    }

    public VersionedEntityPropertyAccessor getVertexPropertyAccessor(int n) {
        return this._propertySchema.versionedVertexProperties().get(n).getNewEntityFieldAccessor(n);
    }

    public VersionedEntityPropertyAccessor getEdgePropertyAccessor(int n) {
        return this._propertySchema.versionedEdgeProperties().get(n).getNewEntityFieldAccessor(n);
    }

    protected VersionedProperty getVertexProperty(int n) {
        return this._propertySchema.versionedVertexProperties().get(n);
    }

    protected VersionedProperty getEdgeProperty(int n) {
        return this._propertySchema.versionedEdgeProperties().get(n);
    }

    public int getVertexPropertyId(String string) throws IllegalArgumentException {
        ArrayList<VersionedProperty> arrayList = this._propertySchema.versionedVertexProperties();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).name().equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("invalid field");
    }

    public int getEdgePropertyId(String string) throws IllegalArgumentException {
        ArrayList<VersionedProperty> arrayList = this._propertySchema.versionedEdgeProperties();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).name().equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("invalid field");
    }

    public Vertex getVertex() {
        ArrayList<Vertex> arrayList = this._vertexPool.get();
        int n = arrayList.size();
        if (n > 0) {
            Vertex vertex = arrayList.remove(n - 1);
            return vertex;
        }
        Vertex vertex = new Vertex(this, this.createVertexEntityFieldAccessors(), this.createVertexEntityPropertyAccessors());
        return vertex;
    }

    public void putVertex(Vertex vertex) {
        if (vertex.getRefCount() == 0) {
            vertex.recycle();
            vertex.clear();
            ArrayList<Vertex> arrayList = this._vertexPool.get();
            arrayList.add(vertex);
        }
    }

    public Edge getEdge() {
        ArrayList<Edge> arrayList = this._edgePool.get();
        int n = arrayList.size();
        if (n > 0) {
            Edge edge = arrayList.remove(n - 1);
            return edge;
        }
        Edge edge = new Edge(this, this.createEdgeEntityFieldAccessors(), this.createEdgeEntityPropertyAccessors());
        return edge;
    }

    public void putEdge(Edge edge) {
        if (edge.getRefCount() == 0) {
            edge.recycle();
            edge.clear();
            ArrayList<Edge> arrayList = this._edgePool.get();
            arrayList.add(edge);
        }
    }

    public int getVertexFieldId(String string) throws IllegalArgumentException {
        ArrayList<NonversionedField> arrayList = this._propertySchema.nonversionedVertexProperties();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).name().equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("invalid field");
    }

    public int getEdgeFieldId(String string) {
        ArrayList<NonversionedField> arrayList = this._propertySchema.nonversionedEdgeProperties();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).name().equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("invalid field");
    }

    public VertexIterator.AllVerticesIterator getNewAllVerticesIterator() {
        return new VertexIterator.AllVerticesIterator(this._vmgr);
    }

    public VertexIterator.WindowedVertexIterator getNewWindowedVertexIterator(long l, long l2) {
        return new VertexIterator.WindowedVertexIterator(this._vmgr, l, l2);
    }

    public EdgeIterator.AllEdgesIterator getNewAllEdgesIterator() {
        return new EdgeIterator.AllEdgesIterator(this._emgr);
    }

    public EdgeIterator.WindowedEdgeIterator getNewWindowedEdgeIterator(long l, long l2) {
        return new EdgeIterator.WindowedEdgeIterator(this._emgr, l, l2);
    }

    public VertexIterator.MTAllVerticesManager getNewMTAllVerticesManager(RaphtoryThreadPool raphtoryThreadPool) {
        VertexIterator.MTAllVerticesManager mTAllVerticesManager = new VertexIterator.MTAllVerticesManager();
        mTAllVerticesManager.init(this._vmgr, raphtoryThreadPool);
        return mTAllVerticesManager;
    }

    public VertexIterator.MTWindowedVertexManager getNewMTWindowedVertexManager(RaphtoryThreadPool raphtoryThreadPool, long l, long l2) {
        VertexIterator.MTWindowedVertexManager mTWindowedVertexManager = new VertexIterator.MTWindowedVertexManager();
        mTWindowedVertexManager.init(this._vmgr, raphtoryThreadPool, l, l2);
        return mTWindowedVertexManager;
    }

    public EdgeIterator.MTAllEdgesManager getNewMTAllEdgesManager(RaphtoryThreadPool raphtoryThreadPool) {
        EdgeIterator.MTAllEdgesManager mTAllEdgesManager = new EdgeIterator.MTAllEdgesManager();
        mTAllEdgesManager.init(this._emgr, raphtoryThreadPool);
        return mTAllEdgesManager;
    }

    public VertexHistoryIterator.WindowedVertexHistoryIterator getNewVertexHistoryIterator() {
        return this.getNewVertexHistoryIterator(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public VertexHistoryIterator.WindowedVertexHistoryIterator getNewVertexHistoryIterator(long l, long l2) {
        return new VertexHistoryIterator.WindowedVertexHistoryIterator(this._vmgr, l, l2);
    }

    public VertexHistoryIterator.WindowedVertexHistoryIterator getNewVertexHistoryIterator(long l, long l2, long l3) {
        return new VertexHistoryIterator.WindowedVertexHistoryIterator(this._vmgr, l, l2, l3);
    }

    public EdgeHistoryIterator.WindowedEdgeHistoryIterator getNewEdgeHistoryIterator(long l, long l2) {
        return new EdgeHistoryIterator.WindowedEdgeHistoryIterator(this._emgr, l, l2);
    }

    public EdgeHistoryIterator.WindowedEdgeHistoryIterator getNewEdgeHistoryIterator(long l, long l2, long l3) {
        return new EdgeHistoryIterator.WindowedEdgeHistoryIterator(this._emgr, l, l2, l3);
    }

    public void takeSnapshot(long l, long l2) {
        VertexIterator.MTWindowedVertexManager mTWindowedVertexManager = new VertexIterator.MTWindowedVertexManager();
        mTWindowedVertexManager.init(this.getVertexMgr(), RaphtoryThreadPool.THREAD_POOL, l, l2);
        int n2 = this.getVertexMgr().nPartitions();
        LongArrayList[] longArrayListArray = new LongArrayList[n2];
        LongArrayList[] longArrayListArray2 = new LongArrayList[n2];
        for (int i = 0; i < n2; ++i) {
            longArrayListArray[i] = new LongArrayList(1024);
            longArrayListArray2[i] = new LongArrayList(1024);
        }
        AtomicLong atomicLong = new AtomicLong();
        AtomicLong atomicLong2 = new AtomicLong();
        long l3 = System.currentTimeMillis();
        mTWindowedVertexManager.start((n, vertexIterator) -> {
            VertexIterator.WindowedVertexHistoryIterator windowedVertexHistoryIterator = (VertexIterator.WindowedVertexHistoryIterator)vertexIterator;
            LongArrayList longArrayList = longArrayListArray[n];
            LongArrayList longArrayList2 = longArrayListArray2[n];
            int n2 = 0;
            int n3 = 0;
            while (windowedVertexHistoryIterator.hasNext()) {
                longArrayList.add(windowedVertexHistoryIterator.next());
                longArrayList2.add(windowedVertexHistoryIterator.getModificationTime());
                ++n3;
                EdgeIterator edgeIterator = windowedVertexHistoryIterator.getAllEdges();
                while (edgeIterator.hasNext()) {
                    edgeIterator.next();
                    ++n2;
                }
            }
            atomicLong2.addAndGet(n3);
            atomicLong.addAndGet(n2);
        });
        mTWindowedVertexManager.waitTilComplete();
        long l4 = System.currentTimeMillis();
        System.out.println("From: " + new Date(l) + " took " + (l4 - l3) + "ms, vc=" + atomicLong2.get() + ", ec=" + atomicLong.get());
    }

    protected static int roundUpToPowerOfTwo(int n) {
        int n2 = Integer.highestOneBit(n);
        return n > n2 ? n2 << 1 : n2;
    }

    public RaphtoryStatistics getStatistics() {
        return this._stats;
    }

    public void dump() {
        PrintStream printStream = System.out;
        printStream.println("Raphtory Arrow Partition " + this._raphtoryPartitionId);
        VertexIterator.AllVerticesIterator allVerticesIterator = this.getNewAllVerticesIterator();
        while (allVerticesIterator.hasNext()) {
            allVerticesIterator.next();
            printStream.println(allVerticesIterator.getGlobalVertexId());
        }
        printStream.println("\n");
        allVerticesIterator = this.getNewAllVerticesIterator();
        while (allVerticesIterator.hasNext()) {
            long l;
            allVerticesIterator.next();
            printStream.println(allVerticesIterator.getGlobalVertexId() + " -> nEdges=" + (allVerticesIterator.getNOutgoingEdges() + allVerticesIterator.getNIncomingEdges()));
            EdgeIterator edgeIterator = ((VertexIterator)allVerticesIterator).getIncomingEdges();
            int n = 0;
            while (edgeIterator.hasNext()) {
                l = edgeIterator.next();
                printStream.println("    I " + n + " -> " + l + ", f=" + this.getGlobalId(edgeIterator.getSrcVertexId(), edgeIterator.isSrcVertexLocal()) + ", t=" + this.getGlobalId(edgeIterator.getDstVertexId(), edgeIterator.isDstVertexLocal()));
                ++n;
            }
            edgeIterator = ((VertexIterator)allVerticesIterator).getOutgoingEdges();
            while (edgeIterator.hasNext()) {
                l = edgeIterator.next();
                printStream.println("    O " + n + " -> " + l + ", f=" + this.getGlobalId(edgeIterator.getSrcVertexId(), edgeIterator.isSrcVertexLocal()) + ", t=" + this.getGlobalId(edgeIterator.getDstVertexId(), edgeIterator.isDstVertexLocal()));
                ++n;
            }
            printStream.println();
        }
        printStream.flush();
        System.out.println(new Date() + ": allVerticesIterator finished");
    }

    private long getGlobalId(long l, boolean bl) {
        if (!bl) {
            return l;
        }
        return this._vmgr.getGlobalVertexId(l);
    }

    public static class RaphtoryArrowPartitionConfig {
        public PropertySchema _propertySchema;
        public String _arrowDir;
        public int _raphtoryPartitionId;
        public int _nRaphtoryPartitions;
        public int _nLocalEntityIdMaps = 256;
        public int _localEntityIdMapSize = 1024;
        public boolean _syncIDMap = true;
        public int _vertexPartitionSize = 0x100000;
        public int _edgePartitionSize = 0x200000;
        public boolean _disableBoundsCheck = true;
    }
}

