/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class NonversionedField {
    public static final HashMap<Class, Supplier<ArrowType>> _typeMap = new HashMap();
    public static final HashMap<Class, Supplier<SchemaFieldAccessor>> _schemaAccessorMap = new HashMap();
    public static final HashMap<Class, Supplier<EntityFieldAccessor>> _entityAccessorMap = new HashMap();
    protected final String _name;
    protected final Class _class;
    protected final Supplier<EntityFieldAccessor> _faSupplier;
    protected int _parentSchemaFieldIndex;

    public NonversionedField(String string, Class clazz) {
        this._name = string.toLowerCase();
        this._class = clazz;
        this._faSupplier = _entityAccessorMap.get(this._class);
    }

    protected void setParentSchemaFieldIndex(int n) {
        this._parentSchemaFieldIndex = n;
    }

    public String name() {
        return this._name;
    }

    public void addToSchema(List<Field> list) {
        Field field = new Field(this._name, new FieldType(false, _typeMap.get(this._class).get(), null), null);
        list.add(field);
    }

    public SchemaFieldAccessor getNewSchemaFieldAccessor(VectorSchemaRoot vectorSchemaRoot) {
        SchemaFieldAccessor schemaFieldAccessor = _schemaAccessorMap.get(this._class).get();
        schemaFieldAccessor.initialise(vectorSchemaRoot, this._parentSchemaFieldIndex);
        return schemaFieldAccessor;
    }

    public EntityFieldAccessor getNewEntityFieldAccessor() {
        EntityFieldAccessor entityFieldAccessor = this._faSupplier.get();
        return entityFieldAccessor;
    }

    static {
        _typeMap.put(Byte.TYPE, () -> new ArrowType.Int(8, true));
        _typeMap.put(Short.TYPE, () -> new ArrowType.Int(16, true));
        _typeMap.put(Integer.TYPE, () -> new ArrowType.Int(32, true));
        _typeMap.put(Long.TYPE, () -> new ArrowType.Int(64, true));
        _typeMap.put(Float.TYPE, () -> new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
        _typeMap.put(Double.TYPE, () -> new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
        _typeMap.put(Boolean.TYPE, ArrowType.Bool::new);
        _typeMap.put(StringBuilder.class, ArrowType.Utf8::new);
        _schemaAccessorMap.put(Byte.TYPE, SchemaFieldAccessor.ByteFieldAccessor::new);
        _schemaAccessorMap.put(Short.TYPE, SchemaFieldAccessor.ShortFieldAccessor::new);
        _schemaAccessorMap.put(Integer.TYPE, SchemaFieldAccessor.IntFieldAccessor::new);
        _schemaAccessorMap.put(Long.TYPE, SchemaFieldAccessor.LongFieldAccessor::new);
        _schemaAccessorMap.put(Float.TYPE, SchemaFieldAccessor.FloatFieldAccessor::new);
        _schemaAccessorMap.put(Double.TYPE, SchemaFieldAccessor.DoubleFieldAccessor::new);
        _schemaAccessorMap.put(Boolean.TYPE, SchemaFieldAccessor.BooleanFieldAccessor::new);
        _schemaAccessorMap.put(StringBuilder.class, SchemaFieldAccessor.StringFieldAccessor::new);
        _entityAccessorMap.put(Byte.TYPE, EntityFieldAccessor.ByteFieldAccessor::new);
        _entityAccessorMap.put(Short.TYPE, EntityFieldAccessor.ShortFieldAccessor::new);
        _entityAccessorMap.put(Integer.TYPE, EntityFieldAccessor.IntFieldAccessor::new);
        _entityAccessorMap.put(Long.TYPE, EntityFieldAccessor.LongFieldAccessor::new);
        _entityAccessorMap.put(Float.TYPE, EntityFieldAccessor.FloatFieldAccessor::new);
        _entityAccessorMap.put(Double.TYPE, EntityFieldAccessor.DoubleFieldAccessor::new);
        _entityAccessorMap.put(Boolean.TYPE, EntityFieldAccessor.BooleanFieldAccessor::new);
        _entityAccessorMap.put(StringBuilder.class, EntityFieldAccessor.StringFieldAccessor::new);
    }
}

