/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

public abstract class EntityFieldAccessor {
    protected boolean _isSet;

    protected EntityFieldAccessor() {
    }

    public boolean isSet() {
        return this._isSet;
    }

    public void reset() {
        this._isSet = false;
    }

    public void set(byte by) {
        throw new IllegalArgumentException("value is not byte");
    }

    public void set(short s) {
        throw new IllegalArgumentException("value is not short");
    }

    public void set(int n) {
        throw new IllegalArgumentException("value is not int");
    }

    public void set(long l) {
        throw new IllegalArgumentException("value is not long");
    }

    public void set(float f) {
        throw new IllegalArgumentException("value is not float");
    }

    public void set(double d) {
        throw new IllegalArgumentException("value is not double");
    }

    public void set(boolean bl) {
        throw new IllegalArgumentException("value is not boolean");
    }

    public void set(CharSequence charSequence) {
        throw new IllegalArgumentException("value is not string");
    }

    public void setEnum(int n) {
        throw new IllegalArgumentException("value is not enum");
    }

    public void setEnum(Enum<?> enum_) {
        throw new IllegalArgumentException("value is not enum");
    }

    public void set(Object object) {
        throw new UnsupportedOperationException();
    }

    public int getInt() {
        throw new IllegalArgumentException("value is not int");
    }

    public long getLong() {
        throw new IllegalArgumentException("value is not long");
    }

    public float getFloat() {
        throw new IllegalArgumentException("value is not float");
    }

    public double getDouble() {
        throw new IllegalArgumentException("value is not double");
    }

    public boolean getBoolean() {
        throw new IllegalArgumentException("value is not boolean");
    }

    public StringBuilder getString() {
        throw new IllegalArgumentException("value is not string");
    }

    public Enum<?> getEnum() {
        throw new IllegalArgumentException("value is not enum");
    }

    public Object get() {
        throw new UnsupportedOperationException();
    }

    public byte getByte() {
        throw new IllegalArgumentException("value is not byte");
    }

    public short getShort() {
        throw new IllegalArgumentException("value is not short");
    }

    public static final class StringFieldAccessor
    extends EntityFieldAccessor {
        private StringBuilder _value = new StringBuilder();

        @Override
        public void set(CharSequence charSequence) {
            this._value.setLength(0);
            this._value.append(charSequence);
            this._isSet = true;
        }

        @Override
        public StringBuilder getString() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value.setLength(0);
        }
    }

    public static final class BooleanFieldAccessor
    extends EntityFieldAccessor {
        private boolean _value;

        @Override
        public void set(boolean bl) {
            this._value = bl;
            this._isSet = true;
        }

        @Override
        public boolean getBoolean() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = false;
        }
    }

    public static final class DoubleFieldAccessor
    extends EntityFieldAccessor {
        private double _value;

        @Override
        public void set(double d) {
            this._value = d;
            this._isSet = true;
        }

        @Override
        public double getDouble() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0.0;
        }
    }

    public static final class FloatFieldAccessor
    extends EntityFieldAccessor {
        private float _value;

        @Override
        public void set(float f) {
            this._value = f;
            this._isSet = true;
        }

        @Override
        public float getFloat() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0.0f;
        }
    }

    public static final class LongFieldAccessor
    extends EntityFieldAccessor {
        private long _value;

        @Override
        public void set(long l) {
            this._value = l;
            this._isSet = true;
        }

        @Override
        public long getLong() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0L;
        }
    }

    public static final class IntFieldAccessor
    extends EntityFieldAccessor {
        private int _value;

        @Override
        public void set(int n) {
            this._value = n;
            this._isSet = true;
        }

        @Override
        public int getInt() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0;
        }
    }

    public static final class ShortFieldAccessor
    extends EntityFieldAccessor {
        private short _value;

        @Override
        public void set(short s) {
            this._value = s;
            this._isSet = true;
        }

        @Override
        public short getShort() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0;
        }
    }

    public static final class ByteFieldAccessor
    extends EntityFieldAccessor {
        private byte _value;

        @Override
        public void set(byte by) {
            this._value = by;
            this._isSet = true;
        }

        @Override
        public byte getByte() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0;
        }
    }
}

