/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.ArrowPropertyIterator;
import com.raphtory.arrowcore.implementation.EdgeHistoryPartition;
import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryThreadPool;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VertexEdgeIndexPartition;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.model.Edge;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.concurrent.Future;

public abstract class EdgeIterator {
    private static final ThreadLocal<WindowedEdgeIterator> _vwesTL = ThreadLocal.withInitial(() -> new WindowedEdgeIterator());
    private static final ThreadLocal<AllEdgesIterator> _aewesTL = ThreadLocal.withInitial(() -> new AllEdgesIterator());
    protected boolean _hasNext = false;
    protected boolean _getNext = true;
    protected EdgePartitionManager _aepm;
    protected EdgePartition _edgePartition;
    protected int _partitionId = -1;
    protected int _edgeRowId;
    protected long _edgeId;
    protected EntityFieldAccessor[] _efa = null;
    protected VersionedEntityPropertyAccessor[] _vefa = null;
    protected ArrowPropertyIterator[] _propertyIterators = null;
    protected VersionedEntityPropertyAccessor[] _propertyIteratorAccessors = null;
    private EdgeHistoryPartition.EdgeHistoryBoundedBinarySearch _isAliveSearcher;

    protected void init(EdgePartitionManager edgePartitionManager) {
        this._aepm = edgePartitionManager;
        this._edgePartition = null;
        this._partitionId = -1;
        this._edgeRowId = -1;
        this._edgeId = -1L;
        this._hasNext = false;
        this._getNext = true;
    }

    protected void init(EdgePartitionManager edgePartitionManager, EdgePartition edgePartition) {
        this._aepm = edgePartitionManager;
        this._edgePartition = edgePartition;
        this._partitionId = this._edgePartition.getPartitionId();
        this._edgeRowId = -1;
        this._edgeId = -1L;
        this._hasNext = false;
        this._getNext = true;
    }

    public boolean reset(long l) {
        this._edgeId = l;
        this._edgeRowId = this._aepm.getRowId(l);
        this._edgePartition = this._aepm.getPartition(this._aepm.getPartitionId(l));
        this._hasNext = this._edgeId != -1L && this._edgePartition != null && this._edgePartition.isValidRow(this._edgeRowId);
        this._getNext = false;
        return this._hasNext;
    }

    protected void clear() {
        this._edgeId = -1L;
        this._edgeRowId = -1;
        this._edgePartition = null;
        this._hasNext = false;
        this._getNext = false;
    }

    public boolean isAliveAt(long l, long l2) {
        if (this._isAliveSearcher != null) {
            return this._edgePartition.isAliveAt(this._edgeId, l, l2, this._isAliveSearcher);
        }
        this._isAliveSearcher = new EdgeHistoryPartition.EdgeHistoryBoundedBinarySearch();
        return this._edgePartition.isAliveAt(this._edgeId, l, l2, this._isAliveSearcher);
    }

    public EntityFieldAccessor getField(int n) {
        if (this._efa == null) {
            this._efa = this._aepm._raphtoryPartition.createEdgeEntityFieldAccessors();
        }
        this._edgePartition._fieldAccessors[n].load(this._efa[n], this._edgeRowId);
        return this._efa[n];
    }

    public VersionedEntityPropertyAccessor getProperty(int n) {
        if (this._vefa == null) {
            this._vefa = this._aepm._raphtoryPartition.createEdgeEntityPropertyAccessors();
        }
        int n2 = this._edgePartition.getPropertyPrevPtrByRow(n, this._edgeRowId);
        this._edgePartition._propertyStores[n].retrieveProperty(n2, this._vefa[n]);
        return this._vefa[n];
    }

    public final long next() {
        if (this._getNext) {
            this.moveToNext();
        }
        this._getNext = true;
        return this._edgeId;
    }

    public final boolean hasNext() {
        if (this._getNext) {
            this._hasNext = this.moveToNext();
            this._getNext = false;
        }
        return this._hasNext;
    }

    public final EdgePartition getPartition() {
        return this._edgePartition;
    }

    protected abstract boolean moveToNext();

    public long getEdgeId() {
        return this._edgeId;
    }

    public Edge getEdge() {
        return this._edgePartition.getEdge(this._edgeId);
    }

    public long getSrcVertexId() {
        return this._edgePartition.getSrcVertexId(this._edgeRowId);
    }

    public long getDstVertexId() {
        return this._edgePartition.getDstVertexId(this._edgeRowId);
    }

    public boolean isSrcVertexLocal() {
        return this._edgePartition.isSrcVertexLocal(this._edgeRowId);
    }

    public boolean isSrcVertexGlobal() {
        return this._edgePartition.isSrcVertexGlobal(this._edgeRowId);
    }

    public boolean isDstVertexLocal() {
        return this._edgePartition.isDstVertexLocal(this._edgeRowId);
    }

    public boolean isDstVertexGlobal() {
        return this._edgePartition.isDstVertexGlobal(this._edgeRowId);
    }

    public long getCreationTime() {
        return this._edgePartition._getCreationTime(this._edgeRowId);
    }

    public ArrowPropertyIterator getPropertyHistory(int n) {
        if (this._propertyIterators == null) {
            this._propertyIteratorAccessors = this._edgePartition._aepm._raphtoryPartition.createEdgeEntityPropertyAccessors();
            this._propertyIterators = new ArrowPropertyIterator[this._propertyIteratorAccessors.length];
            for (int i = 0; i < this._propertyIterators.length; ++i) {
                this._propertyIterators[i] = new ArrowPropertyIterator.AllPropertiesIterator();
                this._propertyIterators[i].init(this._edgePartition._propertyStores[n]._store, this._edgePartition._propertyStores[n]._accessor, this._propertyIteratorAccessors[i], -1);
            }
        }
        this._propertyIterators[n].init(this._edgePartition._propertyStores[n]._store, this._edgePartition._propertyStores[n]._accessor, this._propertyIteratorAccessors[n], this._edgePartition.getPropertyPrevPtrByRow(n, this._edgeRowId));
        return this._propertyIterators[n];
    }

    protected static WindowedEdgeIterator getNextAliveAtWithWindowVector(EdgePartitionManager edgePartitionManager, long l, long l2) {
        WindowedEdgeIterator windowedEdgeIterator = _vwesTL.get();
        windowedEdgeIterator.init(edgePartitionManager, l, l2);
        return windowedEdgeIterator;
    }

    protected static AllEdgesIterator getAllEdges(EdgePartitionManager edgePartitionManager, EdgePartition edgePartition) {
        AllEdgesIterator allEdgesIterator = _aewesTL.get();
        allEdgesIterator.init(edgePartitionManager, edgePartition);
        return allEdgesIterator;
    }

    public static class MatchingEdgesIterator
    extends EdgeIterator {
        protected VertexPartition _vp;
        protected long _srcVertexId;
        protected long _dstVertexId;
        protected boolean _dstIsGlobal;
        protected int _nOutgoingEdges;
        protected VertexEdgeIndexPartition _veip;
        protected int _firstIndex;
        protected int _lastIndex;
        protected int _vertexRowId;
        protected int _index;

        protected void findEdgesViaVertex(VertexPartition vertexPartition, long l, long l2, boolean bl, int n) {
            this._vp = vertexPartition;
            this._srcVertexId = l;
            this._dstVertexId = l2;
            this._dstIsGlobal = bl;
            this._nOutgoingEdges = n;
            if (n > 0) {
                this._veip = vertexPartition._edgeIndex;
                this._vertexRowId = vertexPartition._apm.getRowId(l);
                this._veip.findMatchingEdges(this);
                this._index = this._lastIndex;
            } else {
                this._index = -1;
            }
        }

        @Override
        protected boolean moveToNext() {
            while (this._index != -1 && this._index >= this._firstIndex) {
                int n = this._veip.getVertexRowIdByIndexRowId(this._index);
                boolean bl = this._veip.getDstIsGlobalByRowId(n);
                if (bl == this._dstIsGlobal) {
                    long l = this._veip.getEdgeIdByRowId(n);
                    this.reset(l);
                    --this._index;
                    return true;
                }
                --this._index;
            }
            return false;
        }
    }

    public static class AllWindowedEdgeIteratorFromVertex
    extends EdgeIterator {
        private final WindowedEdgeIteratorFromVertex _incoming = new WindowedEdgeIteratorFromVertex();
        private final WindowedEdgeIteratorFromVertex _outgoing = new WindowedEdgeIteratorFromVertex();
        private LongOpenHashSet _processedEdges = new LongOpenHashSet();
        private WindowedEdgeIteratorFromVertex _delegate = null;

        protected void init(EdgePartitionManager edgePartitionManager, long l, long l2, long l3, long l4) {
            super.init(edgePartitionManager);
            this._incoming.init(edgePartitionManager, l, true, l3, l4);
            this._outgoing.init(edgePartitionManager, l2, false, l3, l4);
            this._delegate = this._incoming;
            this._processedEdges.clear();
        }

        @Override
        protected boolean moveToNext() {
            block2: {
                long l;
                boolean bl;
                do {
                    boolean bl2;
                    if (!(bl2 = this._delegate.hasNext()) && this._delegate == this._incoming) {
                        this._delegate = this._outgoing;
                        bl2 = this._delegate.hasNext();
                    }
                    if (!bl2) break block2;
                    l = this._delegate.next();
                    boolean bl3 = bl = this._delegate.getSrcVertexId() == this._delegate.getDstVertexId() && this._delegate.isSrcVertexLocal() && this._delegate.isDstVertexLocal();
                } while (bl && !this._processedEdges.add(l));
                this._edgePartition = this._delegate._edgePartition;
                this._partitionId = this._delegate._partitionId;
                this._edgeRowId = this._delegate._edgeRowId;
                this._edgeId = this._delegate._edgeId;
                return true;
            }
            return false;
        }
    }

    public static class WindowedEdgeIteratorFromVertex
    extends EdgeIterator {
        private boolean _incoming;
        private long _startTime;
        private long _endTime;

        protected void init(EdgePartitionManager edgePartitionManager, long l, boolean bl, long l2, long l3) {
            super.init(edgePartitionManager);
            this._incoming = bl;
            this._startTime = l2;
            this._endTime = l3;
            this._edgeId = l;
            while (this._edgeId != -1L) {
                this.reset(this._edgeId);
                if (this.isAliveAt(this._startTime, this._endTime)) break;
                if (this._incoming) {
                    this._edgeId = this._edgePartition._getPrevIncomingPtrByRow(this._edgeRowId);
                    continue;
                }
                this._edgeId = this._edgePartition._getPrevOutgoingPtrByRow(this._edgeRowId);
            }
            if (this._edgeId == -1L) {
                this.clear();
            }
        }

        @Override
        protected boolean moveToNext() {
            if (this._edgePartition == null) {
                this._edgeRowId = -1;
                this._edgeId = -1L;
                return false;
            }
            do {
                this._edgeId = this._incoming ? this._edgePartition._getPrevIncomingPtrByRow(this._edgeRowId) : this._edgePartition._getPrevOutgoingPtrByRow(this._edgeRowId);
                if (this._edgeId == -1L) {
                    this._edgePartition = null;
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                    return false;
                }
                this._edgeRowId = this._aepm.getRowId(this._edgeId);
                this._edgePartition = this._aepm.getPartition(this._aepm.getPartitionId(this._edgeId));
            } while (!this.isAliveAt(this._startTime, this._endTime));
            return true;
        }
    }

    public static class EdgeIteratorFromVertex
    extends EdgeIterator {
        private boolean _incoming;

        protected void init(EdgePartitionManager edgePartitionManager, long l, boolean bl) {
            super.init(edgePartitionManager);
            this._incoming = bl;
            if (l != -1L) {
                this.reset(l);
            }
        }

        @Override
        protected boolean moveToNext() {
            if (this._edgePartition == null) {
                this._edgeRowId = -1;
                this._edgeId = -1L;
                return false;
            }
            this._edgeId = this._incoming ? this._edgePartition._getPrevIncomingPtrByRow(this._edgeRowId) : this._edgePartition._getPrevOutgoingPtrByRow(this._edgeRowId);
            if (this._edgeId == -1L) {
                this._edgePartition = null;
                this._edgeRowId = -1;
                this._edgeId = -1L;
                return false;
            }
            this._edgeRowId = this._aepm.getRowId(this._edgeId);
            this._edgePartition = this._aepm.getPartition(this._aepm.getPartitionId(this._edgeId));
            return true;
        }
    }

    public static class AllEdgesIteratorFromVertex
    extends EdgeIterator {
        private final EdgeIteratorFromVertex _incoming = new EdgeIteratorFromVertex();
        private final EdgeIteratorFromVertex _outgoing = new EdgeIteratorFromVertex();
        private EdgeIteratorFromVertex _delegate = null;
        private LongOpenHashSet _processedEdges = new LongOpenHashSet();

        protected void init(EdgePartitionManager edgePartitionManager, long l, long l2) {
            super.init(edgePartitionManager);
            this._incoming.init(edgePartitionManager, l, true);
            this._outgoing.init(edgePartitionManager, l2, false);
            this._delegate = this._incoming;
            this._processedEdges.clear();
        }

        @Override
        protected boolean moveToNext() {
            block2: {
                long l;
                boolean bl;
                do {
                    boolean bl2;
                    if (!(bl2 = this._delegate.hasNext()) && this._delegate == this._incoming) {
                        this._delegate = this._outgoing;
                        bl2 = this._delegate.hasNext();
                    }
                    if (!bl2) break block2;
                    l = this._delegate.next();
                    boolean bl3 = bl = this._delegate.getSrcVertexId() == this._delegate.getDstVertexId() && this._delegate.isSrcVertexLocal() && this._delegate.isDstVertexLocal();
                } while (bl && !this._processedEdges.add(l));
                this._edgePartition = this._delegate._edgePartition;
                this._partitionId = this._delegate._partitionId;
                this._edgeRowId = this._delegate._edgeRowId;
                this._edgeId = this._delegate._edgeId;
                return true;
            }
            return false;
        }
    }

    public static class AllEdgesIterator
    extends EdgeIterator {
        protected long _index = -1L;
        protected boolean _doAll = true;

        private AllEdgesIterator() {
        }

        protected AllEdgesIterator(EdgePartitionManager edgePartitionManager) {
            this.init(edgePartitionManager);
        }

        @Override
        public boolean reset(long l) {
            if (super.reset(l)) {
                this._partitionId = this._edgePartition._partitionId;
                return true;
            }
            this._partitionId = -1;
            return false;
        }

        @Override
        protected void init(EdgePartitionManager edgePartitionManager) {
            super.init(edgePartitionManager);
            this._index = -1L;
            this._doAll = true;
        }

        @Override
        protected void init(EdgePartitionManager edgePartitionManager, EdgePartition edgePartition) {
            super.init(edgePartitionManager, edgePartition);
            this._index = -1L;
            this._doAll = false;
        }

        @Override
        protected boolean moveToNext() {
            while (true) {
                if (this._doAll && this._edgePartition == null) {
                    this._edgePartition = this._aepm.getPartition(++this._partitionId);
                    this._edgeRowId = -1;
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                }
                if (this._edgePartition == null) {
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                    return false;
                }
                if (this._edgePartition.isValidRow(++this._edgeRowId)) break;
                this._edgePartition = null;
                this._edgeRowId = -1;
                this._edgeId = -1L;
            }
            this._edgeId = this._edgePartition._getLocalEdgeIdByRow(this._edgeRowId);
            return true;
        }
    }

    public static class WindowedEdgeIterator
    extends EdgeIterator {
        protected LongOpenHashSet _processedEdges = new LongOpenHashSet(1024);
        protected long _minTime;
        protected long _maxTime;
        protected int _firstIndex;
        protected int _lastIndex;
        protected int _index;
        protected boolean _firstTime = true;

        private WindowedEdgeIterator() {
        }

        protected WindowedEdgeIterator(EdgePartitionManager edgePartitionManager, long l, long l2) {
            this.init(edgePartitionManager, l, l2);
        }

        private void init(EdgePartitionManager edgePartitionManager, long l, long l2) {
            super.init(edgePartitionManager);
            this._minTime = l;
            this._maxTime = l2;
            this._firstTime = true;
            this._index = -1;
        }

        private long getNext() {
            while (true) {
                if (this._edgePartition == null) {
                    this._edgePartition = this._aepm.getPartition(++this._partitionId);
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._processedEdges.clear();
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                }
                if (this._edgePartition == null) {
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                    return -1L;
                }
                if (this._lastIndex != -1) {
                    if (this._index >= this._firstIndex) {
                        int n = this._edgePartition._history.getHistoryRowIdBySortedIndex(this._index);
                        boolean bl = this._edgePartition._history.getIsAliveByRowId(n);
                        this._edgeRowId = this._edgePartition._history.getEdgeLocalRowIdByHistoryRowId(n);
                        if (!this._processedEdges.contains((long)this._edgeRowId)) {
                            this._processedEdges.add((long)this._edgeRowId);
                            if (bl) {
                                return this._edgePartition._getLocalEdgeIdByRow(this._edgeRowId);
                            }
                        } else {
                            --this._index;
                            continue;
                        }
                    }
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._edgePartition = null;
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                    continue;
                }
                this._edgePartition._history.isAliveAtWithWindowVector(this);
                if (this._lastIndex == -1) {
                    this._edgePartition = null;
                    this._edgeRowId = -1;
                    this._edgeId = -1L;
                    continue;
                }
                this._index = this._lastIndex;
            }
        }

        @Override
        protected boolean moveToNext() {
            if (!this._firstTime) {
                --this._index;
            } else {
                this._firstTime = false;
            }
            this._edgeId = this.getNext();
            return this._edgeId != -1L;
        }
    }

    public static class MTAllEdgesManager {
        private final ArrayList<Future<?>> _tasks = new ArrayList();
        EdgePartitionManager _aepm;
        RaphtoryThreadPool _pool;

        protected MTAllEdgesManager() {
        }

        protected void init(EdgePartitionManager edgePartitionManager, RaphtoryThreadPool raphtoryThreadPool) {
            this._aepm = edgePartitionManager;
            this._pool = raphtoryThreadPool;
        }

        public synchronized void start(MTEdgeIteratorConsumer mTEdgeIteratorConsumer) {
            EdgePartition edgePartition;
            int n = 0;
            this._tasks.clear();
            while ((edgePartition = this._aepm.getPartition(n++)) != null) {
                IterTask iterTask = new IterTask(edgePartition, mTEdgeIteratorConsumer);
                Future<?> future = this._pool.submitTask(iterTask);
                this._tasks.add(future);
            }
        }

        public synchronized void waitTilComplete() {
            this._pool.waitTilComplete(this._tasks);
        }

        public synchronized void cancel() {
            this._pool.cancel(this._tasks);
        }

        private class IterTask
        implements Runnable {
            protected final EdgePartition _pp;
            protected final MTEdgeIteratorConsumer _consumer;

            private IterTask(EdgePartition edgePartition, MTEdgeIteratorConsumer mTEdgeIteratorConsumer) {
                this._pp = edgePartition;
                this._consumer = mTEdgeIteratorConsumer;
            }

            @Override
            public void run() {
                AllEdgesIterator allEdgesIterator = EdgeIterator.getAllEdges(MTAllEdgesManager.this._aepm, this._pp);
                this._consumer.accept(this._pp.getPartitionId(), allEdgesIterator);
            }
        }
    }

    public static interface MTEdgeIteratorConsumer {
        public void accept(int var1, EdgeIterator var2);
    }
}

