/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.spouts;

import cats.effect.kernel.Async;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Spout;
import com.raphtory.api.input.SpoutInstance;
import com.raphtory.spouts.FileSpout$;
import com.raphtory.spouts.FileSpoutInstance;
import fs2.Stream;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A [[com.raphtory.api.input.Spout Spout]] that reads files from disk.\n  *\n  * This Spout takes a given file or folder and reads the contents line by line passing these to the graph builders.\n  * If a file is given, only this will be read, if a folder is provided, all included files fitting the regexPattern will be read.\n  *\n  * As a more advanced feature, the Spout has a generic T type which in combination with the optional lineConverter (String => T) parameter allows each line to be\n  * converted into any serialisable type the user desires as long as a suitable GraphBuilder[T] is provided when building the graph.\n  *\n  * @param path The path to the directory or file the user is interested in reading from.\n  * @param regexPattern A regex pattern used to select only certain files in a folder. Defaults to .csv.\n  * @param reReadFiles A boolean flag specifying if the user wishes the spout to reread the file once it has finished. This is useful for updated log files and monitoring folders where new data is periodically dumped into.\n  * @param recurse A boolean flag for if the user wants the spout to recursively read all subdirectories in a given directory.\n  * @param lineConverter If the FileSpout is intended to output anything other than Strings the user must specify how to make the conversion.\n  *\n  * @example\n  * {{{\n  * import com.raphtory.algorithms.generic.EdgeList\n  * import com.raphtory.sinks.FileSink\n  * import com.raphtory.spouts.FileSpout\n  *\n  * val fileSpout = new FileSpout(\"/path/to/your/data\")\n  * val graph = Raphtory.load(fileSpout, YourGraphBuilder())\n  * val sink = FileSink(\"/tmp/raphtoryTest\")\n  *\n  * graph.execute(EdgeList()).writeTo(sink)\n  * }}}\n  * @see [[com.raphtory.api.input.Spout Spout]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\tue\u0001B\u00181\u0001^B\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tW\u0002\u0011\t\u0012)A\u0005G\"AA\u000e\u0001BK\u0002\u0013\u0005!\r\u0003\u0005n\u0001\tE\t\u0015!\u0003d\u0011!q\u0007A!f\u0001\n\u0003y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q3A\u0005\u0002=D\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\tm\u0002\u0011)\u001a!C\u0001o\"Aa\u0010\u0001B\tB\u0003%\u0001\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003#\u0001A\u0011IA\n\u0011%\tY\u0002AA\u0001\n\u0003\ti\u0002C\u0005\u00026\u0001\t\n\u0011\"\u0001\u00028!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"!\u0019\u0001#\u0003%\t!a\u0019\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005%\u0004\"CA9\u0001\u0005\u0005I\u0011IA:\u0011%\t\u0019\tAA\u0001\n\u0003\t)\tC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0001\u0002\u0010\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"a+\u0001\u0003\u0003%\t%!,\t\u0013\u0005E\u0006!!A\u0005B\u0005M\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u0011%\tI\fAA\u0001\n\u0003\nYlB\u0004\u0002\\BB\t!!8\u0007\r=\u0002\u0004\u0012AAp\u0011\u0019yX\u0004\"\u0001\u0002l\"9\u0011Q^\u000f\u0005\u0002\u0005=\bbBAw;\u0011\u0005\u0011q\u001f\u0005\b\u0003[lB\u0011\u0001B\u0002\u0011%\ti/HA\u0001\n\u0003\u0013I\u0002C\u0005\u00032u\t\n\u0011\"\u0001\u00034!I!qG\u000f\u0012\u0002\u0013\u0005!\u0011\b\u0005\n\u0005{i\u0012\u0013!C\u0001\u0005\u007fA\u0011Ba\u0011\u001e#\u0003%\tA!\u0012\t\u0013\t%S$%A\u0005\u0002\t-\u0003\"\u0003B-;\u0005\u0005I\u0011\u0011B.\u0011%\u0011)(HI\u0001\n\u0003\u00119\bC\u0005\u0003|u\t\n\u0011\"\u0001\u0003~!I!\u0011Q\u000f\u0012\u0002\u0013\u0005!1\u0011\u0005\n\u0005\u000fk\u0012\u0013!C\u0001\u0005\u0013C\u0011B!$\u001e#\u0003%\tAa$\t\u0013\tMU$!A\u0005\n\tU%!\u0003$jY\u0016\u001c\u0006o\\;u\u0015\t\t$'\u0001\u0004ta>,Ho\u001d\u0006\u0003gQ\n\u0001B]1qQR|'/\u001f\u0006\u0002k\u0005\u00191m\\7\u0004\u0001U\u0011\u0001(S\n\u0006\u0001ez$+\u0016\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u0001+u)D\u0001B\u0015\t\u00115)A\u0003j]B,HO\u0003\u0002Ee\u0005\u0019\u0011\r]5\n\u0005\u0019\u000b%!B*q_V$\bC\u0001%J\u0019\u0001!QA\u0013\u0001C\u0002-\u0013\u0011\u0001V\t\u0003\u0019>\u0003\"AO'\n\u00059[$a\u0002(pi\"Lgn\u001a\t\u0003uAK!!U\u001e\u0003\u0007\u0005s\u0017\u0010\u0005\u0002;'&\u0011Ak\u000f\u0002\b!J|G-^2u!\t1fL\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!LN\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!!X\u001e\u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003;n\nA\u0001]1uQV\t1\r\u0005\u0002eQ:\u0011QM\u001a\t\u00031nJ!aZ\u001e\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003On\nQ\u0001]1uQ\u0002\nAB]3hKb\u0004\u0016\r\u001e;fe:\fQB]3hKb\u0004\u0016\r\u001e;fe:\u0004\u0013a\u0003:f%\u0016\fGMR5mKN,\u0012\u0001\u001d\t\u0003uEL!A]\u001e\u0003\u000f\t{w\u000e\\3b]\u0006a!/\u001a*fC\u00124\u0015\u000e\\3tA\u00059!/Z2veN,\u0017\u0001\u0003:fGV\u00148/\u001a\u0011\u0002\u001b1Lg.Z\"p]Z,'\u000f^3s+\u0005A\bc\u0001\u001ezw&\u0011!p\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tib8mR\u0005\u0003{n\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001d1Lg.Z\"p]Z,'\u000f^3sA\u00051A(\u001b8jiz\"B\"a\u0001\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\u0001B!!\u0002\u0001\u000f6\t\u0001\u0007C\u0004b\u0017A\u0005\t\u0019A2\t\u000f1\\\u0001\u0013!a\u0001G\"9an\u0003I\u0001\u0002\u0004\u0001\bb\u0002;\f!\u0003\u0005\r\u0001\u001d\u0005\bm.\u0001\n\u00111\u0001y\u0003)\u0011W/\u001b7e'B|W\u000f\u001e\u000b\u0003\u0003+\u0001B\u0001QA\f\u000f&\u0019\u0011\u0011D!\u0003\u001bM\u0003x.\u001e;J]N$\u0018M\\2f\u0003\u0011\u0019w\u000e]=\u0016\t\u0005}\u0011Q\u0005\u000b\r\u0003C\t9#!\u000b\u0002,\u00055\u0012q\u0006\t\u0006\u0003\u000b\u0001\u00111\u0005\t\u0004\u0011\u0006\u0015B!\u0002&\u000e\u0005\u0004Y\u0005bB1\u000e!\u0003\u0005\ra\u0019\u0005\bY6\u0001\n\u00111\u0001d\u0011\u001dqW\u0002%AA\u0002ADq\u0001^\u0007\u0011\u0002\u0003\u0007\u0001\u000f\u0003\u0005w\u001bA\u0005\t\u0019AA\u0019!\u0011Q\u00140a\r\u0011\u000bib8-a\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!\u0011\u0011HA(+\t\tYDK\u0002d\u0003{Y#!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013Z\u0014AC1o]>$\u0018\r^5p]&!\u0011QJA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006\u0015:\u0011\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\tI$!\u0016\u0005\u000b){!\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u00111LA0+\t\tiFK\u0002q\u0003{!QA\u0013\tC\u0002-\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0003\u0002\\\u0005\u0015D!\u0002&\u0012\u0005\u0004Y\u0015AD2paf$C-\u001a4bk2$H%N\u000b\u0005\u0003W\ny'\u0006\u0002\u0002n)\u001a\u00010!\u0010\u0005\u000b)\u0013\"\u0019A&\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\nAA[1wC&\u0019\u0011.!\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0005c\u0001\u001e\u0002\n&\u0019\u00111R\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007=\u000b\t\nC\u0005\u0002\u0014V\t\t\u00111\u0001\u0002\b\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!'\u0011\u000b\u0005m\u0015\u0011U(\u000e\u0005\u0005u%bAAPw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0016Q\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002q\u0003SC\u0001\"a%\u0018\u0003\u0003\u0005\raT\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002v\u0005=\u0006\"CAJ1\u0005\u0005\t\u0019AAD\u0003!A\u0017m\u001d5D_\u0012,GCAAD\u0003!!xn\u0015;sS:<GCAA;\u0003\u0019)\u0017/^1mgR\u0019\u0001/!0\t\u0011\u0005M5$!AA\u0002=Cs\u0001AAa\u0003+\f9\u000e\u0005\u0003\u0002D\u0006EWBAAc\u0015\u0011\t9-!3\u0002\u0011M\u001c\u0017\r\\1e_\u000eTA!a3\u0002N\u00069A/Y6fu>,'bAAhi\u00051q-\u001b;ik\nLA!a5\u0002F\nA1kY1mC\u0012|7-A\u0003wC2,X-\t\u0002\u0002Z\u0006i9k\f\u0016+A\u0005\u00033lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]%t\u0007/\u001e;/'B|W\u000f\u001e\u0011Ta>,H/X/!i\"\fG\u000f\t:fC\u0012\u001c\bEZ5mKN\u0004cM]8nA\u0011L7o\u001b\u0018\u000bA\u0001R#\u0002\t\u0011+AQC\u0017n\u001d\u0011Ta>,H\u000f\t;bW\u0016\u001c\b%\u0019\u0011hSZ,g\u000e\t4jY\u0016\u0004sN\u001d\u0011g_2$WM\u001d\u0011b]\u0012\u0004#/Z1eg\u0002\"\b.\u001a\u0011d_:$XM\u001c;tA1Lg.\u001a\u0011cs\u0002b\u0017N\\3!a\u0006\u001c8/\u001b8hAQDWm]3!i>\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011ck&dG-\u001a:t])\u0001\u0003E\u000b\u0011JM\u0002\n\u0007EZ5mK\u0002J7\u000fI4jm\u0016tG\u0006I8oYf\u0004C\u000f[5tA]LG\u000e\u001c\u0011cK\u0002\u0012X-\u00193-A%4\u0007%\u0019\u0011g_2$WM\u001d\u0011jg\u0002\u0002(o\u001c<jI\u0016$G\u0006I1mY\u0002Jgn\u00197vI\u0016$\u0007EZ5mKN\u0004c-\u001b;uS:<\u0007\u0005\u001e5fAI,w-\u001a=QCR$XM\u001d8!o&dG\u000e\t2fAI,\u0017\r\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0005\u001b\b%\u0019\u0011n_J,\u0007%\u00193wC:\u001cW\r\u001a\u0011gK\u0006$XO]3-AQDW\rI*q_V$\b\u0005[1tA\u0005\u0004s-\u001a8fe&\u001c\u0007\u0005\u0016\u0011usB,\u0007e\u001e5jG\"\u0004\u0013N\u001c\u0011d_6\u0014\u0017N\\1uS>t\u0007e^5uQ\u0002\"\b.\u001a\u0011paRLwN\\1mA1Lg.Z\"p]Z,'\u000f^3sA!\u001aFO]5oO\u0002jd\b\t+*AA\f'/Y7fi\u0016\u0014\b%\u00197m_^\u001c\b%Z1dQ\u0002b\u0017N\\3!i>\u0004#-\u001a\u0006!A)\u00023m\u001c8wKJ$X\r\u001a\u0011j]R|\u0007%\u00198zAM,'/[1mSN\f'\r\\3!if\u0004X\r\t;iK\u0002*8/\u001a:!I\u0016\u001c\u0018N]3tA\u0005\u001c\b\u0005\\8oO\u0002\n7\u000fI1!gVLG/\u00192mK\u0002:%/\u00199i\u0005VLG\u000eZ3s7Rk\u0006%[:!aJ|g/\u001b3fI\u0002:\b.\u001a8!EVLG\u000eZ5oO\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\f\u0006!A)R\u0001\u0005\t\u0016!\u0001B\f'/Y7!a\u0006$\b\u000e\t+iK\u0002\u0002\u0018\r\u001e5!i>\u0004C\u000f[3!I&\u0014Xm\u0019;pef\u0004sN\u001d\u0011gS2,\u0007\u0005\u001e5fAU\u001cXM\u001d\u0011jg\u0002Jg\u000e^3sKN$X\r\u001a\u0011j]\u0002\u0012X-\u00193j]\u001e\u0004cM]8n])\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011sK\u001e,\u0007\u0010U1ui\u0016\u0014h\u000eI!!e\u0016<W\r\u001f\u0011qCR$XM\u001d8!kN,G\r\t;pAM,G.Z2uA=tG.\u001f\u0011dKJ$\u0018-\u001b8!M&dWm\u001d\u0011j]\u0002\n\u0007EZ8mI\u0016\u0014h\u0006\t#fM\u0006,H\u000e^:!i>\u0004cfY:w])\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011sKJ+\u0017\r\u001a$jY\u0016\u001c\b%\u0011\u0011c_>dW-\u00198!M2\fw\rI:qK\u000eLg-_5oO\u0002Jg\r\t;iK\u0002*8/\u001a:!o&\u001c\b.Z:!i\",\u0007e\u001d9pkR\u0004Co\u001c\u0011sKJ,\u0017\r\u001a\u0011uQ\u0016\u0004c-\u001b7fA=t7-\u001a\u0011ji\u0002B\u0017m\u001d\u0011gS:L7\u000f[3e]\u0001\"\u0006.[:!SN\u0004So]3gk2\u0004cm\u001c:!kB$\u0017\r^3eA1|w\r\t4jY\u0016\u001c\b%\u00198eA5|g.\u001b;pe&tw\r\t4pY\u0012,'o\u001d\u0011xQ\u0016\u0014X\r\t8fo\u0002\"\u0017\r^1!SN\u0004\u0003/\u001a:j_\u0012L7-\u00197ms\u0002\"W/\u001c9fI\u0002Jg\u000e^8/\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t:fGV\u00148/\u001a\u0011BA\t|w\u000e\\3b]\u00022G.Y4!M>\u0014\b%\u001b4!i\",\u0007%^:fe\u0002:\u0018M\u001c;tAQDW\rI:q_V$\b\u0005^8!e\u0016\u001cWO]:jm\u0016d\u0017\u0010\t:fC\u0012\u0004\u0013\r\u001c7!gV\u0014G-\u001b:fGR|'/[3tA%t\u0007%\u0019\u0011hSZ,g\u000e\t3je\u0016\u001cGo\u001c:z])\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011mS:,7i\u001c8wKJ$XM\u001d\u0011JM\u0002\"\b.\u001a\u0011GS2,7\u000b]8vi\u0002J7\u000fI5oi\u0016tG-\u001a3!i>\u0004s.\u001e;qkR\u0004\u0013M\\=uQ&tw\rI8uQ\u0016\u0014\b\u0005\u001e5b]\u0002\u001aFO]5oON\u0004C\u000f[3!kN,'\u000fI7vgR\u00043\u000f]3dS\u001aL\b\u0005[8xAQ|\u0007%\\1lK\u0002\"\b.\u001a\u0011d_:4XM]:j_:t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!fq\u0006l\u0007\u000f\\3\u000bA\u0001R\u0003e_>|\u0015\u0001\u0002#\u0006I5na>\u0014H\u000fI2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u001d,g.\u001a:jG:*EmZ3MSN$(\u0002\t\u0011+A%l\u0007o\u001c:uA\r|WN\f:ba\"$xN]=/g&t7n\u001d\u0018GS2,7+\u001b8l\u0015\u0001\u0002#\u0006I5na>\u0014H\u000fI2p[:\u0012\u0018\r\u001d5u_JLhf\u001d9pkR\u001chFR5mKN\u0003x.\u001e;\u000bA\u0001R#\u0002\t\u0011+AY\fG\u000e\t4jY\u0016\u001c\u0006o\\;uAu\u0002c.Z<!\r&dWm\u00159pkRD#e\f9bi\"|Co\\\u0018z_V\u0014x\u0006Z1uC\nJ#\u0002\t\u0011+AY\fG\u000eI4sCBD\u0007%\u0010\u0011SCBDGo\u001c:z]1|\u0017\r\u001a\u0015gS2,7\u000b]8vi2\u0002\u0013l\\;s\u000fJ\f\u0007\u000f\u001b\"vS2$WM\u001d\u0015*S)\u0001\u0003E\u000b\u0011wC2\u00043/\u001b8lAu\u0002c)\u001b7f'&t7\u000e\u000b\u00120i6\u0004xF]1qQR|'/\u001f+fgR\u0014\u0013F\u0003\u0011!U)\u0001\u0003E\u000b\u0011he\u0006\u0004\bNL3yK\u000e,H/\u001a\u0015FI\u001e,G*[:uQ%Jcf\u001e:ji\u0016$v\u000eK:j].L#\u0002\t\u0011+AulXP\u0003\u0011!U\u0001\u00025/Z3!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0005\u0004\u0018NL5oaV$hf\u00159pkR\u00043\u000b]8vivk&\u0002\t\u0011+_\u0005Ia)\u001b7f'B|W\u000f\u001e\t\u0004\u0003\u000bi2\u0003B\u000f:\u0003C\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0005\u0003O\fi(\u0001\u0002j_&\u0019q,!:\u0015\u0005\u0005u\u0017!B1qa2LH\u0003BAy\u0003g\u0004B!!\u0002\u0001G\"1\u0011Q_\u0010A\u0002\r\faa]8ve\u000e,GCCA}\u0003w\fi0a@\u0003\u0002A!\u0011Q\u0001\u0001M\u0011\u0019\t)\u0010\ta\u0001G\")A\u000e\ta\u0001G\")a\u000e\ta\u0001a\")A\u000f\ta\u0001aV!!Q\u0001B\u0006)1\u00119A!\u0004\u0003\u0010\tE!1\u0003B\u000b!\u0015\t)\u0001\u0001B\u0005!\rA%1\u0002\u0003\u0006\u0015\u0006\u0012\ra\u0013\u0005\u0007\u0003k\f\u0003\u0019A2\t\u000b1\f\u0003\u0019A2\t\u000b9\f\u0003\u0019\u00019\t\u000bQ\f\u0003\u0019\u00019\t\rY\f\u0003\u0019\u0001B\f!\u0015QDp\u0019B\u0005+\u0011\u0011YB!\t\u0015\u0019\tu!1\u0005B\u0013\u0005O\u0011ICa\u000b\u0011\u000b\u0005\u0015\u0001Aa\b\u0011\u0007!\u0013\t\u0003B\u0003KE\t\u00071\nC\u0004bEA\u0005\t\u0019A2\t\u000f1\u0014\u0003\u0013!a\u0001G\"9aN\tI\u0001\u0002\u0004\u0001\bb\u0002;#!\u0003\u0005\r\u0001\u001d\u0005\tm\n\u0002\n\u00111\u0001\u0003.A!!(\u001fB\u0018!\u0015QDp\u0019B\u0010\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nT\u0003BA\u001d\u0005k!QAS\u0012C\u0002-\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0005\u0003s\u0011Y\u0004B\u0003KI\t\u00071*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\tYF!\u0011\u0005\u000b)+#\u0019A&\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*B!a\u0017\u0003H\u0011)!J\nb\u0001\u0017\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$S'\u0006\u0003\u0003N\t]SC\u0001B(U\u0011\u0011\t&!\u0010\u000f\u0007i\u0012\u0019&C\u0002\u0003Vm\nAAT8oK\u0012)!j\nb\u0001\u0017\u00069QO\\1qa2LX\u0003\u0002B/\u0005[\"BAa\u0018\u0003pA!!(\u001fB1!%Q$1M2daB\u00149'C\u0002\u0003fm\u0012a\u0001V;qY\u0016,\u0004\u0003\u0002\u001ez\u0005S\u0002RA\u000f?d\u0005W\u00022\u0001\u0013B7\t\u0015Q\u0005F1\u0001L\u0011%\u0011\t\bKA\u0001\u0002\u0004\u0011\u0019(A\u0002yIA\u0002R!!\u0002\u0001\u0005W\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT\u0003BA\u001d\u0005s\"QAS\u0015C\u0002-\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T\u0003BA\u001d\u0005\u007f\"QA\u0013\u0016C\u0002-\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003BA.\u0005\u000b#QAS\u0016C\u0002-\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T\u0003BA.\u0005\u0017#QA\u0013\u0017C\u0002-\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T\u0003\u0002B'\u0005##QAS\u0017C\u0002-\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa&\u0011\t\u0005]$\u0011T\u0005\u0005\u00057\u000bIH\u0001\u0004PE*,7\r\u001e")
public class FileSpout<T>
implements Spout<T>,
Product,
Serializable {
    private final String path;
    private final String regexPattern;
    private final boolean reReadFiles;
    private final boolean recurse;
    private final Option<Function1<String, T>> lineConverter;

    public static <T> None$ $lessinit$greater$default$5() {
        return FileSpout$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> boolean $lessinit$greater$default$4() {
        return FileSpout$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> boolean $lessinit$greater$default$3() {
        return FileSpout$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> String $lessinit$greater$default$2() {
        return FileSpout$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> String $lessinit$greater$default$1() {
        return FileSpout$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> Option<Tuple5<String, String, Object, Object, Option<Function1<String, T>>>> unapply(FileSpout<T> x$0) {
        return FileSpout$.MODULE$.unapply(x$0);
    }

    public static <T> None$ apply$default$5() {
        return FileSpout$.MODULE$.apply$default$5();
    }

    public static <T> boolean apply$default$4() {
        return FileSpout$.MODULE$.apply$default$4();
    }

    public static <T> boolean apply$default$3() {
        return FileSpout$.MODULE$.apply$default$3();
    }

    public static <T> String apply$default$2() {
        return FileSpout$.MODULE$.apply$default$2();
    }

    public static <T> String apply$default$1() {
        return FileSpout$.MODULE$.apply$default$1();
    }

    public static <T> FileSpout<T> apply(String path, String regexPattern, boolean reReadFiles, boolean recurse, Option<Function1<String, T>> lineConverter) {
        return FileSpout$.MODULE$.apply(path, regexPattern, reReadFiles, recurse, lineConverter);
    }

    public static <T> FileSpout<T> apply(String source, String regexPattern, boolean reReadFiles, boolean recurse, Function1<String, T> lineConverter) {
        return FileSpout$.MODULE$.apply(source, regexPattern, reReadFiles, recurse, lineConverter);
    }

    public static FileSpout<Nothing$> apply(String source, String regexPattern, boolean reReadFiles, boolean recurse) {
        return FileSpout$.MODULE$.apply(source, regexPattern, reReadFiles, recurse);
    }

    public static FileSpout<String> apply(String source) {
        return FileSpout$.MODULE$.apply(source);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public <F> Stream<F, T> asStream(Async<F> evidence$1) {
        return Spout.asStream$(this, evidence$1);
    }

    public String path() {
        return this.path;
    }

    public String regexPattern() {
        return this.regexPattern;
    }

    public boolean reReadFiles() {
        return this.reReadFiles;
    }

    public boolean recurse() {
        return this.recurse;
    }

    public Option<Function1<String, T>> lineConverter() {
        return this.lineConverter;
    }

    @Override
    public SpoutInstance<T> buildSpout() {
        return new FileSpoutInstance<T>(this.path(), this.regexPattern(), this.reReadFiles(), this.recurse(), this.lineConverter());
    }

    public <T> FileSpout<T> copy(String path, String regexPattern, boolean reReadFiles, boolean recurse, Option<Function1<String, T>> lineConverter) {
        return new FileSpout<T>(path, regexPattern, reReadFiles, recurse, lineConverter);
    }

    public <T> String copy$default$1() {
        return this.path();
    }

    public <T> String copy$default$2() {
        return this.regexPattern();
    }

    public <T> boolean copy$default$3() {
        return this.reReadFiles();
    }

    public <T> boolean copy$default$4() {
        return this.recurse();
    }

    public <T> Option<Function1<String, T>> copy$default$5() {
        return this.lineConverter();
    }

    public String productPrefix() {
        return "FileSpout";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.path();
                break;
            }
            case 1: {
                object = this.regexPattern();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.reReadFiles());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.recurse());
                break;
            }
            case 4: {
                object = this.lineConverter();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FileSpout;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "path";
                break;
            }
            case 1: {
                string = "regexPattern";
                break;
            }
            case 2: {
                string = "reReadFiles";
                break;
            }
            case 3: {
                string = "recurse";
                break;
            }
            case 4: {
                string = "lineConverter";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.regexPattern()));
        n = Statics.mix((int)n, (int)(this.reReadFiles() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.recurse() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.lineConverter()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FileSpout)) return false;
        boolean bl = true;
        if (!bl) return false;
        FileSpout fileSpout = (FileSpout)x$1;
        if (this.reReadFiles() != fileSpout.reReadFiles()) return false;
        if (this.recurse() != fileSpout.recurse()) return false;
        String string = this.path();
        String string2 = fileSpout.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.regexPattern();
        String string4 = fileSpout.regexPattern();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<Function1<String, T>> option = this.lineConverter();
        Option<Function1<String, T>> option2 = fileSpout.lineConverter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fileSpout.canEqual(this)) return false;
        return true;
    }

    public FileSpout(String path, String regexPattern, boolean reReadFiles, boolean recurse, Option<Function1<String, T>> lineConverter) {
        this.path = path;
        this.regexPattern = regexPattern;
        this.reReadFiles = reReadFiles;
        this.recurse = recurse;
        this.lineConverter = lineConverter;
        Spout.$init$(this);
        Product.$init$((Product)this);
    }
}

