/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.ImmutableString;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.sources.SqlConnection;
import com.raphtory.sources.SqlSource;
import com.raphtory.sources.SqlSource$;
import com.raphtory.sources.SqlVertexSource$;
import java.io.Serializable;
import java.sql.ResultSet;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** Source for ingesting vertices from SQL Database queries\n  *\n  * This source ingest one vertex from each of the rows returned when submitting the `query`\n  * to the database referred by `conn`.\n  * `id`, `time`, `edgeType`, and `properties` are used to set the names of the columns to use\n  * for the id, the timestamp, the type, and the properties for every edge.\n  *\n  * @param conn the connection to a specific type of database, e.g. `PostgresConnection`\n  * @param query the query to be executed against the the database\n  * @param id the name of the column to use as the id of vertex\n  * @param time the name of the column to use as the timestamp\n  * @param vertexType the name of the column to use as vertex type\n  * @param properties the names of the columns to use as the properties for the vertex\n  */")
@ScalaSignature(bytes="\u0006\u0005\t=c\u0001\u0002\u00180\u0001ZB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003V\u0011!q\u0006A!f\u0001\n\u0003!\u0006\u0002C0\u0001\u0005#\u0005\u000b\u0011B+\t\u0011\u0001\u0004!Q3A\u0005\u0002QC\u0001\"\u0019\u0001\u0003\u0012\u0003\u0006I!\u0016\u0005\tE\u0002\u0011)\u001a!C\u0001)\"A1\r\u0001B\tB\u0003%Q\u000b\u0003\u0005e\u0001\tU\r\u0011\"\u0001f\u0011!I\u0007A!E!\u0002\u00131\u0007\"\u00026\u0001\t\u0003Y\u0007bB:\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007\u007f\u0002\u0001\u000b\u0011B;\t\u000f\u0005\u0005\u0001\u0001\"\u0015\u0002\u0004!9\u0011\u0011\f\u0001\u0005R\u0005m\u0003BBA1\u0001\u0011ES\rC\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003\u0017\u0003\u0011\u0013!C\u0001\u0003\u001bC\u0011\"!%\u0001#\u0003%\t!!$\t\u0013\u0005M\u0005!%A\u0005\u0002\u00055\u0005\"CAK\u0001E\u0005I\u0011AAG\u0011%\t9\nAI\u0001\n\u0003\tI\nC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0011\u0002 \"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"a-\u0001\u0003\u0003%\t%!.\t\u0013\u0005\r\u0007!!A\u0005\u0002\u0005\u0015\u0007\"CAh\u0001\u0005\u0005I\u0011IAi\u0011%\t)\u000eAA\u0001\n\u0003\n9\u000eC\u0005\u0002Z\u0002\t\t\u0011\"\u0011\u0002\\\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0013q\\\u0004\n\u0003\u007f|\u0013\u0011!E\u0001\u0005\u00031\u0001BL\u0018\u0002\u0002#\u0005!1\u0001\u0005\u0007U\u0012\"\tAa\u0007\t\u0013\u0005eG%!A\u0005F\u0005m\u0007\"\u0003B\u000fI\u0005\u0005I\u0011\u0011B\u0010\u0011%\u0011i\u0003JI\u0001\n\u0003\ti\tC\u0005\u00030\u0011\n\n\u0011\"\u0001\u0002\u001a\"I!\u0011\u0007\u0013\u0002\u0002\u0013\u0005%1\u0007\u0005\n\u0005\u0003\"\u0013\u0013!C\u0001\u0003\u001bC\u0011Ba\u0011%#\u0003%\t!!'\t\u0013\t\u0015C%!A\u0005\n\t\u001d#aD*rYZ+'\u000f^3y'>,(oY3\u000b\u0005A\n\u0014aB:pkJ\u001cWm\u001d\u0006\u0003eM\n\u0001B]1qQR|'/\u001f\u0006\u0002i\u0005\u00191m\\7\u0004\u0001M!\u0001aN\u001eB!\tA\u0014(D\u00010\u0013\tQtFA\u0005Tc2\u001cv.\u001e:dKB\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\"K\u001d\t\u0019\u0005J\u0004\u0002E\u000f6\tQI\u0003\u0002Gk\u00051AH]8pizJ\u0011AP\u0005\u0003\u0013v\nq\u0001]1dW\u0006<W-\u0003\u0002L\u0019\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011*P\u0001\u0005G>tg.F\u0001P!\tA\u0004+\u0003\u0002R_\ti1+\u001d7D_:tWm\u0019;j_:\fQaY8o]\u0002\nQ!];fef,\u0012!\u0016\t\u0003-js!a\u0016-\u0011\u0005\u0011k\u0014BA->\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ek\u0014AB9vKJL\b%\u0001\u0002jI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\tQLW.Z\u0001\u0006i&lW\rI\u0001\u000bm\u0016\u0014H/\u001a=UsB,\u0017a\u0003<feR,\u0007\u0010V=qK\u0002\n!\u0002\u001d:pa\u0016\u0014H/[3t+\u00051\u0007c\u0001\"h+&\u0011\u0001\u000e\u0014\u0002\u0005\u0019&\u001cH/A\u0006qe>\u0004XM\u001d;jKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0004m[:|\u0007/\u001d:\u0011\u0005a\u0002\u0001\"B'\u000e\u0001\u0004y\u0005\"B*\u000e\u0001\u0004)\u0006\"\u00020\u000e\u0001\u0004)\u0006\"\u00021\u000e\u0001\u0004)\u0006b\u00022\u000e!\u0003\u0005\r!\u0016\u0005\bI6\u0001\n\u00111\u0001g\u0003\u001d!\u0018\u0010]3D_2,\u0012!\u001e\t\u0004yYD\u0018BA<>\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005mS\u0018\u0001\u0003;za\u0016\u001cu\u000e\u001c\u0011\u0002\u001d\t,\u0018\u000e\u001c3FqR\u0014\u0018m\u0019;peR!\u0011QAA%!%a\u0014qAA\u0006\u0003/\ti\"C\u0002\u0002\nu\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005}\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003+\tyAA\u0005SKN,H\u000e^*fiB\u0019A(!\u0007\n\u0007\u0005mQH\u0001\u0003M_:<\u0007#\u0002\"\u0002 \u0005\r\u0012bAA\u0011\u0019\n\u00191+Z9\u0011\t\u0005\u0015\u00121\t\b\u0005\u0003O\tiD\u0004\u0003\u0002*\u0005]b\u0002BA\u0016\u0003gqA!!\f\u000229\u0019A)a\f\n\u0003QJ!AM\u001a\n\u0007\u0005U\u0012'A\u0005j]R,'O\\1mg&!\u0011\u0011HA\u001e\u0003\u00159'/\u00199i\u0015\r\t)$M\u0005\u0005\u0003\u007f\t\t%A\bHe\u0006\u0004\b.\u00117uKJ\fG/[8o\u0015\u0011\tI$a\u000f\n\t\u0005\u0015\u0013q\t\u0002\f\u000fJ\f\u0007\u000f[+qI\u0006$XM\u0003\u0003\u0002@\u0005\u0005\u0003bBA&!\u0001\u0007\u0011QJ\u0001\fG>dW/\u001c8UsB,7\u000f\u0005\u0004W\u0003\u001f*\u00161K\u0005\u0004\u0003#b&aA'baB\u0019A(!\u0016\n\u0007\u0005]SHA\u0002J]R\f1#\u001a=qK\u000e$X\rZ\"pYVlg\u000eV=qKN,\"!!\u0018\u0011\rY\u000by%VA0!\u0011\u0011u-a\u0015\u0002\u001f\u0015D\b/Z2uK\u0012\u001cu\u000e\\;n]N\fAaY8qsRiA.a\u001a\u0002j\u0005-\u0014QNA8\u0003cBq!T\n\u0011\u0002\u0003\u0007q\nC\u0004T'A\u0005\t\u0019A+\t\u000fy\u001b\u0002\u0013!a\u0001+\"9\u0001m\u0005I\u0001\u0002\u0004)\u0006b\u00022\u0014!\u0003\u0005\r!\u0016\u0005\bIN\u0001\n\u00111\u0001g\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001e+\u0007=\u000bIh\u000b\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C;oG\",7m[3e\u0015\r\t))P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAE\u0003\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a$+\u0007U\u000bI(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u00037S3AZA=\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u00010\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002T\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAU\u0003_\u00032\u0001PAV\u0013\r\ti+\u0010\u0002\u0004\u0003:L\b\"CAY9\u0005\u0005\t\u0019AA*\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0017\t\u0007\u0003s\u000by,!+\u000e\u0005\u0005m&bAA_{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00171\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002H\u00065\u0007c\u0001\u001f\u0002J&\u0019\u00111Z\u001f\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0017\u0010\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002y\u0003'D\u0011\"!- \u0003\u0003\u0005\r!a\u0015\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0015\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u0017\u0011\u001d\u0005\n\u0003c\u0013\u0013\u0011!a\u0001\u0003SCs\u0001AAs\u0003s\fY\u0010\u0005\u0003\u0002h\u0006UXBAAu\u0015\u0011\tY/!<\u0002\u0011M\u001c\u0017\r\\1e_\u000eTA!a<\u0002r\u00069A/Y6fu>,'bAAzg\u00051q-\u001b;ik\nLA!a>\u0002j\nA1kY1mC\u0012|7-A\u0003wC2,X-\t\u0002\u0002~\u00061Yf\f\u0016+AM{WO]2fA\u0019|'\u000fI5oO\u0016\u001cH/\u001b8hAY,'\u000f^5dKN\u0004cM]8nAM\u000bF\n\t#bi\u0006\u0014\u0017m]3!cV,'/[3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\"\u0006.[:!g>,(oY3!S:<Wm\u001d;!_:,\u0007E^3si\u0016D\bE\u001a:p[\u0002*\u0017m\u00195!_\u001a\u0004C\u000f[3!e><8\u000f\t:fiV\u0014h.\u001a3!o\",g\u000eI:vE6LG\u000f^5oO\u0002\"\b.\u001a\u0011acV,'/\u001f1\u000bA\u0001R\u0003\u0005^8!i\",\u0007\u0005Z1uC\n\f7/\u001a\u0011sK\u001a,'O]3eA\tL\b\u0005Y2p]:\u0004gF\u0003\u0011!U\u0001\u0002\u0017\u000e\u001a1-A\u0001$\u0018.\\3aY\u0001\u0002W\rZ4f)f\u0004X\r\u0019\u0017!C:$\u0007\u0005\u00199s_B,'\u000f^5fg\u0002\u0004\u0013M]3!kN,G\r\t;pAM,G\u000f\t;iK\u0002r\u0017-\\3tA=4\u0007\u0005\u001e5fA\r|G.^7og\u0002\"x\u000eI;tK*\u0001\u0003E\u000b\u0011g_J\u0004C\u000f[3!S\u0012d\u0003\u0005\u001e5fAQLW.Z:uC6\u0004H\u0006\t;iK\u0002\"\u0018\u0010]3-A\u0005tG\r\t;iK\u0002\u0002(o\u001c9feRLWm\u001d\u0011g_J\u0004SM^3ss\u0002*GmZ3/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001awN\u001c8!i\",\u0007eY8o]\u0016\u001cG/[8oAQ|\u0007%\u0019\u0011ta\u0016\u001c\u0017NZ5dAQL\b/\u001a\u0011pM\u0002\"\u0017\r^1cCN,G\u0006I3/O:\u0002\u0003\rU8ti\u001e\u0014Xm]\"p]:,7\r^5p]\u0002T\u0001\u0005\t\u0016!\u0001B\f'/Y7!cV,'/\u001f\u0011uQ\u0016\u0004\u0013/^3ss\u0002\"x\u000e\t2fA\u0015DXmY;uK\u0012\u0004\u0013mZ1j]N$\b\u0005\u001e5fAQDW\r\t3bi\u0006\u0014\u0017m]3\u000bA\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001b3!i\",\u0007E\\1nK\u0002zg\r\t;iK\u0002\u001aw\u000e\\;n]\u0002\"x\u000eI;tK\u0002\n7\u000f\t;iK\u0002JG\rI8gAY,'\u000f^3y\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t;j[\u0016\u0004C\u000f[3!]\u0006lW\rI8gAQDW\rI2pYVlg\u000e\t;pAU\u001cX\rI1tAQDW\r\t;j[\u0016\u001cH/Y7q\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t<feR,\u0007\u0010V=qK\u0002\"\b.\u001a\u0011oC6,\u0007e\u001c4!i\",\u0007eY8mk6t\u0007\u0005^8!kN,\u0007%Y:!m\u0016\u0014H/\u001a=!if\u0004XM\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u0002(o\u001c9feRLWm\u001d\u0011uQ\u0016\u0004c.Y7fg\u0002zg\r\t;iK\u0002\u001aw\u000e\\;n]N\u0004Co\u001c\u0011vg\u0016\u0004\u0013m\u001d\u0011uQ\u0016\u0004\u0003O]8qKJ$\u0018.Z:!M>\u0014\b\u0005\u001e5fAY,'\u000f^3y\u0015\u0001\u0002#fL\u0001\u0010'Fdg+\u001a:uKb\u001cv.\u001e:dKB\u0011\u0001\bJ\n\u0006I\t\u0015!\u0011\u0003\t\f\u0005\u000f\u0011iaT+V+V3G.\u0004\u0002\u0003\n)\u0019!1B\u001f\u0002\u000fI,h\u000e^5nK&!!q\u0002B\u0005\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\u000e\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!q\u0003?\u0002\u0005%|\u0017bA&\u0003\u0016Q\u0011!\u0011A\u0001\u0006CB\u0004H.\u001f\u000b\u000eY\n\u0005\"1\u0005B\u0013\u0005O\u0011ICa\u000b\t\u000b5;\u0003\u0019A(\t\u000bM;\u0003\u0019A+\t\u000by;\u0003\u0019A+\t\u000b\u0001<\u0003\u0019A+\t\u000f\t<\u0003\u0013!a\u0001+\"9Am\nI\u0001\u0002\u00041\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00036\tu\u0002\u0003\u0002\u001fw\u0005o\u0001\u0012\u0002\u0010B\u001d\u001fV+V+\u00164\n\u0007\tmRH\u0001\u0004UkBdWM\u000e\u0005\t\u0005\u007fQ\u0013\u0011!a\u0001Y\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\n\t\u0004s\n-\u0013b\u0001B'u\n1qJ\u00196fGR\u0004")
public class SqlVertexSource
extends SqlSource
implements Product,
Serializable {
    private final SqlConnection conn;
    private final String query;
    private final String id;
    private final String time;
    private final String vertexType;
    private final List<String> properties;
    private final Option<String> typeCol;

    public static List<String> $lessinit$greater$default$6() {
        return SqlVertexSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return SqlVertexSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<SqlConnection, String, String, String, String, List<String>>> unapply(SqlVertexSource x$0) {
        return SqlVertexSource$.MODULE$.unapply(x$0);
    }

    public static List<String> apply$default$6() {
        return SqlVertexSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return SqlVertexSource$.MODULE$.apply$default$5();
    }

    public static SqlVertexSource apply(SqlConnection conn, String query, String id, String time, String vertexType, List<String> properties) {
        return SqlVertexSource$.MODULE$.apply(conn, query, id, time, vertexType, properties);
    }

    public static Function1<Tuple6<SqlConnection, String, String, String, String, List<String>>, SqlVertexSource> tupled() {
        return SqlVertexSource$.MODULE$.tupled();
    }

    public static Function1<SqlConnection, Function1<String, Function1<String, Function1<String, Function1<String, Function1<List<String>, SqlVertexSource>>>>>> curried() {
        return SqlVertexSource$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SqlConnection conn() {
        return this.conn;
    }

    public String query() {
        return this.query;
    }

    public String id() {
        return this.id;
    }

    public String time() {
        return this.time;
    }

    public String vertexType() {
        return this.vertexType;
    }

    public List<String> properties() {
        return this.properties;
    }

    private Option<String> typeCol() {
        return this.typeCol;
    }

    @Override
    public Function2<ResultSet, Object, Seq<GraphAlteration.GraphUpdate>> buildExtractor(Map<String, Object> columnTypes) {
        boolean idIsInteger = this.checkType(columnTypes, this.id(), SqlSource$.MODULE$.integerTypes());
        boolean timeIsInteger = this.checkType(columnTypes, this.time(), SqlSource$.MODULE$.integerTypes());
        int propertiesStart = this.typeCol().isDefined() ? 4 : 3;
        int propertiesEnd = propertiesStart + this.properties().size();
        Range propertyIndexes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(propertiesStart), propertiesEnd);
        List propertyBuilders = ((List)this.properties().zip((IterableOnce)propertyIndexes)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String col = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Function1<ResultSet, Property> function1 = this.getPropertyBuilder(index, col, columnTypes);
            return function1;
        });
        return (Function2 & Serializable)(rs, index) -> SqlVertexSource.$anonfun$buildExtractor$2(this, idIsInteger, timeIsInteger, propertyBuilders, rs, BoxesRunTime.unboxToLong((Object)index));
    }

    @Override
    public Map<String, List<Object>> expectedColumnTypes() {
        Map mainTypes = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.id()), SqlSource$.MODULE$.idTypes()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.time()), SqlSource$.MODULE$.epochTypes())}));
        Option typeTypes = this.typeCol().map((Function1 & Serializable)col -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(col), SqlSource$.MODULE$.stringTypes()));
        List propTypes = this.properties().map((Function1 & Serializable)property -> new Tuple2(property, SqlSource$.MODULE$.propertyTypes()));
        return (Map)((MapOps)mainTypes.$plus$plus((IterableOnce)typeTypes)).$plus$plus((IterableOnce)propTypes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public List<String> expectedColumns() {
        return (List)((IterableOps)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.id(), this.time()}))).$plus$plus(this.typeCol())).$plus$plus(this.properties());
    }

    public SqlVertexSource copy(SqlConnection conn, String query, String id, String time, String vertexType, List<String> properties) {
        return new SqlVertexSource(conn, query, id, time, vertexType, properties);
    }

    public SqlConnection copy$default$1() {
        return this.conn();
    }

    public String copy$default$2() {
        return this.query();
    }

    public String copy$default$3() {
        return this.id();
    }

    public String copy$default$4() {
        return this.time();
    }

    public String copy$default$5() {
        return this.vertexType();
    }

    public List<String> copy$default$6() {
        return this.properties();
    }

    public String productPrefix() {
        return "SqlVertexSource";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.conn();
                break;
            }
            case 1: {
                object = this.query();
                break;
            }
            case 2: {
                object = this.id();
                break;
            }
            case 3: {
                object = this.time();
                break;
            }
            case 4: {
                object = this.vertexType();
                break;
            }
            case 5: {
                object = this.properties();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SqlVertexSource;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "conn";
                break;
            }
            case 1: {
                string = "query";
                break;
            }
            case 2: {
                string = "id";
                break;
            }
            case 3: {
                string = "time";
                break;
            }
            case 4: {
                string = "vertexType";
                break;
            }
            case 5: {
                string = "properties";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SqlVertexSource)) return false;
        boolean bl = true;
        if (!bl) return false;
        SqlVertexSource sqlVertexSource = (SqlVertexSource)x$1;
        SqlConnection sqlConnection = this.conn();
        SqlConnection sqlConnection2 = sqlVertexSource.conn();
        if (sqlConnection == null) {
            if (sqlConnection2 != null) {
                return false;
            }
        } else if (!sqlConnection.equals(sqlConnection2)) return false;
        String string = this.query();
        String string2 = sqlVertexSource.query();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.id();
        String string4 = sqlVertexSource.id();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.time();
        String string6 = sqlVertexSource.time();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.vertexType();
        String string8 = sqlVertexSource.vertexType();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        List<String> list = this.properties();
        List<String> list2 = sqlVertexSource.properties();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!sqlVertexSource.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Seq $anonfun$buildExtractor$2(SqlVertexSource $this, boolean idIsInteger$1, boolean timeIsInteger$1, List propertyBuilders$1, ResultSet rs, long index) {
        long id = idIsInteger$1 ? rs.getLong(1) : Graph$.MODULE$.assignID(rs.getString(1));
        long epoch = timeIsInteger$1 ? rs.getLong(2) : rs.getTimestamp(2).getTime();
        Option vertexType = $this.typeCol().map((Function1 & Serializable)x$1 -> new Type(rs.getString(3)));
        List properties = propertyBuilders$1.map((Function1 & Serializable)x$2 -> (Property)x$2.apply((Object)rs));
        None$ name = idIsInteger$1 ? None$.MODULE$ : new Some((Object)new ImmutableString("name", rs.getString(1)));
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphAlteration.VertexAdd[]{new GraphAlteration.VertexAdd(epoch, index, id, new Properties((Seq<Property>)((Seq)properties.$plus$plus((IterableOnce)name))), (Option<Type>)vertexType, SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider())}));
    }

    public SqlVertexSource(SqlConnection conn, String query, String id, String time, String vertexType, List<String> properties) {
        this.conn = conn;
        this.query = query;
        this.id = id;
        this.time = time;
        this.vertexType = vertexType;
        this.properties = properties;
        super(conn, query);
        Product.$init$((Product)this);
        this.typeCol = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(vertexType)) ? new Some((Object)vertexType.toUpperCase()) : None$.MODULE$;
    }
}

