/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.ImmutableString;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.sources.SqlConnection;
import com.raphtory.sources.SqlEdgeSource$;
import com.raphtory.sources.SqlSource;
import com.raphtory.sources.SqlSource$;
import java.io.Serializable;
import java.sql.ResultSet;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** Source for ingesting edges from SQL Database queries\n  *\n  * This source ingest one edge from each of the rows returned when submitting the `query`\n  * to the database referred by `conn`.\n  * `source`, `target`, `time`, `edgeType`, and `properties` are used to set the names of the columns to use\n  * for the ids, the timestamp, the type, and the properties for every edge.\n  *\n  * @param conn the connection to a specific type of database, e.g. `PostgresConnection`\n  * @param query the query to be executed against the the database\n  * @param source the name of the column to use as the id of the source vertex\n  * @param target the name of the column to use as the id of the target vertex\n  * @param time the name of the column to use as the timestamp\n  * @param edgeType the name of the column to use as edge type\n  * @param properties the names of the columns to use as the properties for the edge\n  */")
@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001B\u00193\u0001fB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005a\u0001\tE\t\u0015!\u0003Y\u0011!\t\u0007A!f\u0001\n\u00039\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u0011\r\u0004!Q3A\u0005\u0002]C\u0001\u0002\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u0017\u0005\tK\u0002\u0011)\u001a!C\u0001/\"Aa\r\u0001B\tB\u0003%\u0001\f\u0003\u0005h\u0001\tU\r\u0011\"\u0001X\u0011!A\u0007A!E!\u0002\u0013A\u0006\u0002C5\u0001\u0005+\u0007I\u0011\u00016\t\u00119\u0004!\u0011#Q\u0001\n-DQa\u001c\u0001\u0005\u0002ADq!\u001f\u0001C\u0002\u0013%!\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B>\t\u000f\u00055\u0001\u0001\"\u0015\u0002\u0010!9\u0011Q\r\u0001\u0005R\u0005\u001d\u0004BBA7\u0001\u0011\u0005#\u000eC\u0005\u0002p\u0001\t\t\u0011\"\u0001\u0002r!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u00037C\u0011\"a(\u0001#\u0003%\t!a'\t\u0013\u0005\u0005\u0006!%A\u0005\u0002\u0005m\u0005\"CAR\u0001E\u0005I\u0011AAN\u0011%\t)\u000bAI\u0001\n\u0003\tY\nC\u0005\u0002(\u0002\t\n\u0011\"\u0001\u0002*\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003c\u0003\u0011\u0011!C\u0001\u0003gC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005\r\u0007!!A\u0005B\u0005\u0015\u0007\"CAj\u0001\u0005\u0005I\u0011AAk\u0011%\ty\u000eAA\u0001\n\u0003\n\t\u000fC\u0005\u0002f\u0002\t\t\u0011\"\u0011\u0002h\"I\u0011\u0011\u001e\u0001\u0002\u0002\u0013\u0005\u00131\u001e\u0005\n\u0003[\u0004\u0011\u0011!C!\u0003_<\u0011Ba\u00043\u0003\u0003E\tA!\u0005\u0007\u0011E\u0012\u0014\u0011!E\u0001\u0005'Aaa\\\u0014\u0005\u0002\t-\u0002\"CAuO\u0005\u0005IQIAv\u0011%\u0011icJA\u0001\n\u0003\u0013y\u0003C\u0005\u0003@\u001d\n\n\u0011\"\u0001\u0002\u001c\"I!\u0011I\u0014\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0005\u0007:\u0013\u0011!CA\u0005\u000bB\u0011Ba\u0015(#\u0003%\t!a'\t\u0013\tUs%%A\u0005\u0002\u0005%\u0006\"\u0003B,O\u0005\u0005I\u0011\u0002B-\u00055\u0019\u0016\u000f\\#eO\u0016\u001cv.\u001e:dK*\u00111\u0007N\u0001\bg>,(oY3t\u0015\t)d'\u0001\u0005sCBDGo\u001c:z\u0015\u00059\u0014aA2p[\u000e\u00011\u0003\u0002\u0001;}\u0011\u0003\"a\u000f\u001f\u000e\u0003IJ!!\u0010\u001a\u0003\u0013M\u000bHnU8ve\u000e,\u0007CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%a\u0002)s_\u0012,8\r\u001e\t\u0003\u000b6s!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%C\u0014A\u0002\u001fs_>$h(C\u0001B\u0013\ta\u0005)A\u0004qC\u000e\\\u0017mZ3\n\u00059{%\u0001D*fe&\fG.\u001b>bE2,'B\u0001'A\u0003\u0011\u0019wN\u001c8\u0016\u0003I\u0003\"aO*\n\u0005Q\u0013$!D*rY\u000e{gN\\3di&|g.A\u0003d_:t\u0007%A\u0003rk\u0016\u0014\u00180F\u0001Y!\tIVL\u0004\u0002[7B\u0011q\tQ\u0005\u00039\u0002\u000ba\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A\fQ\u0001\u0007cV,'/\u001f\u0011\u0002\rM|WO]2f\u0003\u001d\u0019x.\u001e:dK\u0002\na\u0001^1sO\u0016$\u0018a\u0002;be\u001e,G\u000fI\u0001\u0005i&lW-A\u0003uS6,\u0007%\u0001\u0005fI\u001e,G+\u001f9f\u0003%)GmZ3UsB,\u0007%\u0001\u0006qe>\u0004XM\u001d;jKN,\u0012a\u001b\t\u0004\u000b2D\u0016BA7P\u0005\u0011a\u0015n\u001d;\u0002\u0017A\u0014x\u000e]3si&,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011E\u00148\u000f^;wob\u0004\"a\u000f\u0001\t\u000bA{\u0001\u0019\u0001*\t\u000bY{\u0001\u0019\u0001-\t\u000b\u0005|\u0001\u0019\u0001-\t\u000b\r|\u0001\u0019\u0001-\t\u000b\u0015|\u0001\u0019\u0001-\t\u000f\u001d|\u0001\u0013!a\u00011\"9\u0011n\u0004I\u0001\u0002\u0004Y\u0017a\u0002;za\u0016\u001cu\u000e\\\u000b\u0002wB\u0019q\b @\n\u0005u\u0004%AB(qi&|g\u000eE\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0005!!.\u0019<b\u0013\rq\u0016\u0011A\u0001\tif\u0004XmQ8mA\u0005q!-^5mI\u0016CHO]1di>\u0014H\u0003BA\t\u0003+\u0002\u0012bPA\n\u0003/\t\u0019#!\u000b\n\u0007\u0005U\u0001IA\u0005Gk:\u001cG/[8oeA!\u0011\u0011DA\u0010\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005\u0015\u0011aA:rY&!\u0011\u0011EA\u000e\u0005%\u0011Vm];miN+G\u000fE\u0002@\u0003KI1!a\nA\u0005\u0011auN\\4\u0011\u000b\u0015\u000bY#a\f\n\u0007\u00055rJA\u0002TKF\u0004B!!\r\u0002P9!\u00111GA%\u001d\u0011\t)$a\u0011\u000f\t\u0005]\u0012q\b\b\u0005\u0003s\tiDD\u0002H\u0003wI\u0011aN\u0005\u0003kYJ1!!\u00115\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0002F\u0005\u001d\u0013!B4sCBD'bAA!i%!\u00111JA'\u0003=9%/\u00199i\u00032$XM]1uS>t'\u0002BA#\u0003\u000fJA!!\u0015\u0002T\tYqI]1qQV\u0003H-\u0019;f\u0015\u0011\tY%!\u0014\t\u000f\u0005]#\u00031\u0001\u0002Z\u0005Y1m\u001c7v[:$\u0016\u0010]3t!\u0019I\u00161\f-\u0002`%\u0019\u0011QL0\u0003\u00075\u000b\u0007\u000fE\u0002@\u0003CJ1!a\u0019A\u0005\rIe\u000e^\u0001\u0014Kb\u0004Xm\u0019;fI\u000e{G.^7o)f\u0004Xm]\u000b\u0003\u0003S\u0002b!WA.1\u0006-\u0004\u0003B#m\u0003?\nq\"\u001a=qK\u000e$X\rZ\"pYVlgn]\u0001\u0005G>\u0004\u0018\u0010F\br\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@\u0011\u001d\u0001V\u0003%AA\u0002ICqAV\u000b\u0011\u0002\u0003\u0007\u0001\fC\u0004b+A\u0005\t\u0019\u0001-\t\u000f\r,\u0002\u0013!a\u00011\"9Q-\u0006I\u0001\u0002\u0004A\u0006bB4\u0016!\u0003\u0005\r\u0001\u0017\u0005\bSV\u0001\n\u00111\u0001l\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\"+\u0007I\u000b9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019\nQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!(+\u0007a\u000b9)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\tYKK\u0002l\u0003\u000f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001@\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003s\u000by\fE\u0002@\u0003wK1!!0A\u0005\r\te.\u001f\u0005\n\u0003\u0003|\u0012\u0011!a\u0001\u0003?\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAd!\u0019\tI-a4\u0002:6\u0011\u00111\u001a\u0006\u0004\u0003\u001b\u0004\u0015AC2pY2,7\r^5p]&!\u0011\u0011[Af\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0017Q\u001c\t\u0004\u007f\u0005e\u0017bAAn\u0001\n9!i\\8mK\u0006t\u0007\"CAaC\u0005\u0005\t\u0019AA]\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\u0007y\f\u0019\u000fC\u0005\u0002B\n\n\t\u00111\u0001\u0002`\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002`\u0005AAo\\*ue&tw\rF\u0001\u007f\u0003\u0019)\u0017/^1mgR!\u0011q[Ay\u0011%\t\t-JA\u0001\u0002\u0004\tI\fK\u0004\u0001\u0003k\u0014IAa\u0003\u0011\t\u0005](QA\u0007\u0003\u0003sTA!a?\u0002~\u0006A1oY1mC\u0012|7M\u0003\u0003\u0002\u0000\n\u0005\u0011a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0005\u00071\u0014AB4ji\",(-\u0003\u0003\u0003\b\u0005e(\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\t5\u0011ab\b0U)\u00023k\\;sG\u0016\u0004cm\u001c:!S:<Wm\u001d;j]\u001e\u0004S\rZ4fg\u00022'o\\7!'Fc\u0005\u0005R1uC\n\f7/\u001a\u0011rk\u0016\u0014\u0018.Z:\u000bA\u0001R#\u0002\t\u0011+AQC\u0017n\u001d\u0011t_V\u00148-\u001a\u0011j]\u001e,7\u000f\u001e\u0011p]\u0016\u0004S\rZ4fA\u0019\u0014x.\u001c\u0011fC\u000eD\u0007e\u001c4!i\",\u0007E]8xg\u0002\u0012X\r^;s]\u0016$\u0007e\u001e5f]\u0002\u001aXOY7jiRLgn\u001a\u0011uQ\u0016\u0004\u0003-];fef\u0004'\u0002\t\u0011+AQ|\u0007\u0005\u001e5fA\u0011\fG/\u00192bg\u0016\u0004#/\u001a4feJ,G\r\t2zA\u0001\u001cwN\u001c8a])\u0001\u0003E\u000b\u0011ag>,(oY3aY\u0001\u0002G/\u0019:hKR\u0004G\u0006\t1uS6,\u0007\r\f\u0011aK\u0012<W\rV=qK\u0002d\u0003%\u00198eA\u0001\u0004(o\u001c9feRLWm\u001d1!CJ,\u0007%^:fI\u0002\"x\u000eI:fi\u0002\"\b.\u001a\u0011oC6,7\u000fI8gAQDW\rI2pYVlgn\u001d\u0011u_\u0002*8/\u001a\u0006!A)\u0002cm\u001c:!i\",\u0007%\u001b3tY\u0001\"\b.\u001a\u0011uS6,7\u000f^1na2\u0002C\u000f[3!if\u0004X\r\f\u0011b]\u0012\u0004C\u000f[3!aJ|\u0007/\u001a:uS\u0016\u001c\bEZ8sA\u00154XM]=!K\u0012<WM\f\u0006!A)R\u0001\u0005\t\u0016!\u0001B\f'/Y7!G>tg\u000e\t;iK\u0002\u001awN\u001c8fGRLwN\u001c\u0011u_\u0002\n\u0007e\u001d9fG&4\u0017n\u0019\u0011usB,\u0007e\u001c4!I\u0006$\u0018MY1tK2\u0002SML4/A\u0001\u0004vn\u001d;he\u0016\u001c8i\u001c8oK\u000e$\u0018n\u001c8a\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI9vKJL\b\u0005\u001e5fAE,XM]=!i>\u0004#-\u001a\u0011fq\u0016\u001cW\u000f^3eA\u0005<\u0017-\u001b8ti\u0002\"\b.\u001a\u0011uQ\u0016\u0004C-\u0019;bE\u0006\u001cXM\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001ax.\u001e:dK\u0002\"\b.\u001a\u0011oC6,\u0007e\u001c4!i\",\u0007eY8mk6t\u0007\u0005^8!kN,\u0007%Y:!i\",\u0007%\u001b3!_\u001a\u0004C\u000f[3!g>,(oY3!m\u0016\u0014H/\u001a=\u000bA\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005^1sO\u0016$\b\u0005\u001e5fA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011d_2,XN\u001c\u0011u_\u0002*8/\u001a\u0011bg\u0002\"\b.\u001a\u0011jI\u0002zg\r\t;iK\u0002\"\u0018M]4fi\u00022XM\u001d;fq*\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011uS6,\u0007\u0005\u001e5fA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011d_2,XN\u001c\u0011u_\u0002*8/\u001a\u0011bg\u0002\"\b.\u001a\u0011uS6,7\u000f^1na*\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011fI\u001e,G+\u001f9fAQDW\r\t8b[\u0016\u0004sN\u001a\u0011uQ\u0016\u00043m\u001c7v[:\u0004Co\u001c\u0011vg\u0016\u0004\u0013m\u001d\u0011fI\u001e,\u0007\u0005^=qK*\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011qe>\u0004XM\u001d;jKN\u0004C\u000f[3!]\u0006lWm\u001d\u0011pM\u0002\"\b.\u001a\u0011d_2,XN\\:!i>\u0004So]3!CN\u0004C\u000f[3!aJ|\u0007/\u001a:uS\u0016\u001c\bEZ8sAQDW\rI3eO\u0016T\u0001\u0005\t\u00160\u00035\u0019\u0016\u000f\\#eO\u0016\u001cv.\u001e:dKB\u00111hJ\n\u0006O\tU!\u0011\u0005\t\r\u0005/\u0011iB\u0015-Y1bC6.]\u0007\u0003\u00053Q1Aa\u0007A\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\b\u0003\u001a\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001c\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQAAa\n\u0002\u0006\u0005\u0011\u0011n\\\u0005\u0004\u001d\n\u0015BC\u0001B\t\u0003\u0015\t\u0007\u000f\u001d7z)=\t(\u0011\u0007B\u001a\u0005k\u00119D!\u000f\u0003<\tu\u0002\"\u0002)+\u0001\u0004\u0011\u0006\"\u0002,+\u0001\u0004A\u0006\"B1+\u0001\u0004A\u0006\"B2+\u0001\u0004A\u0006\"B3+\u0001\u0004A\u0006bB4+!\u0003\u0005\r\u0001\u0017\u0005\bS*\u0002\n\u00111\u0001l\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u00122\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\u0002\u000fUt\u0017\r\u001d9msR!!q\tB(!\u0011yDP!\u0013\u0011\u0015}\u0012YE\u0015-Y1bC6.C\u0002\u0003N\u0001\u0013a\u0001V;qY\u0016<\u0004\u0002\u0003B)[\u0005\u0005\t\u0019A9\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tm\u0003cA@\u0003^%!!qLA\u0001\u0005\u0019y%M[3di\u0002")
public class SqlEdgeSource
extends SqlSource
implements Product,
Serializable {
    private final SqlConnection conn;
    private final String query;
    private final String source;
    private final String target;
    private final String time;
    private final String edgeType;
    private final List<String> properties;
    private final Option<String> typeCol;

    public static List<String> $lessinit$greater$default$7() {
        return SqlEdgeSource$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return SqlEdgeSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Tuple7<SqlConnection, String, String, String, String, String, List<String>>> unapply(SqlEdgeSource x$0) {
        return SqlEdgeSource$.MODULE$.unapply(x$0);
    }

    public static List<String> apply$default$7() {
        return SqlEdgeSource$.MODULE$.apply$default$7();
    }

    public static String apply$default$6() {
        return SqlEdgeSource$.MODULE$.apply$default$6();
    }

    public static SqlEdgeSource apply(SqlConnection conn, String query, String source, String target, String time, String edgeType, List<String> properties) {
        return SqlEdgeSource$.MODULE$.apply(conn, query, source, target, time, edgeType, properties);
    }

    public static Function1<Tuple7<SqlConnection, String, String, String, String, String, List<String>>, SqlEdgeSource> tupled() {
        return SqlEdgeSource$.MODULE$.tupled();
    }

    public static Function1<SqlConnection, Function1<String, Function1<String, Function1<String, Function1<String, Function1<String, Function1<List<String>, SqlEdgeSource>>>>>>> curried() {
        return SqlEdgeSource$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SqlConnection conn() {
        return this.conn;
    }

    public String query() {
        return this.query;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public String time() {
        return this.time;
    }

    public String edgeType() {
        return this.edgeType;
    }

    public List<String> properties() {
        return this.properties;
    }

    private Option<String> typeCol() {
        return this.typeCol;
    }

    @Override
    public Function2<ResultSet, Object, Seq<GraphAlteration.GraphUpdate>> buildExtractor(Map<String, Object> columnTypes) {
        boolean sourceIsInteger = this.checkType(columnTypes, this.source(), SqlSource$.MODULE$.integerTypes());
        boolean targetIsInteger = this.checkType(columnTypes, this.target(), SqlSource$.MODULE$.integerTypes());
        boolean timeIsInteger = this.checkType(columnTypes, this.time(), SqlSource$.MODULE$.integerTypes());
        int propertiesStart = this.typeCol().isDefined() ? 5 : 4;
        int propertiesEnd = propertiesStart + this.properties().size();
        Range propertyIndexes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(propertiesStart), propertiesEnd);
        List propertyBuilders = ((List)this.properties().zip((IterableOnce)propertyIndexes)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String col = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Function1<ResultSet, Property> function1 = this.getPropertyBuilder(index, col, columnTypes);
            return function1;
        });
        return (Function2 & Serializable)(rs, index) -> SqlEdgeSource.$anonfun$buildExtractor$2(this, sourceIsInteger, targetIsInteger, timeIsInteger, propertyBuilders, rs, BoxesRunTime.unboxToLong((Object)index));
    }

    @Override
    public Map<String, List<Object>> expectedColumnTypes() {
        Map mainTypes = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.source()), SqlSource$.MODULE$.idTypes()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.target()), SqlSource$.MODULE$.idTypes()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.time()), SqlSource$.MODULE$.epochTypes())}));
        Option typeTypes = this.typeCol().map((Function1 & Serializable)col -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(col), SqlSource$.MODULE$.stringTypes()));
        List propTypes = this.properties().map((Function1 & Serializable)property -> new Tuple2(property, SqlSource$.MODULE$.propertyTypes()));
        return (Map)((MapOps)mainTypes.$plus$plus((IterableOnce)typeTypes)).$plus$plus((IterableOnce)propTypes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public List<String> expectedColumns() {
        return (List)((IterableOps)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.source(), this.target(), this.time()}))).$plus$plus(this.typeCol())).$plus$plus(this.properties());
    }

    public SqlEdgeSource copy(SqlConnection conn, String query, String source, String target, String time, String edgeType, List<String> properties) {
        return new SqlEdgeSource(conn, query, source, target, time, edgeType, properties);
    }

    public SqlConnection copy$default$1() {
        return this.conn();
    }

    public String copy$default$2() {
        return this.query();
    }

    public String copy$default$3() {
        return this.source();
    }

    public String copy$default$4() {
        return this.target();
    }

    public String copy$default$5() {
        return this.time();
    }

    public String copy$default$6() {
        return this.edgeType();
    }

    public List<String> copy$default$7() {
        return this.properties();
    }

    public String productPrefix() {
        return "SqlEdgeSource";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.conn();
                break;
            }
            case 1: {
                object = this.query();
                break;
            }
            case 2: {
                object = this.source();
                break;
            }
            case 3: {
                object = this.target();
                break;
            }
            case 4: {
                object = this.time();
                break;
            }
            case 5: {
                object = this.edgeType();
                break;
            }
            case 6: {
                object = this.properties();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SqlEdgeSource;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "conn";
                break;
            }
            case 1: {
                string = "query";
                break;
            }
            case 2: {
                string = "source";
                break;
            }
            case 3: {
                string = "target";
                break;
            }
            case 4: {
                string = "time";
                break;
            }
            case 5: {
                string = "edgeType";
                break;
            }
            case 6: {
                string = "properties";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SqlEdgeSource)) return false;
        boolean bl = true;
        if (!bl) return false;
        SqlEdgeSource sqlEdgeSource = (SqlEdgeSource)x$1;
        SqlConnection sqlConnection = this.conn();
        SqlConnection sqlConnection2 = sqlEdgeSource.conn();
        if (sqlConnection == null) {
            if (sqlConnection2 != null) {
                return false;
            }
        } else if (!sqlConnection.equals(sqlConnection2)) return false;
        String string = this.query();
        String string2 = sqlEdgeSource.query();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.source();
        String string4 = sqlEdgeSource.source();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.target();
        String string6 = sqlEdgeSource.target();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.time();
        String string8 = sqlEdgeSource.time();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        String string9 = this.edgeType();
        String string10 = sqlEdgeSource.edgeType();
        if (string9 == null) {
            if (string10 != null) {
                return false;
            }
        } else if (!string9.equals(string10)) return false;
        List<String> list = this.properties();
        List<String> list2 = sqlEdgeSource.properties();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!sqlEdgeSource.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Seq $anonfun$buildExtractor$2(SqlEdgeSource $this, boolean sourceIsInteger$1, boolean targetIsInteger$1, boolean timeIsInteger$1, List propertyBuilders$1, ResultSet rs, long index) {
        long sourceId = sourceIsInteger$1 ? rs.getLong(1) : Graph$.MODULE$.assignID(rs.getString(1));
        long targetId = targetIsInteger$1 ? rs.getLong(2) : Graph$.MODULE$.assignID(rs.getString(2));
        long epoch = timeIsInteger$1 ? rs.getLong(3) : rs.getTimestamp(3).getTime();
        Option edgeType = $this.typeCol().map((Function1 & Serializable)x$1 -> new Type(rs.getString(4)));
        List properties = propertyBuilders$1.map((Function1 & Serializable)x$2 -> (Property)x$2.apply((Object)rs));
        None$ sourceAdd = sourceIsInteger$1 ? None$.MODULE$ : new Some((Object)new GraphAlteration.VertexAdd(epoch, index, sourceId, new Properties((Seq<Property>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{new ImmutableString("name", rs.getString(1))})), (Option<Type>)None$.MODULE$, SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider()));
        None$ targetAdd = targetIsInteger$1 ? None$.MODULE$ : new Some((Object)new GraphAlteration.VertexAdd(epoch, index, targetId, new Properties((Seq<Property>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{new ImmutableString("name", rs.getString(2))})), (Option<Type>)None$.MODULE$, SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider()));
        GraphAlteration.EdgeAdd edgeAdd = new GraphAlteration.EdgeAdd(epoch, index, sourceId, targetId, new Properties((Seq<Property>)properties), (Option<Type>)edgeType, SchemaProviderInstances$.MODULE$.edgeAddSchemaProvider());
        return (Seq)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphAlteration.EdgeAdd[]{edgeAdd})).$plus$plus((IterableOnce)sourceAdd)).$plus$plus((IterableOnce)targetAdd);
    }

    public SqlEdgeSource(SqlConnection conn, String query, String source, String target, String time, String edgeType, List<String> properties) {
        this.conn = conn;
        this.query = query;
        this.source = source;
        this.target = target;
        this.time = time;
        this.edgeType = edgeType;
        this.properties = properties;
        super(conn, query);
        Product.$init$((Product)this);
        this.typeCol = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(edgeType)) ? new Some((Object)edgeType.toUpperCase()) : None$.MODULE$;
    }
}

