/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import cats.effect.kernel.Async;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.GraphBuilder;
import com.raphtory.api.input.Spout;
import com.raphtory.api.input.SpoutBuilderSource;
import com.raphtory.api.input.Type;
import com.raphtory.sources.JSONEdgeListSource$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

@Scaladoc(value="/**\n  * JSONEdgeListSource is for building graphs in Raphtory from JSON data with no nested classes in JSON objects.\n  *\n  * @param spout state where to ingest your data from (Mandatory field)\n  * @param sourceKey state the key of the source ID in your JSON data (default = \"source\")\n  * @param sourceType state what type of value the source is (default = None)\n  * @param targetKey state the key of the target ID in your JSON data (default = \"target\")\n  * @param targetType state what type of value the target is (default = None)\n  * @param edgeRelationship state what the edge relationship is (default = None)\n  * @param timeKey state the key of the timestamp in your JSON data, timestamp must be in datetime format (default = \"time\")\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\u0015+\u0001EB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0005\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001B\u0001B\u0003%!\b\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003;\u0011!y\u0005A!A!\u0002\u0013Q\u0004\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011E\u0003!\u0011!Q\u0001\niB\u0001B\u0015\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006=\u0002!\teX\u0004\u0006c*B\tA\u001d\u0004\u0006S)B\ta\u001d\u0005\u0006'2!\t\u0001\u001f\u0005\u0006s2!\tA\u001f\u0005\n\u0003\u000ba\u0011\u0013!C\u0001\u0003\u000fA\u0011\"!\b\r#\u0003%\t!a\u0002\t\u0013\u0005}A\"%A\u0005\u0002\u0005\u001d\u0001\"CA\u0011\u0019E\u0005I\u0011AA\u0004\u0011%\t\u0019\u0003DI\u0001\n\u0003\t9\u0001C\u0005\u0002&1\t\n\u0011\"\u0001\u0002\b!9\u0011q\u0005\u0007\u0005\u0002\u0005%\u0002\"CA\u001e\u0019E\u0005I\u0011AA\u0004\u0011%\ti\u0004DI\u0001\n\u0003\t9\u0001C\u0005\u0002@1\t\n\u0011\"\u0001\u0002\b!I\u0011\u0011\t\u0007\u0012\u0002\u0013\u0005\u0011q\u0001\u0005\n\u0003\u0007b\u0011\u0013!C\u0001\u0003\u000fA\u0011\"!\u0012\r#\u0003%\t!a\u0002\t\u000f\u0005\u001dC\u0002\"\u0001\u0002J!I\u0011\u0011\f\u0007\u0012\u0002\u0013\u0005\u0011q\u0001\u0005\n\u00037b\u0011\u0013!C\u0001\u0003\u000fA\u0011\"!\u0018\r#\u0003%\t!a\u0002\t\u0013\u0005}C\"%A\u0005\u0002\u0005\u001d\u0001\"CA1\u0019E\u0005I\u0011AA\u0004\u0011%\t\u0019\u0007DI\u0001\n\u0003\t9\u0001C\u0005\u0002f1\t\n\u0011\"\u0001\u0002\b!I\u0011q\r\u0007\u0012\u0002\u0013\u0005\u0011q\u0001\u0005\n\u0003Sb\u0011\u0013!C\u0001\u0003\u000fA\u0011\"a\u001b\r#\u0003%\t!a\u0002\t\u0013\u00055D\"%A\u0005\u0002\u0005\u001d\u0001\"CA8\u0019E\u0005I\u0011AA\u0004\u0005IQ5k\u0014(FI\u001e,G*[:u'>,(oY3\u000b\u0005-b\u0013aB:pkJ\u001cWm\u001d\u0006\u0003[9\n\u0001B]1qQR|'/\u001f\u0006\u0002_\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\r\t\u0004gaRT\"\u0001\u001b\u000b\u0005U2\u0014!B5oaV$(BA\u001c-\u0003\r\t\u0007/[\u0005\u0003sQ\u0012!c\u00159pkR\u0014U/\u001b7eKJ\u001cv.\u001e:dKB\u00111\b\u0012\b\u0003y\t\u0003\"!\u0010!\u000e\u0003yR!a\u0010\u0019\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u0003\u0015!B:q_V$X#A%\u0011\u0007MR%(\u0003\u0002Li\t)1\u000b]8vi\u000611\u000f]8vi\u0002\n\u0011b]8ve\u000e,7*Z=\u0002\u0015M|WO]2f)f\u0004X-A\u0005uCJ<W\r^&fs\u0006QA/\u0019:hKR$\u0016\u0010]3\u0002!\u0015$w-\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004\u0018a\u0002;j[\u0016\\U-_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011U;\u0006,\u0017.\\9v\u0003\"A\u0016\u0001\u000e\u0003)BQaR\u0005A\u0002%Cq!T\u0005\u0011\u0002\u0003\u0007!\bC\u0004O\u0013A\u0005\t\u0019\u0001\u001e\t\u000f=K\u0001\u0013!a\u0001u!9\u0001+\u0003I\u0001\u0002\u0004Q\u0004bB)\n!\u0003\u0005\rA\u000f\u0005\b%&\u0001\n\u00111\u0001;\u0003\u001d\u0011W/\u001b7eKJ,\u0012\u0001\u0019\t\u0004g\u0005T\u0014B\u000125\u000519%/\u00199i\u0005VLG\u000eZ3sQ\u0011\u0001AM\\8\u0011\u0005\u0015dW\"\u00014\u000b\u0005\u001dD\u0017\u0001C:dC2\fGm\\2\u000b\u0005%T\u0017a\u0002;bW\u0016Tx.\u001a\u0006\u0003W:\naaZ5uQV\u0014\u0017BA7g\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%\u00019\u0002\u000b\u0017|#F\u000b\u0006!A)\u0002#jU(O\u000b\u0012<W\rT5tiN{WO]2fA%\u001c\bEZ8sA\t,\u0018\u000e\u001c3j]\u001e\u0004sM]1qQN\u0004\u0013N\u001c\u0011SCBDGo\u001c:zA\u0019\u0014x.\u001c\u0011K'>s\u0005\u0005Z1uC\u0002:\u0018\u000e\u001e5!]>\u0004c.Z:uK\u0012\u00043\r\\1tg\u0016\u001c\b%\u001b8!\u0015N{e\nI8cU\u0016\u001cGo\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0003\u0018M]1nAM\u0004x.\u001e;!gR\fG/\u001a\u0011xQ\u0016\u0014X\r\t;pA%tw-Z:uAe|WO\u001d\u0011eCR\f\u0007E\u001a:p[\u0002BS*\u00198eCR|'/\u001f\u0011gS\u0016dG-\u000b\u0006!A)\u0002\u0003\t]1sC6\u00043o\\;sG\u0016\\U-\u001f\u0011ti\u0006$X\r\t;iK\u0002ZW-\u001f\u0011pM\u0002\"\b.\u001a\u0011t_V\u00148-\u001a\u0011J\t\u0002Jg\u000eI=pkJ\u0004#jU(OA\u0011\fG/\u0019\u0011)I\u00164\u0017-\u001e7uAu\u0002#e]8ve\u000e,'%\u000b\u0006!A)\u0002\u0003\t]1sC6\u00043o\\;sG\u0016$\u0016\u0010]3!gR\fG/\u001a\u0011xQ\u0006$\b\u0005^=qK\u0002zg\r\t<bYV,\u0007\u0005\u001e5fAM|WO]2fA%\u001c\b\u0005\u000b3fM\u0006,H\u000e\u001e\u0011>A9{g.Z\u0015\u000bA\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005^1sO\u0016$8*Z=!gR\fG/\u001a\u0011uQ\u0016\u00043.Z=!_\u001a\u0004C\u000f[3!i\u0006\u0014x-\u001a;!\u0013\u0012\u0003\u0013N\u001c\u0011z_V\u0014\bES*P\u001d\u0002\"\u0017\r^1!Q\u0011,g-Y;mi\u0002j\u0004E\t;be\u001e,GOI\u0015\u000bA\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005^1sO\u0016$H+\u001f9fAM$\u0018\r^3!o\"\fG\u000f\t;za\u0016\u0004sN\u001a\u0011wC2,X\r\t;iK\u0002\"\u0018M]4fi\u0002J7\u000f\t\u0015eK\u001a\fW\u000f\u001c;!{\u0001ruN\\3*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI3eO\u0016\u0014V\r\\1uS>t7\u000f[5qAM$\u0018\r^3!o\"\fG\u000f\t;iK\u0002*GmZ3!e\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u0011jg\u0002BC-\u001a4bk2$\b%\u0010\u0011O_:,\u0017F\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"\u0018.\\3LKf\u00043\u000f^1uK\u0002\"\b.\u001a\u0011lKf\u0004sN\u001a\u0011uQ\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011j]\u0002Jx.\u001e:!\u0015N{e\n\t3bi\u0006d\u0003\u0005^5nKN$\u0018-\u001c9![V\u001cH\u000f\t2fA%t\u0007\u0005Z1uKRLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011)I\u00164\u0017-\u001e7uAu\u0002#\u0005^5nK\nJ#\u0002\t\u0011+_\u0005\u0011\"jU(O\u000b\u0012<W\rT5tiN{WO]2f!\t1Fb\u0005\u0002\riB\u0011QO^\u0007\u0002\u0001&\u0011q\u000f\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0003I\fQ!\u00199qYf$\"\"V>}{z|\u0018\u0011AA\u0002\u0011\u00159e\u00021\u0001J\u0011\u001die\u0002%AA\u0002iBqA\u0014\b\u0011\u0002\u0003\u0007!\bC\u0004P\u001dA\u0005\t\u0019\u0001\u001e\t\u000fAs\u0001\u0013!a\u0001u!9\u0011K\u0004I\u0001\u0002\u0004Q\u0004b\u0002*\u000f!\u0003\u0005\rAO\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0002\u0016\u0004u\u0005-1FAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0001)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0007\u0002\u0012\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00138\u0003!1'o\\7GS2,GcD+\u0002,\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\t\r\u00055R\u00031\u0001;\u0003\u0011\u0001\u0018\r\u001e5\t\u000f5+\u0002\u0013!a\u0001u!9a*\u0006I\u0001\u0002\u0004Q\u0004bB(\u0016!\u0003\u0005\rA\u000f\u0005\b!V\u0001\n\u00111\u0001;\u0011\u001d\tV\u0003%AA\u0002iBqAU\u000b\u0011\u0002\u0003\u0007!(\u0001\nge>lg)\u001b7fI\u0011,g-Y;mi\u0012\u0012\u0014A\u00054s_64\u0015\u000e\\3%I\u00164\u0017-\u001e7uIM\n!C\u001a:p[\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0011bM]8n\r&dW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003I1'o\\7GS2,G\u0005Z3gCVdG\u000f\n\u001c\u0002%\u0019\u0014x.\u001c$jY\u0016$C-\u001a4bk2$HeN\u0001\rMJ|WNU3t_V\u00148-\u001a\u000b\u0010+\u0006-\u0013QJA(\u0003#\n\u0019&!\u0016\u0002X!1\u0011Q\u0006\u000fA\u0002iBq!\u0014\u000f\u0011\u0002\u0003\u0007!\bC\u0004O9A\u0005\t\u0019\u0001\u001e\t\u000f=c\u0002\u0013!a\u0001u!9\u0001\u000b\bI\u0001\u0002\u0004Q\u0004bB)\u001d!\u0003\u0005\rA\u000f\u0005\b%r\u0001\n\u00111\u0001;\u0003Y1'o\\7SKN|WO]2fI\u0011,g-Y;mi\u0012\u0012\u0014A\u00064s_6\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000fJ\u001a\u0002-\u0019\u0014x.\u001c*fg>,(oY3%I\u00164\u0017-\u001e7uIQ\naC\u001a:p[J+7o\\;sG\u0016$C-\u001a4bk2$H%N\u0001\u0017MJ|WNU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u00051bM]8n%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$s'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0004")
public class JSONEdgeListSource
extends SpoutBuilderSource<String> {
    private final Spout<String> spout;
    private final String sourceKey;
    private final String sourceType;
    private final String targetKey;
    private final String targetType;
    private final String edgeRelationship;
    private final String timeKey;

    public static String $lessinit$greater$default$7() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static String fromResource$default$7() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$7();
    }

    public static String fromResource$default$6() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$6();
    }

    public static String fromResource$default$5() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$5();
    }

    public static String fromResource$default$4() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$4();
    }

    public static String fromResource$default$3() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$3();
    }

    public static String fromResource$default$2() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$2();
    }

    public static JSONEdgeListSource fromResource(String path, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        return JSONEdgeListSource$.MODULE$.fromResource(path, sourceKey, sourceType, targetKey, targetType, edgeRelationship, timeKey);
    }

    public static String fromFile$default$7() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$7();
    }

    public static String fromFile$default$6() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$6();
    }

    public static String fromFile$default$5() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$5();
    }

    public static String fromFile$default$4() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$4();
    }

    public static String fromFile$default$3() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$3();
    }

    public static String fromFile$default$2() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$2();
    }

    public static JSONEdgeListSource fromFile(String path, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        return JSONEdgeListSource$.MODULE$.fromFile(path, sourceKey, sourceType, targetKey, targetType, edgeRelationship, timeKey);
    }

    public static String apply$default$7() {
        return JSONEdgeListSource$.MODULE$.apply$default$7();
    }

    public static String apply$default$6() {
        return JSONEdgeListSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return JSONEdgeListSource$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return JSONEdgeListSource$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return JSONEdgeListSource$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return JSONEdgeListSource$.MODULE$.apply$default$2();
    }

    public static JSONEdgeListSource apply(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        return JSONEdgeListSource$.MODULE$.apply(spout, sourceKey, sourceType, targetKey, targetType, edgeRelationship, timeKey);
    }

    @Override
    public Spout<String> spout() {
        return this.spout;
    }

    @Override
    public GraphBuilder<String> builder() {
        return new GraphBuilder<String>(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JSONEdgeListSource $outer;

            public final <F> F make(Async<F> evidence$1) {
                return (F)GraphBuilder.make$(this, evidence$1);
            }

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public void apply$mcVII$sp(int v1, int v2) {
                Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Graph, Function1<String, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Graph, String>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public final void apply(Graph v1, String v2) {
                this.$outer.com$raphtory$sources$JSONEdgeListSource$$$anonfun$builder$1(v1, v2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Function2.$init$((Function2)this);
                GraphBuilder.$init$(this);
            }
        };
    }

    public final /* synthetic */ void com$raphtory$sources$JSONEdgeListSource$$$anonfun$builder$1(Graph graph, String jsonString) {
        block2: {
            String str = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(jsonString));
            Value json = package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(str), package$.MODULE$.read$default$2());
            String src = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(this.sourceKey)).toString();
            String dst = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(this.targetKey)).toString();
            long timestamp = graph.parseDatetime(json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(this.timeKey)).toString().replace("\"", ""), graph.parseDatetime$default$2());
            long srcID = Graph$.MODULE$.assignID(src);
            long dstID = Graph$.MODULE$.assignID(dst);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(src))) {
                graph.addVertex(timestamp, srcID, new Type(this.sourceType));
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dst))) {
                graph.addVertex(timestamp, dstID, new Type(this.targetType));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(src)) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dst))) break block2;
            graph.addEdge(timestamp, srcID, dstID, new Type(this.edgeRelationship));
        }
    }

    public JSONEdgeListSource(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        this.spout = spout;
        this.sourceKey = sourceKey;
        this.sourceType = sourceType;
        this.targetKey = targetKey;
        this.targetType = targetType;
        this.edgeRelationship = edgeRelationship;
        this.timeKey = timeKey;
    }
}

