/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import cats.effect.kernel.Async;
import cats.effect.kernel.Ref;
import cats.syntax.package;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.GraphBuilder;
import com.raphtory.api.input.ImmutableString;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Source;
import com.raphtory.api.input.Spout;
import com.raphtory.sources.CSVEdgeListSource$;
import fs2.Stream;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * CSVEdgeListSource is for building graphs in Raphtory from CSV data.\n  * CSV data must conform to three columns: source, target and time. Any delimiter is allowed and headers are also handled for.\n  *\n  * @param spout state where to ingest your data from (Mandatory field)\n  * @param timeIndex state which column of your data contains the time (default index = 2)\n  * @param sourceIndex state which column of your data contains the source ID (default index = 0)\n  * @param targetIndex state which column of your data contains the target ID (default index = 1)\n  * @param delimiter state the delimiter of your CSV data (default delimiter = \",\")\n  * @param header state whether your CSV data contains a header or not (default = false)\n  */")
@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\u001c8\u0001yB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t;\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\u0007A!A!\u0002\u0013y\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001b\u0001\u0005\u0002)D\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002;\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00131\b\"\u0003?\u0001\u0001\u0004\u0005\t\u0015)\u0003g\u0011%i\b\u00011AA\u0002\u0013%A\u000fC\u0005\u007f\u0001\u0001\u0007\t\u0019!C\u0005\u007f\"Q\u00111\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0015\u0005\u0015\u0001\u00011AA\u0002\u0013%A\u000fC\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\n\u0005%\u0001BCA\u0007\u0001\u0001\u0007\t\u0011)Q\u0005M\"Q\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011\u0002;\t\u0017\u0005E\u0001\u00011AA\u0002\u0013%\u00111\u0003\u0005\u000b\u0003/\u0001\u0001\u0019!A!B\u00131\u0007BCA\r\u0001\u0001\u0007\t\u0019!C\u0005i\"Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011)\t\t\u0003\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002n\u0002!\t!a<\b\u000f\tMq\u0007#\u0001\u0003\u0016\u00191ag\u000eE\u0001\u0005/Aa![\u000f\u0005\u0002\te\u0001b\u0002B\u000e;\u0011\u0005!Q\u0004\u0005\n\u0005Wi\u0012\u0013!C\u0001\u0005[A\u0011Ba\u0011\u001e#\u0003%\tA!\f\t\u0013\t\u0015S$%A\u0005\u0002\t5\u0002\"\u0003B$;E\u0005I\u0011\u0001B%\u0011%\u0011i%HI\u0001\n\u0003\u0011y\u0005C\u0004\u0003Tu!\tA!\u0016\t\u0013\t\u0015T$%A\u0005\u0002\t5\u0002\"\u0003B4;E\u0005I\u0011\u0001B\u0017\u0011%\u0011I'HI\u0001\n\u0003\u0011i\u0003C\u0005\u0003lu\t\n\u0011\"\u0001\u0003J!I!QN\u000f\u0012\u0002\u0013\u0005!q\n\u0005\b\u0005_jB\u0011\u0001B9\u0011%\u0011y(HI\u0001\n\u0003\u0011i\u0003C\u0005\u0003\u0002v\t\n\u0011\"\u0001\u0003.!I!1Q\u000f\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005\u000bk\u0012\u0013!C\u0001\u0005\u0013B\u0011Ba\"\u001e#\u0003%\tAa\u0014\t\u0013\t%U$%A\u0005\u0002\t5\u0002\"\u0003BF;E\u0005I\u0011\u0001B\u0017\u0011%\u0011i)HI\u0001\n\u0003\u0011i\u0003C\u0005\u0003\u0010v\t\n\u0011\"\u0001\u0003J!I!\u0011S\u000f\u0012\u0002\u0013\u0005!q\n\u0002\u0012\u0007N3V\tZ4f\u0019&\u001cHoU8ve\u000e,'B\u0001\u001d:\u0003\u001d\u0019x.\u001e:dKNT!AO\u001e\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011\u0001P\u0001\u0004G>l7\u0001A\n\u0004\u0001}*\u0005C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\r\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006)\u0011N\u001c9vi*\u0011!*O\u0001\u0004CBL\u0017B\u0001'H\u0005\u0019\u0019v.\u001e:dK\u0006)1\u000f]8viV\tq\nE\u0002G!JK!!U$\u0003\u000bM\u0003x.\u001e;\u0011\u0005MSfB\u0001+Y!\t)\u0016)D\u0001W\u0015\t9V(\u0001\u0004=e>|GOP\u0005\u00033\u0006\u000ba\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011,Q\u0001\u0007gB|W\u000f\u001e\u0011\u0002\u0013QLW.Z%oI\u0016D\bC\u0001!a\u0013\t\t\u0017IA\u0002J]R\f1b]8ve\u000e,\u0017J\u001c3fq\u0006YA/\u0019:hKRLe\u000eZ3y\u0003%!W\r\\5nSR,'/\u0001\u0004iK\u0006$WM\u001d\t\u0003\u0001\u001eL!\u0001[!\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"ra[7o_B\f(\u000f\u0005\u0002m\u00015\tq\u0007C\u0003N\u0011\u0001\u0007q\nC\u0004_\u0011A\u0005\t\u0019A0\t\u000f\tD\u0001\u0013!a\u0001?\"91\r\u0003I\u0001\u0002\u0004y\u0006b\u00023\t!\u0003\u0005\rA\u0015\u0005\bK\"\u0001\n\u00111\u0001g\u0003!!\u0018\u0010]3t'\u0016$X#\u00014\u0002\u0019QL\b/Z:TKR|F%Z9\u0015\u0005]T\bC\u0001!y\u0013\tI\u0018I\u0001\u0003V]&$\bbB>\u000b\u0003\u0003\u0005\rAZ\u0001\u0004q\u0012\n\u0014!\u0003;za\u0016\u001c8+\u001a;!\u00039!\u0017\r^3US6,gi\u001c:nCR\f!\u0003Z1uKRKW.\u001a$pe6\fGo\u0018\u0013fcR\u0019q/!\u0001\t\u000fml\u0011\u0011!a\u0001M\u0006yA-\u0019;f)&lWMR8s[\u0006$\b%A\u0006fa>\u001c\u0007NR8s[\u0006$\u0018aD3q_\u000eDgi\u001c:nCR|F%Z9\u0015\u0007]\fY\u0001C\u0004|!\u0005\u0005\t\u0019\u00014\u0002\u0019\u0015\u0004xn\u00195G_Jl\u0017\r\u001e\u0011\u0002\u00151|gn\u001a$pe6\fG/\u0001\bm_:<gi\u001c:nCR|F%Z9\u0015\u0007]\f)\u0002C\u0004|'\u0005\u0005\t\u0019\u00014\u0002\u00171|gn\u001a$pe6\fG\u000fI\u0001\rgR\u0014\u0018N\\4G_Jl\u0017\r^\u0001\u0011gR\u0014\u0018N\\4G_Jl\u0017\r^0%KF$2a^A\u0010\u0011\u001dYh#!AA\u0002\u0019\fQb\u001d;sS:<gi\u001c:nCR\u0004\u0013AC7bW\u0016\u001cFO]3b[V!\u0011qEA\u0018)\u0011\tI#!,\u0015\t\u0005-\u0012Q\u0012\t\u0007\u0003[\ty#a\u0012\r\u0001\u00119\u0011\u0011\u0007\rC\u0002\u0005M\"!\u0001$\u0016\t\u0005U\u00121I\t\u0005\u0003o\ti\u0004E\u0002A\u0003sI1!a\u000fB\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001QA \u0013\r\t\t%\u0011\u0002\u0004\u0003:LH\u0001CA#\u0003_\u0011\r!!\u000e\u0003\t}#C%\r\t\t\u0003\u0013\ny%a\u0015\u0002V5\u0011\u00111\n\u0006\u0003\u0003\u001b\n1AZ:3\u0013\u0011\t\t&a\u0013\u0003\rM#(/Z1n!\u0011\ti#a\f\u0011\r\u0005]\u0013\u0011MA4\u001d\u0011\tI&!\u0018\u000f\u0007U\u000bY&C\u0001C\u0013\r\ty&Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019'!\u001a\u0003\u0007M+\u0017OC\u0002\u0002`\u0005\u0003B!!\u001b\u0002\b:!\u00111NAA\u001d\u0011\ti'a\u001f\u000f\t\u0005=\u0014q\u000f\b\u0005\u0003c\n)HD\u0002V\u0003gJ\u0011\u0001P\u0005\u0003umJ1!!\u001f:\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0002~\u0005}\u0014!B4sCBD'bAA=s%!\u00111QAC\u0003=9%/\u00199i\u00032$XM]1uS>t'\u0002BA?\u0003\u007fJA!!#\u0002\f\nYqI]1qQV\u0003H-\u0019;f\u0015\u0011\t\u0019)!\"\t\u0013\u0005=\u0005$!AA\u0004\u0005E\u0015AC3wS\u0012,gnY3%cA1\u00111SAT\u0003'rA!!&\u0002$:!\u0011qSAO\u001d\r)\u0016\u0011T\u0005\u0003\u00037\u000bAaY1ug&!\u0011qTAQ\u0003\u0019)gMZ3di*\u0011\u00111T\u0005\u0005\u0003?\n)K\u0003\u0003\u0002 \u0006\u0005\u0016\u0002BAU\u0003W\u0013Q!Q:z]\u000eTA!a\u0018\u0002&\"9\u0011q\u0016\rA\u0002\u0005E\u0016aC4m_\n\fG.\u00138eKb\u0004\u0002\"a-\u0002:\u0006M\u0013QX\u0007\u0003\u0003kSA!a.\u0002&\u000611.\u001a:oK2LA!a/\u00026\n\u0019!+\u001a4\u0011\u0007\u0001\u000by,C\u0002\u0002B\u0006\u0013A\u0001T8oO\u0006)\"-^5mI\u000e\u001bf+\u00123hK2K7\u000f^$sCBDGcC<\u0002H\u0006=\u00171[Al\u00037Dq!! \u001a\u0001\u0004\tI\rE\u0002G\u0003\u0017L1!!4H\u0005\u00159%/\u00199i\u0011\u0019\t\t.\u0007a\u0001%\u0006)A/\u001e9mK\"1\u0011Q[\rA\u0002I\u000bqA]1x)&lW\r\u0003\u0004\u0002Zf\u0001\rAU\u0001\u0007g>,(oY3\t\r\u0005u\u0017\u00041\u0001S\u0003\u0019!\u0018M]4fi\u000692\r[3dWRK\b/Z:B]\u0012\u0014U/\u001b7e\u000fJ\f\u0007\u000f\u001b\u000b\fo\u0006\r\u0018Q]At\u0003S\fY\u000fC\u0004\u0002~i\u0001\r!!3\t\r\u0005E'\u00041\u0001S\u0011\u0019\t)N\u0007a\u0001%\"1\u0011\u0011\u001c\u000eA\u0002ICa!!8\u001b\u0001\u0004\u0011\u0016a\u00022vS2$WM]\u000b\u0003\u0003c\u0004BARAz%&\u0019\u0011Q_$\u0003\u0019\u001d\u0013\u0018\r\u001d5Ck&dG-\u001a:)\u000f\u0001\tIP!\u0004\u0003\u0010A!\u00111 B\u0005\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011\u0001C:dC2\fGm\\2\u000b\t\t\r!QA\u0001\bi\u0006\\WM_8f\u0015\r\u00119aO\u0001\u0007O&$\b.\u001e2\n\t\t-\u0011Q \u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012!\u0011C\u0001\u0006R>R#F\u0003\u0011!U\u0001\u001a5KV#eO\u0016d\u0015n\u001d;T_V\u00148-\u001a\u0011jg\u00022wN\u001d\u0011ck&dG-\u001b8hA\u001d\u0014\u0018\r\u001d5tA%t\u0007EU1qQR|'/\u001f\u0011ge>l\u0007eQ*WA\u0011\fG/\u0019\u0018\u000bA\u0001R\u0003eQ*WA\u0011\fG/\u0019\u0011nkN$\beY8oM>\u0014X\u000e\t;pAQD'/Z3!G>dW/\u001c8tu\u0001\u001ax.\u001e:dK2\u0002C/\u0019:hKR\u0004\u0013M\u001c3!i&lWM\f\u0011B]f\u0004C-\u001a7j[&$XM\u001d\u0011jg\u0002\nG\u000e\\8xK\u0012\u0004\u0013M\u001c3!Q\u0016\fG-\u001a:tA\u0005\u0014X\rI1mg>\u0004\u0003.\u00198eY\u0016$\u0007EZ8s])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\t]1sC6\u00043\u000f]8vi\u0002\u001aH/\u0019;fA]DWM]3!i>\u0004\u0013N\\4fgR\u0004\u0013p\\;sA\u0011\fG/\u0019\u0011ge>l\u0007\u0005K'b]\u0012\fGo\u001c:zA\u0019LW\r\u001c3*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t;j[\u0016Le\u000eZ3yAM$\u0018\r^3!o\"L7\r\u001b\u0011d_2,XN\u001c\u0011pM\u0002Jx.\u001e:!I\u0006$\u0018\rI2p]R\f\u0017N\\:!i\",\u0007\u0005^5nK\u0002BC-\u001a4bk2$\b%\u001b8eKb\u0004S\b\t\u001a*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI:pkJ\u001cW-\u00138eKb\u00043\u000f^1uK\u0002:\b.[2iA\r|G.^7oA=4\u0007%_8ve\u0002\"\u0017\r^1!G>tG/Y5og\u0002\"\b.\u001a\u0011t_V\u00148-\u001a\u0011J\t\u0002BC-\u001a4bk2$\b%\u001b8eKb\u0004S\b\t\u0019*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t;be\u001e,G/\u00138eKb\u00043\u000f^1uK\u0002:\b.[2iA\r|G.^7oA=4\u0007%_8ve\u0002\"\u0017\r^1!G>tG/Y5og\u0002\"\b.\u001a\u0011uCJ<W\r\u001e\u0011J\t\u0002BC-\u001a4bk2$\b%\u001b8eKb\u0004S\bI\u0019*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t3fY&l\u0017\u000e^3sAM$\u0018\r^3!i\",\u0007\u0005Z3mS6LG/\u001a:!_\u001a\u0004\u0013p\\;sA\r\u001bf\u000b\t3bi\u0006\u0004\u0003\u0006Z3gCVdG\u000f\t3fY&l\u0017\u000e^3sAu\u0002#\u0005\f\u0012*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t5fC\u0012,'\u000fI:uCR,\u0007e\u001e5fi\",'\u000fI=pkJ\u00043i\u0015,!I\u0006$\u0018\rI2p]R\f\u0017N\\:!C\u0002BW-\u00193fe\u0002z'\u000f\t8pi\u0002BC-\u001a4bk2$\b%\u0010\u0011gC2\u001cX-\u000b\u0006!A)z\u0013!E\"T-\u0016#w-\u001a'jgR\u001cv.\u001e:dKB\u0011A.H\n\u0003;}\"\"A!\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001b-\u0014yB!\t\u0003$\t\u0015\"q\u0005B\u0015\u0011\u0015iu\u00041\u0001P\u0011\u001dqv\u0004%AA\u0002}CqAY\u0010\u0011\u0002\u0003\u0007q\fC\u0004d?A\u0005\t\u0019A0\t\u000f\u0011|\u0002\u0013!a\u0001%\"9Qm\bI\u0001\u0002\u00041\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t=\"fA0\u00032-\u0012!1\u0007\t\u0005\u0005k\u0011y$\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0003>\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tEa\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-#f\u0001*\u00032\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'\u0006\u0002\u0003R)\u001aaM!\r\u0002\u0011\u0019\u0014x.\u001c$jY\u0016$Rb\u001bB,\u00057\u0012iFa\u0018\u0003b\t\r\u0004B\u0002B-K\u0001\u0007!+\u0001\u0003qCRD\u0007b\u00020&!\u0003\u0005\ra\u0018\u0005\bE\u0016\u0002\n\u00111\u0001`\u0011\u001d\u0019W\u0005%AA\u0002}Cq\u0001Z\u0013\u0011\u0002\u0003\u0007!\u000bC\u0004fKA\u0005\t\u0019\u00014\u0002%\u0019\u0014x.\u001c$jY\u0016$C-\u001a4bk2$HEM\u0001\u0013MJ|WNR5mK\u0012\"WMZ1vYR$3'\u0001\nge>lg)\u001b7fI\u0011,g-Y;mi\u0012\"\u0014A\u00054s_64\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\n!C\u001a:p[\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005aaM]8n%\u0016\u001cx.\u001e:dKRi1Na\u001d\u0003v\t]$\u0011\u0010B>\u0005{BaA!\u0017,\u0001\u0004\u0011\u0006b\u00020,!\u0003\u0005\ra\u0018\u0005\bE.\u0002\n\u00111\u0001`\u0011\u001d\u00197\u0006%AA\u0002}Cq\u0001Z\u0016\u0011\u0002\u0003\u0007!\u000bC\u0004fWA\u0005\t\u0019\u00014\u0002-\u0019\u0014x.\u001c*fg>,(oY3%I\u00164\u0017-\u001e7uII\naC\u001a:p[J+7o\\;sG\u0016$C-\u001a4bk2$HeM\u0001\u0017MJ|WNU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u00051bM]8n%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$S'\u0001\fge>l'+Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00137\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\u000e")
public class CSVEdgeListSource
implements Source {
    private final Spout<String> spout;
    private final int timeIndex;
    private final int sourceIndex;
    private final int targetIndex;
    private final String delimiter;
    private final boolean header;
    private boolean typesSet;
    private boolean dateTimeFormat;
    private boolean epochFormat;
    private boolean longFormat;
    private boolean stringFormat;

    public static boolean $lessinit$greater$default$6() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean fromResource$default$6() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$6();
    }

    public static String fromResource$default$5() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$5();
    }

    public static int fromResource$default$4() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$4();
    }

    public static int fromResource$default$3() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$3();
    }

    public static int fromResource$default$2() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$2();
    }

    public static CSVEdgeListSource fromResource(String path, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        return CSVEdgeListSource$.MODULE$.fromResource(path, timeIndex, sourceIndex, targetIndex, delimiter, header);
    }

    public static boolean fromFile$default$6() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$6();
    }

    public static String fromFile$default$5() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$5();
    }

    public static int fromFile$default$4() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$4();
    }

    public static int fromFile$default$3() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$3();
    }

    public static int fromFile$default$2() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$2();
    }

    public static CSVEdgeListSource fromFile(String path, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        return CSVEdgeListSource$.MODULE$.fromFile(path, timeIndex, sourceIndex, targetIndex, delimiter, header);
    }

    public static boolean apply$default$6() {
        return CSVEdgeListSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return CSVEdgeListSource$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return CSVEdgeListSource$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return CSVEdgeListSource$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CSVEdgeListSource$.MODULE$.apply$default$2();
    }

    public static CSVEdgeListSource apply(Spout<String> spout, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        return CSVEdgeListSource$.MODULE$.apply(spout, timeIndex, sourceIndex, targetIndex, delimiter, header);
    }

    @Override
    public List<Class<?>> getDynamicClasses() {
        return Source.getDynamicClasses$(this);
    }

    public Spout<String> spout() {
        return this.spout;
    }

    private boolean typesSet() {
        return this.typesSet;
    }

    private void typesSet_$eq(boolean x$1) {
        this.typesSet = x$1;
    }

    private boolean dateTimeFormat() {
        return this.dateTimeFormat;
    }

    private void dateTimeFormat_$eq(boolean x$1) {
        this.dateTimeFormat = x$1;
    }

    private boolean epochFormat() {
        return this.epochFormat;
    }

    private void epochFormat_$eq(boolean x$1) {
        this.epochFormat = x$1;
    }

    private boolean longFormat() {
        return this.longFormat;
    }

    private void longFormat_$eq(boolean x$1) {
        this.longFormat = x$1;
    }

    private boolean stringFormat() {
        return this.stringFormat;
    }

    private void stringFormat_$eq(boolean x$1) {
        this.stringFormat = x$1;
    }

    @Override
    public <F> F makeStream(Ref<F, Object> globalIndex, Async<F> evidence$1) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.builder().make(evidence$1), evidence$1).map((Function1 & Serializable)builderInstance -> {
            Stream tuples = $this.header ? this.spout().asStream(evidence$1).tail() : this.spout().asStream(evidence$1);
            Stream stream = tuples.chunks().evalMap((Function1 & Serializable)chunk -> builderInstance.parseUpdates(chunk, globalIndex));
            return new Tuple3(builderInstance, (Object)tuples, (Object)stream);
        }), evidence$1).map((Function1 & Serializable)x$6 -> {
            Stream stream;
            Tuple3 tuple3 = x$6;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Stream stream2 = stream = (Stream)tuple3._3();
            return stream2;
        });
    }

    public void buildCSVEdgeListGraph(Graph graph, String tuple, String rawTime, String source, String target) {
        long l;
        long l2;
        long l3;
        if (this.dateTimeFormat()) {
            l3 = graph.parseDatetime(rawTime, graph.parseDatetime$default$2());
        } else if (this.epochFormat()) {
            l3 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(rawTime));
        } else {
            throw new RuntimeException(new StringBuilder(0).append(new StringBuilder(64).append("Timestamp in tuple '").append(tuple).append("' does not conform to what was seen in first").toString()).append(new StringBuilder(16).append(" line of data (").append((Object)(this.dateTimeFormat() ? "datetime format" : "epoch format")).append(")").toString()).toString());
        }
        long timestamp = l3;
        if (this.longFormat()) {
            l2 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(source));
        } else if (this.stringFormat()) {
            l2 = Graph$.MODULE$.assignID(source);
        } else {
            throw new RuntimeException(new StringBuilder(73).append("Source does not conform to what was seen in first line of data in tuple: ").append(tuple).toString());
        }
        long src = l2;
        if (this.longFormat()) {
            l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(target));
        } else if (this.stringFormat()) {
            l = Graph$.MODULE$.assignID(target);
        } else {
            throw new RuntimeException(new StringBuilder(73).append("Target does not conform to what was seen in first line of data in tuple: ").append(tuple).toString());
        }
        long dst = l;
        graph.addVertex(timestamp, src, new Properties((Seq<Property>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{new ImmutableString("name", source)})), graph.addVertex$default$4(), graph.addVertex$default$5());
        graph.addVertex(timestamp, dst, new Properties((Seq<Property>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{new ImmutableString("name", target)})), graph.addVertex$default$4(), graph.addVertex$default$5());
        graph.addEdge(timestamp, src, dst, graph.addEdge$default$4(), graph.addEdge$default$5(), graph.addEdge$default$6());
    }

    public void checkTypesAndBuildGraph(Graph graph, String tuple, String rawTime, String source, String target) {
        if (!this.typesSet()) {
            Boolean bl = Predef$.MODULE$.boolean2Boolean(this.typesSet());
            synchronized (bl) {
                if (!this.typesSet()) {
                    this.liftedTree1$1(rawTime, graph);
                    this.liftedTree2$1(source, target);
                }
                this.typesSet_$eq(true);
            }
        }
        this.buildCSVEdgeListGraph(graph, tuple, rawTime, source, target);
    }

    public GraphBuilder<String> builder() {
        return new GraphBuilder<String>(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVEdgeListSource $outer;

            public final <F> F make(Async<F> evidence$1) {
                return (F)GraphBuilder.make$(this, evidence$1);
            }

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public void apply$mcVII$sp(int v1, int v2) {
                Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Graph, Function1<String, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Graph, String>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public final void apply(Graph v1, String v2) {
                this.$outer.com$raphtory$sources$CSVEdgeListSource$$$anonfun$builder$1(v1, v2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Function2.$init$((Function2)this);
                GraphBuilder.$init$(this);
            }
        };
    }

    private final /* synthetic */ void liftedTree1$1(String rawTime$1, Graph graph$1) {
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(rawTime$1));
            this.epochFormat_$eq(true);
        }
        catch (NumberFormatException e) {
            graph$1.parseDatetime(rawTime$1, graph$1.parseDatetime$default$2());
            this.dateTimeFormat_$eq(true);
        }
    }

    private final /* synthetic */ void liftedTree2$1(String source$1, String target$1) {
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(source$1));
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(target$1));
            this.longFormat_$eq(true);
        }
        catch (NumberFormatException e) {
            this.stringFormat_$eq(true);
        }
    }

    public final /* synthetic */ void com$raphtory$sources$CSVEdgeListSource$$$anonfun$builder$1(Graph graph, String tuple) {
        block0: {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(tuple))) break block0;
            String[] fileLine = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tuple.split(this.delimiter)), (Function1 & Serializable)x$7 -> x$7.trim(), ClassTag$.MODULE$.apply(String.class));
            String source = fileLine[this.sourceIndex];
            String target = fileLine[this.targetIndex];
            String rawTime = fileLine[this.timeIndex];
            this.checkTypesAndBuildGraph(graph, tuple, rawTime, source, target);
        }
    }

    public CSVEdgeListSource(Spout<String> spout, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        this.spout = spout;
        this.timeIndex = timeIndex;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.delimiter = delimiter;
        this.header = header;
        Source.$init$(this);
    }
}

