/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sinks;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.FormatAgnosticSink;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.sinks.PrintSink$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A [[com.raphtory.api.output.sink.Sink Sink]] that prints a `Table` to the standard output.\n  *\n  * @param format the format to be used by this sink (`CsvFormat` by default)\n  *\n  * @note This sink is only intended for testing and should be used for deployments with only one partition.\n  *\n  * @example\n  * {{{\n  * import com.raphtory.algorithms.generic.EdgeList\n  * import com.raphtory.sinks.PrintSink\n  * import com.raphtory.spouts.FileSpout\n  *\n  * val graphBuilder = new YourGraphBuilder()\n  * val graph = Raphtory.stream(FileSpout(\"/path/to/your/file\"), graphBuilder)\n  * val sink = PrintSink()\n  *\n  * graph.execute(EdgeList()).writeTo(sink)\n  * }}}\n  * @see [[com.raphtory.api.output.sink.Sink Sink]]\n  *      [[com.raphtory.api.output.format.Format Format]]\n  *      [[com.raphtory.formats.CsvFormat CsvFormat]]\n  *      [[com.raphtory.api.analysis.table.Table Table]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\r\u001b\u0001\u0006B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0001\")a\t\u0001C\u0001\u000f\")1\n\u0001C!\u0019\"9A\u000eAA\u0001\n\u0003i\u0007bB8\u0001#\u0003%\t\u0001\u001d\u0005\bw\u0002\t\t\u0011\"\u0011}\u0011%\tI\u0001AA\u0001\n\u0003\tY\u0001C\u0005\u0002\u000e\u0001\t\t\u0011\"\u0001\u0002\u0010!I\u00111\u0004\u0001\u0002\u0002\u0013\u0005\u0013Q\u0004\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"a\u000e\u0001\u0003\u0003%\t%!\u000f\t\u0013\u0005u\u0002!!A\u0005B\u0005}\u0002\"CA!\u0001\u0005\u0005I\u0011IA\"\u0011%\t)\u0005AA\u0001\n\u0003\n9eB\u0005\u0002hi\t\t\u0011#\u0001\u0002j\u0019A\u0011DGA\u0001\u0012\u0003\tY\u0007\u0003\u0004G#\u0011\u0005\u00111\u0011\u0005\n\u0003\u0003\n\u0012\u0011!C#\u0003\u0007B\u0011\"!\"\u0012\u0003\u0003%\t)a\"\t\u0011\u0005-\u0015#%A\u0005\u0002AD\u0011\"!$\u0012\u0003\u0003%\t)a$\t\u0011\u0005m\u0015#%A\u0005\u0002AD\u0011\"!(\u0012\u0003\u0003%I!a(\u0003\u0013A\u0013\u0018N\u001c;TS:\\'BA\u000e\u001d\u0003\u0015\u0019\u0018N\\6t\u0015\tib$\u0001\u0005sCBDGo\u001c:z\u0015\u0005y\u0012aA2p[\u000e\u00011\u0003\u0002\u0001#YI\u0002\"a\t\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\tMLgn\u001b\u0006\u0003O!\naa\\;uaV$(BA\u0015\u001d\u0003\r\t\u0007/[\u0005\u0003W\u0011\u0012!CR8s[\u0006$\u0018i\u001a8pgRL7mU5oWB\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t9\u0001K]8ek\u000e$\bCA\u001a<\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u00028A\u00051AH]8pizJ\u0011aL\u0005\u0003u9\nq\u0001]1dW\u0006<W-\u0003\u0002={\ta1+\u001a:jC2L'0\u00192mK*\u0011!HL\u0001\u0007M>\u0014X.\u0019;\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!A\u0010\u0014\n\u0005\u0011\u0013%A\u0002$pe6\fG/A\u0004g_Jl\u0017\r\u001e\u0011\u0002\rqJg.\u001b;?)\tA%\n\u0005\u0002J\u00015\t!\u0004C\u0004?\u0007A\u0005\t\u0019\u0001!\u0002\u001d\t,\u0018\u000e\u001c3D_:tWm\u0019;peR1Q\n\u0015.`Q*\u0004\"a\t(\n\u0005=##!D*j].\u001cuN\u001c8fGR|'\u000fC\u0003R\t\u0001\u0007!+A\u0003k_\nLE\t\u0005\u0002T/:\u0011A+\u0016\t\u0003k9J!A\u0016\u0018\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-:BQa\u0017\u0003A\u0002q\u000b1\u0002]1si&$\u0018n\u001c8J\tB\u0011Q&X\u0005\u0003=:\u00121!\u00138u\u0011\u0015\u0001G\u00011\u0001b\u0003\u0019\u0019wN\u001c4jOB\u0011!MZ\u0007\u0002G*\u0011\u0001\r\u001a\u0006\u0003Kz\t\u0001\u0002^=qKN\fg-Z\u0005\u0003O\u000e\u0014aaQ8oM&<\u0007\"B5\u0005\u0001\u0004\u0011\u0016!D5uK6$U\r\\5nSR,'\u000fC\u0003l\t\u0001\u0007!+A\u0007gS2,W\t\u001f;f]NLwN\\\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002I]\"9a(\u0002I\u0001\u0002\u0004\u0001\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002c*\u0012\u0001I]\u0016\u0002gB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001f\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002{k\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u00031~\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001X\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t\"a\u0006\u0011\u00075\n\u0019\"C\u0002\u0002\u00169\u00121!\u00118z\u0011!\tI\"CA\u0001\u0002\u0004a\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002 A1\u0011\u0011EA\u0014\u0003#i!!a\t\u000b\u0007\u0005\u0015b&\u0001\u0006d_2dWm\u0019;j_:LA!!\u000b\u0002$\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty#!\u000e\u0011\u00075\n\t$C\u0002\u000249\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001a-\t\t\u00111\u0001\u0002\u0012\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\ri\u00181\b\u0005\t\u00033a\u0011\u0011!a\u00019\u0006A\u0001.Y:i\u0007>$W\rF\u0001]\u0003!!xn\u0015;sS:<G#A?\u0002\r\u0015\fX/\u00197t)\u0011\ty#!\u0013\t\u0013\u0005eq\"!AA\u0002\u0005E\u0001f\u0002\u0001\u0002N\u0005\u0005\u00141\r\t\u0005\u0003\u001f\ni&\u0004\u0002\u0002R)!\u00111KA+\u0003!\u00198-\u00197bI>\u001c'\u0002BA,\u00033\nq\u0001^1lKj|WMC\u0002\u0002\\y\taaZ5uQV\u0014\u0017\u0002BA0\u0003#\u0012\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003K\na1^\u0018+U\u0001\n\u0005eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:zW\u000f\u001e9vi:\u001a\u0018N\\6/'&t7\u000eI*j].lV\f\t;iCR\u0004\u0003O]5oiN\u0004\u0013\r\t1UC\ndW\r\u0019\u0011u_\u0002\"\b.\u001a\u0011ti\u0006tG-\u0019:eA=,H\u000f];u])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\t]1sC6\u0004cm\u001c:nCR\u0004C\u000f[3!M>\u0014X.\u0019;!i>\u0004#-\u001a\u0011vg\u0016$\u0007EY=!i\"L7\u000fI:j].\u0004\u0003\u0006Y\"tm\u001a{'/\\1uA\u0002\u0012\u0017\u0010\t3fM\u0006,H\u000e^\u0015\u000bA\u0001R#\u0002\t\u0011+A\u0001sw\u000e^3!)\"L7\u000fI:j].\u0004\u0013n\u001d\u0011p]2L\b%\u001b8uK:$W\r\u001a\u0011g_J\u0004C/Z:uS:<\u0007%\u00198eAMDw.\u001e7eA\t,\u0007%^:fI\u00022wN\u001d\u0011eKBdw._7f]R\u001c\be^5uQ\u0002zg\u000e\\=!_:,\u0007\u0005]1si&$\u0018n\u001c8/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002U\r_1na2,'\u0002\t\u0011+Am\\8P\u0003\u0011!U\u0001JW\u000e]8si\u0002\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7OL4f]\u0016\u0014\u0018n\u0019\u0018FI\u001e,G*[:u\u0015\u0001\u0002#\u0006I5na>\u0014H\u000fI2p[:\u0012\u0018\r\u001d5u_JLhf]5oWNt\u0003K]5oiNKgn\u001b\u0006!A)\u0002\u0013.\u001c9peR\u00043m\\7/e\u0006\u0004\b\u000e^8ss:\u001a\bo\\;ug:2\u0015\u000e\\3Ta>,HO\u0003\u0011!U)\u0001\u0003E\u000b\u0011wC2\u0004sM]1qQ\n+\u0018\u000e\u001c3fe\u0002j\u0004E\\3xAe{WO]$sCBD')^5mI\u0016\u0014\b&\u000b\u0006!A)\u0002c/\u00197!OJ\f\u0007\u000f\u001b\u0011>AI\u000b\u0007\u000f\u001b;peft3\u000f\u001e:fC6Dc)\u001b7f'B|W\u000f\u001e\u0015#_A\fG\u000f[\u0018u_>Jx.\u001e:0M&dWMI\u0015-A\u001d\u0014\u0018\r\u001d5Ck&dG-\u001a:*\u0015\u0001\u0002#\u0006\t<bY\u0002\u001a\u0018N\\6!{\u0001\u0002&/\u001b8u'&t7\u000eK\u0015\u000bA\u0001R#\u0002\t\u0011+A\u001d\u0014\u0018\r\u001d5/Kb,7-\u001e;fQ\u0015#w-\u001a'jgRD\u0013&\u000b\u0018xe&$X\rV8)g&t7.\u000b\u0006!A)\u0002S0`?\u000bA\u0001R\u0003\u0005Q:fK\u0002Z6lY8n]I\f\u0007\u000f\u001b;peft\u0013\r]5/_V$\b/\u001e;/g&t7NL*j].\u00043+\u001b8l;vS\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005I.\\G>lgF]1qQR|'/\u001f\u0018ba&ts.\u001e;qkRtcm\u001c:nCRtci\u001c:nCR\u0004ci\u001c:nCRlVL\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0019|'/\\1ug:\u001a5O\u001e$pe6\fG\u000fI\"tm\u001a{'/\\1u;vS\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005I.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013M\\1msNL7O\f;bE2,g\u0006V1cY\u0016\u0004C+\u00192mKvk&\u0002\t\u0011+_\u0005I\u0001K]5oiNKgn\u001b\t\u0003\u0013F\u0019R!EA7\u0003s\u0002b!a\u001c\u0002v\u0001CUBAA9\u0015\r\t\u0019HL\u0001\beVtG/[7f\u0013\u0011\t9(!\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\u0011\ty(a\u0001\u0002\u0005%|\u0017b\u0001\u001f\u0002~Q\u0011\u0011\u0011N\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0011\u0006%\u0005b\u0002 \u0015!\u0003\u0005\r\u0001Q\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%c\u00059QO\\1qa2LH\u0003BAI\u0003/\u0003B!LAJ\u0001&\u0019\u0011Q\u0013\u0018\u0003\r=\u0003H/[8o\u0011!\tIJFA\u0001\u0002\u0004A\u0015a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!)\u0011\u0007y\f\u0019+C\u0002\u0002&~\u0014aa\u00142kK\u000e$\b")
public class PrintSink
extends FormatAgnosticSink
implements Product,
Serializable {
    private final Format format;

    public static Format $lessinit$greater$default$1() {
        return PrintSink$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Format> unapply(PrintSink x$0) {
        return PrintSink$.MODULE$.unapply(x$0);
    }

    public static Format apply$default$1() {
        return PrintSink$.MODULE$.apply$default$1();
    }

    public static PrintSink apply(Format format) {
        return PrintSink$.MODULE$.apply(format);
    }

    public static <A> Function1<Format, A> andThen(Function1<PrintSink, A> g) {
        return PrintSink$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, PrintSink> compose(Function1<A, Format> g) {
        return PrintSink$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Format format() {
        return this.format;
    }

    @Override
    public SinkConnector buildConnector(String jobID, int partitionID, Config config, String itemDelimiter, String fileExtension) {
        return new SinkConnector(null, itemDelimiter){
            private final String itemDelimiter$1;

            @Scaladoc(value="/** Writes a header for the output if this connector support it as specified by `allowsHeader`\n    * @param header the header to be written at the beginning\n    */")
            public final void writeHeader(String header) {
                SinkConnector.writeHeader$(this, header);
            }

            public boolean allowsHeader() {
                return true;
            }

            public void write(String value) {
                System.out.print(value);
            }

            public void closeItem() {
                System.out.print(this.itemDelimiter$1);
            }

            public void close() {
            }
            {
                this.itemDelimiter$1 = itemDelimiter$1;
                SinkConnector.$init$(this);
            }
        };
    }

    public PrintSink copy(Format format) {
        return new PrintSink(format);
    }

    public Format copy$default$1() {
        return this.format();
    }

    public String productPrefix() {
        return "PrintSink";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.format();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PrintSink;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "format";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PrintSink)) return false;
        boolean bl = true;
        if (!bl) return false;
        PrintSink printSink = (PrintSink)x$1;
        Format format = this.format();
        Format format2 = printSink.format();
        if (format == null) {
            if (format2 != null) {
                return false;
            }
        } else if (!format.equals(format2)) return false;
        if (!printSink.canEqual(this)) return false;
        return true;
    }

    public PrintSink(Format format) {
        this.format = format;
        super(format);
        Product.$init$((Product)this);
    }
}

