/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.serialisers;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.internals.serialisers.KryoSerialiser$;
import com.raphtory.internals.serialisers.ScalaKryoMaker$;
import com.twitter.chill.KryoPool;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Support serialisation and deserialisation using ScalaKryoInstantiator from twitter.chill package\n  *\n  * Usage:\n  *\n  * {{{\n  * import com.raphtory.serialisers.PulsarKryoSerialiser\n  * import com.raphtory.config.PulsarController\n  * import org.apache.pulsar.client.api.Schema\n  *\n  * val schema: Schema[Array[Byte]] = Schema.BYTES\n  * val kryo = KryoSerialiser()\n  *\n  * val pulsarController = new PulsarController(config)\n  * val client         = pulsarController.accessClient\n  * val producer_topic = \"test_lotr_graph_input_topic\"\n  * val producer       = client.newProducer(Schema.BYTES).topic(producer_topic).create()\n  * producer.sendAsync(kryo.serialise(\"Gandalf,Benjamin,400\"))\n  * }}}\n  */")
@ScalaSignature(bytes="\u0006\u0005}3AAC\u0006\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003N\u0001\u0011\u0005ajB\u0003[\u0017!\u00051LB\u0003\u000b\u0017!\u0005A\fC\u0003\u001c\u000f\u0011\u0005Q\fC\u0003_\u000f\u0011\u0005AD\u0001\bLef|7+\u001a:jC2L7/\u001a:\u000b\u00051i\u0011aC:fe&\fG.[:feNT!AD\b\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001\t\u0012\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0017\u0005!1N]=p+\u0005\t\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015\u0019\u0007.\u001b7m\u0015\t1\u0013#A\u0004uo&$H/\u001a:\n\u0005!\u001a#\u0001C&ss>\u0004vn\u001c7\u0002\u000b-\u0014\u0018p\u001c\u0011\u0002\u0013M,'/[1mSN,WC\u0001\u00178)\ti3\u0007E\u0002\u0017]AJ!aL\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Y\t\u0014B\u0001\u001a\u0018\u0005\u0011\u0011\u0015\u0010^3\t\u000bQ\"\u0001\u0019A\u001b\u0002\u000bY\fG.^3\u0011\u0005Y:D\u0002\u0001\u0003\u0006q\u0011\u0011\r!\u000f\u0002\u0002)F\u0011!(\u0010\t\u0003-mJ!\u0001P\f\u0003\u000f9{G\u000f[5oOB\u0011aCP\u0005\u0003\u007f]\u00111!\u00118zQ\u0011!\u0011\tN&\u0011\u0005\tKU\"A\"\u000b\u0005\u0011+\u0015\u0001C:dC2\fGm\\2\u000b\u0005\u0019;\u0015a\u0002;bW\u0016Tx.\u001a\u0006\u0003\u0011F\taaZ5uQV\u0014\u0017B\u0001&D\u0005!\u00196-\u00197bI>\u001c\u0017%\u0001'\u0002\u001d>R#\u0006I:fe&\fG.[:fAY\fG.^3!i>\u0004#-\u001f;fA\u0005\u0014(/Y=\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011wC2,X\r\t<bYV,\u0007\u0005^8!g\u0016\u0014\u0018.\u00197jg\u0016T\u0001\u0005\t\u0011!U=\n1\u0002Z3tKJL\u0017\r\\5tKV\u0011q*\u0015\u000b\u0003!J\u0003\"AN)\u0005\u000ba*!\u0019A\u001d\t\u000bM+\u0001\u0019A\u0017\u0002\u000b\tLH/Z:)\t\u0015\tE'V\u0011\u0002-\u0006IvF\u000b\u0016!I\u0016\u001cXM]5bY&\u001cX\r\t2zi\u0016\u0004\u0013M\u001d:bs\u0002\"x\u000eI8cU\u0016\u001cGO\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007EY=uKN\u0004#-\u001f;fA\u0005\u0014(/Y=!i>\u0004C-Z\u0017tKJL\u0017\r\\5tK*\u0001\u0003\u0005\t\u0011+_!\"\u0001!\u0011\u001bYC\u0005I\u0016!b\u001f0U)\u00023+\u001e9q_J$\be]3sS\u0006d\u0017n]1uS>t\u0007%\u00198eA\u0011,7/\u001a:jC2L7/\u0019;j_:\u0004So]5oO\u0002\u001a6-\u00197b\u0017JLx.\u00138ti\u0006tG/[1u_J\u0004cM]8nAQ<\u0018\u000e\u001e;fe:\u001a\u0007.\u001b7mAA\f7m[1hK*\u0001\u0003E\u000b\u0006!A)\u0002Sk]1hKjR\u0001\u0005\t\u0016\u000bA\u0001R\u0003e_>|\u0015\u0001\u0002#\u0006I5na>\u0014H\u000fI2p[:\u0012\u0018\r\u001d5u_JLhf]3sS\u0006d\u0017n]3sg:\u0002V\u000f\\:be.\u0013\u0018p\\*fe&\fG.[:fe*\u0001\u0003E\u000b\u0011j[B|'\u000f\u001e\u0011d_6t#/\u00199ii>\u0014\u0018PL2p]\u001aLwM\f)vYN\f'oQ8oiJ|G\u000e\\3s\u0015\u0001\u0002#\u0006I5na>\u0014H\u000fI8sO:\n\u0007/Y2iK:\u0002X\u000f\\:be:\u001aG.[3oi:\n\u0007/\u001b\u0018TG\",W.\u0019\u0006!A)R\u0001\u0005\t\u0016!m\u0006d\u0007e]2iK6\f'\bI*dQ\u0016l\u0017mW!se\u0006L8LQ=uKvk\u0006%\u0010\u0011TG\",W.\u0019\u0018C3R+5K\u0003\u0011!U\u00012\u0018\r\u001c\u0011lef|\u0007%\u0010\u0011Lef|7+\u001a:jC2L7/\u001a:)S)\u0001\u0003E\u000b\u0006!A)\u0002c/\u00197!aVd7/\u0019:D_:$(o\u001c7mKJ\u0004S\b\t8fo\u0002\u0002V\u000f\\:be\u000e{g\u000e\u001e:pY2,'\u000fK2p]\u001aLw-\u000b\u0006!A)\u0002c/\u00197!G2LWM\u001c;!A\u0001\u0002\u0003\u0005\t\u0011!Au\u0002\u0003/\u001e7tCJ\u001cuN\u001c;s_2dWM\u001d\u0018bG\u000e,7o]\"mS\u0016tGO\u0003\u0011!U\u00012\u0018\r\u001c\u0011qe>$WoY3s?R|\u0007/[2!{\u0001\u0012C/Z:u?2|GO]0he\u0006\u0004\bnX5oaV$x\f^8qS\u000e\u0014#\u0002\t\u0011+AY\fG\u000e\t9s_\u0012,8-\u001a:!A\u0001\u0002\u0003\u0005\t\u0011>A\rd\u0017.\u001a8u]9,w\u000f\u0015:pIV\u001cWM\u001d\u0015TG\",W.\u0019\u0018C3R+5+\u000b\u0018u_BL7\r\u000b9s_\u0012,8-\u001a:`i>\u0004\u0018nY\u0015/GJ,\u0017\r^3)S)\u0001\u0003E\u000b\u0011qe>$WoY3s]M,g\u000eZ!ts:\u001c\u0007f\u001b:z_:\u001aXM]5bY&\u001cX\r\u000b\u0012HC:$\u0017\r\u001c4-\u0005\u0016t'.Y7j]2\"\u0004\u0007\r\u0012*S)\u0001\u0003E\u000b\u0011~{vT\u0001\u0005\t\u00160\u00039Y%/_8TKJL\u0017\r\\5tKJ\u0004\"AH\u0004\u0014\u0005\u001d)B#A.\u0002\u000b\u0005\u0004\b\u000f\\=")
public class KryoSerialiser {
    private final KryoPool kryo = ScalaKryoMaker$.MODULE$.defaultPool();

    public static KryoSerialiser apply() {
        return KryoSerialiser$.MODULE$.apply();
    }

    private KryoPool kryo() {
        return this.kryo;
    }

    @Scaladoc(value="/** serialise value to byte array\n    * @param value value to serialise\n    */")
    public <T> byte[] serialise(T value) {
        return this.kryo().toBytesWithClass(value);
    }

    @Scaladoc(value="/** deserialise byte array to object\n    * @param bytes byte array to de-serialise\n    */")
    public <T> T deserialise(byte[] bytes) {
        return (T)this.kryo().fromBytes(bytes);
    }
}

