/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.serialisers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.internals.components.querymanager.DynamicLoader;
import com.raphtory.internals.components.querymanager.DynamicLoader$;
import com.raphtory.internals.serialisers.DynamicClassLoader$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Using;
import scala.util.Using$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001\u0002\u0005\n\u0001IA\u0001b\t\u0001\u0003\u0002\u0003\u0006Ia\u0005\u0005\u0006I\u0001!\t!\n\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0011\u0019\u0019\u0004\u0001)A\u0005W!)A\u0007\u0001C\u0001k!)A\u000e\u0001C![\"1q\u0010\u0001C!\u0003\u0003\u0011q\u0003R=oC6L7\rT8bI\u0016\u00148+\u001a:jC2L'0\u001a:\u000b\u0005)Y\u0011aC:fe&\fG.[:feNT!\u0001D\u0007\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001\b\u0010\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0019\u0002c\u0001\u000b\u001a75\tQC\u0003\u0002\u0017/\u0005!1N]=p\u0015\tAr\"\u0001\tfg>$XM]5dg>4Go^1sK&\u0011!$\u0006\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u00031\tX/\u001a:z[\u0006t\u0017mZ3s\u0015\t\u00013\"\u0001\u0006d_6\u0004xN\\3oiNL!AI\u000f\u0003\u001b\u0011Kh.Y7jG2{\u0017\rZ3s\u0003\u001d!WMZ1vYR\fa\u0001P5oSRtDC\u0001\u0014)!\t9\u0003!D\u0001\n\u0011\u0015\u0019#\u00011\u0001\u0014\u0003\u0019awnZ4feV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005a1oY1mC2|wmZ5oO*\u0011\u0001gD\u0001\tif\u0004Xm]1gK&\u0011!'\f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005q1\r\\1tgJ\u0012\u0015\u0010^3d_\u0012,WC\u0001\u001cV)\t9d\n\u0005\u00039wu\u001aU\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\rQ+\b\u000f\\33!\rAd\bQ\u0005\u0003\u007fe\u0012Q!\u0011:sCf\u0004\"\u0001O!\n\u0005\tK$\u0001\u0002\"zi\u0016\u0004\"\u0001R&\u000f\u0005\u0015K\u0005C\u0001$:\u001b\u00059%B\u0001%\u0012\u0003\u0019a$o\\8u}%\u0011!*O\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002Ks!)q*\u0002a\u0001!\u0006\t1\rE\u0002E#NK!AU'\u0003\u000b\rc\u0017m]:\u0011\u0005Q+F\u0002\u0001\u0003\u0006-\u0016\u0011\ra\u0016\u0002\u0002)F\u0011\u0001l\u0017\t\u0003qeK!AW\u001d\u0003\u000f9{G\u000f[5oOB\u0011\u0001\bX\u0005\u0003;f\u00121!\u00118zQ\u0011)q,\u001b6\u0011\u0005\u0001<W\"A1\u000b\u0005\t\u001c\u0017\u0001C:dC2\fGm\\2\u000b\u0005\u0011,\u0017a\u0002;bW\u0016Tx.\u001a\u0006\u0003M>\taaZ5uQV\u0014\u0017B\u00015b\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A6\u0002\u0003sz#F\u000b\u0006!A\u0001\u0002#\u0006\t+iK\u0002\u001aG.Y:tA\r\fg\u000e\t2fA1|\u0017\rZ3eA\u0015LG\u000f[3sA\u0019\u0014x.\u001c\u0011uQ\u0016\u00043\r\\1tgB\fG\u000f\u001b\u0011wS\u0006\u00043l\u0017*fa>\u001c\u0018\u000e^8ssvk&\u0002\t\u0011!A)\u0002sN\u001d\u0011ge>l\u0007\u0005\u001e5fA\rd\u0017m]:!gR|'/Y4fA%4\u0007\u0005\u001e5fA\rd\u0017m]:!SN\u0004cn\u001c;!Y>\u001c\u0017\r\u001c\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI2\u000bA\u0001\u0002\u0003E\u000b\u0011AiB\f'/Y7!)*\u0001\u0003\u0005\t\u0011+A\u0001\u0013X\r^;s]*\u0001\u0003\u0005\t\u0011+_\u0005)qO]5uKR!a.];~!\tAt.\u0003\u0002qs\t!QK\\5u\u0011\u00151b\u00011\u0001s!\t!2/\u0003\u0002u+\t!1J]=p\u0011\u00151h\u00011\u0001x\u0003\u0019yW\u000f\u001e9viB\u0011\u0001p_\u0007\u0002s*\u0011!0F\u0001\u0003S>L!\u0001`=\u0003\r=+H\u000f];u\u0011\u0015qh\u00011\u0001\u001c\u0003\u0005\t\u0018\u0001\u0002:fC\u0012$raGA\u0002\u0003\u000b\ty\u0001C\u0003\u0017\u000f\u0001\u0007!\u000fC\u0004\u0002\b\u001d\u0001\r!!\u0003\u0002\u000b%t\u0007/\u001e;\u0011\u0007a\fY!C\u0002\u0002\u000ee\u0014Q!\u00138qkRDq!!\u0005\b\u0001\u0004\t\u0019\"A\u0002ua\u0016\u00042\u0001R)\u001c\u0001")
public class DynamicLoaderSerializer
extends Serializer<DynamicLoader> {
    private final Serializer<DynamicLoader> default;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    @Scaladoc(value="/**\n    * The class can be loaded either from the classpath via [[Repository]]\n    * or from the class storage if the class is not local\n    * @param c\n    * @tparam T\n    * @return\n    */")
    public <T> Tuple2<byte[], String> class2Bytecode(Class<T> c) {
        Tuple2 tuple2;
        try {
            JavaClass jc = Repository.lookupClass(c);
            tuple2 = (Tuple2)Using$.MODULE$.apply((Function0 & Serializable)() -> new ByteArrayOutputStream(), (Function1 & Serializable)bos -> {
                jc.dump((OutputStream)bos);
                bos.flush();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bos.toByteArray()), (Object)jc.getClassName());
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).get();
        }
        catch (Throwable t) {
            String name = c.getName();
            Option<byte[]> option = DynamicClassLoader$.MODULE$.lookupClass(c.getName());
            if (!(option instanceof Some)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Can't find {} in {}", new Object[]{name, DynamicClassLoader$.MODULE$.classStorage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalStateException(new StringBuilder(30).append("Failed to get bytes for class ").append(name).toString(), t);
            }
            Some some = (Some)option;
            byte[] bytes = (byte[])some.value();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bytes), (Object)name);
            tuple2 = tuple22;
        }
        return tuple2;
    }

    public void write(Kryo kryo, Output output, DynamicLoader q) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Writing down {} classes for dynamic loading {}", new Object[]{BoxesRunTime.boxToInteger((int)q.classes().size()), q.classes()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (!q.resolved()) {
            throw new IllegalArgumentException("DynamicLoader object needs to be resolved before serialising");
        }
        output.writeInt(q.classes().size());
        q.classes().foreach((Function1 & Serializable)c -> {
            DynamicLoaderSerializer.$anonfun$write$1(this, output, c);
            return BoxedUnit.UNIT;
        });
        kryo.writeObject(output, (Object)new DynamicLoader(DynamicLoader$.MODULE$.apply$default$1(), DynamicLoader$.MODULE$.apply$default$2()), this.default);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Done Writing the DynamicLoader object");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public DynamicLoader read(Kryo kryo, Input input, Class<DynamicLoader> tpe) {
        DynamicLoader dynamicLoader;
        try {
            BoxedUnit boxedUnit;
            int n = input.readInt();
            List classes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable)x$2 -> DynamicLoaderSerializer.$anonfun$read$1(input, BoxesRunTime.unboxToInt((Object)x$2))).toList();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Loaded {} classes: {}", new Object[]{BoxesRunTime.boxToInteger((int)n), classes});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLoader = ((DynamicLoader)kryo.readObject(input, tpe, this.default)).copy(classes, true);
        }
        catch (Throwable t) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to read Dynamic Loader", t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw t;
        }
        return dynamicLoader;
    }

    public static final /* synthetic */ void $anonfun$write$1(DynamicLoaderSerializer $this, Output output$1, Class c) {
        Tuple2<byte[], String> tuple2 = $this.class2Bytecode(c);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] bytes = (byte[])tuple2._1();
        String name = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)bytes, (Object)name);
        Tuple2 tuple23 = tuple22;
        byte[] bytes2 = (byte[])tuple23._1();
        String name2 = (String)tuple23._2();
        output$1.writeString(name2);
        output$1.writeInt(bytes2.length);
        output$1.writeBytes(bytes2);
    }

    public static final /* synthetic */ Class $anonfun$read$1(Input input$1, int x$2) {
        String name = input$1.readString();
        int length = input$1.readInt();
        byte[] bytes = input$1.readBytes(length);
        return DynamicClassLoader$.MODULE$.injectClass(name, bytes);
    }

    public DynamicLoaderSerializer(Serializer<DynamicLoader> serializer) {
        this.default = serializer;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((Class)this.getClass()));
    }
}

