/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.formats;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.api.output.sink.SinkExecutor;
import com.raphtory.api.time.Interval;
import com.raphtory.api.time.Perspective;
import com.raphtory.formats.CsvFormat$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A `Format` that writes a `Table` in comma-separated value (CSV) format\n  *\n  * This format outputs one CSV line per row.\n  * The first two values are the timestamp used to create the perspective corresponding to that row\n  * and the size of the window applied over the perspective.\n  * If no window was applied over the perspective, the window size is omitted.\n  * The following values are the values composing the row.\n  *\n  * For a table with just one perspective created from timestamp 10 with a window size 5 and 3 rows\n  * the output might look as follows:\n  *\n  * {{{\n  * 10,5,id1,12\n  * 10,5,id2,13\n  * 10,5,id3,24\n  * }}}\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u0011\"\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t%\u0002\u0011\t\u0012)A\u0005\u0015\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015y\u0006\u0001\"\u0011J\u0011\u0015\u0001\u0007\u0001\"\u0011J\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u001dq\b!!A\u0005\u0002}D\u0011\"!\u0002\u0001#\u0003%\t!a\u0002\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t)\u0004AA\u0001\n\u0003\t9\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0001\u0002<!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0013\u0011\n\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u0018\u0001\u0003\u0003%\t%a\u0018\t\u0013\u0005\r\u0004!!A\u0005B\u0005\u0015\u0004\"CA4\u0001\u0005\u0005I\u0011IA5\u0011%\tY\u0007AA\u0001\n\u0003\nigB\u0005\u0002\u000e\u0006\n\t\u0011#\u0001\u0002\u0010\u001aA\u0001%IA\u0001\u0012\u0003\t\t\n\u0003\u0004Z-\u0011\u0005\u0011\u0011\u0016\u0005\n\u0003O2\u0012\u0011!C#\u0003SB\u0011\"a+\u0017\u0003\u0003%\t)!,\t\u0013\u0005Mf#%A\u0005\u0002\u0005\u001d\u0001\"CA[-E\u0005I\u0011AA\u0010\u0011%\t9LFA\u0001\n\u0003\u000bI\fC\u0005\u0002LZ\t\n\u0011\"\u0001\u0002\b!I\u0011Q\u001a\f\u0012\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003\u001f4\u0012\u0011!C\u0005\u0003#\u0014\u0011bQ:w\r>\u0014X.\u0019;\u000b\u0005\t\u001a\u0013a\u00024pe6\fGo\u001d\u0006\u0003I\u0015\n\u0001B]1qQR|'/\u001f\u0006\u0002M\u0005\u00191m\\7\u0004\u0001M)\u0001!K\u0018:yA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\r\u0019|'/\\1u\u0015\t!T'\u0001\u0004pkR\u0004X\u000f\u001e\u0006\u0003m\r\n1!\u00199j\u0013\tA\u0014G\u0001\u0004G_Jl\u0017\r\u001e\t\u0003UiJ!aO\u0016\u0003\u000fA\u0013x\u000eZ;diB\u0011Q(\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!Q\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013B\u0001#,\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0011[\u0013!\u00033fY&l\u0017\u000e^3s+\u0005Q\u0005CA&P\u001d\taU\n\u0005\u0002@W%\u0011ajK\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002OW\u0005QA-\u001a7j[&$XM\u001d\u0011\u0002\u001b%t7\r\\;eK\"+\u0017\rZ3s+\u0005)\u0006C\u0001\u0016W\u0013\t96FA\u0004C_>dW-\u00198\u0002\u001d%t7\r\\;eK\"+\u0017\rZ3sA\u00051A(\u001b8jiz\"2aW/_!\ta\u0006!D\u0001\"\u0011\u001dAU\u0001%AA\u0002)CqaU\u0003\u0011\u0002\u0003\u0007Q+\u0001\teK\u001a\fW\u000f\u001c;EK2LW.\u001b;fe\u0006\u0001B-\u001a4bk2$X\t\u001f;f]NLwN\\\u0001\tKb,7-\u001e;peR)1-\u001b8qkB\u0011AmZ\u0007\u0002K*\u0011amM\u0001\u0005g&t7.\u0003\u0002iK\na1+\u001b8l\u000bb,7-\u001e;pe\")!\u000e\u0003a\u0001W\u0006I1m\u001c8oK\u000e$xN\u001d\t\u0003I2L!!\\3\u0003\u001bMKgn[\"p]:,7\r^8s\u0011\u0015y\u0007\u00021\u0001K\u0003\u0015QwNY%E\u0011\u0015\t\b\u00021\u0001s\u0003-\u0001\u0018M\u001d;ji&|g.\u0013#\u0011\u0005)\u001a\u0018B\u0001;,\u0005\rIe\u000e\u001e\u0005\u0006m\"\u0001\ra^\u0001\u0007G>tg-[4\u0011\u0005adX\"A=\u000b\u0005YT(BA>&\u0003!!\u0018\u0010]3tC\u001a,\u0017BA?z\u0005\u0019\u0019uN\u001c4jO\u0006!1m\u001c9z)\u0015Y\u0016\u0011AA\u0002\u0011\u001dA\u0015\u0002%AA\u0002)CqaU\u0005\u0011\u0002\u0003\u0007Q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%!f\u0001&\u0002\f-\u0012\u0011Q\u0002\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0018-\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY\"!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005\"fA+\u0002\f\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005!A.\u00198h\u0015\t\t\t$\u0001\u0003kCZ\f\u0017b\u0001)\u0002,\u0005a\u0001O]8ek\u000e$\u0018I]5usV\t!/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00121\t\t\u0004U\u0005}\u0012bAA!W\t\u0019\u0011I\\=\t\u0011\u0005\u0015c\"!AA\u0002I\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA&!\u0019\ti%a\u0015\u0002>5\u0011\u0011q\n\u0006\u0004\u0003#Z\u0013AC2pY2,7\r^5p]&!\u0011QKA(\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007U\u000bY\u0006C\u0005\u0002FA\t\t\u00111\u0001\u0002>\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9#!\u0019\t\u0011\u0005\u0015\u0013#!AA\u0002I\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002e\u0006AAo\\*ue&tw\r\u0006\u0002\u0002(\u00051Q-];bYN$2!VA8\u0011%\t)\u0005FA\u0001\u0002\u0004\ti\u0004K\u0004\u0001\u0003g\n9)!#\u0011\t\u0005U\u00141Q\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005A1oY1mC\u0012|7M\u0003\u0003\u0002~\u0005}\u0014a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003\u0003+\u0013AB4ji\",(-\u0003\u0003\u0002\u0006\u0006]$\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005-\u0015\u0001\"@0U)\u0002\u0013\t\t1G_Jl\u0017\r\u001e1!i\"\fG\u000fI<sSR,7\u000fI1!AR\u000b'\r\\3aA%t\u0007eY8n[\u0006l3/\u001a9be\u0006$X\r\u001a\u0011wC2,X\r\t\u0015D'ZK\u0003EZ8s[\u0006$(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t+iSN\u0004cm\u001c:nCR\u0004s.\u001e;qkR\u001c\be\u001c8fA\r\u001bf\u000b\t7j]\u0016\u0004\u0003/\u001a:!e><hF\u0003\u0011!U\u0001\"\u0006.\u001a\u0011gSJ\u001cH\u000f\t;x_\u00022\u0018\r\\;fg\u0002\n'/\u001a\u0011uQ\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011vg\u0016$\u0007\u0005^8!GJ,\u0017\r^3!i\",\u0007\u0005]3sgB,7\r^5wK\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002\"x\u000e\t;iCR\u0004#o\\<\u000bA\u0001R\u0003%\u00198eAQDW\rI:ju\u0016\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^\u0004\u0013\r\u001d9mS\u0016$\u0007e\u001c<fe\u0002\"\b.\u001a\u0011qKJ\u001c\b/Z2uSZ,gF\u0003\u0011!U\u0001Je\r\t8pA]Lg\u000eZ8xA]\f7\u000fI1qa2LW\r\u001a\u0011pm\u0016\u0014\b\u0005\u001e5fAA,'o\u001d9fGRLg/\u001a\u0017!i\",\u0007e^5oI><\be]5{K\u0002J7\u000fI8nSR$X\r\u001a\u0018\u000bA\u0001R\u0003\u0005\u00165fA\u0019|G\u000e\\8xS:<\u0007E^1mk\u0016\u001c\b%\u0019:fAQDW\r\t<bYV,7\u000fI2p[B|7/\u001b8hAQDW\r\t:po:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003ER8sA\u0005\u0004C/\u00192mK\u0002:\u0018\u000e\u001e5!UV\u001cH\u000fI8oK\u0002\u0002XM]:qK\u000e$\u0018N^3!GJ,\u0017\r^3eA\u0019\u0014x.\u001c\u0011uS6,7\u000f^1na\u0002\n\u0004\u0007I<ji\"\u0004\u0013\rI<j]\u0012|w\u000fI:ju\u0016\u0004S\u0007I1oI\u0002\u001a\u0004E]8xg*\u0001\u0003E\u000b\u0011uQ\u0016\u0004s.\u001e;qkR\u0004S.[4ii\u0002bwn\\6!CN\u0004cm\u001c7m_^\u001c(H\u0003\u0011!U)\u0001\u0003E\u000b\u0011|wnT\u0001\u0005\t\u0016!cAbS\u0007L5ec1\n$G\u0003\u0011!U\u0001\n\u0004\u0007L\u001b-S\u0012\u0014D&M\u001a\u000bA\u0001R\u0003%\r\u0019-k1JGm\r\u00173i)\u0001\u0003E\u000b\u0011~{vT\u0001\u0005\t\u00160\u0003%\u00195O\u001e$pe6\fG\u000f\u0005\u0002]-M)a#a%\u0002 B9\u0011QSAN\u0015V[VBAAL\u0015\r\tIjK\u0001\beVtG/[7f\u0013\u0011\ti*a&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\u0011\t)+a\f\u0002\u0005%|\u0017b\u0001$\u0002$R\u0011\u0011qR\u0001\u0006CB\u0004H.\u001f\u000b\u00067\u0006=\u0016\u0011\u0017\u0005\b\u0011f\u0001\n\u00111\u0001K\u0011\u001d\u0019\u0016\u0004%AA\u0002U\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BA^\u0003\u000f\u0004RAKA_\u0003\u0003L1!a0,\u0005\u0019y\u0005\u000f^5p]B)!&a1K+&\u0019\u0011QY\u0016\u0003\rQ+\b\u000f\\33\u0011!\tI\rHA\u0001\u0002\u0004Y\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAj!\u0011\tI#!6\n\t\u0005]\u00171\u0006\u0002\u0007\u001f\nTWm\u0019;")
public class CsvFormat
implements Format,
Product,
Serializable {
    private final String delimiter;
    private final boolean includeHeader;

    public static boolean $lessinit$greater$default$2() {
        return CsvFormat$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CsvFormat$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple2<String, Object>> unapply(CsvFormat x$0) {
        return CsvFormat$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return CsvFormat$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return CsvFormat$.MODULE$.apply$default$1();
    }

    public static CsvFormat apply(String delimiter, boolean includeHeader) {
        return CsvFormat$.MODULE$.apply(delimiter, includeHeader);
    }

    public static Function1<Tuple2<String, Object>, CsvFormat> tupled() {
        return CsvFormat$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Object, CsvFormat>> curried() {
        return CsvFormat$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String delimiter() {
        return this.delimiter;
    }

    public boolean includeHeader() {
        return this.includeHeader;
    }

    @Override
    public String defaultDelimiter() {
        return "\n";
    }

    @Override
    public String defaultExtension() {
        return "csv";
    }

    @Override
    public SinkExecutor executor(SinkConnector connector, String jobID, int partitionID, Config config) {
        return new SinkExecutor(this, connector){
            private boolean firstPerspective;
            private Perspective currentPerspective;
            private List<String> currentHeader;
            private String currentLinePrefix;
            private final JsonMapper mapper;
            @Scaladoc(value="/** Logger instance for writing debug messages */")
            private Logger logger;
            private volatile boolean bitmap$0;
            private final /* synthetic */ CsvFormat $outer;
            private final SinkConnector connector$1;

            @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
            public void threadSafeWriteRow(Row row) {
                SinkExecutor.threadSafeWriteRow$(this, row);
            }

            private Logger logger$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.logger = SinkExecutor.logger$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
            }

            private boolean firstPerspective() {
                return this.firstPerspective;
            }

            private void firstPerspective_$eq(boolean x$1) {
                this.firstPerspective = x$1;
            }

            private Perspective currentPerspective() {
                return this.currentPerspective;
            }

            private void currentPerspective_$eq(Perspective x$1) {
                this.currentPerspective = x$1;
            }

            private List<String> currentHeader() {
                return this.currentHeader;
            }

            private void currentHeader_$eq(List<String> x$1) {
                this.currentHeader = x$1;
            }

            private String currentLinePrefix() {
                return this.currentLinePrefix;
            }

            private void currentLinePrefix_$eq(String x$1) {
                this.currentLinePrefix = x$1;
            }

            private JsonMapper mapper() {
                return this.mapper;
            }

            private String ensureQuoted(String str) {
                return str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'") || !str.contains(this.$outer.delimiter()) ? str : new StringBuilder(2).append("\"").append(str).append("\"").toString();
            }

            private String csvValue(Object value) {
                String string;
                Object object = value;
                if (object instanceof String) {
                    String string2 = (String)object;
                    string = this.ensureQuoted(string2);
                } else {
                    string = this.ensureQuoted(this.mapper().writeValueAsString(object));
                }
                return string;
            }

            public void setupPerspective(Perspective perspective, List<String> header) {
                this.currentPerspective_$eq(perspective);
                Option<Interval> option = perspective.window();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Interval w = (Interval)some.value();
                    this.currentLinePrefix_$eq(new StringBuilder(0).append(perspective.timestampAsString()).append(this.$outer.delimiter()).append(w).append(this.$outer.delimiter()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.currentLinePrefix_$eq(new StringBuilder(0).append(perspective.timestampAsString()).append(this.$outer.delimiter()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                if (this.firstPerspective()) {
                    this.currentHeader_$eq(header);
                    if (this.$outer.includeHeader()) {
                        String csvColumns = header.mkString(this.$outer.delimiter());
                        Option<Interval> option2 = perspective.window();
                        if (option2 instanceof Some) {
                            this.connector$1.writeHeader(new StringBuilder(17).append("timestamp,window,").append(csvColumns).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option2)) {
                            this.connector$1.writeHeader(new StringBuilder(10).append("timestamp,").append(csvColumns).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option2);
                        }
                    }
                    this.firstPerspective_$eq(false);
                } else {
                    List<String> list = header;
                    List<String> list2 = this.currentHeader();
                    if (list == null ? list2 != null : !list.equals(list2)) {
                        String msg = new StringBuilder(140).append("The number of columns needs to be consistent between perspectives when using the CsvFormat. ").append(new StringBuilder(31).append("Was previously '").append(this.currentHeader()).append("' and now is '").append(header).append("'").toString()).append("You can explicitly set them using graph.select()").toString();
                        throw new IllegalStateException(msg);
                    }
                }
            }

            public void writeRow(Row row) {
                this.connector$1.write(this.currentLinePrefix());
                this.connector$1.write(((IterableOnceOps)row.columns().values().map((Function1 & Serializable)value -> this.csvValue(value))).mkString(this.$outer.delimiter()));
                this.connector$1.closeItem();
            }

            public void closePerspective() {
            }

            public void close() {
                this.connector$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connector$1 = connector$1;
                SinkExecutor.$init$(this);
                this.firstPerspective = true;
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$writeRow$1(com.raphtory.formats.CsvFormat$$anon$1 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public CsvFormat copy(String delimiter, boolean includeHeader) {
        return new CsvFormat(delimiter, includeHeader);
    }

    public String copy$default$1() {
        return this.delimiter();
    }

    public boolean copy$default$2() {
        return this.includeHeader();
    }

    public String productPrefix() {
        return "CsvFormat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.delimiter();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.includeHeader());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvFormat;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "delimiter";
                break;
            }
            case 1: {
                string = "includeHeader";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.delimiter()));
        n = Statics.mix((int)n, (int)(this.includeHeader() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvFormat)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvFormat csvFormat = (CsvFormat)x$1;
        if (this.includeHeader() != csvFormat.includeHeader()) return false;
        String string = this.delimiter();
        String string2 = csvFormat.delimiter();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!csvFormat.canEqual(this)) return false;
        return true;
    }

    public CsvFormat(String delimiter, boolean includeHeader) {
        this.delimiter = delimiter;
        this.includeHeader = includeHeader;
        Product.$init$((Product)this);
    }
}

