/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.progresstracker;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.TableOutput;
import com.raphtory.api.analysis.table.TableOutput$;
import com.raphtory.api.progresstracker.QueryProgressTracker;
import com.raphtory.api.progresstracker.QueryProgressTrackerWithIterator$;
import com.raphtory.api.progresstracker.QueryProgressTrackerWithIterator$TableOutputIterator$;
import com.raphtory.internals.graph.Perspective;
import com.raphtory.protocol.PerspectiveCompleted;
import com.raphtory.protocol.PerspectiveFailed;
import com.raphtory.protocol.QueryCompleted;
import com.raphtory.protocol.QueryFailed;
import com.raphtory.protocol.QueryUpdate;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * Iterator over perspective results with additional query tracking functionality.\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001B\u0014)\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005o!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!9\u0006A!A!\u0002\u0013A\u0006\"B1\u0001\t\u0003\u0011\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B6\t\u000fI\u0004\u0001\u0019!C\u0005g\"9\u0001\u0010\u0001a\u0001\n\u0013I\bBB@\u0001A\u0003&A\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!I\u00111\u0002\u0001A\u0002\u0013%\u0011Q\u0002\u0005\t\u0003#\u0001\u0001\u0015)\u0003\u0002\u0006!I\u00111\u0003\u0001A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_A\u0001\"a\r\u0001A\u0003&\u0011q\u0003\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003oA\u0001\"!\u0015\u0001A\u0003%\u0011\u0011\b\u0005\b\u0003'\u0002A\u0011IA+\u0011\u0019\t9\u0007\u0001C!g\"9\u0011\u0011\u000e\u0001\u0005\n\u0005-taBA7\u0001!\u0005\u0011q\u000e\u0004\b\u0003g\u0002\u0001\u0012AA;\u0011\u0019\t\u0007\u0004\"\u0001\u0002\u0004\"1\u0011Q\u0011\r\u0005BMDq!a\"\u0019\t\u0003\nIiB\u0004\u0002\fbAI!!$\u0007\u000f\u0005E\u0005\u0004#\u0003\u0002\u0014\"1\u0011-\bC\u0001\u0003+3a!a&\u001e\u0001\u0005e\u0005\u0002\u0003# \u0005\u0003\u0005\u000b\u0011B\u001c\t\u0013\u0005\u0005vD!A!\u0002\u00139\u0004BB1 \t\u0003\t\u0019kB\u0004\u0002J\"B\t!a3\u0007\r\u001dB\u0003\u0012AAg\u0011\u0019\tG\u0005\"\u0001\u0002P\"9\u0011\u0011\u001b\u0013\u0005\u0002\u0005M'\u0001I)vKJL\bK]8he\u0016\u001c8\u000f\u0016:bG.,'oV5uQ&#XM]1u_JT!!\u000b\u0016\u0002\u001fA\u0014xn\u001a:fgN$(/Y2lKJT!a\u000b\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002.]\u0005A!/\u00199ii>\u0014\u0018PC\u00010\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0007\u0005\u00024i5\t\u0001&\u0003\u00026Q\t!\u0012+^3ssB\u0013xn\u001a:fgN$&/Y2lKJ\fqa\u001a:ba\"LE\t\u0005\u00029\u0003:\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003yA\na\u0001\u0010:p_Rt$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f\u0002\u000b)|'-\u0013#\u0002\t\r|gN\u001a\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000baaY8oM&<'BA&/\u0003!!\u0018\u0010]3tC\u001a,\u0017BA'I\u0005\u0019\u0019uN\u001c4jO\u00069A/[7f_V$\bC\u0001)V\u001b\u0005\t&B\u0001*T\u0003!!WO]1uS>t'B\u0001+>\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003-F\u0013\u0001\u0002R;sCRLwN\\\u0001\u0007Q\u0016\fG-\u001a:\u0011\u0007esvG\u0004\u0002[9:\u0011!hW\u0005\u0002}%\u0011Q,P\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006M\u0001\u0003MSN$(BA/>\u0003\u0019a\u0014N\\5u}Q11\rZ3gO\"\u0004\"a\r\u0001\t\u000bY2\u0001\u0019A\u001c\t\u000b\u00113\u0001\u0019A\u001c\t\u000b\u00153\u0001\u0019\u0001$\t\u000b93\u0001\u0019A(\t\u000b]3\u0001\u0019\u0001-\u0002\r1|wmZ3s+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018K\u00031\u00198-\u00197bY><w-\u001b8h\u0013\t\u0001XN\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003)yW\u000f\u001e9vi\u0012{g.Z\u000b\u0002iB\u0011QO^\u0007\u0002{%\u0011q/\u0010\u0002\b\u0005>|G.Z1o\u00039yW\u000f\u001e9vi\u0012{g.Z0%KF$\"A_?\u0011\u0005U\\\u0018B\u0001?>\u0005\u0011)f.\u001b;\t\u000fyT\u0011\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u0017=,H\u000f];u\t>tW\rI\u0001\tU>\u00147\u000fR8oKV\u0011\u0011Q\u0001\t\u0004k\u0006\u001d\u0011bAA\u0005{\t\u0019\u0011J\u001c;\u0002\u0019)|'m\u001d#p]\u0016|F%Z9\u0015\u0007i\fy\u0001\u0003\u0005\u007f\u001b\u0005\u0005\t\u0019AA\u0003\u0003%QwNY:E_:,\u0007%\u0001\u0006oKb$(+Z:vYR,\"!a\u0006\u0011\u000bU\fI\"!\b\n\u0007\u0005mQH\u0001\u0004PaRLwN\u001c\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0015!\u0018M\u00197f\u0015\r\t9CK\u0001\tC:\fG._:jg&!\u00111FA\u0011\u0005-!\u0016M\u00197f\u001fV$\b/\u001e;\u0002\u001d9,\u0007\u0010\u001e*fgVdGo\u0018\u0013fcR\u0019!0!\r\t\u0011y\u0004\u0012\u0011!a\u0001\u0003/\t1B\\3yiJ+7/\u001e7uA\u0005\u00012m\\7qY\u0016$X\r\u001a*fgVdGo]\u000b\u0003\u0003s\u0001b!a\u000f\u0002H\u0005-SBAA\u001f\u0015\r!\u0016q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003vi&d'BAA#\u0003\u0011Q\u0017M^1\n\t\u0005%\u0013Q\b\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h#V,W/\u001a\t\u0004k\u00065\u0013bAA({\t\u0019\u0011I\\=\u0002#\r|W\u000e\u001d7fi\u0016$'+Z:vYR\u001c\b%A\tiC:$G.Z)vKJLX\u000b\u001d3bi\u0016$2A_A,\u0011\u001d\tI\u0006\u0006a\u0001\u00037\n1!\\:h!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1Y\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002f\u0005}#aC)vKJLX\u000b\u001d3bi\u0016\f\u0011\"[:K_\n$uN\\3\u0002#]\f\u0017\u000e\u001e$pe:+\u0007\u0010\u001e*fgVdG\u000f\u0006\u0002\u0002L\u0005\u0019B+\u00192mK>+H\u000f];u\u0013R,'/\u0019;peB\u0019\u0011\u0011\u000f\r\u000e\u0003\u0001\u00111\u0003V1cY\u0016|U\u000f\u001e9vi&#XM]1u_J\u001cR\u0001GA<\u0003{\u00022!^A=\u0013\r\tY(\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u000be\u000by(!\b\n\u0007\u0005\u0005\u0005M\u0001\u0005Ji\u0016\u0014\u0018\r^8s)\t\ty'A\u0004iCNtU\r\u001f;\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0003;\tA\u0004V1cY\u0016|U\u000f\u001e9vi&#XM]1u_J,\u0005pY3qi&|g\u000eE\u0002\u0002\u0010vi\u0011\u0001\u0007\u0002\u001d)\u0006\u0014G.Z(viB,H/\u0013;fe\u0006$xN]#yG\u0016\u0004H/[8o'\ri\u0012q\u000f\u000b\u0003\u0003\u001b\u0013!CS8c\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]N\u0019q$a'\u0011\u0007e\u000bi*C\u0002\u0002 \u0002\u0014\u0001CU;oi&lW-\u0012=dKB$\u0018n\u001c8\u0002\rI,\u0017m]8o)\u0019\t)+!+\u0002,B\u0019\u0011qU\u0010\u000e\u0003uAQ\u0001\u0012\u0012A\u0002]Ba!!)#\u0001\u00049\u0004f\u0002\u0001\u00020\u0006\r\u0017Q\u0019\t\u0005\u0003c\u000by,\u0004\u0002\u00024*!\u0011QWA\\\u0003!\u00198-\u00197bI>\u001c'\u0002BA]\u0003w\u000bq\u0001^1lKj|WMC\u0002\u0002>:\naaZ5uQV\u0014\u0017\u0002BAa\u0003g\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000f\fAl\f\u0016+\u0015\u0001\u0002#\u0006I%uKJ\fGo\u001c:!_Z,'\u000f\t9feN\u0004Xm\u0019;jm\u0016\u0004#/Z:vYR\u001c\be^5uQ\u0002\nG\rZ5uS>t\u0017\r\u001c\u0011rk\u0016\u0014\u0018\u0010\t;sC\u000e\\\u0017N\\4!MVt7\r^5p]\u0006d\u0017\u000e^=/\u0015\u0001\u0002#fL\u0001!#V,'/\u001f)s_\u001e\u0014Xm]:Ue\u0006\u001c7.\u001a:XSRD\u0017\n^3sCR|'\u000f\u0005\u00024IM\u0019A%a\u001e\u0015\u0005\u0005-\u0017!B1qa2LHcC2\u0002V\u0006]\u0017\u0011\\An\u0003;DQA\u000e\u0014A\u0002]BQ\u0001\u0012\u0014A\u0002]BQ!\u0012\u0014A\u0002\u0019CQA\u0014\u0014A\u0002=CQa\u0016\u0014A\u0002a\u0003")
public class QueryProgressTrackerWithIterator
extends QueryProgressTracker {
    private volatile QueryProgressTrackerWithIterator$TableOutputIterator$ TableOutputIterator$module;
    public final String com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$jobID;
    private final Config conf;
    private final Duration timeout;
    private final List<String> header;
    private final Logger com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger;
    private boolean com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone;
    private int jobsDone;
    private Option<TableOutput> com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult;
    private final LinkedBlockingQueue<Object> completedResults;

    public static QueryProgressTrackerWithIterator apply(String graphID, String jobID, Config conf, Duration timeout, List<String> header) {
        return QueryProgressTrackerWithIterator$.MODULE$.apply(graphID, jobID, conf, timeout, header);
    }

    public QueryProgressTrackerWithIterator$TableOutputIterator$ TableOutputIterator() {
        if (this.TableOutputIterator$module == null) {
            this.TableOutputIterator$lzycompute$1();
        }
        return this.TableOutputIterator$module;
    }

    public Logger com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger;
    }

    public boolean com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone;
    }

    public void com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone_$eq(boolean x$1) {
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone = x$1;
    }

    private int jobsDone() {
        return this.jobsDone;
    }

    private void jobsDone_$eq(int x$1) {
        this.jobsDone = x$1;
    }

    public Option<TableOutput> com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult;
    }

    public void com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult_$eq(Option<TableOutput> x$1) {
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult = x$1;
    }

    private LinkedBlockingQueue<Object> completedResults() {
        return this.completedResults;
    }

    @Override
    public void handleQueryUpdate(QueryUpdate msg) {
        Boolean bl;
        QueryUpdate queryUpdate = msg;
        if (queryUpdate instanceof PerspectiveCompleted) {
            BoxedUnit boxedUnit;
            PerspectiveCompleted perspectiveCompleted = (PerspectiveCompleted)queryUpdate;
            Perspective perspective = perspectiveCompleted.perspective();
            Seq<Row> rows = perspectiveCompleted.rows();
            if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isDebugEnabled()) {
                this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().debug("received message {}", (Object)msg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = BoxesRunTime.boxToBoolean((boolean)this.completedResults().add(TableOutput$.MODULE$.apply(this.getJobId(), perspective, this.header, (Row[])rows.toArray(ClassTag$.MODULE$.apply(Row.class)), this.conf)));
        } else {
            boolean bl2 = queryUpdate instanceof QueryCompleted ? true : queryUpdate instanceof QueryFailed;
            if (bl2) {
                bl = BoxesRunTime.boxToBoolean((boolean)this.completedResults().add(msg));
            } else if (queryUpdate instanceof PerspectiveFailed) {
                BoxedUnit boxedUnit;
                PerspectiveFailed perspectiveFailed = (PerspectiveFailed)queryUpdate;
                Perspective perspective = perspectiveFailed.perspective();
                String reason = perspectiveFailed.reason();
                if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isErrorEnabled()) {
                    this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().error("perspective {} failed: {}", new Object[]{perspective, reason});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = BoxesRunTime.boxToBoolean((boolean)this.completedResults().add(TableOutput$.MODULE$.apply(this.getJobId(), perspective, this.header, (Row[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Row.class)), this.conf)));
            } else {
                BoxedUnit boxedUnit;
                if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isErrorEnabled()) {
                    this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().error("unknown {}", (Object)msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = boxedUnit;
            }
        }
        super.handleQueryUpdate(msg);
    }

    @Override
    public boolean isJobDone() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone();
    }

    public Object com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$waitForNextResult() {
        BoxedUnit boxedUnit;
        if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isDebugEnabled()) {
            this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().debug("waiting for result");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.timeout.isFinite() ? Option$.MODULE$.apply(this.completedResults().poll(this.timeout.length(), this.timeout.unit())) : Option$.MODULE$.apply(this.completedResults().take());
    }

    private final void TableOutputIterator$lzycompute$1() {
        QueryProgressTrackerWithIterator queryProgressTrackerWithIterator = this;
        synchronized (queryProgressTrackerWithIterator) {
            if (this.TableOutputIterator$module == null) {
                this.TableOutputIterator$module = new QueryProgressTrackerWithIterator$TableOutputIterator$(this);
            }
        }
    }

    public QueryProgressTrackerWithIterator(String graphID, String jobID, Config conf, Duration timeout, List<String> header) {
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$jobID = jobID;
        this.conf = conf;
        this.timeout = timeout;
        this.header = header;
        super(graphID, jobID, conf);
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone = false;
        this.jobsDone = 0;
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult = None$.MODULE$;
        this.completedResults = new LinkedBlockingQueue();
    }
}

