/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.TemporalNodeList$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ExplodedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`TemporalNodeList(properties: String*) = new TemporalNodeList(properties)`\n  *  : Write out timestamped nodes with selected properties to table\n  *\n  * {s}`TemporalNodeLisst(defaults: Map[String, Any], properties: String*)`\n  *  : Specify default values for missing properties\n  *\n  * {s}`TemporalNodeList(properties: Seq[String] = Seq.empty[String], defaults: Map[String, Any] = Map.empty[String, Any])`\n  *  : Specify property names as sequence\n  *\n  * Property names are looked up on a node's computational state first and then in a node's property. Property values\n  * are looked up using creation timestamps explicitly. Computational state is expanded if it is a sequence\n  * with the same size as the vertex's distinct creation timestamps and assuming that state maps to a vertex's\n  * distinct, sorted timestamps. This means that this algorithm can be used as the last step in an algorithm\n  * chain to include output of intermediate results.\n  *\n  * ## Params\n  *\n  *  {s}`properties: Seq[String]`\n  *    : Sequence of property names\n  *\n  *  {s}`defaults: Map[String, Any]`\n  *    : Map from property names to default values (if a property name is not found on a node,\n  *      it is first looked up in defaults, and if not found there, set to {s}`None`)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | time stamp      | property 1      | ... |\n  *  | ----------------- | --------------- | --------------- | --- |\n  *  | {s}`name: String` | {s}`time: Long` | {s}`value: Any` | ... |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001\u0002\n\u0014\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")\u0011\n\u0001C\u0001\u0015\"9q\n\u0001b\u0001\n\u0013\u0001\u0006B\u00021\u0001A\u0003%\u0011\u000bC\u0003b\u0001\u0011\u0005#m\u0002\u0004\u0000'!\u0005\u0011\u0011\u0001\u0004\u0007%MA\t!a\u0001\t\r%CA\u0011AA\t\u0011\u001d\t\u0019\u0002\u0003C\u0001\u0003+A\u0011\"a\u0007\t#\u0003%\t!!\b\t\u0013\u0005M\u0002\"%A\u0005\u0002\u0005U\u0002bBA\n\u0011\u0011\u0005\u0011\u0011\b\u0005\b\u0003'AA\u0011AA\"\u0011%\tI\u0005CI\u0001\n\u0003\ti\u0002C\u0005\u0002L!\t\n\u0011\"\u0001\u00026!I\u0011Q\n\u0005\u0002\u0002\u0013%\u0011q\n\u0002\u0011)\u0016l\u0007o\u001c:bY:{G-\u001a'jgRT!\u0001F\u000b\u0002\u0011Q,W\u000e]8sC2T!AF\f\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002\u00193\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011ZS\"A\u0013\u000b\u0005\u0019:\u0013!C1mO>\u0014\u0018\u000e\u001e5n\u0015\tA\u0013&\u0001\u0005b]\u0006d\u0017p]5t\u0015\tQs#A\u0002ba&L!\u0001L\u0013\u0003\u000f\u001d+g.\u001a:jG\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0007=:$H\u0004\u00021k9\u0011\u0011\u0007N\u0007\u0002e)\u00111gG\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!AN\u0010\u0002\u000fA\f7m[1hK&\u0011\u0001(\u000f\u0002\u0004'\u0016\f(B\u0001\u001c !\tYtH\u0004\u0002={A\u0011\u0011gH\u0005\u0003}}\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011ahH\u0001\tI\u00164\u0017-\u001e7ugB!1\b\u0012\u001eG\u0013\t)\u0015IA\u0002NCB\u0004\"AH$\n\u0005!{\"aA!os\u00061A(\u001b8jiz\"2aS'O!\ta\u0005!D\u0001\u0014\u0011\u001di3\u0001%AA\u00029BqAQ\u0002\u0011\u0002\u0003\u00071)A\u0004d_2,XN\\:\u0016\u0003E\u00032AU,Z\u001b\u0005\u0019&B\u0001+V\u0003%IW.\\;uC\ndWM\u0003\u0002W?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001b&\u0001\u0002'jgR\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\t1\fgn\u001a\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00015,\u0001\u0005d_2,XN\\:!\u0003)!\u0018MY;mCJL7/\u001a\u000b\u0003G&\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\u0014\u0002\u000bQ\f'\r\\3\n\u0005!,'!\u0002+bE2,\u0007\"\u00026\u0007\u0001\u0004Y\u0017!B4sCBD\u0007C\u00017p\u001b\u0005i'B\u00018(\u0003%9'/\u00199im&,w/\u0003\u0002q[\n\u0001rI]1qQB+'o\u001d9fGRLg/\u001a\u0015\u0005\u0001IdX\u0010\u0005\u0002tu6\tAO\u0003\u0002vm\u0006A1oY1mC\u0012|7M\u0003\u0002xq\u00069A/Y6fu>,'BA=\u001a\u0003\u00199\u0017\u000e\u001e5vE&\u00111\u0010\u001e\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\na0AFf_)R#\u0002\t\u0011+Am\u001cX\u0010\u0019+f[B|'/\u00197O_\u0012,G*[:uQA\u0014x\u000e]3si&,7O\u000f\u0011TiJLgn\u001a\u0016*Au\u0002c.Z<!)\u0016l\u0007o\u001c:bY:{G-\u001a'jgRD\u0003O]8qKJ$\u0018.Z:*A*\u0001\u0003E\u000b\u0011!u\u0001:&/\u001b;fA=,H\u000f\t;j[\u0016\u001cH/Y7qK\u0012\u0004cn\u001c3fg\u0002:\u0018\u000e\u001e5!g\u0016dWm\u0019;fI\u0002\u0002(o\u001c9feRLWm\u001d\u0011u_\u0002\"\u0018M\u00197f\u0015\u0001\u0002#F\u0003\u0011!U\u0001Z8/ 1UK6\u0004xN]1m\u001d>$W\rT5tgRDC-\u001a4bk2$8O\u000f\u0011NCB\\6\u000b\u001e:j]\u001ed\u0003%\u00118z;2\u0002\u0003O]8qKJ$\u0018.Z:;AM#(/\u001b8hU%\u0002'\u0002\t\u0011+A\u0001R\u0004e\u00159fG&4\u0017\u0010\t3fM\u0006,H\u000e\u001e\u0011wC2,Xm\u001d\u0011g_J\u0004S.[:tS:<\u0007\u0005\u001d:pa\u0016\u0014H/[3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001Z8/ 1UK6\u0004xN]1m\u001d>$W\rT5ti\"\u0002(o\u001c9feRLWm\u001d\u001e!'\u0016\f8l\u0015;sS:<W\fI\u001f!'\u0016\fh&Z7qif\\6\u000b\u001e:j]\u001elF\u0006\t3fM\u0006,H\u000e^:;A5\u000b\u0007oW*ue&tw\r\f\u0011B]fl\u0006%\u0010\u0011NCBtS-\u001c9usn\u001bFO]5oO2\u0002\u0013I\\=^S\u0001T\u0001\u0005\t\u0016!Ai\u00023\u000b]3dS\u001aL\b\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,7\u000fI1tAM,\u0017/^3oG\u0016T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u0015:pa\u0016\u0014H/\u001f\u0011oC6,7\u000fI1sK\u0002bwn\\6fI\u0002*\b\u000fI8oA\u0005\u0004cn\u001c3fOM\u00043m\\7qkR\fG/[8oC2\u00043\u000f^1uK\u00022\u0017N]:uA\u0005tG\r\t;iK:\u0004\u0013N\u001c\u0011bA9|G-Z\u0014tAA\u0014x\u000e]3sift\u0003\u0005\u0015:pa\u0016\u0014H/\u001f\u0011wC2,Xm\u001d\u0006!A)\u0002\u0013M]3!Y>|7.\u001a3!kB\u0004So]5oO\u0002\u001a'/Z1uS>t\u0007\u0005^5nKN$\u0018-\u001c9tA\u0015D\b\u000f\\5dSRd\u0017P\f\u0011D_6\u0004X\u000f^1uS>t\u0017\r\u001c\u0011ti\u0006$X\rI5tA\u0015D\b/\u00198eK\u0012\u0004\u0013N\u001a\u0011ji\u0002J7\u000fI1!g\u0016\fX/\u001a8dK*\u0001\u0003E\u000b\u0011xSRD\u0007\u0005\u001e5fAM\fW.\u001a\u0011tSj,\u0007%Y:!i\",\u0007E^3si\u0016Dxe\u001d\u0011eSN$\u0018N\\2uA\r\u0014X-\u0019;j_:\u0004C/[7fgR\fW\u000e]:!C:$\u0007%Y:tk6Lgn\u001a\u0011uQ\u0006$\be\u001d;bi\u0016\u0004S.\u00199tAQ|\u0007%\u0019\u0011wKJ$X\r_\u0014t\u0015\u0001\u0002#\u0006\t3jgRLgn\u0019;-AM|'\u000f^3eAQLW.Z:uC6\u00048O\f\u0011UQ&\u001c\b%\\3b]N\u0004C\u000f[1uAQD\u0017n\u001d\u0011bY\u001e|'/\u001b;i[\u0002\u001a\u0017M\u001c\u0011cK\u0002*8/\u001a3!CN\u0004C\u000f[3!Y\u0006\u001cH\u000fI:uKB\u0004\u0013N\u001c\u0011b]\u0002\nGnZ8sSRDWN\u0003\u0011!U\u0001\u001a\u0007.Y5oAQ|\u0007%\u001b8dYV$W\rI8viB,H\u000fI8gA%tG/\u001a:nK\u0012L\u0017\r^3!e\u0016\u001cX\u000f\u001c;t])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011QCJ\fWn\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00199s_B,'\u000f^5fgj\u00023+Z9\\'R\u0014\u0018N\\4^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004eU3rk\u0016t7-\u001a\u0011pM\u0002\u0002(o\u001c9feRL\bE\\1nKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$WMZ1vYR\u001c(\bI'ban\u001bFO]5oO2\u0002\u0013I\\=^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004%T1qA\u0019\u0014x.\u001c\u0011qe>\u0004XM\u001d;zA9\fW.Z:!i>\u0004C-\u001a4bk2$\bE^1mk\u0016\u001c\b\u0005K5gA\u0005\u0004\u0003O]8qKJ$\u0018\u0010\t8b[\u0016\u0004\u0013n\u001d\u0011o_R\u0004cm\\;oI\u0002zg\u000eI1!]>$W\r\f\u0006!A)\u0002\u0003\u0005\t\u0011!A%$\b%[:!M&\u00148\u000f\u001e\u0011m_>\\W\r\u001a\u0011va\u0002Jg\u000e\t3fM\u0006,H\u000e^:-A\u0005tG\rI5gA9|G\u000f\t4pk:$\u0007\u0005\u001e5fe\u0016d\u0003e]3uAQ|\u0007e_:~A:{g.\u001a1*\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002\"\u0018.\\3!gR\fW\u000e\u001d\u0011!A\u0001\u0002\u0003\u0005 \u0011qe>\u0004XM\u001d;zAE\u0002\u0003\u0005\t\u0011!Aq\u0004cF\f\u0018!y*\u0001\u0003E\u000b\u0011!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\b\r^5nKj\u0002Cj\u001c8hA\u0002b\be_:~AZ\fG.^3;A\u0005s\u0017\u0010\u0019\u0011}A9rc\u0006\t?\u000bA\u0001Rs&\u0001\tUK6\u0004xN]1m\u001d>$W\rT5tiB\u0011A\nC\n\u0005\u0011u\t)\u0001\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY!X\u0001\u0003S>LA!a\u0004\u0002\n\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011A\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0017\u0006]\u0011\u0011\u0004\u0005\b[)\u0001\n\u00111\u0001/\u0011\u001d\u0011%\u0002%AA\u0002\r\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0003\u0003?Q3ALA\u0011W\t\t\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0017?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0012q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]\"fA\"\u0002\"Q\u00191*a\u000f\t\r5j\u0001\u0019AA\u001f!\u0011q\u0012q\b\u001e\n\u0007\u0005\u0005sD\u0001\u0006=e\u0016\u0004X-\u0019;fIz\"RaSA#\u0003\u000fBQA\u0011\bA\u0002\rCa!\f\bA\u0002\u0005u\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003#\u00022AWA*\u0013\r\t)f\u0017\u0002\u0007\u001f\nTWm\u0019;")
public class TemporalNodeList
implements Generic {
    private final List<String> columns;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Map<String, Object> $lessinit$greater$default$2() {
        return TemporalNodeList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$1() {
        return TemporalNodeList$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<String, Object> apply$default$2() {
        return TemporalNodeList$.MODULE$.apply$default$2();
    }

    public static Seq<String> apply$default$1() {
        return TemporalNodeList$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation returns the graph unchanged.\n    * This should be overridden by subclasses to define the actual\n    * algorithm steps unless the algorithm only outputs existing state or properties.\n    *\n    * @param graph graph to run function upon\n    */")
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return Generic.apply$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    private List<String> columns() {
        return this.columns;
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.multilayerView().step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            TemporalNodeList.$anonfun$tabularise$1(vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)this.columns());
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(ExplodedVertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("baseName", vertex.baseName());
        ((EntityVisitor)((Object)vertex)).setState("timestamp", BoxesRunTime.boxToLong((long)vertex.timestamp()));
    }

    public TemporalNodeList(Seq<String> properties, Map<String, Object> defaults) {
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
        this.columns = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baseName", "timestamp"}))).$plus$plus(properties);
    }
}

