/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n  *  {s}`ThreeNodeMotifs()`\n  *    : Count occurrences of three-node motifs that a node participates in.\n  *\n  *  The algorithm works by first counting star motifs, including potential triangles.\n  *  Then, for each star we send a message to one of the neighbours to identify the potential third edge.\n  *  Based on the responses, we correct the star counts and count the triangles.\n  *\n  *  ```{note}\n  *  Stars are only counted once as they only appear in the counts for the central vertex. However, triangles\n  *  appear for each of the 3 vertices, so the count for triangles should be divided by 3 when aggregating results to get\n  *  motif counts for the whole graph.\n  *  ```\n  *\n  *  ## Motifs\n  *\n  *  ### Stars\n  *\n  *    - 0: l <- c -> r\n  *    - 1: l -> c <- r\n  *    - 2: l -> c -> r\n  *    - 3: l -> c <-> r\n  *    - 4: l <- c <-> r\n  *    - 5: l <-> c <-> r\n  *\n  *  ### Triangles\n  *\n  *  (Index of star + third edge)\n  *    - 6: 0 + l -> r\n  *    - 7: 2 + l <- r\n  *    - 8: 3 + l -> r\n  *    - 9: 4 + l -> r\n  *    - 10: 4 + l <- r\n  *    - 11: 5 + l -> r\n  *    - 12: 5 + l <-> r\n  *\n  * ## States\n  *  {s}`motifCounts: Array[Long]`\n  *    : Motif counts stored as an array (see indices above)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | Motif 0                   | ... | Motif 12                   |\n  *  | ----------------- | ------------------------- | --- | -------------------------- |\n  *  | {s}`name: String` | {s}`motifCounts(0): Long` | ... | {s}`motifCounts(12): Long` |\n  */")
public final class ThreeNodeMotifs$
implements Generic {
    public static final ThreeNodeMotifs$ MODULE$ = new ThreeNodeMotifs$();
    private static final int inoutEdge;
    private static final int outEdge;
    private static final int inEdge;
    private static final int noEdge;
    private static final Map<Tuple2<Object, Object>, Object> starMotifIndex;
    private static final Map<Tuple2<Object, Object>, Object> triangleMotifIndex;
    private static final Seq<String> columns;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private static Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    static {
        BaseAlgorithm.$init$(MODULE$);
        Generic.$init$(MODULE$);
        inoutEdge = 0;
        outEdge = 1;
        inEdge = 2;
        noEdge = -1;
        starMotifIndex = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.outEdge(), MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.inEdge(), MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.inEdge(), MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.outEdge(), MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.inEdge(), MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.inoutEdge(), MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)-3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.outEdge(), MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.inoutEdge(), MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)-4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(MODULE$.inoutEdge(), MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)5))}));
        triangleMotifIndex = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(0, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(0, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(0, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(1, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(1, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(1, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-2, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-2, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-2, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)11)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-3, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)11)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-3, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-3, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(4, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)11)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-4, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)11)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(4, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-4, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(4, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(-4, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(5, MODULE$.inoutEdge())), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(5, MODULE$.outEdge())), (Object)BoxesRunTime.boxToInteger((int)11)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(5, MODULE$.inEdge())), (Object)BoxesRunTime.boxToInteger((int)11))}));
        columns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 13).map((Function1 & Serializable)index -> ThreeNodeMotifs$.MODULE$.motifCountColumn(BoxesRunTime.unboxToInt((Object)index))));
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    public int inoutEdge() {
        return inoutEdge;
    }

    public int outEdge() {
        return outEdge;
    }

    public int inEdge() {
        return inEdge;
    }

    public int noEdge() {
        return noEdge;
    }

    public Map<Tuple2<Object, Object>, Object> starMotifIndex() {
        return starMotifIndex;
    }

    public Map<Tuple2<Object, Object>, Object> triangleMotifIndex() {
        return triangleMotifIndex;
    }

    public Function1<Object, Object> _getEdgeType(Vertex vertex) {
        return (Function1 & Serializable)vID -> BoxesRunTime.boxToInteger((int)ThreeNodeMotifs$.$anonfun$_getEdgeType$1(vertex, vID));
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            ThreeNodeMotifs$.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            ThreeNodeMotifs$.$anonfun$apply$5(vertex);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            ThreeNodeMotifs$.$anonfun$apply$8(vertex);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<String> columns() {
        return columns;
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            ThreeNodeMotifs$.$anonfun$tabularise$1(vertex);
            return BoxedUnit.UNIT;
        }).select(this.columns());
    }

    private String motifCountColumn(int index) {
        return new StringBuilder(2).append("mc").append(index).toString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ThreeNodeMotifs$.class);
    }

    public static final /* synthetic */ int $anonfun$_getEdgeType$1(Vertex vertex$1, Object vID) {
        return vertex$1.isInNeighbour(vID) && vertex$1.isOutNeighbour(vID) ? MODULE$.inoutEdge() : (vertex$1.isOutNeighbour(vID) ? MODULE$.outEdge() : (vertex$1.isInNeighbour(vID) ? MODULE$.inEdge() : MODULE$.noEdge()));
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex vertex) {
        ArrayBuffer motifCounts = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(13, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L);
        Object neighbours = vertex.neighbours().toArray(vertex.IDClassTag());
        Function1<Object, Object> getEdgeType = MODULE$._getEdgeType(vertex);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.genericArrayOps(neighbours)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Object first = ScalaRunTime$.MODULE$.array_apply(neighbours, i);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(i + 1), ScalaRunTime$.MODULE$.array_length(neighbours)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                Object second = ScalaRunTime$.MODULE$.array_apply(neighbours, j);
                int mType = BoxesRunTime.unboxToInt((Object)MODULE$.starMotifIndex().apply((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)getEdgeType.apply(first)), BoxesRunTime.unboxToInt((Object)getEdgeType.apply(second)))));
                int n = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(mType));
                motifCounts.update(n, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)motifCounts.apply(n)) + 1L)));
                vertex.messageVertex(first, new Tuple3(vertex.ID(), second, (Object)BoxesRunTime.boxToInteger((int)mType)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            });
        });
        ((EntityVisitor)((Object)vertex)).setState("motifCounts", motifCounts);
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$apply$7(Function1 getEdgeType$2, Vertex vertex$3, Tuple3 x$1) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x$1;
        if (tuple3 != null) {
            Object source = tuple3._1();
            Object second = tuple3._2();
            int mType = BoxesRunTime.unboxToInt((Object)tuple3._3());
            int eType = BoxesRunTime.unboxToInt((Object)getEdgeType$2.apply(second));
            if (eType != MODULE$.noEdge()) {
                vertex$3.messageVertex(source, new Tuple2.mcII.sp(mType, eType), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$apply$5(Vertex vertex) {
        Seq messages = vertex.messageQueue();
        Function1<Object, Object> getEdgeType = MODULE$._getEdgeType(vertex);
        messages.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ThreeNodeMotifs$.$anonfun$apply$6(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            ThreeNodeMotifs$.$anonfun$apply$7(getEdgeType, vertex, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$9(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$apply$10(ArrayBuffer motifCounts$2, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int mType = tuple2._1$mcI$sp();
        int eType = tuple2._2$mcI$sp();
        int n = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(mType));
        motifCounts$2.update(n, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)motifCounts$2.apply(n)) - 1L)));
        int n2 = BoxesRunTime.unboxToInt((Object)MODULE$.triangleMotifIndex().apply((Object)new Tuple2.mcII.sp(mType, eType)));
        motifCounts$2.update(n2, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)motifCounts$2.apply(n2)) + 1L)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$8(Vertex vertex) {
        Seq messages = vertex.messageQueue();
        ArrayBuffer motifCounts = (ArrayBuffer)((EntityVisitor)((Object)vertex)).getState("motifCounts", ((EntityVisitor)((Object)vertex)).getState$default$2());
        messages.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ThreeNodeMotifs$.$anonfun$apply$9(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
            ThreeNodeMotifs$.$anonfun$apply$10(motifCounts, x$2);
            return BoxedUnit.UNIT;
        });
        ((EntityVisitor)((Object)vertex)).setState("motifCounts", motifCounts);
    }

    public static final /* synthetic */ void $anonfun$tabularise$2(Vertex vertex$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long motifCount = tuple2._1$mcJ$sp();
        int index = tuple2._2$mcI$sp();
        ((EntityVisitor)((Object)vertex$4)).setState(MODULE$.motifCountColumn(index), BoxesRunTime.boxToLong((long)motifCount));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(Vertex vertex) {
        ArrayBuffer motifCounts = (ArrayBuffer)((EntityVisitor)((Object)vertex)).getState("motifCounts", ((EntityVisitor)((Object)vertex)).getState$default$2());
        ((EntityVisitor)((Object)vertex)).setState("name", vertex.name(vertex.name$default$1()));
        ((IterableOnceOps)motifCounts.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ThreeNodeMotifs$.$anonfun$tabularise$2(vertex, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private ThreeNodeMotifs$() {
    }
}

