/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.dynamic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.dynamic.Node2VecWalk$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.utils.Sampling$;
import com.raphtory.utils.Sampling$WeightedSampling$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.compat.immutable.package$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`Node2VecWalk(walkLength:Int = 10, p: Double = 1.0, q: Double = 1.0)`\n  *  : Node2Vec biased random walk on directed, unweighted graph\n  *\n  * Node2Vec is used to construct feature vectors to represent vertices or edges in a graph such that classical machine\n  * learning algorithms can be applied to the resulting vector representations for network analysis tasks,\n  * such as node classification and link prediction. This algorithm implements the Node2Vec biased 2nd-order random\n  * walk model to sample neighbors of every vertex in a graph. This random walk model interpolates between breadth-first\n  * and depth-first search in the graph in a flexible manner so that local and global structures of the vertex\n  * neighborhood can both be captured. In this way, it is capable of supporting different varieties of graphs\n  * and analysis tasks well.This implementation is based on [Fast-Node2Vec](https://arxiv.org/pdf/1805.00280.pdf)\n  * and computes transition probabilities on the fly rather than precomputing all probabilities in advance.\n  *\n  * ```{note}\n  * This implementation currently does not support edge weights. This algorithm also only implements the random walk\n  * step of Node2Vec. For a full implementation of Node2Vec, the resulting output should be fed into a skip-gram model.[^node2vec]\n  * ```\n  *\n  * ```{note}\n  * If the walk reaches a vertex with out-degree 0, it will remain there until {s}`walkLength` is reached.\n  * ```\n  *\n  * ## Parameters\n  *\n  *  {s}`walkLength: Int = 10`\n  *    : Lengths of the generated random walks\n  *\n  *  {s}`p: Double = 1.0`\n  *    : bias parameter $p$\n  *\n  *  {s}`q: Double = 1.0`\n  *    : bias parameter $q$\n  *\n  * ## States\n  *\n  *  {s}`walk: ArrayBuffer[String]`\n  *    : List of vertices visited by the random walk starting from this vertex\n  *\n  * ## Returns\n  *\n  * | vertex 1          | vertex 2          | ... | vertex `walkLength` |\n  * | ----------------- | ----------------- | --- | ------------------- |\n  * | {s}`name: String` | {s}`name: String` | ... | {s}`name: String`   |\n  *\n  *  Each row of the table corresponds to a single random walk and columns correspond to the vertex at a given step.\n  *  The algorithm starts one random walk from each vertex in the graph.\n  *\n  * [^node2vec]: [node2vec: Scalable Feature Learning for Networks](https://arxiv.org/abs/1607.00653)\n  */")
@ScalaSignature(bytes="\u0006\u0005\reb\u0001\u0002%J\u0001QC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"AQ\u000e\u0001B\u0001B\u0003%!\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0004v\u0001\t\u0007I\u0011\u0002<\t\ru\u0004\u0001\u0015!\u0003x\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\tY\u0002\u0001C!\u0003;9q!!\u0013J\u0011\u0003\tYE\u0002\u0004I\u0013\"\u0005\u0011Q\n\u0005\u0007]*!\t!a\u0018\t\ryTA\u0011AA1\u0011%\tIGCI\u0001\n\u0003\tY\u0007C\u0005\u0002\u0002*\t\n\u0011\"\u0001\u0002\u0004\"I\u0011q\u0011\u0006\u0012\u0002\u0013\u0005\u00111\u0011\u0004\n\u0003\u0013S\u0001\u0013aI\u0011\u0003\u00173aAa\u0013\u000b\u0001\n5\u0003B\u0003B,#\tU\r\u0011\"\u0001\u0003Z!Q!1L\t\u0003\u0012\u0003\u0006IAa\u0015\t\u0015\tu\u0013C!f\u0001\n\u0003\u0011I\u0006\u0003\u0006\u0003`E\u0011\t\u0012)A\u0005\u0005'B!B!\u0019\u0012\u0005+\u0007I\u0011\u0001B2\u0011)\u0011Y'\u0005B\tB\u0003%!Q\r\u0005\u000b\u0005[\n\"1!Q\u0001\f\t=\u0004B\u00028\u0012\t\u0003\u0011Y\bC\u0005\u0002jF\t\t\u0011\"\u0001\u0003\n\"I\u0011q_\t\u0012\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005S\u000b\u0012\u0013!C\u0001\u0005WC\u0011Ba,\u0012#\u0003%\tA!-\t\u0013\t\u0005\u0011#!A\u0005B\t\r\u0001\"\u0003B\b#\u0005\u0005I\u0011\u0001B\t\u0011%\u0011\u0019\"EA\u0001\n\u0003\u0011I\fC\u0005\u0003\u001cE\t\t\u0011\"\u0011\u0003\u001e!I!1F\t\u0002\u0002\u0013\u0005!Q\u0018\u0005\n\u0005o\t\u0012\u0011!C!\u0005\u0003D\u0011B!\u0010\u0012\u0003\u0003%\tEa\u0010\t\u0013\t\u0005\u0013#!A\u0005B\t\r\u0003\"\u0003B##\u0005\u0005I\u0011\tBc\u000f%\u0011IMCA\u0001\u0012\u0003\u0011YMB\u0005\u0003L)\t\t\u0011#\u0001\u0003N\"1a\u000e\u000bC\u0001\u0005\u001fD\u0011B!\u0011)\u0003\u0003%)Ea\u0011\t\u0011yD\u0013\u0011!CA\u0005#D\u0011B!;)\u0003\u0003%\tIa;\t\u0013\r\u001d\u0001&!A\u0005\n\r%aABAR\u0015\u0001\u000b)\u000b\u0003\u0006\u0002N:\u0012)\u001a!C\u0001\u0003\u001fD!\"!9/\u0005#\u0005\u000b\u0011BAi\u0011\u0019qg\u0006\"\u0001\u0002d\"I\u0011\u0011\u001e\u0018\u0002\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003ot\u0013\u0013!C\u0001\u0003sD\u0011B!\u0001/\u0003\u0003%\tEa\u0001\t\u0013\t=a&!A\u0005\u0002\tE\u0001\"\u0003B\n]\u0005\u0005I\u0011\u0001B\u000b\u0011%\u0011YBLA\u0001\n\u0003\u0012i\u0002C\u0005\u0003,9\n\t\u0011\"\u0001\u0003.!I!q\u0007\u0018\u0002\u0002\u0013\u0005#\u0011\b\u0005\n\u0005{q\u0013\u0011!C!\u0005\u007fA\u0011B!\u0011/\u0003\u0003%\tEa\u0011\t\u0013\t\u0015c&!A\u0005B\t\u001ds!CB\t\u0015\u0005\u0005\t\u0012AB\n\r%\t\u0019KCA\u0001\u0012\u0003\u0019)\u0002\u0003\u0004o}\u0011\u00051q\u0003\u0005\n\u0005\u0003r\u0014\u0011!C#\u0005\u0007B\u0001B  \u0002\u0002\u0013\u00055\u0011\u0004\u0005\n\u0005St\u0014\u0011!CA\u0007KA\u0011ba\u0002?\u0003\u0003%Ia!\u0003\t\u0013\rM\"\"%A\u0005\u0002\u0005-\u0004\"CB\u001b\u0015E\u0005I\u0011AAB\u0011%\u00199DCI\u0001\n\u0003\t\u0019\tC\u0005\u0004\b)\t\t\u0011\"\u0003\u0004\n\taaj\u001c3feY+7mV1mW*\u0011!jS\u0001\bIft\u0017-\\5d\u0015\taU*A\u0004hK:,'/[2\u000b\u00059{\u0015AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011\u0001+U\u0001\te\u0006\u0004\b\u000e^8ss*\t!+A\u0002d_6\u001c\u0001aE\u0002\u0001+n\u0003\"AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013a!\u00118z%\u00164\u0007C\u0001/d\u001b\u0005i&B\u00010`\u0003%\tGnZ8sSRDWN\u0003\u0002aC\u0006A\u0011M\\1msNL7O\u0003\u0002c\u001f\u0006\u0019\u0011\r]5\n\u0005\u0011l&aB$f]\u0016\u0014\u0018nY\u0001\u000bo\u0006d7\u000eT3oORD\u0007C\u0001,h\u0013\tAwKA\u0002J]R\f\u0011\u0001\u001d\t\u0003-.L!\u0001\\,\u0003\r\u0011{WO\u00197f\u0003\u0005\t\u0018A\u0002\u001fj]&$h\b\u0006\u0003qeN$\bCA9\u0001\u001b\u0005I\u0005bB3\u0005!\u0003\u0005\rA\u001a\u0005\bS\u0012\u0001\n\u00111\u0001k\u0011\u001diG\u0001%AA\u0002)\f1A\u001d8h+\u00059\bC\u0001=|\u001b\u0005I(B\u0001>X\u0003\u0011)H/\u001b7\n\u0005qL(A\u0002*b]\u0012|W.\u0001\u0003s]\u001e\u0004\u0013!B1qa2LH\u0003BA\u0001\u0003\u000f\u0001B!a\u0001\u0002\u00189!\u0011QAA\u0004\u0019\u0001Aq!!\u0003\b\u0001\u0004\tY!A\u0003he\u0006\u0004\b\u000e\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tbX\u0001\nOJ\f\u0007\u000f\u001b<jK^LA!!\u0006\u0002\u0010\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0005\u00033\t\u0019BA\u0003He\u0006\u0004\b.\u0001\u0006uC\n,H.\u0019:jg\u0016$B!a\b\u0002,A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&}\u000bQ\u0001^1cY\u0016LA!!\u000b\u0002$\t)A+\u00192mK\"9\u0011\u0011\u0002\u0005A\u0002\u0005-\u0001f\u0002\u0001\u00020\u0005\r\u0013Q\t\t\u0005\u0003c\ty$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003!\u00198-\u00197bI>\u001c'\u0002BA\u001d\u0003w\tq\u0001^1lKj|WMC\u0002\u0002>E\u000baaZ5uQV\u0014\u0017\u0002BA!\u0003g\u0011\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000f\n!SQ\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004gj\u001c3feY+7mV1mW\":\u0018\r\\6MK:<G\u000f\u001b\u001eJ]R\u0004S\bI\u00191Y\u0001\u0002(\b\t#pk\ndW\rI\u001f!c9\u0002D\u0006I9;A\u0011{WO\u00197fAu\u0002\u0013G\f\u0019*A*\u0001\u0003E\u000b\u0011!u\u0001ru\u000eZ33-\u0016\u001c\u0007EY5bg\u0016$\u0007E]1oI>l\u0007e^1mW\u0002zg\u000e\t3je\u0016\u001cG/\u001a3-AUtw/Z5hQR,G\rI4sCBD'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t(pI\u0016\u0014d+Z2!SN\u0004So]3eAQ|\u0007eY8ogR\u0014Xo\u0019;!M\u0016\fG/\u001e:fAY,7\r^8sg\u0002\"x\u000e\t:faJ,7/\u001a8uAY,'\u000f^5dKN\u0004sN\u001d\u0011fI\u001e,7\u000fI5oA\u0005\u0004sM]1qQ\u0002\u001aXo\u00195!i\"\fG\u000fI2mCN\u001c\u0018nY1mA5\f7\r[5oK*\u0001\u0003E\u000b\u0011mK\u0006\u0014h.\u001b8hA\u0005dwm\u001c:ji\"l7\u000fI2b]\u0002\u0012W\rI1qa2LW\r\u001a\u0011u_\u0002\"\b.\u001a\u0011sKN,H\u000e^5oO\u00022Xm\u0019;pe\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:\u001c\bEZ8sA9,Go^8sW\u0002\ng.\u00197zg&\u001c\b\u0005^1tWNd#\u0002\t\u0011+AM,8\r\u001b\u0011bg\u0002rw\u000eZ3!G2\f7o]5gS\u000e\fG/[8oA\u0005tG\r\t7j].\u0004\u0003O]3eS\u000e$\u0018n\u001c8/AQC\u0017n\u001d\u0011bY\u001e|'/\u001b;i[\u0002JW\u000e\u001d7f[\u0016tGo\u001d\u0011uQ\u0016\u0004cj\u001c3feY+7\r\t2jCN,G\r\t\u001aoI6z'\u000fZ3sAI\fg\u000eZ8n\u0015\u0001\u0002#\u0006I<bY.\u0004Sn\u001c3fY\u0002\"x\u000eI:b[BdW\r\t8fS\u001eD'm\u001c:tA=4\u0007%\u001a<fef\u0004c/\u001a:uKb\u0004\u0013N\u001c\u0011bA\u001d\u0014\u0018\r\u001d5/AQC\u0017n\u001d\u0011sC:$w.\u001c\u0011xC2\\\u0007%\\8eK2\u0004\u0013N\u001c;feB|G.\u0019;fg\u0002\u0012W\r^<fK:\u0004#M]3bIRDWFZ5sgRT\u0001\u0005\t\u0016!C:$\u0007\u0005Z3qi\"lc-\u001b:ti\u0002\u001aX-\u0019:dQ\u0002Jg\u000e\t;iK\u0002:'/\u00199iA%t\u0007%\u0019\u0011gY\u0016D\u0018N\u00197fA5\fgN\\3sAM|\u0007\u0005\u001e5bi\u0002bwnY1mA\u0005tG\rI4m_\n\fG\u000eI:ueV\u001cG/\u001e:fg\u0002zg\r\t;iK\u00022XM\u001d;fq*\u0001\u0003E\u000b\u0011oK&<\u0007NY8sQ>|G\rI2b]\u0002\u0012w\u000e\u001e5!E\u0016\u00043-\u00199ukJ,GM\f\u0011J]\u0002\"\b.[:!o\u0006LH\u0006I5uA%\u001c\beY1qC\ndW\rI8gAM,\b\u000f]8si&tw\r\t3jM\u001a,'/\u001a8uAY\f'/[3uS\u0016\u001c\be\u001c4!OJ\f\u0007\u000f[:\u000bA\u0001R\u0003%\u00198eA\u0005t\u0017\r\\=tSN\u0004C/Y:lg\u0002:X\r\u001c7/)\"L7\u000fI5na2,W.\u001a8uCRLwN\u001c\u0011jg\u0002\u0012\u0017m]3eA=t\u0007e\u0017$bgRlcj\u001c3feY+7-\u0018\u0015iiR\u00048OO\u00180CJD\u0018N\u001e\u0018pe\u001e|\u0003\u000f\u001a40ca\u0002TG\f\u00191ea\u0002d\u0006\u001d3gS)\u0001\u0003E\u000b\u0011b]\u0012\u00043m\\7qkR,7\u000f\t;sC:\u001c\u0018\u000e^5p]\u0002\u0002(o\u001c2bE&d\u0017\u000e^5fg\u0002zg\u000e\t;iK\u00022G.\u001f\u0011sCRDWM\u001d\u0011uQ\u0006t\u0007\u0005\u001d:fG>l\u0007/\u001e;j]\u001e\u0004\u0013\r\u001c7!aJ|'-\u00192jY&$\u0018.Z:!S:\u0004\u0013\r\u001a<b]\u000e,gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011aA\u0002\\hn\u001c;f{*\u0001\u0003E\u000b\u0011UQ&\u001c\b%[7qY\u0016lWM\u001c;bi&|g\u000eI2veJ,g\u000e\u001e7zA\u0011|Wm\u001d\u0011o_R\u00043/\u001e9q_J$\b%\u001a3hK\u0002:X-[4iiNt\u0003\u0005\u00165jg\u0002\nGnZ8sSRDW\u000eI1mg>\u0004sN\u001c7zA%l\u0007\u000f\\3nK:$8\u000f\t;iK\u0002\u0012\u0018M\u001c3p[\u0002:\u0018\r\\6\u000bA\u0001R\u0003e\u001d;fa\u0002zg\r\t(pI\u0016\u0014d+Z2/A\u0019{'\u000fI1!MVdG\u000eI5na2,W.\u001a8uCRLwN\u001c\u0011pM\u0002ru\u000eZ33-\u0016\u001cG\u0006\t;iK\u0002\u0012Xm];mi&tw\rI8viB,H\u000fI:i_VdG\r\t2fA\u0019,G\rI5oi>\u0004\u0013\rI:lSBlsM]1nA5|G-\u001a7/7zsw\u000eZ33m\u0016\u001cWL\u0003\u0011!U\u0001\u0002\u0007\r\u0019\u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047P\\8uKvT\u0001\u0005\t\u0016!\u0013\u001a\u0004C\u000f[3!o\u0006d7\u000e\t:fC\u000eDWm\u001d\u0011bAY,'\u000f^3yA]LG\u000f\u001b\u0011pkRlC-Z4sK\u0016\u0004\u0003\u0007\f\u0011ji\u0002:\u0018\u000e\u001c7!e\u0016l\u0017-\u001b8!i\",'/\u001a\u0011v]RLG\u000eI>t{\u0002<\u0018\r\\6MK:<G\u000f\u001b1!SN\u0004#/Z1dQ\u0016$gF\u0003\u0011!U\u0001\u0002\u0007\r\u0019\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002\u0003+\u0019:b[\u0016$XM]:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1xC2\\G*\u001a8hi\"T\u0004%\u00138uAu\u0002\u0013\u0007\r1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001bUM\\4uQN\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001a8fe\u0006$X\r\u001a\u0011sC:$w.\u001c\u0011xC2\\7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b\r\u001d\u001e!\t>,(\r\\3!{\u0001\nd\u0006\r1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\u0012\u0017.Y:!a\u0006\u0014\u0018-\\3uKJ\u0004C\u0005\u001d\u0013\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1ru\u0001\"u.\u001e2mK\u0002j\u0004%\r\u00181A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004EY5bg\u0002\u0002\u0018M]1nKR,'\u000f\t\u0013rI)\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y<bY.T\u0004%\u0011:sCf\u0014UO\u001a4fen\u001bFO]5oOv\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011MSN$\be\u001c4!m\u0016\u0014H/[2fg\u00022\u0018n]5uK\u0012\u0004#-\u001f\u0011uQ\u0016\u0004#/\u00198e_6\u0004s/\u00197lAM$\u0018M\u001d;j]\u001e\u0004cM]8nAQD\u0017n\u001d\u0011wKJ$X\r\u001f\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002#+\u001a;ve:\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t?!m\u0016\u0014H/\u001a=!c\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u00113A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u0010\t\u0018/]\u0001b\bE^3si\u0016D\b\u0005Y<bY.dUM\\4uQ\u0002\u0004CP\u0003\u0011!U\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011/]9\u0002C\u0010I>t{\u0002t\u0017-\\3;AM#(/\u001b8hA\u0002\u0002\u0003\u0005 \u0006!A)R\u0001\u0005\t\u0016!A\u0015\u000b7\r\u001b\u0011s_^\u0004sN\u001a\u0011uQ\u0016\u0004C/\u00192mK\u0002\u001awN\u001d:fgB|g\u000eZ:!i>\u0004\u0013\rI:j]\u001edW\r\t:b]\u0012|W\u000eI<bY.\u0004\u0013M\u001c3!G>dW/\u001c8tA\r|'O]3ta>tG\r\t;pAQDW\r\t<feR,\u0007\u0010I1uA\u0005\u0004s-\u001b<f]\u0002\u001aH/\u001a9/\u0015\u0001\u0002#\u0006\t\u0011UQ\u0016\u0004\u0013\r\\4pe&$\b.\u001c\u0011ti\u0006\u0014Ho\u001d\u0011p]\u0016\u0004#/\u00198e_6\u0004s/\u00197lA\u0019\u0014x.\u001c\u0011fC\u000eD\u0007E^3si\u0016D\b%\u001b8!i\",\u0007e\u001a:ba\"t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I._]>$WM\r<fGvS\u0004e\u00178pI\u0016\u0014d/Z2;AM\u001b\u0017\r\\1cY\u0016\u0004c)Z1ukJ,\u0007\u0005T3be:Lgn\u001a\u0011g_J\u0004c*\u001a;x_J\\7/\u0018\u0015iiR\u00048OO\u00180CJD\u0018N\u001e\u0018pe\u001e|\u0013MY:0cY\u0002tG\f\u00191mU\u001a\u0014F\u0003\u0011!U=\nABT8eKJ2VmY,bY.\u0004\"!\u001d\u0006\u0014\t))\u0016q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\tIwN\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\u0011\ti&a\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005-Cc\u00029\u0002d\u0005\u0015\u0014q\r\u0005\bK2\u0001\n\u00111\u0001g\u0011\u001dIG\u0002%AA\u0002)Dq!\u001c\u0007\u0011\u0002\u0003\u0007!.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiGK\u0002g\u0003_Z#!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w:\u0016AC1o]>$\u0018\r^5p]&!\u0011qPA;\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0011\u0016\u0004U\u0006=\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0003\u00115+7o]1hKN,B!!$\u0002\u0010N\u0011\u0001#\u0016\u0003\b\u0003#\u0003\"\u0019AAJ\u0005!1VM\u001d;fq&#\u0015\u0003BAK\u00037\u00032AVAL\u0013\r\tIj\u0016\u0002\b\u001d>$\b.\u001b8h!\r1\u0016QT\u0005\u0004\u0003?;&aA!os&\u001a\u0001CL\t\u0003\u0019M#xN]3NKN\u001c\u0018mZ3\u0016\t\u0005\u001d\u0016qV\n\t]U\u000bI+!-\u00028B)\u00111\u0016\t\u0002.6\t!\u0002\u0005\u0003\u0002\u0006\u0005=FaBAI]\t\u0007\u00111\u0013\t\u0004-\u0006M\u0016bAA[/\n9\u0001K]8ek\u000e$\b\u0003BA]\u0003\u0013tA!a/\u0002F:!\u0011QXAb\u001b\t\tyLC\u0002\u0002BN\u000ba\u0001\u0010:p_Rt\u0014\"\u0001-\n\u0007\u0005\u001dw+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u00131\u001a\u0006\u0004\u0003\u000f<\u0016\u0001\u00028pI\u0016,\"!!5\u0011\t\u0005M\u00171\u001c\b\u0005\u0003+\f9\u000eE\u0002\u0002>^K1!!7X\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\\Ap\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\\,\u0002\u000b9|G-\u001a\u0011\u0015\t\u0005\u0015\u0018q\u001d\t\u0006\u0003Ws\u0013Q\u0016\u0005\b\u0003\u001b\f\u0004\u0019AAi\u0003\u0011\u0019w\u000e]=\u0016\t\u00055\u00181\u001f\u000b\u0005\u0003_\f)\u0010E\u0003\u0002,:\n\t\u0010\u0005\u0003\u0002\u0006\u0005MHaBAIe\t\u0007\u00111\u0013\u0005\n\u0003\u001b\u0014\u0004\u0013!a\u0001\u0003#\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002|\u0006}XCAA\u007fU\u0011\t\t.a\u001c\u0005\u000f\u0005E5G1\u0001\u0002\u0014\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013QAAa\u0003\u0002X\u0005!A.\u00198h\u0013\u0011\tiN!\u0003\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\u0019\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001c\n]\u0001\u0002\u0003B\rm\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u0002\u0005\u0004\u0003\"\t\u001d\u00121T\u0007\u0003\u0005GQ1A!\nX\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005S\u0011\u0019C\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0018\u0005k\u00012A\u0016B\u0019\u0013\r\u0011\u0019d\u0016\u0002\b\u0005>|G.Z1o\u0011%\u0011I\u0002OA\u0001\u0002\u0004\tY*\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u0003\u0005wA\u0001B!\u0007:\u0003\u0003\u0005\rAZ\u0001\tQ\u0006\u001c\bnQ8eKR\ta-\u0001\u0005u_N#(/\u001b8h)\t\u0011)!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005_\u0011I\u0005C\u0005\u0003\u001aq\n\t\u00111\u0001\u0002\u001c\nYq+\u00197l\u001b\u0016\u001c8/Y4f+\u0011\u0011yE!\u0016\u0014\u0011E)&\u0011KAY\u0003o\u0003R!a+\u0011\u0005'\u0002B!!\u0002\u0003V\u00119\u0011\u0011S\tC\u0002\u0005M\u0015AB:pkJ\u001cW-\u0006\u0002\u0003T\u000591o\\;sG\u0016\u0004\u0013\u0001\u00027bgR\fQ\u0001\\1ti\u0002\n!B\\3jO\"\u0014w.\u001e:t+\t\u0011)\u0007E\u0003W\u0005O\u0012\u0019&C\u0002\u0003j]\u0013Q!\u0011:sCf\f1B\\3jO\"\u0014w.\u001e:tA\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\tE$q\u000fB*\u001b\t\u0011\u0019HC\u0002\u0003v]\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0003z\tM$\u0001C\"mCN\u001cH+Y4\u0015\u0011\tu$1\u0011BC\u0005\u000f#BAa \u0003\u0002B)\u00111V\t\u0003T!9!QN\rA\u0004\t=\u0004b\u0002B,3\u0001\u0007!1\u000b\u0005\b\u0005;J\u0002\u0019\u0001B*\u0011\u001d\u0011\t'\u0007a\u0001\u0005K*BAa#\u0003\u0014RA!Q\u0012BM\u00057\u0013i\n\u0006\u0003\u0003\u0010\nU\u0005#BAV#\tE\u0005\u0003BA\u0003\u0005'#q!!%\u001b\u0005\u0004\t\u0019\nC\u0004\u0003ni\u0001\u001dAa&\u0011\r\tE$q\u000fBI\u0011%\u00119F\u0007I\u0001\u0002\u0004\u0011\t\nC\u0005\u0003^i\u0001\n\u00111\u0001\u0003\u0012\"I!\u0011\r\u000e\u0011\u0002\u0003\u0007!q\u0014\t\u0006-\n\u001d$\u0011S\u000b\u0005\u0005G\u00139+\u0006\u0002\u0003&*\"!1KA8\t\u001d\t\tj\u0007b\u0001\u0003'\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0003$\n5FaBAI9\t\u0007\u00111S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011\u0019La.\u0016\u0005\tU&\u0006\u0002B3\u0003_\"q!!%\u001e\u0005\u0004\t\u0019\n\u0006\u0003\u0002\u001c\nm\u0006\u0002\u0003B\rA\u0005\u0005\t\u0019\u00014\u0015\t\t=\"q\u0018\u0005\n\u00053\u0011\u0013\u0011!a\u0001\u00037#BA!\u0002\u0003D\"A!\u0011D\u0012\u0002\u0002\u0003\u0007a\r\u0006\u0003\u00030\t\u001d\u0007\"\u0003B\rM\u0005\u0005\t\u0019AAN\u0003-9\u0016\r\\6NKN\u001c\u0018mZ3\u0011\u0007\u0005-\u0006f\u0005\u0003)+\u0006=CC\u0001Bf+\u0011\u0011\u0019Na7\u0015\u0011\tU'\u0011\u001dBr\u0005K$BAa6\u0003^B)\u00111V\t\u0003ZB!\u0011Q\u0001Bn\t\u001d\t\tj\u000bb\u0001\u0003'CqA!\u001c,\u0001\b\u0011y\u000e\u0005\u0004\u0003r\t]$\u0011\u001c\u0005\b\u0005/Z\u0003\u0019\u0001Bm\u0011\u001d\u0011if\u000ba\u0001\u00053DqA!\u0019,\u0001\u0004\u00119\u000fE\u0003W\u0005O\u0012I.A\u0004v]\u0006\u0004\b\u000f\\=\u0016\t\t5(Q \u000b\u0005\u0005_\u001c\t\u0001E\u0003W\u0005c\u0014)0C\u0002\u0003t^\u0013aa\u00149uS>t\u0007#\u0003,\u0003x\nm(1 B\u0000\u0013\r\u0011Ip\u0016\u0002\u0007)V\u0004H.Z\u001a\u0011\t\u0005\u0015!Q \u0003\b\u0003#c#\u0019AAJ!\u00151&q\rB~\u0011%\u0019\u0019\u0001LA\u0001\u0002\u0004\u0019)!A\u0002yIA\u0002R!a+\u0012\u0005w\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa\u0003\u0011\t\t\u001d1QB\u0005\u0005\u0007\u001f\u0011IA\u0001\u0004PE*,7\r^\u0001\r'R|'/Z'fgN\fw-\u001a\t\u0004\u0003Ws4\u0003\u0002 V\u0003\u001f\"\"aa\u0005\u0016\t\rm1\u0011\u0005\u000b\u0005\u0007;\u0019\u0019\u0003E\u0003\u0002,:\u001ay\u0002\u0005\u0003\u0002\u0006\r\u0005BaBAI\u0003\n\u0007\u00111\u0013\u0005\b\u0003\u001b\f\u0005\u0019AAi+\u0011\u00199c!\r\u0015\t\r%21\u0006\t\u0006-\nE\u0018\u0011\u001b\u0005\n\u0007\u0007\u0011\u0015\u0011!a\u0001\u0007[\u0001R!a+/\u0007_\u0001B!!\u0002\u00042\u00119\u0011\u0011\u0013\"C\u0002\u0005M\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a")
public class Node2VecWalk
implements Generic {
    private final int walkLength;
    private final double p;
    private final double q;
    private final Random rng;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static double $lessinit$greater$default$3() {
        return Node2VecWalk$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return Node2VecWalk$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$1() {
        return Node2VecWalk$.MODULE$.$lessinit$greater$default$1();
    }

    public static double apply$default$3() {
        return Node2VecWalk$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return Node2VecWalk$.MODULE$.apply$default$2();
    }

    public static int apply$default$1() {
        return Node2VecWalk$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    private Random rng() {
        return this.rng;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Node2VecWalk.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            Node2VecWalk.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        }, this.walkLength - 1, false).step((Function1 & Serializable)vertex -> {
            Node2VecWalk.$anonfun$apply$5(vertex);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        IndexedSeq steps = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.walkLength).map((Function1 & Serializable)x$1 -> Node2VecWalk.$anonfun$tabularise$1(BoxesRunTime.unboxToInt((Object)x$1)));
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Node2VecWalk.$anonfun$tabularise$2(steps, vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)steps);
    }

    public static final /* synthetic */ void $anonfun$apply$1(Node2VecWalk $this, Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("walk", ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{vertex.name(vertex.name$default$1())})));
        Object neighbours = vertex.outNeighbours().toArray(vertex.IDClassTag());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.genericArrayOps(neighbours))) {
            vertex.messageSelf(new WalkMessage<Object>(vertex.ID(), vertex.ID(), neighbours, vertex.IDClassTag()), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        } else {
            vertex.messageVertex(ScalaRunTime$.MODULE$.array_apply(neighbours, $this.rng().nextInt(ScalaRunTime$.MODULE$.array_length(neighbours))), new WalkMessage<Object>(vertex.ID(), vertex.ID(), neighbours, vertex.IDClassTag()), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ double $anonfun$apply$4(Node2VecWalk $this, Object last$1, Set lastNeighbourSet$1, Object n) {
        return BoxesRunTime.equals((Object)n, (Object)last$1) ? 1.0 / $this.p : (lastNeighbourSet$1.contains(n) ? 1.0 : 1.0 / $this.q);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Node2VecWalk $this, Vertex vertex) {
        vertex.messageQueue().foreach((Function1 & Serializable)x0$1 -> {
            Buffer buffer;
            Messages messages = x0$1;
            if (messages instanceof WalkMessage) {
                BoxedUnit boxedUnit;
                WalkMessage walkMessage = (WalkMessage)messages;
                Object source = walkMessage.source();
                Object last = walkMessage.last();
                Object lastNeighbours = walkMessage.neighbours();
                vertex.messageVertex(source, new StoreMessage(vertex.name(vertex.name$default$1())), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                Object neighbours = vertex.outNeighbours().toArray(vertex.IDClassTag());
                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.genericArrayOps(neighbours))) {
                    vertex.messageSelf(new WalkMessage<Object>(source, vertex.ID(), neighbours, vertex.IDClassTag()), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Set lastNeighbourSet = Predef$.MODULE$.genericWrapArray(lastNeighbours).toSet();
                    double[] weights = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(neighbours), (Function1 & Serializable)n -> BoxesRunTime.boxToDouble((double)Node2VecWalk.$anonfun$apply$4($this, last, lastNeighbourSet, n)), (ClassTag)ClassTag$.MODULE$.Double());
                    vertex.messageVertex(ScalaRunTime$.MODULE$.array_apply(neighbours, Sampling$WeightedSampling$.MODULE$.sample$extension(Sampling$.MODULE$.WeightedSampling($this.rng()), (Seq<Object>)package$.MODULE$.ArraySeq().unsafeWrapArray((Object)weights))), new WalkMessage<Object>(source, vertex.ID(), neighbours, vertex.IDClassTag()), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                    boxedUnit = BoxedUnit.UNIT;
                }
                buffer = boxedUnit;
            } else if (messages instanceof StoreMessage) {
                StoreMessage storeMessage = (StoreMessage)messages;
                String name = storeMessage.node();
                buffer = ((Buffer)((EntityVisitor)((Object)vertex)).getState("walk", ((EntityVisitor)((Object)vertex)).getState$default$2())).append((Object)name);
            } else {
                throw new MatchError((Object)messages);
            }
            return buffer;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$5(Vertex vertex) {
        vertex.messageQueue().foreach((Function1 & Serializable)x0$2 -> {
            BoxedUnit boxedUnit;
            Messages messages = x0$2;
            if (messages instanceof StoreMessage) {
                StoreMessage storeMessage = (StoreMessage)messages;
                String node = storeMessage.node();
                boxedUnit = ((Buffer)((EntityVisitor)((Object)vertex)).getState("walk", ((EntityVisitor)((Object)vertex)).getState$default$2())).append((Object)node);
            } else if (messages instanceof WalkMessage) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)messages);
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ String $anonfun$tabularise$1(int x$1) {
        return new StringBuilder(7).append("vertex ").append(x$1).toString();
    }

    public static final /* synthetic */ void $anonfun$tabularise$3(Vertex vertex$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String step = (String)tuple2._1();
        String node = (String)tuple2._2();
        ((EntityVisitor)((Object)vertex$3)).setState(step, node);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tabularise$2(IndexedSeq steps$1, Vertex vertex) {
        ((IterableOnceOps)steps$1.zip((IterableOnce)((EntityVisitor)((Object)vertex)).getState("walk", ((EntityVisitor)((Object)vertex)).getState$default$2()))).foreach((Function1 & Serializable)x0$1 -> {
            Node2VecWalk.$anonfun$tabularise$3(vertex, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Node2VecWalk(int walkLength, double p, double q) {
        this.walkLength = walkLength;
        this.p = p;
        this.q = q;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
        this.rng = new Random();
    }

    public static interface Messages<VertexID> {
    }

    public static class StoreMessage<VertexID>
    implements Messages<VertexID>,
    Product,
    Serializable {
        private final String node;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String node() {
            return this.node;
        }

        public <VertexID> StoreMessage<VertexID> copy(String node) {
            return new StoreMessage<VertexID>(node);
        }

        public <VertexID> String copy$default$1() {
            return this.node();
        }

        public String productPrefix() {
            return "StoreMessage";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.node();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StoreMessage;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "node";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StoreMessage)) return false;
            boolean bl = true;
            if (!bl) return false;
            StoreMessage storeMessage = (StoreMessage)x$1;
            String string = this.node();
            String string2 = storeMessage.node();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!storeMessage.canEqual(this)) return false;
            return true;
        }

        public StoreMessage(String node) {
            this.node = node;
            Product.$init$((Product)this);
        }
    }

    public static class WalkMessage<VertexID>
    implements Messages<VertexID>,
    Product,
    Serializable {
        private final VertexID source;
        private final VertexID last;
        private final Object neighbours;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public VertexID source() {
            return this.source;
        }

        public VertexID last() {
            return this.last;
        }

        public Object neighbours() {
            return this.neighbours;
        }

        public <VertexID> WalkMessage<VertexID> copy(VertexID source, VertexID last, Object neighbours, ClassTag<VertexID> evidence$1) {
            return new WalkMessage<VertexID>(source, last, neighbours, evidence$1);
        }

        public <VertexID> VertexID copy$default$1() {
            return this.source();
        }

        public <VertexID> VertexID copy$default$2() {
            return this.last();
        }

        public <VertexID> Object copy$default$3() {
            return this.neighbours();
        }

        public String productPrefix() {
            return "WalkMessage";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.source();
                    break;
                }
                case 1: {
                    object = this.last();
                    break;
                }
                case 2: {
                    object = this.neighbours();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WalkMessage;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "source";
                    break;
                }
                case 1: {
                    string = "last";
                    break;
                }
                case 2: {
                    string = "neighbours";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WalkMessage)) return false;
            boolean bl = true;
            if (!bl) return false;
            WalkMessage walkMessage = (WalkMessage)x$1;
            if (!BoxesRunTime.equals(this.source(), walkMessage.source())) return false;
            if (!BoxesRunTime.equals(this.last(), walkMessage.last())) return false;
            if (!BoxesRunTime.equals((Object)this.neighbours(), (Object)walkMessage.neighbours())) return false;
            if (!walkMessage.canEqual(this)) return false;
            return true;
        }

        public WalkMessage(VertexID source, VertexID last, Object neighbours, ClassTag<VertexID> evidence$1) {
            this.source = source;
            this.last = last;
            this.neighbours = neighbours;
            Product.$init$((Product)this);
        }
    }
}

