/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.dynamic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.dynamic.DiscreteSI$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`DiscreteSI(infectedNode: Iterable[String], infectionProbability: Double = 0.5, maxGenerations: Int = 100, seed:Long = -1)`\n  *    : discrete susceptible-infected (SI) model on the network\n  *\n  *  The network is treated as directed. An infected node propagates the infection along each\n  *  of its out-edges with probability `infectionProbability`. The propagation terminates once there are no newly infected\n  *  nodes or `maxGenerations` is reached. The initially infected seed nodes are considered generation 0.\n  *\n  * ## Parameters\n  *\n  *  {s}`infectedNode: Seq[String]`\n  *    : names of initially infected nodes\n  *\n  *  {s}`infectionProbability: Double = 0.5`\n  *    : probability of infection propagation along each edge\n  *\n  *  {s}`seed: Long`\n  *    : seed for random number generator (specify for deterministic results)\n  *\n  *  {s}`maxGenerations: Int = 100`\n  *    : maximum number of propagation generations\n  *\n  * ## States\n  *\n  *  {s}`infected: Boolean`\n  *    : infection status of vertex\n  *\n  *  {s}`generation: Int`\n  *    : generation at which vertex became infected (unset for vertices that were never infected)\n  *\n  * ## Returns\n  *\n  * | vertex name       | infection status       |\n  * | ----------------- | ---------------------- |\n  * | {s}`name: String` | {s}`infected: Boolean` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\n\u0014\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015I\u0005\u0001\"\u0011K\u000f\u0015Q7\u0003#\u0001l\r\u0015\u00112\u0003#\u0001m\u0011\u0015\t\u0005\u0002\"\u0001y\u0011\u0015I\u0005\u0002\"\u0001z\u0011%\t\t\u0002CI\u0001\n\u0003\t\u0019\u0002C\u0005\u0002*!\t\n\u0011\"\u0001\u0002,!I\u0011q\u0006\u0005\u0012\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003kA\u0011\u0013!C\u0001\u0003'A\u0011\"a\u000e\t#\u0003%\t!a\u000b\t\u0013\u0005e\u0002\"%A\u0005\u0002\u0005E\u0002\"CA\u001e\u0011\u0005\u0005I\u0011BA\u001f\u0005)!\u0015n]2sKR,7+\u0013\u0006\u0003)U\tq\u0001Z=oC6L7M\u0003\u0002\u0017/\u00059q-\u001a8fe&\u001c'B\u0001\r\u001a\u0003)\tGnZ8sSRDWn\u001d\u0006\u00035m\t\u0001B]1qQR|'/\u001f\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\u0005j\u0011!F\u0005\u0003EU\u0011\u0001BT8eK2K7\u000f^\u0001\u000eS:4Wm\u0019;fI:{G-Z:\u0011\u0007\u0015r\u0013G\u0004\u0002'YA\u0011qEK\u0007\u0002Q)\u0011\u0011&H\u0001\u0007yI|w\u000e\u001e \u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0003GA\u0002TKRT!!\f\u0016\u0011\u0005\u0015\u0012\u0014BA\u001a1\u0005\u0019\u0019FO]5oO\u0006!\u0012N\u001c4fGRLwN\u001c)s_\n\f'-\u001b7jif\u0004\"AN\u001c\u000e\u0003)J!\u0001\u000f\u0016\u0003\r\u0011{WO\u00197f\u00039i\u0017\r_$f]\u0016\u0014\u0018\r^5p]N\u0004\"AN\u001e\n\u0005qR#aA%oi\u0006!1/Z3e!\t1t(\u0003\u0002AU\t!Aj\u001c8h\u0003\u0019a\u0014N\\5u}Q)1)\u0012$H\u0011B\u0011A\tA\u0007\u0002'!)1%\u0002a\u0001I!9A'\u0002I\u0001\u0002\u0004)\u0004bB\u001d\u0006!\u0003\u0005\rA\u000f\u0005\b{\u0015\u0001\n\u00111\u0001?\u0003\u0015\t\u0007\u000f\u001d7z)\tYe\n\u0005\u0002M5:\u0011QJ\u0014\u0007\u0001\u0011\u0015ye\u00011\u0001Q\u0003\u00159'/\u00199i!\t\t\u0006,D\u0001S\u0015\t\u0019F+A\u0005he\u0006\u0004\bN^5fo*\u0011QKV\u0001\tC:\fG._:jg*\u0011q+G\u0001\u0004CBL\u0017BA-S\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002\\1\n)qI]1qQ\"\"\u0001!X4i!\tqV-D\u0001`\u0015\t\u0001\u0017-\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\t\u00117-A\u0004uC.,'p\\3\u000b\u0005\u0011\\\u0012AB4ji\",(-\u0003\u0002g?\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001j\u0003)\u001dtF\u000b\u0016\u000bA\u0001R\u0003e_:~A\u0012K7o\u0019:fi\u0016\u001c\u0016\nK5oM\u0016\u001cG/\u001a3O_\u0012,'\bI%uKJ\f'\r\\3\\'R\u0014\u0018N\\4^Y\u0001JgNZ3di&|g\u000e\u0015:pE\u0006\u0014\u0017\u000e\\5usj\u0002Ci\\;cY\u0016\u0004S\b\t\u0019/k1\u0002S.\u0019=HK:,'/\u0019;j_:\u001c(\bI%oi\u0002j\u0004%\r\u00191Y\u0001\u001aX-\u001a3;\u0019>tw\rI\u001f![EJ\u0003M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!I&\u001c8M]3uK\u0002\u001aXo]2faRL'\r\\3.S:4Wm\u0019;fI\u0002B3+S\u0015![>$W\r\u001c\u0011p]\u0002\"\b.\u001a\u0011oKR<xN]6\u000bA\u0001R#\u0002\t\u0011+A\u0001\"\u0006.\u001a\u0011oKR<xN]6!SN\u0004CO]3bi\u0016$\u0007%Y:!I&\u0014Xm\u0019;fI:\u0002\u0013I\u001c\u0011j]\u001a,7\r^3eA9|G-\u001a\u0011qe>\u0004\u0018mZ1uKN\u0004C\u000f[3!S:4Wm\u0019;j_:\u0004\u0013\r\\8oO\u0002*\u0017m\u00195\u000bA\u0001R\u0003\u0005I8gA%$8\u000fI8vi6*GmZ3tA]LG\u000f\u001b\u0011qe>\u0014\u0017MY5mSRL\b\u0005Y5oM\u0016\u001cG/[8o!J|'-\u00192jY&$\u0018\u0010\u0019\u0018!)\",\u0007\u0005\u001d:pa\u0006<\u0017\r^5p]\u0002\"XM]7j]\u0006$Xm\u001d\u0011p]\u000e,\u0007\u0005\u001e5fe\u0016\u0004\u0013M]3!]>\u0004c.Z<ms\u0002JgNZ3di\u0016$'\u0002\t\u0011+A\u0001rw\u000eZ3tA=\u0014\b\u0005Y7bq\u001e+g.\u001a:bi&|gn\u001d1!SN\u0004#/Z1dQ\u0016$g\u0006\t+iK\u0002Jg.\u001b;jC2d\u0017\u0010I5oM\u0016\u001cG/\u001a3!g\u0016,G\r\t8pI\u0016\u001c\b%\u0019:fA\r|gn]5eKJ,G\rI4f]\u0016\u0014\u0018\r^5p]\u0002\u0002dF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y5oM\u0016\u001cG/\u001a3O_\u0012,'\bI*fcn\u001bFO]5oOv\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011oC6,7\u000fI8gA%t\u0017\u000e^5bY2L\b%\u001b8gK\u000e$X\r\u001a\u0011o_\u0012,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u001b8gK\u000e$\u0018n\u001c8Qe>\u0014\u0017MY5mSRL(\b\t#pk\ndW\rI\u001f!a9*\u0004M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!aJ|'-\u00192jY&$\u0018\u0010I8gA%tg-Z2uS>t\u0007\u0005\u001d:pa\u0006<\u0017\r^5p]\u0002\nGn\u001c8hA\u0015\f7\r\u001b\u0011fI\u001e,'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u00047/Z3eu\u0001buN\\4a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u00023/Z3eA\u0019|'\u000f\t:b]\u0012|W\u000e\t8v[\n,'\u000fI4f]\u0016\u0014\u0018\r^8sA!\u001a\b/Z2jMf\u0004cm\u001c:!I\u0016$XM]7j]&\u001cH/[2!e\u0016\u001cX\u000f\u001c;tS)\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A6\f\u0007pR3oKJ\fG/[8ogj\u0002\u0013J\u001c;!{\u0001\n\u0004\u0007\r1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001j\u0017\r_5nk6\u0004c.^7cKJ\u0004sN\u001a\u0011qe>\u0004\u0018mZ1uS>t\u0007eZ3oKJ\fG/[8og*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y5oM\u0016\u001cG/\u001a3;A\t{w\u000e\\3b]\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI5oM\u0016\u001cG/[8oAM$\u0018\r^;tA=4\u0007E^3si\u0016D(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004w-\u001a8fe\u0006$\u0018n\u001c8;A%sG\u000f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A\u001d,g.\u001a:bi&|g\u000eI1uA]D\u0017n\u00195!m\u0016\u0014H/\u001a=!E\u0016\u001c\u0017-\\3!S:4Wm\u0019;fI\u0002BSO\\:fi\u00022wN\u001d\u0011wKJ$\u0018nY3tAQD\u0017\r\u001e\u0011xKJ,\u0007E\\3wKJ\u0004\u0013N\u001c4fGR,G-\u000b\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002#+\u001a;ve:\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t?!m\u0016\u0014H/\u001a=!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005 \u0011j]\u001a,7\r^5p]\u0002\u001aH/\u0019;vg\u0002\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5\u0002CP\u0003\u0011!U\u0001b\be_:~A:\fW.\u001a\u001e!'R\u0014\u0018N\\4aAq\u00043p]?aS:4Wm\u0019;fIj\u0002#i\\8mK\u0006t\u0007\r\t?\u000bA\u0001Rs&\u0001\u0006ESN\u001c'/\u001a;f'&\u0003\"\u0001\u0012\u0005\u0014\u0007!i\u0007\u000f\u0005\u00027]&\u0011qN\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018AA5p\u0015\u0005)\u0018\u0001\u00026bm\u0006L!a\u001e:\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003-$\u0002b\u0011>\u0002\f\u00055\u0011q\u0002\u0005\u0006w*\u0001\r\u0001`\u0001\rS:4Wm\u0019;fI:{G-\u001a\t\u0005{\u0006\u0015\u0011GD\u0002\u007f\u0003\u0003q!aJ@\n\u0003-J1!a\u0001+\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0002\u0002\n\tA\u0011\n^3sC\ndWMC\u0002\u0002\u0004)Bq\u0001\u000e\u0006\u0011\u0002\u0003\u0007Q\u0007C\u0004:\u0015A\u0005\t\u0019\u0001\u001e\t\u000fuR\u0001\u0013!a\u0001}\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0016)\u001aQ'a\u0006,\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\t+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\tiBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HeM\u000b\u0003\u0003[Q3AOA\f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TCAA\u001aU\rq\u0014qC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t;\u0002\t1\fgnZ\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0004PE*,7\r\u001e")
public class DiscreteSI
extends NodeList {
    private final Set<String> infectedNodes;
    private final double infectionProbability;
    private final int maxGenerations;
    private final long seed;

    public static long $lessinit$greater$default$4() {
        return DiscreteSI$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return DiscreteSI$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return DiscreteSI$.MODULE$.$lessinit$greater$default$2();
    }

    public static long apply$default$4() {
        return DiscreteSI$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return DiscreteSI$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return DiscreteSI$.MODULE$.apply$default$2();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        Random randomiser = this.seed != -1L ? new Random(this.seed) : new Random();
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            DiscreteSI.$anonfun$apply$1(this, randomiser, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            DiscreteSI.$anonfun$apply$3(this, randomiser, vertex);
            return BoxedUnit.UNIT;
        }, this.maxGenerations, true);
    }

    public static final /* synthetic */ void $anonfun$apply$2(DiscreteSI $this, Random randomiser$1, ConcreteEdge edge) {
        block0: {
            if (!((double)randomiser$1.nextFloat() < $this.infectionProbability)) break block0;
            edge.send(BoxesRunTime.boxToInteger((int)1));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(DiscreteSI $this, Random randomiser$1, Vertex vertex) {
        if ($this.infectedNodes.contains((Object)vertex.name(vertex.name$default$1()))) {
            ((EntityVisitor)((Object)vertex)).setState("infected", BoxesRunTime.boxToBoolean((boolean)true));
            ((EntityVisitor)((Object)vertex)).setState("generation", BoxesRunTime.boxToInteger((int)0));
            vertex.outEdges().foreach((Function1 & Serializable)edge -> {
                DiscreteSI.$anonfun$apply$2($this, randomiser$1, edge);
                return BoxedUnit.UNIT;
            });
        } else {
            ((EntityVisitor)((Object)vertex)).setState("infected", BoxesRunTime.boxToBoolean((boolean)false));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(DiscreteSI $this, Random randomiser$1, int generation$1, ConcreteEdge edge) {
        block0: {
            if (!((double)randomiser$1.nextFloat() < $this.infectionProbability)) break block0;
            edge.send(BoxesRunTime.boxToInteger((int)(generation$1 + 1)));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(DiscreteSI $this, Random randomiser$1, Vertex vertex) {
        boolean infected = BoxesRunTime.unboxToBoolean(((EntityVisitor)((Object)vertex)).getState("infected", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        if (infected) {
            vertex.voteToHalt();
        } else {
            int generation = BoxesRunTime.unboxToInt((Object)vertex.messageQueue().head());
            ((EntityVisitor)((Object)vertex)).setState("infected", BoxesRunTime.boxToBoolean((boolean)true));
            ((EntityVisitor)((Object)vertex)).setState("generation", BoxesRunTime.boxToInteger((int)generation));
            vertex.outEdges().foreach((Function1 & Serializable)edge -> {
                DiscreteSI.$anonfun$apply$4($this, randomiser$1, generation, edge);
                return BoxedUnit.UNIT;
            });
        }
    }

    public DiscreteSI(Set<String> infectedNodes, double infectionProbability, int maxGenerations, long seed) {
        this.infectedNodes = infectedNodes;
        this.infectionProbability = infectionProbability;
        this.maxGenerations = maxGenerations;
        this.seed = seed;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"infected"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

