/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.community;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.community.SLPA$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`SLPA(iterNumber: Int = 50, speakerRule: Rule = ChooseRandom(), listenerRule: Rule = MostCommon())`\n  *  : find overlapping communities using synchronous label propagation\n  *\n  * This returns the overlapping communities of the graph by a variant of the synchronous label propagation algorithm.\n  * In this algorithm, each node maintains a memory of labels. At each step, a vertex chooses a label from its memory\n  * to send to all its neighbours according to a Speaking Rule (defaults to choosing a label at random from memory).\n  * Then each vertex chooses a label from its received queue of labels to add to memory according to a Listening Rule\n  * (defaults to choosing the most commonly received label). Instead of converging based on some criterium, the\n  * labels a node \"remembers\" is stored and the algorithm terminates after a set number of iterations. At this point,\n  * Raphtory returns the name of each vertex and its memory of labels (the size of which is the number of iterations).\n  *\n  * ## Parameters\n  *\n  *  {s}`iterNumber: Int = 50`\n  *    : Number of iterations to run (default 50).\n  *\n  *  {s}`speakerRule: Rule = ChooseRandom()`\n  *    : rule for choosing label to propagate (default: ChooseRandom())\n  *\n  *  {s}`listenerRule: Rule = MostCommon()`\n  *    : rule for choosing label to add to mem (default: MostCommon())\n  *\n  * ## States\n  *\n  *  {s}`memory: Queue[Long]`\n  *    : memory of labels\n  *\n  * ## Returns\n  *\n  *  | vertex name       | label memory             |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`name: String` | {s}`memory: Array[Long]` |\n  *\n  * ## Rules\n  *\n  * {s}`Fifo()`\n  *  : Return labels in first-in-first-out order\n  *\n  * {s}`MostCommon()`\n  *  : Return most common label\n  *\n  * {s}`ChooseRandom()`\n  *  : Sample label at random from list of labels\n  *\n  *  ```{note}\n  *  This implementation is based on the paper SLPA: Uncovering Overlapping Communities in Social Networks via A\n  *  Speaker-listener Interaction Dynamic Process by Jierui Xie, Boleslaw K. Szymanski and Xiaoming Liu (2011)\n  *  ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\rea\u0001B+W\u0001\u0005D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"I!q\r\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\b\u0003K\u0001A\u0011\u0001Be\u0011\u001d\tI\u0003\u0001C!\u0005#DqAa;\u0001\t\u0003\u0012ioB\u0004\u0002\u000eYC\t!a\u0004\u0007\rU3\u0006\u0012AA\n\u0011\u001d\t)\u0003\u0003C\u0001\u0003OAq!!\u000b\t\t\u0003\tY\u0003C\u0005\u0003j!\t\n\u0011\"\u0001\u0003l!I!q\u000e\u0005\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005kB\u0011\u0013!C\u0001\u0005c2\u0011\"a\u000e\t!\u0003\r\n#!\u000f\t\u000f\u0005mbB\"\u0001\u0002>\u00191!Q\u0004\u0005A\u0005?Aq!!\n\u0011\t\u0003\u0011\t\u0003C\u0004\u0002<A!\tE!\n\t\u0013\u0005]\u0006#!A\u0005\u0002\t\u0005\u0002\"CAk!\u0005\u0005I\u0011IAl\u0011%\t)\u000fEA\u0001\n\u0003\t9\u000fC\u0005\u0002jB\t\t\u0011\"\u0001\u00032!I\u0011\u0011\u001f\t\u0002\u0002\u0013\u0005\u00131\u001f\u0005\n\u0003{\u0004\u0012\u0011!C\u0001\u0005kA\u0011B!\u0003\u0011\u0003\u0003%\tE!\u000f\t\u0013\t=\u0001#!A\u0005B\tE\u0001\"\u0003B\n!\u0005\u0005I\u0011\tB\u000b\u0011%\u00119\u0002EA\u0001\n\u0003\u0012idB\u0005\u0003x!\t\t\u0011#\u0001\u0003z\u0019I!Q\u0004\u0005\u0002\u0002#\u0005!1\u0010\u0005\b\u0003KqB\u0011\u0001BE\u0011%\u0011\u0019BHA\u0001\n\u000b\u0012)\u0002C\u0005\u0002*y\t\t\u0011\"!\u0003\"!I!1\u0012\u0010\u0002\u0002\u0013\u0005%Q\u0012\u0005\n\u0005's\u0012\u0011!C\u0005\u0005+3aA!\u0011\t\u0001\n\r\u0003bBA\u0013I\u0011\u0005!Q\t\u0005\b\u0003w!C\u0011\tB%\u0011%\t9\fJA\u0001\n\u0003\u0011)\u0005C\u0005\u0002V\u0012\n\t\u0011\"\u0011\u0002X\"I\u0011Q\u001d\u0013\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003S$\u0013\u0011!C\u0001\u0005+B\u0011\"!=%\u0003\u0003%\t%a=\t\u0013\u0005uH%!A\u0005\u0002\te\u0003\"\u0003B\u0005I\u0005\u0005I\u0011\tB/\u0011%\u0011y\u0001JA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\u0014\u0011\n\t\u0011\"\u0011\u0003\u0016!I!q\u0003\u0013\u0002\u0002\u0013\u0005#\u0011M\u0004\n\u0005;C\u0011\u0011!E\u0001\u0005?3\u0011B!\u0011\t\u0003\u0003E\tA!)\t\u000f\u0005\u0015\"\u0007\"\u0001\u0003&\"I!1\u0003\u001a\u0002\u0002\u0013\u0015#Q\u0003\u0005\n\u0003S\u0011\u0014\u0011!CA\u0005\u000bB\u0011Ba#3\u0003\u0003%\tIa*\t\u0013\tM%'!A\u0005\n\tUeABA7\u0011\u0001\u000by\u0007\u0003\u0006\u0002\bb\u0012)\u001a!C\u0001\u0003\u0013C!\"!%9\u0005#\u0005\u000b\u0011BAF\u0011\u001d\t)\u0003\u000fC\u0001\u0003'C\u0011\"!'9\u0005\u0004%\t!a'\t\u0011\u0005%\u0006\b)A\u0005\u0003;Cq!a\u000f9\t\u0003\nY\u000bC\u0005\u00028b\n\t\u0011\"\u0001\u0002:\"I\u0011Q\u0018\u001d\u0012\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003+D\u0014\u0011!C!\u0003/D\u0011\"!:9\u0003\u0003%\t!a:\t\u0013\u0005%\b(!A\u0005\u0002\u0005-\b\"CAyq\u0005\u0005I\u0011IAz\u0011%\ti\u0010OA\u0001\n\u0003\ty\u0010C\u0005\u0003\na\n\t\u0011\"\u0011\u0003\f!I!q\u0002\u001d\u0002\u0002\u0013\u0005#\u0011\u0003\u0005\n\u0005'A\u0014\u0011!C!\u0005+A\u0011Ba\u00069\u0003\u0003%\tE!\u0007\b\u0013\t-\u0006\"!A\t\u0002\t5f!CA7\u0011\u0005\u0005\t\u0012\u0001BX\u0011\u001d\t)c\u0013C\u0001\u0005oC\u0011Ba\u0005L\u0003\u0003%)E!\u0006\t\u0013\u0005%2*!A\u0005\u0002\ne\u0006\"\u0003B5\u0017F\u0005I\u0011AA`\u0011%\u0011YiSA\u0001\n\u0003\u0013i\fC\u0005\u0003H.\u000b\n\u0011\"\u0001\u0002@\"I!1S&\u0002\u0002\u0013%!Q\u0013\u0005\n\u0005\u000fD\u0011\u0013!C\u0001\u0005WB\u0011Ba%\t\u0003\u0003%IA!&\u0003\tMc\u0005+\u0011\u0006\u0003/b\u000b\u0011bY8n[Vt\u0017\u000e^=\u000b\u0005eS\u0016aB4f]\u0016\u0014\u0018n\u0019\u0006\u00037r\u000b!\"\u00197h_JLG\u000f[7t\u0015\tif,\u0001\u0005sCBDGo\u001c:z\u0015\u0005y\u0016aA2p[\u000e\u00011c\u0001\u0001cQB\u00111MZ\u0007\u0002I*\tQ-A\u0003tG\u0006d\u0017-\u0003\u0002hI\n1\u0011I\\=SK\u001a\u0004\"!\u001b9\u000e\u0003)T!a\u001b7\u0002\u0013\u0005dwm\u001c:ji\"l'BA7o\u0003!\tg.\u00197zg&\u001c(BA8]\u0003\r\t\u0007/[\u0005\u0003c*\u0014qaR3oKJL7-\u0001\u0006ji\u0016\u0014h*^7cKJ\u0004\"a\u0019;\n\u0005U$'aA%oi\u0006Y1\u000f]3bW\u0016\u0014(+\u001e7f!\tAhB\u0004\u0002z\u000f9\u0019!0a\u0003\u000f\u0007m\fIAD\u0002}\u0003\u000fq1!`A\u0003\u001d\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u00011\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0016BA/_\u0013\tYF,\u0003\u0002Z5&\u0011q\u000bW\u0001\u0005'2\u0003\u0016\tE\u0002\u0002\u0012!i\u0011AV\n\u0005\u0011\t\f)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0005%|'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005=\u0011!B1qa2LH\u0003CA\u0017\u0003_\t\tD!\u001a\u0011\u0007\u0005E\u0001\u0001C\u0004s\u0015A\u0005\t\u0019A:\t\u0011YT\u0001\u0013!a\u0001\u0003g\u00012!!\u000e\u000f\u001b\u0005A!\u0001\u0002*vY\u0016\u001c\"A\u00042\u0002\u0017\rDwn\\:f\u0019\u0006\u0014W\r\\\u000b\u0005\u0003\u007f\t)\u0005\u0006\u0003\u0002B\u0005]\u0003\u0003BA\"\u0003\u000bb\u0001\u0001B\u0004\u0002H=\u0011\r!!\u0013\u0003\u0011Y+'\u000f^3y\u0013\u0012\u000bB!a\u0013\u0002RA\u00191-!\u0014\n\u0007\u0005=CMA\u0004O_RD\u0017N\\4\u0011\u0007\r\f\u0019&C\u0002\u0002V\u0011\u00141!\u00118z\u0011\u001d\tIf\u0004a\u0001\u00037\na\u0001\\1cK2\u001c\bCBA/\u0003O\n\t%\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u001diW\u000f^1cY\u0016T1!!\u001ae\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\nyFA\u0003Rk\u0016,X-\u000b\u0003\u000fqA!#\u0001D\"i_>\u001cXMU1oI>l7\u0003\u0003\u001dc\u0003g\t\t(a\u001e\u0011\u0007\r\f\u0019(C\u0002\u0002v\u0011\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002z\u0005\re\u0002BA>\u0003\u007fr1A`A?\u0013\u0005)\u0017bAAAI\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003\u000bS1!!!e\u0003\u0011\u0019X-\u001a3\u0016\u0005\u0005-\u0005cA2\u0002\u000e&\u0019\u0011q\u00123\u0003\t1{gnZ\u0001\u0006g\u0016,G\r\t\u000b\u0005\u0003+\u000b9\nE\u0002\u00026aB\u0011\"a\"<!\u0003\u0005\r!a#\u0002\u0007ItG-\u0006\u0002\u0002\u001eB!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$\u0012\fA!\u001e;jY&!\u0011qUAQ\u0005\u0019\u0011\u0016M\u001c3p[\u0006!!O\u001c3!+\u0011\ti+!-\u0015\t\u0005=\u00161\u0017\t\u0005\u0003\u0007\n\t\fB\u0004\u0002Hy\u0012\r!!\u0013\t\u000f\u0005ec\b1\u0001\u00026B1\u0011QLA4\u0003_\u000bAaY8qsR!\u0011QSA^\u0011%\t9i\u0010I\u0001\u0002\u0004\tY)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005'\u0006BAF\u0003\u0007\\#!!2\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001f$\u0017AC1o]>$\u0018\r^5p]&!\u00111[Ae\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0007\u0003BAn\u0003Cl!!!8\u000b\t\u0005}\u0017QD\u0001\u0005Y\u0006tw-\u0003\u0003\u0002d\u0006u'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001t\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0015\u0002n\"A\u0011q^\"\u0002\u0002\u0003\u00071/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0004b!a>\u0002z\u0006ESBAA2\u0013\u0011\tY0a\u0019\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0003\u00119\u0001E\u0002d\u0005\u0007I1A!\u0002e\u0005\u001d\u0011un\u001c7fC:D\u0011\"a<F\u0003\u0003\u0005\r!!\u0015\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00033\u0014i\u0001\u0003\u0005\u0002p\u001a\u000b\t\u00111\u0001t\u0003!A\u0017m\u001d5D_\u0012,G#A:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!7\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tAa\u0007\t\u0013\u0005=\u0018*!AA\u0002\u0005E#\u0001\u0002$jM>\u001c\u0002\u0002\u00052\u00024\u0005E\u0014q\u000f\u000b\u0003\u0005G\u00012!!\u000e\u0011+\u0011\u00119Ca\u000b\u0015\t\t%\"Q\u0006\t\u0005\u0003\u0007\u0012Y\u0003B\u0004\u0002HI\u0011\r!!\u0013\t\u000f\u0005e#\u00031\u0001\u00030A1\u0011QLA4\u0005S!B!!\u0015\u00034!A\u0011q\u001e\f\u0002\u0002\u0003\u00071\u000f\u0006\u0003\u0003\u0002\t]\u0002\"CAx1\u0005\u0005\t\u0019AA))\u0011\tINa\u000f\t\u0011\u0005=\u0018$!AA\u0002M$BA!\u0001\u0003@!I\u0011q\u001e\u000f\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0002\u000b\u001b>\u001cHoQ8n[>t7\u0003\u0003\u0013c\u0003g\t\t(a\u001e\u0015\u0005\t\u001d\u0003cAA\u001bIU!!1\nB()\u0011\u0011iE!\u0015\u0011\t\u0005\r#q\n\u0003\b\u0003\u000f2#\u0019AA%\u0011\u001d\tIF\na\u0001\u0005'\u0002b!!\u0018\u0002h\t5C\u0003BA)\u0005/B\u0001\"a<+\u0003\u0003\u0005\ra\u001d\u000b\u0005\u0005\u0003\u0011Y\u0006C\u0005\u0002p2\n\t\u00111\u0001\u0002RQ!\u0011\u0011\u001cB0\u0011!\ty/LA\u0001\u0002\u0004\u0019H\u0003\u0002B\u0001\u0005GB\u0011\"a<1\u0003\u0003\u0005\r!!\u0015\t\u0013\t\u001d$\u0002%AA\u0002\u0005M\u0012\u0001\u00047jgR,g.\u001a:Sk2,\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5$fA:\u0002D\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0003t)\"\u00111GAb\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0002$jM>\u00042!!\u000e\u001f'\u0015q\"QPA\u000b!\u0019\u0011yH!\"\u0003$5\u0011!\u0011\u0011\u0006\u0004\u0005\u0007#\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005\u000f\u0013\tIA\tBEN$(/Y2u\rVt7\r^5p]B\"\"A!\u001f\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0001BH\u0011%\u0011\tJIA\u0001\u0002\u0004\u0011\u0019#A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa&\u0011\t\u0005m'\u0011T\u0005\u0005\u00057\u000biN\u0001\u0004PE*,7\r^\u0001\u000b\u001b>\u001cHoQ8n[>t\u0007cAA\u001beM)!Ga)\u0002\u0016A1!q\u0010BC\u0005\u000f\"\"Aa(\u0015\t\t\u0005!\u0011\u0016\u0005\n\u0005#3\u0014\u0011!a\u0001\u0005\u000f\nAb\u00115p_N,'+\u00198e_6\u00042!!\u000eL'\u0015Y%\u0011WA\u000b!!\u0011yHa-\u0002\f\u0006U\u0015\u0002\u0002B[\u0005\u0003\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011i\u000b\u0006\u0003\u0002\u0016\nm\u0006\"CAD\u001dB\u0005\t\u0019AAF)\u0011\u0011yL!2\u0011\u000b\r\u0014\t-a#\n\u0007\t\rGM\u0001\u0004PaRLwN\u001c\u0005\n\u0005#\u0003\u0016\u0011!a\u0001\u0003+\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nD\u0003CA\u0017\u0005\u0017\u0014iMa4\t\u000fI$\u0001\u0013!a\u0001g\")a\u000f\u0002a\u0001o\"1!q\r\u0003A\u0002]$BAa5\u0003XB!!Q\u001bBt\u001d\u0011\t\u0019Ea6\t\u000f\teW\u00011\u0001\u0003\\\u0006)qM]1qQB!!Q\u001cBr\u001b\t\u0011yNC\u0002\u0003b2\f\u0011b\u001a:ba\"4\u0018.Z<\n\t\t\u0015(q\u001c\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016LAA!;\u0003d\n)qI]1qQ\u0006QA/\u00192vY\u0006\u0014\u0018n]3\u0015\t\t=(1 \t\u0005\u0005c\u001490\u0004\u0002\u0003t*\u0019!Q\u001f7\u0002\u000bQ\f'\r\\3\n\t\te(1\u001f\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u000534\u0001\u0019\u0001BnQ\u001d\u0001!q`B\n\u0007+\u0001Ba!\u0001\u0004\u00105\u001111\u0001\u0006\u0005\u0007\u000b\u00199!\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\u0019Iaa\u0003\u0002\u000fQ\f7.\u001a>pK*\u00191Q\u00020\u0002\r\u001dLG\u000f[;c\u0013\u0011\u0019\tba\u0001\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#aa\u0006\u0002!Gz#F\u000b\u0006!A)\u00023p]?a'2\u0003\u0016\tK5uKJtU/\u001c2fej\u0002\u0013J\u001c;!{\u0001*\u0004\u0007\f\u0011ta\u0016\f7.\u001a:Sk2,'\b\t*vY\u0016\u0004S\bI\"i_>\u001cXMU1oI>l\u0007&\u000b\u0017!Y&\u001cH/\u001a8feJ+H.\u001a\u001e!%VdW\rI\u001f!\u001b>\u001cHoQ8n[>t\u0007&K\u0015a\u0015\u0001\u0002#\u0006\t\u0011;A\u0019Lg\u000e\u001a\u0011pm\u0016\u0014H.\u00199qS:<\u0007eY8n[Vt\u0017\u000e^5fg\u0002*8/\u001b8hAMLhn\u00195s_:|Wo\u001d\u0011mC\n,G\u000e\t9s_B\fw-\u0019;j_:T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00165jg\u0002\u0012X\r^;s]N\u0004C\u000f[3!_Z,'\u000f\\1qa&tw\rI2p[6,h.\u001b;jKN\u0004sN\u001a\u0011uQ\u0016\u0004sM]1qQ\u0002\u0012\u0017\u0010I1!m\u0006\u0014\u0018.\u00198uA=4\u0007\u0005\u001e5fAMLhn\u00195s_:|Wo\u001d\u0011mC\n,G\u000e\t9s_B\fw-\u0019;j_:\u0004\u0013\r\\4pe&$\b.\u001c\u0018\u000bA\u0001R\u0003%\u00138!i\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nY\u0001*\u0017m\u00195!]>$W\rI7bS:$\u0018-\u001b8tA\u0005\u0004S.Z7pef\u0004sN\u001a\u0011mC\n,Gn\u001d\u0018!\u0003R\u0004S-Y2iAM$X\r\u001d\u0017!C\u00022XM\u001d;fq\u0002\u001a\u0007n\\8tKN\u0004\u0013\r\t7bE\u0016d\u0007E\u001a:p[\u0002JGo\u001d\u0011nK6|'/\u001f\u0006!A)\u0002Co\u001c\u0011tK:$\u0007\u0005^8!C2d\u0007%\u001b;tA9,\u0017n\u001a5c_V\u00148\u000fI1dG>\u0014H-\u001b8hAQ|\u0007%\u0019\u0011Ta\u0016\f7.\u001b8hAI+H.\u001a\u0011)I\u00164\u0017-\u001e7ug\u0002\"x\u000eI2i_>\u001c\u0018N\\4!C\u0002b\u0017MY3mA\u0005$\bE]1oI>l\u0007E\u001a:p[\u0002jW-\\8ss&r#\u0002\t\u0011+AQCWM\u001c\u0011fC\u000eD\u0007E^3si\u0016D\be\u00195p_N,7\u000fI1!Y\u0006\u0014W\r\u001c\u0011ge>l\u0007%\u001b;tAI,7-Z5wK\u0012\u0004\u0013/^3vK\u0002zg\r\t7bE\u0016d7\u000f\t;pA\u0005$G\r\t;pA5,Wn\u001c:zA\u0005\u001c7m\u001c:eS:<\u0007\u0005^8!C\u0002b\u0015n\u001d;f]&tw\r\t*vY\u0016T\u0001\u0005\t\u0016!Q\u0011,g-Y;miN\u0004Co\u001c\u0011dQ>|7/\u001b8hAQDW\rI7pgR\u00043m\\7n_:d\u0017\u0010\t:fG\u0016Lg/\u001a3!Y\u0006\u0014W\r\\\u0015/A%s7\u000f^3bI\u0002zg\rI2p]Z,'oZ5oO\u0002\u0012\u0017m]3eA=t\u0007e]8nK\u0002\u001a'/\u001b;fe&,X\u000e\f\u0011uQ\u0016T\u0001\u0005\t\u0016!Y\u0006\u0014W\r\\:!C\u0002rw\u000eZ3!EI,W.Z7cKJ\u001c(\u0005I5tAM$xN]3eA\u0005tG\r\t;iK\u0002\nGnZ8sSRDW\u000e\t;fe6Lg.\u0019;fg\u0002\ng\r^3sA\u0005\u00043/\u001a;!]Vl'-\u001a:!_\u001a\u0004\u0013\u000e^3sCRLwN\\:/A\u0005#\b\u0005\u001e5jg\u0002\u0002x.\u001b8uY)\u0001\u0003E\u000b\u0011SCBDGo\u001c:zAI,G/\u001e:og\u0002\"\b.\u001a\u0011oC6,\u0007e\u001c4!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010I1oI\u0002JGo\u001d\u0011nK6|'/\u001f\u0011pM\u0002b\u0017MY3mg\u0002BC\u000f[3!g&TX\rI8gA]D\u0017n\u00195!SN\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004\u0013\u000e^3sCRLwN\\:*])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011QCJ\fW.\u001a;feNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002LG/\u001a:Ok6\u0014WM\u001d\u001e!\u0013:$\b%\u0010\u00116a\u0001T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t(v[\n,'\u000fI8gA%$XM]1uS>t7\u000f\t;pAI,h\u000e\t\u0015eK\u001a\fW\u000f\u001c;!kAJcF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\bm\u001d9fC.,'OU;mKj\u0002#+\u001e7fAu\u00023\t[8pg\u0016\u0014\u0016M\u001c3p[\"J\u0003M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!eVdW\r\t4pe\u0002\u001a\u0007n\\8tS:<\u0007\u0005\\1cK2\u0004Co\u001c\u0011qe>\u0004\u0018mZ1uK\u0002BC-\u001a4bk2$(\bI\"i_>\u001cXMU1oI>l\u0007&K\u0015\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1mSN$XM\\3s%VdWM\u000f\u0011Sk2,\u0007%\u0010\u0011N_N$8i\\7n_:D\u0013\u0006\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AI,H.\u001a\u0011g_J\u00043\r[8pg&tw\r\t7bE\u0016d\u0007\u0005^8!C\u0012$\u0007\u0005^8![\u0016l\u0007\u0005\u000b3fM\u0006,H\u000e\u001e\u001e!\u001b>\u001cHoQ8n[>t\u0007&K\u0015\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003e\u0015;bi\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004W.Z7pefT\u0004%U;fk\u0016\\Fj\u001c8h;\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI7f[>\u0014\u0018\u0010I8gA1\f'-\u001a7t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002b\u0017MY3mA5,Wn\u001c:zA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002lW-\\8ssj\u0002\u0013I\u001d:bsncuN\\4^A\u0002b(\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+H.Z:\u000bA\u0001R#\u0002\t\u0011+Am\u001cX\u0010\u0019$jM>D\u0013\u0006\u0019\u0006!A)\u0002\u0003E\u000f\u0011SKR,(O\u001c\u0011mC\n,Gn\u001d\u0011j]\u00022\u0017N]:u[%tWFZ5sgRls.\u001e;!_J$WM\u001d\u0006!A)R\u0001\u0005\t\u0016!wNl\b-T8ti\u000e{W.\\8oQ%\u0002'\u0002\t\u0011+A\u0001R\u0004EU3ukJt\u0007%\\8ti\u0002\u001aw.\\7p]\u0002b\u0017MY3m\u0015\u0001\u0002#F\u0003\u0011!U\u0001Z8/ 1DQ>|7/\u001a*b]\u0012|W\u000eK\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AM\u000bW\u000e\u001d7fA1\f'-\u001a7!CR\u0004#/\u00198e_6\u0004cM]8nA1L7\u000f\u001e\u0011pM\u0002b\u0017MY3mg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005\u00191aw:|G/Z?\u000bA\u0001R\u0003\u0005\t+iSN\u0004\u0013.\u001c9mK6,g\u000e^1uS>t\u0007%[:!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011qCB,'\u000fI*M!\u0006S\u0004%\u00168d_Z,'/\u001b8hA=3XM\u001d7baBLgn\u001a\u0011D_6lWO\\5uS\u0016\u001c\b%\u001b8!'>\u001c\u0017.\u00197!\u001d\u0016$xo\u001c:lg\u00022\u0018.\u0019\u0011B\u0015\u0001\u0002#\u0006\t\u0011Ta\u0016\f7.\u001a:.Y&\u001cH/\u001a8fe\u0002Je\u000e^3sC\u000e$\u0018n\u001c8!\tft\u0017-\\5dAA\u0013xnY3tg\u0002\u0012\u0017\u0010\t&jKJ,\u0018\u000e\t-jK2\u0002#i\u001c7fg2\fw\u000fI&/AMS\u00180\\1og.L\u0007%\u00198eAaK\u0017m\\7j]\u001e\u0004C*[;!QI\u0002\u0014'M\u0015\u000bA\u0001R\u0003\u0005\t1aA*\u0001\u0003EK\u0018")
public class SLPA
implements Generic {
    private final int iterNumber;
    private final Rule speakerRule;
    private final Rule listenerRule;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static int $lessinit$greater$default$1() {
        return SLPA$.MODULE$.$lessinit$greater$default$1();
    }

    public static Rule apply$default$3() {
        return SLPA$.MODULE$.apply$default$3();
    }

    public static Rule apply$default$2() {
        return SLPA$.MODULE$.apply$default$2();
    }

    public static int apply$default$1() {
        return SLPA$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ConcreteGraphPerspective qual$1 = graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            SLPA.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            SLPA.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = this.iterNumber;
        return qual$1.iterate(x$1, x$3, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            SLPA.$anonfun$tabularise$1(vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "memory"}));
    }

    public static final /* synthetic */ void $anonfun$apply$1(SLPA $this, Vertex vertex) {
        Queue memory = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.ID()}));
        ((EntityVisitor)((Object)vertex)).setState("memory", memory);
        Object message = $this.speakerRule.chooseLabel(memory);
        vertex.messageAllNeighbours(message, vertex.provider());
    }

    public static final /* synthetic */ void $anonfun$apply$2(SLPA $this, Vertex vertex) {
        Object newlab = $this.listenerRule.chooseLabel((Queue)Queue$.MODULE$.apply(vertex.messageQueue()));
        Queue memory = (Queue)((EntityVisitor)((Object)vertex)).getState("memory", ((EntityVisitor)((Object)vertex)).getState$default$2());
        memory.$plus$eq(newlab);
        Object message = $this.speakerRule.chooseLabel(memory);
        vertex.messageAllNeighbours(message, vertex.provider());
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("name", vertex.name(vertex.name$default$1()));
    }

    public SLPA(int iterNumber, Rule speakerRule, Rule listenerRule) {
        this.iterNumber = iterNumber;
        this.speakerRule = speakerRule;
        this.listenerRule = listenerRule;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }

    public static class ChooseRandom
    implements Rule,
    Product,
    Serializable {
        private final long seed;
        private final Random rnd;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long seed() {
            return this.seed;
        }

        public Random rnd() {
            return this.rnd;
        }

        @Override
        public <VertexID> VertexID chooseLabel(Queue<VertexID> labels) {
            List asList = labels.toList();
            return (VertexID)asList.apply(this.rnd().nextInt(labels.size()));
        }

        public ChooseRandom copy(long seed) {
            return new ChooseRandom(seed);
        }

        public long copy$default$1() {
            return this.seed();
        }

        public String productPrefix() {
            return "ChooseRandom";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.seed());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ChooseRandom;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "seed";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seed()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ChooseRandom)) return false;
            boolean bl = true;
            if (!bl) return false;
            ChooseRandom chooseRandom = (ChooseRandom)x$1;
            if (this.seed() != chooseRandom.seed()) return false;
            if (!chooseRandom.canEqual(this)) return false;
            return true;
        }

        public ChooseRandom(long seed) {
            this.seed = seed;
            Product.$init$((Product)this);
            this.rnd = seed == -1L ? new Random() : new Random(seed);
        }
    }

    public static class Fifo
    implements Rule,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public <VertexID> VertexID chooseLabel(Queue<VertexID> labels) {
            return (VertexID)labels.dequeue();
        }

        public Fifo copy() {
            return new Fifo();
        }

        public String productPrefix() {
            return "Fifo";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Fifo;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof Fifo;
            return bl && ((Fifo)x$1).canEqual(this);
        }

        public Fifo() {
            Product.$init$((Product)this);
        }
    }

    public static class MostCommon
    implements Rule,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public <VertexID> VertexID chooseLabel(Queue<VertexID> labels) {
            return (VertexID)((Tuple2)labels.groupBy((Function1 & Serializable)x -> Predef$.MODULE$.identity(x)).view().mapValues((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).maxBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
        }

        public MostCommon copy() {
            return new MostCommon();
        }

        public String productPrefix() {
            return "MostCommon";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MostCommon;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MostCommon;
            return bl && ((MostCommon)x$1).canEqual(this);
        }

        public MostCommon() {
            Product.$init$((Product)this);
        }
    }

    public static interface Rule {
        public <VertexID> VertexID chooseLabel(Queue<VertexID> var1);
    }
}

