/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.centrality.AverageNeighbourDegree$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`AverageNeighbourDegree()`\n  *  : Compute the average degree of a vertex's neighbours\n  *\n  *  ```{note}\n  *  This algorithm treats the network as undirected.\n  *  ```\n  *\n  * ## States\n  *\n  *  {s}`avgNeighbourDegree: Double`\n  *    : Average degree of the vertex's neighbours\n  *\n  * ## Returns\n  *\n  *  | vertex name       | average neighbour degree     |\n  *  | ----------------- | ---------------------------- |\n  *  | {s}`name: String` | `avgNeighbourDegree: Double` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u001d;Q!\u0002\u0004\t\u0002E1Qa\u0005\u0004\t\u0002QAQ!G\u0001\u0005\u0002iAQaG\u0001\u0005BqAqAL\u0001\u0002\u0002\u0013%q&\u0001\fBm\u0016\u0014\u0018mZ3OK&<\u0007NY8ve\u0012+wM]3f\u0015\t9\u0001\"\u0001\u0006dK:$(/\u00197jifT!!\u0003\u0006\u0002\u000f\u001d,g.\u001a:jG*\u00111\u0002D\u0001\u000bC2<wN]5uQ6\u001c(BA\u0007\u000f\u0003!\u0011\u0018\r\u001d5u_JL(\"A\b\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005I\tQ\"\u0001\u0004\u0003-\u00053XM]1hK:+\u0017n\u001a5c_V\u0014H)Z4sK\u0016\u001c\"!A\u000b\u0011\u0005Y9R\"\u0001\u0005\n\u0005aA!\u0001\u0003(pI\u0016d\u0015n\u001d;\u0002\rqJg.\u001b;?)\u0005\t\u0012!B1qa2LHCA\u000f!!\tqBF\u0004\u0002 A1\u0001\u0001\"B\u0011\u0004\u0001\u0004\u0011\u0013!B4sCBD\u0007CA\u0012+\u001b\u0005!#BA\u0013'\u0003%9'/\u00199im&,wO\u0003\u0002(Q\u0005A\u0011M\\1msNL7O\u0003\u0002*\u0019\u0005\u0019\u0011\r]5\n\u0005-\"#\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\ti#FA\u0003He\u0006\u0004\b.\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u00011!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0003mC:<'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oI\u0012aa\u00142kK\u000e$\b\u0006B\u0001:\u0007\u0012\u0003\"AO!\u000e\u0003mR!\u0001P\u001f\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!AP \u0002\u000fQ\f7.\u001a>pK*\u0011\u0001ID\u0001\u0007O&$\b.\u001e2\n\u0005\t[$\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003\u0015\u000b1Q[\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004\u0017I^3sC\u001e,g*Z5hQ\n|WO\u001d#fOJ,W\rK\u0015a\u0015\u0001\u0002#\u0006\t\u0011;A\r{W\u000e];uK\u0002\"\b.\u001a\u0011bm\u0016\u0014\u0018mZ3!I\u0016<'/Z3!_\u001a\u0004\u0013\r\t<feR,\u0007pJ:!]\u0016Lw\r\u001b2pkJ\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011aA\u0002\\hn\u001c;f{*\u0001\u0003E\u000b\u0011!)\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nAQ\u0014X-\u0019;tAQDW\r\t8fi^|'o\u001b\u0011bg\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0018\u000bA\u0001R\u0003\u0005\t1aA*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y1wO:+\u0017n\u001a5c_V\u0014H)Z4sK\u0016T\u0004\u0005R8vE2,\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\u0003Z,'/Y4fA\u0011,wM]3fA=4\u0007\u0005\u001e5fAY,'\u000f^3yOM\u0004c.Z5hQ\n|WO]:\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003EU3ukJt7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!y\u00022XM\u001d;fq\u0002r\u0017-\\3!A\u0001\u0002\u0003\u0005\t\u0011}A\u00054XM]1hK\u0002rW-[4iE>,(\u000f\t3fOJ,W\r\t\u0011!A\u0001b(\u0002\t\u0011+A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010\t1bm\u001etU-[4iE>,(\u000fR3he\u0016,'\b\t#pk\ndW\r\u0019\u0011}\u0015\u0001\u0002#f\f\u0015\u0005\u0001e\u001aE\t")
public final class AverageNeighbourDegree {
    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return AverageNeighbourDegree$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return AverageNeighbourDegree$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return AverageNeighbourDegree$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return AverageNeighbourDegree$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return AverageNeighbourDegree$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return AverageNeighbourDegree$.MODULE$.name();
    }

    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public static Table run(GraphPerspective graph) {
        return AverageNeighbourDegree$.MODULE$.run(graph);
    }
}

