/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeEdgeCount$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`NodeEdgeCount`\n  *  Stores/returns the number of nodes and edges in the graph.\n  *\n  *  This counts the number of nodes and edges in the perspective and returns them. We count both the number of \"undirected\"\n  *  edges, treating the graph as a simple undirected graph, the number of directed edges, treating the graph as directed\n  *  and simple, and the number of temporal edges which includes duplicate directed edges between the same pair of nodes.\n  *\n  * ## States\n  *\n  *  {s}`numNodes: Int`\n  *  : Number of nodes in the perspective\n  *\n  *  {s}`directedEdges: Int`\n  *  : Number of directed edges in the perspective\n  *\n  *  {s}`undirectedEdges: Int`\n  *  : Number of undirected edges in the perspective\n  *\n  *  {s}`temporalEdges: Int`\n  *  : Number of directed edges with multiplicity in the perspective\n  *\n  *\n  *  ## Returns\n  *\n  *  | no nodes          | no directed edges       | no undirected edges       | no temporal edges |\n  *  | ----------------- | ----------------------- | ------------------------- | ----------------- |\n  *  | {s}`numNodes: Int` | {s}`directedEdges: Int` | {s}`undirectedEdges: Int` | {s}`temporalEdges: Int` |\n  *\n  */")
@ScalaSignature(bytes="\u0006\u0005);Q!\u0002\u0004\t\u0002=1Q!\u0005\u0004\t\u0002IAQ\u0001I\u0001\u0005\u0002\u0005BQAI\u0001\u0005B\rBq!M\u0001\u0002\u0002\u0013%!'A\u0007O_\u0012,W\tZ4f\u0007>,h\u000e\u001e\u0006\u0003\u000f!\tqaZ3oKJL7M\u0003\u0002\n\u0015\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005-a\u0011\u0001\u0003:ba\"$xN]=\u000b\u00035\t1aY8n\u0007\u0001\u0001\"\u0001E\u0001\u000e\u0003\u0019\u0011QBT8eK\u0016#w-Z\"pk:$8cA\u0001\u0014;A\u0011AcG\u0007\u0002+)\u0011acF\u0001\nC2<wN]5uQ6T!\u0001G\r\u0002\u0011\u0005t\u0017\r\\=tSNT!A\u0007\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001d+\t\u0001rI]1qQN#\u0018\r^3PkR\u0004X\u000f\u001e\t\u0003)yI!aH\u000b\u0003!\u001d+g.\u001a:jGJ+G-^2uS>t\u0017A\u0002\u001fj]&$h\bF\u0001\u0010\u0003\u0015\t\u0007\u000f\u001d7z)\t!s\u0005\u0005\u0002&_9\u0011ae\n\u0007\u0001\u0011\u0015A3\u00011\u0001*\u0003\u00159'/\u00199i!\tQS&D\u0001,\u0015\tas#A\u0005he\u0006\u0004\bN^5fo&\u0011af\u000b\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016L!\u0001M\u0017\u0003\u0019I+G-^2fI\u001e\u0013\u0018\r\u001d5\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0003M\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\t1\fgn\u001a\u0006\u0002q\u0005!!.\u0019<b\u0013\tQTG\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003q2u\t\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006A1oY1mC\u0012|7M\u0003\u0002B\u0005\u00069A/Y6fu>,'BA\"\r\u0003\u00199\u0017\u000e\u001e5vE&\u0011QI\u0010\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\n\u0001*AE\u0015_)R#\u0002\t\u0011+Am\u001cX\u0010\u0019(pI\u0016,EmZ3D_VtG\u000f\u0019\u0006!A)\u0002\u0003e\u0015;pe\u0016\u001cxF]3ukJt7\u000f\t;iK\u0002rW/\u001c2fe\u0002zg\r\t8pI\u0016\u001c\b%\u00198eA\u0015$w-Z:!S:\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\"\u0006.[:!G>,h\u000e^:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!]>$Wm\u001d\u0011b]\u0012\u0004S\rZ4fg\u0002Jg\u000e\t;iK\u0002\u0002XM]:qK\u000e$\u0018N^3!C:$\u0007E]3ukJt7\u000f\t;iK6t\u0003eV3!G>,h\u000e\u001e\u0011c_RD\u0007\u0005\u001e5fA9,XNY3sA=4\u0007EI;oI&\u0014Xm\u0019;fI\nR\u0001\u0005\t\u0016!A\u0015$w-Z:-AQ\u0014X-\u0019;j]\u001e\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011bg\u0002\n\u0007e]5na2,\u0007%\u001e8eSJ,7\r^3eA\u001d\u0014\u0018\r\u001d5-AQDW\r\t8v[\n,'\u000fI8gA\u0011L'/Z2uK\u0012\u0004S\rZ4fg2\u0002CO]3bi&tw\r\t;iK\u0002:'/\u00199iA\u0005\u001c\b\u0005Z5sK\u000e$X\r\u001a\u0006!A)\u0002\u0003%\u00198eAMLW\u000e\u001d7fY\u0001\ng\u000e\u001a\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011uK6\u0004xN]1mA\u0015$w-Z:!o\"L7\r\u001b\u0011j]\u000edW\u000fZ3tA\u0011,\b\u000f\\5dCR,\u0007\u0005Z5sK\u000e$X\r\u001a\u0011fI\u001e,7\u000f\t2fi^,WM\u001c\u0011uQ\u0016\u00043/Y7fAA\f\u0017N\u001d\u0011pM\u0002rw\u000eZ3t])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00198v[:{G-Z:;A%sG\u000f\u0019\u0006!A)\u0002\u0003E\u000f\u0011Ok6\u0014WM\u001d\u0011pM\u0002rw\u000eZ3tA%t\u0007\u0005\u001e5fAA,'o\u001d9fGRLg/\u001a\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00193je\u0016\u001cG/\u001a3FI\u001e,7O\u000f\u0011J]R\u0004'\u0002\t\u0011+A\u0001R\u0004ET;nE\u0016\u0014\be\u001c4!I&\u0014Xm\u0019;fI\u0002*GmZ3tA%t\u0007\u0005\u001e5fAA,'o\u001d9fGRLg/\u001a\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y;oI&\u0014Xm\u0019;fI\u0016#w-Z:;A%sG\u000f\u0019\u0006!A)\u0002\u0003E\u000f\u0011Ok6\u0014WM\u001d\u0011pM\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0011fI\u001e,7\u000fI5oAQDW\r\t9feN\u0004Xm\u0019;jm\u0016T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$X-\u001c9pe\u0006dW\tZ4fgj\u0002\u0013J\u001c;a\u0015\u0001\u0002#\u0006\t\u0011;A9+XNY3sA=4\u0007\u0005Z5sK\u000e$X\r\u001a\u0011fI\u001e,7\u000fI<ji\"\u0004S.\u001e7uSBd\u0017nY5us\u0002Jg\u000e\t;iK\u0002\u0002XM]:qK\u000e$\u0018N^3\u000bA\u0001R#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!]>\u0004cn\u001c3fg\u0002\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005 \u0011o_\u0002\"\u0017N]3di\u0016$\u0007%\u001a3hKN\u0004\u0003\u0005\t\u0011!A\u0001b\bE\\8!k:$\u0017N]3di\u0016$\u0007%\u001a3hKN\u0004\u0003\u0005\t\u0011!A\u0001b\bE\\8!i\u0016l\u0007o\u001c:bY\u0002*GmZ3tAqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.^7O_\u0012,7O\u000f\u0011J]R\u0004\u0007\u0005 \u0011|gv\u0004G-\u001b:fGR,G-\u00123hKNT\u0004%\u00138uA\u0002b\be_:~AVtG-\u001b:fGR,G-\u00123hKNT\u0004%\u00138uA\u0002b\be_:~AR,W\u000e]8sC2,EmZ3tu\u0001Je\u000e\u001e1!y*\u0001\u0003E\u000b\u0006!A)z\u0003\u0006\u0002\u0001=\r\u001e\u0003")
public final class NodeEdgeCount {
    public static ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return NodeEdgeCount$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return NodeEdgeCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return NodeEdgeCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(Generic other) {
        return NodeEdgeCount$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return NodeEdgeCount$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return NodeEdgeCount$.MODULE$.name();
    }

    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public static Table run(GraphPerspective graph) {
        return NodeEdgeCount$.MODULE$.run(graph);
    }
}

