/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`KCore(3)`\n  * : Identify the K-Cores of a graph with given k\n  *\n  * A k-core of a graph is a maximal subgraph in which every vertex has degree at least k. This algorithm identifies the k-cores of a graph.\n  * (https://en.wikipedia.org/w/index.php?title=Degeneracy_(graph_theory)&action=edit&section=3).\n  *\n  * ## Parameters\n  *\n  *  {s}`k: Int`\n  *    : The value of k to run k-core with.\n  *\n  *  {s}`resetStates: Bool = True`\n  *    : When true this resets all the effectiveDegree states at the start of running so the algorithm runs from scratch, when false reuses previous effectiveDegree data and runs on the remaining alive nodes (e.g. for nested KCore iterations like in Coreness.)\n  *    : Defaults to true, generally should be true.\n  *\n  * ## States\n  *\n  * {s}`effectiveDegree: Int`\n  * : Stores the current number of alive neighbours of each vertex (decreases as nodes get deleted).\n  * : At the end of the algorithm the nodes in the k-cores are those with effectiveDegree => k.\n  * : In a tabularise this can be filtered using the boolean {s}`vertex.getState[Int](\"effectiveDegree\") >= k`\n  *\n  * ## Returns\n  *\n  * | vertex name       | if in the k-core (only returns true rows)               |\n  * | ----------------- | ------------------------------------------------------- |\n  * | {s}`name: String` | {s}`vertex.getState[Int](\"effectiveDegree\") >= k: Bool` |\n  *\n  * ## Implementation\n  *\n  * The algorithm works by recursively removing nodes that don't have enough alive neighbours for them to remain in the graph.\n  *\n  *  1. Each node sets is effectiveDegree to it's actual degree (as all it's neighbours are currently alive). If it has degree < k, it can't be in the k-core, so dies and broadcasts its death.\n  *     If resetStates == false, we start from previous effectiveDegree values instead.\n  *\n  *  2. When a node receives a message saying its neighbour has died, it decrements its effective degree.\n  *\n  *  3. It then checks if its effectiveDegree < k, in which case it can't be in the k-core, so dies and broadcasts its death.\n  *\n  *  4. This continues until no more nodes are dying.\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\b\u0011\u0001eA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C!s!)q\t\u0001C!\u0011\u001e)a\f\u0005E\u0001?\u001a)q\u0002\u0005E\u0001A\")!g\u0002C\u0001S\"9!n\u0002b\u0001\n\u000bY\u0007BB8\bA\u00035A\u000eC\u00039\u000f\u0011\u0005\u0001\u000fC\u0004t\u000fE\u0005I\u0011\u0001;\t\u000f}<\u0011\u0013!C\u0001i\"I\u0011\u0011A\u0004\u0002\u0002\u0013%\u00111\u0001\u0002\u0006\u0017\u000e{'/\u001a\u0006\u0003#I\tqaZ3oKJL7M\u0003\u0002\u0014)\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005U1\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0005K\u0007\u0002E)\u00111\u0005J\u0001\nC2<wN]5uQ6T!!\n\u0014\u0002\u0011\u0005t\u0017\r\\=tSNT!a\n\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*E\t9q)\u001a8fe&\u001c\u0017!A6\u0011\u0005ma\u0013BA\u0017\u001d\u0005\rIe\u000e^\u0001\fe\u0016\u001cX\r^*uCR,7\u000f\u0005\u0002\u001ca%\u0011\u0011\u0007\b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0005U\u0002Q\"\u0001\t\t\u000b)\u001a\u0001\u0019A\u0016\t\u000f9\u001a\u0001\u0013!a\u0001_\u0005)\u0011\r\u001d9msR\u0011!(\u0010\t\u0003w\u0015s!\u0001P\u001f\r\u0001!)a\b\u0002a\u0001\u007f\u0005)qM]1qQB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tJ\u0001\nOJ\f\u0007\u000f\u001b<jK^L!\u0001R!\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017B\u0001$D\u0005\u00159%/\u00199i\u0003)!\u0018MY;mCJL7/\u001a\u000b\u0003\u0013>\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u0013\u0002\u000bQ\f'\r\\3\n\u00059[%!\u0002+bE2,\u0007\"\u0002 \u0006\u0001\u0004y\u0004\u0006\u0002\u0001R7r\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!AV,\u0002\u000fQ\f7.\u001a>pK*\u0011\u0001LF\u0001\u0007O&$\b.\u001e2\n\u0005i\u001b&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003u\u000b\u0001sV\u0018+U)\u0001\u0003E\u000b\u0011|gv\u00047jQ8sK\"\u001a\u0014\u0006\u0019\u0006!A)\u0002#\bI%eK:$\u0018NZ=!i\",\u0007eS\u0017D_J,7\u000fI8gA\u0005\u0004sM]1qQ\u0002:\u0018\u000e\u001e5!O&4XM\u001c\u0011l\u0015\u0001\u0002#F\u0003\u0011!U\u0001\n\u0005e[\u0017d_J,\u0007e\u001c4!C\u0002:'/\u00199iA%\u001c\b%\u0019\u0011nCbLW.\u00197!gV\u0014wM]1qQ\u0002Jg\u000eI<iS\u000eD\u0007%\u001a<fef\u0004c/\u001a:uKb\u0004\u0003.Y:!I\u0016<'/Z3!CR\u0004C.Z1ti\u0002Zg\u0006\t+iSN\u0004\u0013\r\\4pe&$\b.\u001c\u0011jI\u0016tG/\u001b4jKN\u0004C\u000f[3!W6\u001awN]3tA=4\u0007%\u0019\u0011he\u0006\u0004\bN\f\u0006!A)\u0002\u0003\u0006\u001b;uaNTtfL3o]]L7.\u001b9fI&\fgf\u001c:h_]|\u0013N\u001c3fq:\u0002\b\u000e] uSRdW-\u0010#fO\u0016tWM]1ds~CsM]1qQ~#\b.Z8ss&2\u0013m\u0019;j_:lT\rZ5uMM,7\r^5p]v\u001a\u0014F\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002\u0003+\u0019:b[\u0016$XM]:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1lu\u0001Je\u000e\u001e1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\"\u0006.\u001a\u0011wC2,X\rI8gA-\u0004Co\u001c\u0011sk:\u00043.L2pe\u0016\u0004s/\u001b;i])\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~AJ,7/\u001a;Ti\u0006$Xm\u001d\u001e!\u0005>|G\u000eI\u001f!)J,X\r\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A]CWM\u001c\u0011ueV,\u0007\u0005\u001e5jg\u0002\u0012Xm]3ug\u0002\nG\u000e\u001c\u0011uQ\u0016\u0004SM\u001a4fGRLg/\u001a#fOJ,W\rI:uCR,7\u000fI1uAQDW\rI:uCJ$\be\u001c4!eVtg.\u001b8hAM|\u0007\u0005\u001e5fA\u0005dwm\u001c:ji\"l\u0007E];og\u00022'o\\7!g\u000e\u0014\u0018\r^2iY\u0001:\b.\u001a8!M\u0006d7/\u001a\u0011sKV\u001cXm\u001d\u0011qe\u00164\u0018n\\;tA\u00154g-Z2uSZ,G)Z4sK\u0016\u0004C-\u0019;bA\u0005tG\r\t:v]N\u0004sN\u001c\u0011uQ\u0016\u0004#/Z7bS:Lgn\u001a\u0011bY&4X\r\t8pI\u0016\u001c\b\u0005K3/O:\u0002cm\u001c:!]\u0016\u001cH/\u001a3!\u0017\u000e{'/\u001a\u0011ji\u0016\u0014\u0018\r^5p]N\u0004C.[6fA%t\u0007eQ8sK:,7o\u001d\u0018*\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C)\u001a4bk2$8\u000f\t;pAQ\u0014X/\u001a\u0017!O\u0016tWM]1mYf\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011ueV,gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u001aF/\u0019;fg*\u0001\u0003E\u000b\u0006!A)\u00023p]?aK\u001a4Wm\u0019;jm\u0016$Um\u001a:fKj\u0002\u0013J\u001c;a\u0015\u0001\u0002#\u0006\t\u001e!'R|'/Z:!i\",\u0007eY;se\u0016tG\u000f\t8v[\n,'\u000fI8gA\u0005d\u0017N^3!]\u0016Lw\r\u001b2pkJ\u001c\be\u001c4!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010\t\u0015eK\u000e\u0014X-Y:fg\u0002\n7\u000f\t8pI\u0016\u001c\beZ3uA\u0011,G.\u001a;fI&r#\u0002\t\u0011+Ai\u0002\u0013\t\u001e\u0011uQ\u0016\u0004SM\u001c3!_\u001a\u0004C\u000f[3!C2<wN]5uQ6\u0004C\u000f[3!]>$Wm\u001d\u0011j]\u0002\"\b.\u001a\u0011l[\r|'/Z:!CJ,\u0007\u0005\u001e5pg\u0016\u0004s/\u001b;iA\u00154g-Z2uSZ,G)Z4sK\u0016\u0004SH\u0010\u0011l])\u0001\u0003E\u000b\u0011;A%s\u0007%\u0019\u0011uC\n,H.\u0019:jg\u0016\u0004C\u000f[5tA\r\fg\u000e\t2fA\u0019LG\u000e^3sK\u0012\u0004So]5oO\u0002\"\b.\u001a\u0011c_>dW-\u00198!wNl\bM^3si\u0016DhfZ3u'R\fG/Z.J]Rl\u0006FI3gM\u0016\u001cG/\u001b<f\t\u0016<'/Z3#S\u0001rT\bI6a\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!y\u00022XM\u001d;fq\u0002r\u0017-\\3!A\u0001\u0002\u0003\u0005\t\u0011}A%4\u0007%\u001b8!i\",\u0007e[\u0017d_J,\u0007\u0005K8oYf\u0004#/\u001a;ve:\u001c\b\u0005\u001e:vK\u0002\u0012xn^:*A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010\u0019<feR,\u0007PL4fiN#\u0018\r^3\\\u0013:$X\f\u000b\u0012fM\u001a,7\r^5wK\u0012+wM]3fE%\u0002c(\u0010\u0011lu\u0001\u0012un\u001c7aAqT\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!\u00136\u0004H.Z7f]R\fG/[8o\u0015\u0001\u0002#F\u0003\u0011!U\u0001\"\u0006.\u001a\u0011bY\u001e|'/\u001b;i[\u0002:xN]6tA\tL\bE]3dkJ\u001c\u0018N^3ms\u0002\u0012X-\\8wS:<\u0007E\\8eKN\u0004C\u000f[1uA\u0011|gn\n;!Q\u00064X\rI3o_V<\u0007\u000eI1mSZ,\u0007E\\3jO\"\u0014w.\u001e:tA\u0019|'\u000f\t;iK6\u0004Co\u001c\u0011sK6\f\u0017N\u001c\u0011j]\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\f\u0006!A)R\u0001\u0005\t\u0016!AEr\u0003%R1dQ\u0002rw\u000eZ3!g\u0016$8\u000fI5tA\u00154g-Z2uSZ,G)Z4sK\u0016\u0004Co\u001c\u0011ji\u001e\u001a\b%Y2uk\u0006d\u0007\u0005Z3he\u0016,\u0007\u0005K1tA\u0005dG\u000eI5uOM\u0004c.Z5hQ\n|WO]:!CJ,\u0007eY;se\u0016tG\u000f\\=!C2Lg/Z\u0015/A%3\u0007%\u001b;!Q\u0006\u001c\b\u0005Z3he\u0016,\u0007\u0005\u0010\u0011lY\u0001JG\u000fI2b]\u001e\"\bEY3!S:\u0004C\u000f[3!W6\u001awN]3-AM|\u0007\u0005Z5fg\u0002\ng\u000e\u001a\u0011ce>\fGmY1tiN\u0004\u0013\u000e^:!I\u0016\fG\u000f\u001b\u0018\u000bA\u0001R\u0003\u0005\t\u0011!A%3\u0007E]3tKR\u001cF/\u0019;fg\u0002jT\b\t4bYN,G\u0006I<fAM$\u0018M\u001d;!MJ|W\u000e\t9sKZLw.^:!K\u001a4Wm\u0019;jm\u0016$Um\u001a:fK\u00022\u0018\r\\;fg\u0002Jgn\u001d;fC\u0012t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u00113]\u0001:\u0006.\u001a8!C\u0002rw\u000eZ3!e\u0016\u001cW-\u001b<fg\u0002\n\u0007%\\3tg\u0006<W\rI:bs&tw\rI5ug\u0002rW-[4iE>,(\u000f\t5bg\u0002\"\u0017.\u001a3-A%$\b\u0005Z3de\u0016lWM\u001c;tA%$8\u000fI3gM\u0016\u001cG/\u001b<fA\u0011,wM]3f])\u0001\u0003E\u000b\u0006!A)\u0002\u0003e\r\u0018!\u0013R\u0004C\u000f[3oA\rDWmY6tA%4\u0007%\u001b;tA\u00154g-Z2uSZ,G)Z4sK\u0016\u0004C\bI6-A%t\u0007e\u001e5jG\"\u00043-Y:fA%$\beY1oOQ\u0004#-\u001a\u0011j]\u0002\"\b.\u001a\u0011l[\r|'/\u001a\u0017!g>\u0004C-[3tA\u0005tG\r\t2s_\u0006$7-Y:ug\u0002JGo\u001d\u0011eK\u0006$\bN\f\u0006!A)R\u0001\u0005\t\u0016!AQr\u0003\u0005\u00165jg\u0002\u001awN\u001c;j]V,7\u000fI;oi&d\u0007E\\8![>\u0014X\r\t8pI\u0016\u001c\b%\u0019:fA\u0011L\u0018N\\4/\u0015\u0001\u0002#fL\u0001\u0006\u0017\u000e{'/\u001a\t\u0003k\u001d\u00192a\u0002\u000eb!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0002j_*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005y\u0016!C#G\r\u0012+uIU#F+\u0005aw\"A7\"\u00039\fq\"\u001a4gK\u000e$\u0018N^3EK\u001e\u0014X-Z\u0001\u000b\u000b\u001a3E)R$S\u000b\u0016\u0003Cc\u0001\u001bre\")!f\u0003a\u0001W!9af\u0003I\u0001\u0002\u0004y\u0013aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003UT#a\f<,\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u0013Ut7\r[3dW\u0016$'B\u0001?\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0003}f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111B3\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\tIA\u0001\u0004PE*,7\r\u001e")
public class KCore
implements Generic {
    private final int k;
    private final boolean resetStates;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$2() {
        return KCore$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean apply$default$2() {
        return KCore$.MODULE$.apply$default$2();
    }

    public static String EFFDEGREE() {
        return KCore$.MODULE$.EFFDEGREE();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            KCore.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            KCore.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        }, 5000, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            KCore.$anonfun$tabularise$1(this, vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "effdegree"})).filter((Function1<Row, Object>)(Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.getBool("effdegree")));
    }

    public static final /* synthetic */ void $anonfun$apply$1(KCore $this, Vertex vertex) {
        if (!$this.resetStates & ((EntityVisitor)((Object)vertex)).containsState("effectiveDegree", ((EntityVisitor)((Object)vertex)).containsState$default$2())) {
            int effDegree = BoxesRunTime.unboxToInt((Object)((EntityVisitor)((Object)vertex)).getStateOrElse("effectiveDegree", BoxesRunTime.boxToInteger((int)vertex.degree()), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3()));
            if (effDegree == $this.k - 1) {
                vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)0), SchemaProviderInstances$.MODULE$.intSchemaProvider());
            }
        } else {
            int degree = vertex.degree();
            if (degree < $this.k) {
                vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)0), SchemaProviderInstances$.MODULE$.intSchemaProvider());
            }
            ((EntityVisitor)((Object)vertex)).setState("effectiveDegree", BoxesRunTime.boxToInteger((int)degree));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(KCore $this, Vertex vertex) {
        int effDegree = BoxesRunTime.unboxToInt((Object)((EntityVisitor)((Object)vertex)).getStateOrElse("effectiveDegree", BoxesRunTime.boxToInteger((int)vertex.degree()), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3()));
        if (effDegree >= $this.k) {
            int newlyDeadNeighbours = vertex.messageQueue().length();
            int newEffDegree = effDegree - newlyDeadNeighbours;
            if (newEffDegree == effDegree) {
                vertex.voteToHalt();
            }
            ((EntityVisitor)((Object)vertex)).setState("effectiveDegree", BoxesRunTime.boxToInteger((int)newEffDegree));
            if (newEffDegree < $this.k) {
                vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)0), SchemaProviderInstances$.MODULE$.intSchemaProvider());
                vertex.voteToHalt();
            }
        } else {
            vertex.voteToHalt();
        }
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(KCore $this, Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("name", vertex.name());
        ((EntityVisitor)((Object)vertex)).setState("effdegree", BoxesRunTime.boxToBoolean((BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("effectiveDegree", ((EntityVisitor)((Object)vertex)).getState$default$2())) >= $this.k ? 1 : 0) != 0));
    }

    public KCore(int k, boolean resetStates) {
        this.k = k;
        this.resetStates = resetStates;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
        if (k < 0) {
            throw new IllegalArgumentException(new StringBuilder(38).append("k must be non-negative. You entered k=").append(k).toString());
        }
    }
}

