/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.CBOD$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n  *  {s}`CBOD(label: String = \"community\", cutoff: Double = 0.0, labeler:GraphAlgorithm = Identity())`\n  *  : Returns outliers detected based on the community structure of the Graph.\n  *\n  *  The algorithm assumes that the state of each vertex contains a community label\n  *  (e.g., set by running [LPA](com.raphtory.algorithms.generic.community.LPA) on the graph, initially)\n  *  and then defines an outlier score based on a node's\n  *  community membership and how it compares to its neighbors community memberships.\n  *\n  * ## Parameters\n  *\n  *  {s}`label: String = \"community\"`\n  *  : Identifier for community label (default: \"community\")\n  *\n  *  {s}`cutoff: Double = 0.0`\n  *  : Outlier score threshold (default: 0.0). Identifies the outliers with an outlier score > cutoff.\n  *\n  *  {s}`labeler: GraphAlgorithm`\n  *  : Community algorithm to run to get labels (does nothing by default, i.e., labels should\n  *    be already set on the input graph, either via chaining or defined as properties of the data)\n  *\n  * ## States\n  *\n  *  {s}`outlierscore: Double`\n  *  : Community-based outlier score for vertex\n  *\n  * ## Returns\n  *\n  *  (only for vertex such that `outlierscore >= cutoff`)\n  *\n  *  | vertex name      | outlier score            |\n  *  |------------------|--------------------------|\n  *  |{s}`name: String` | {s}`outlierscore: Double`|\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.community.LPA)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\n\u0014\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%1\u0005C\u0003?\u0001\u0011\u0005q\bC\u0003F\u0001\u0011\u0005c\tC\u0003U\u0001\u0011\u0005SkB\u0003l'!\u0005ANB\u0003\u0013'!\u0005Q\u000eC\u0003?\u0011\u0011\u0005a\u000fC\u0003F\u0011\u0011\u0005q\u000fC\u0004|\u0011E\u0005I\u0011\u0001?\t\u0013\u0005=\u0001\"%A\u0005\u0002\u0005E\u0001\"CA\u000b\u0011E\u0005I\u0011AA\f\u0011!\tY\u0002CI\u0001\n\u0003a\b\"CA\u000f\u0011E\u0005I\u0011AA\t\u0011%\ty\u0002CI\u0001\n\u0003\t9\u0002C\u0005\u0002\"!\t\t\u0011\"\u0003\u0002$\t!1IQ(E\u0015\t!R#A\u0004hK:,'/[2\u000b\u0005Y9\u0012AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011\u0001$G\u0001\te\u0006\u0004\b\u000e^8ss*\t!$A\u0002d_6\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003%\tGnZ8sSRDWN\u0003\u0002)S\u0005A\u0011M\\1msNL7O\u0003\u0002+/\u0005\u0019\u0011\r]5\n\u00051*#aB$f]\u0016\u0014\u0018nY\u0001\u0006Y\u0006\u0014W\r\u001c\t\u0003_Yr!\u0001\r\u001b\u0011\u0005EzR\"\u0001\u001a\u000b\u0005MZ\u0012A\u0002\u001fs_>$h(\u0003\u00026?\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)t$\u0001\u0004dkR|gM\u001a\t\u0003=mJ!\u0001P\u0010\u0003\r\u0011{WO\u00197f\u0003\u001da\u0017MY3mKJ\fa\u0001P5oSRtD\u0003\u0002!C\u0007\u0012\u0003\"!\u0011\u0001\u000e\u0003MAq!\f\u0003\u0011\u0002\u0003\u0007a\u0006C\u0004:\tA\u0005\t\u0019\u0001\u001e\t\u000fu\"\u0001\u0013!a\u0001G\u0005)\u0011\r\u001d9msR\u0011qI\u0013\t\u0003\u0011Js!!\u0013&\r\u0001!)1*\u0002a\u0001\u0019\u0006)qM]1qQB\u0011Q\nU\u0007\u0002\u001d*\u0011qjJ\u0001\nOJ\f\u0007\u000f\u001b<jK^L!!\u0015(\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017BA*Q\u0005\u00159%/\u00199i\u0003)!\u0018MY;mCJL7/\u001a\u000b\u0003-r\u0003\"a\u0016.\u000e\u0003aS!!W\u0014\u0002\u000bQ\f'\r\\3\n\u0005mC&!\u0002+bE2,\u0007\"B&\u0007\u0001\u0004a\u0005\u0006\u0002\u0001_Q&\u0004\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!a\u00193\u0002\u000fQ\f7.\u001a>pK*\u0011Q-G\u0001\u0007O&$\b.\u001e2\n\u0005\u001d\u0004'\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003)\f1RK\u0018+U)\u0001\u0003E\u000b\u0011!wNl\bm\u0011\"P\t\"b\u0017MY3mu\u0001\u001aFO]5oO\u0002j\u0004EI2p[6,h.\u001b;zE1\u00023-\u001e;pM\u001aT\u0004\u0005R8vE2,\u0007%\u0010\u00111]Ab\u0003\u0005\\1cK2,'OO$sCBD\u0017\t\\4pe&$\b.\u001c\u0011>A%#WM\u001c;jifD\u0013&\u000b1\u000bA\u0001R\u0003\u0005\t\u001e!%\u0016$XO\u001d8tA=,H\u000f\\5feN\u0004C-\u001a;fGR,G\r\t2bg\u0016$\u0007e\u001c8!i\",\u0007eY8n[Vt\u0017\u000e^=!gR\u0014Xo\u0019;ve\u0016\u0004sN\u001a\u0011uQ\u0016\u0004sI]1qQ:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t+iK\u0002\nGnZ8sSRDW\u000eI1tgVlWm\u001d\u0011uQ\u0006$\b\u0005\u001e5fAM$\u0018\r^3!_\u001a\u0004S-Y2iAY,'\u000f^3yA\r|g\u000e^1j]N\u0004\u0013\rI2p[6,h.\u001b;zA1\f'-\u001a7\u000bA\u0001R\u0003\u0005\t\u0015f]\u001dtC\u0006I:fi\u0002\u0012\u0017\u0010\t:v]:Lgn\u001a\u0011\\\u0019B\u000bU\fK2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u001d,g.\u001a:jG:\u001aw.\\7v]&$\u0018P\f'Q\u0003&\u0002sN\u001c\u0011uQ\u0016\u0004sM]1qQ2\u0002\u0013N\\5uS\u0006dG._\u0015\u000bA\u0001R\u0003\u0005I1oI\u0002\"\b.\u001a8!I\u00164\u0017N\\3tA\u0005t\u0007e\\;uY&,'\u000fI:d_J,\u0007EY1tK\u0012\u0004sN\u001c\u0011bA9|G-Z\u0014t\u0015\u0001\u0002#\u0006\t\u0011d_6lWO\\5us\u0002jW-\u001c2feND\u0017\u000e\u001d\u0011b]\u0012\u0004\u0003n\\<!SR\u00043m\\7qCJ,7\u000f\t;pA%$8\u000f\t8fS\u001eD'm\u001c:tA\r|W.\\;oSRL\b%\\3nE\u0016\u00148\u000f[5qg:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004G.\u00192fYj\u00023\u000b\u001e:j]\u001e\u0004S\b\t\u0012d_6lWO\\5us\n\u0002'\u0002\t\u0011+A\u0001R\u0004%\u00133f]RLg-[3sA\u0019|'\u000fI2p[6,h.\u001b;zA1\f'-\u001a7!Q\u0011,g-Y;mij\u0002#eY8n[Vt\u0017\u000e^=#S)\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A\u000e,Ho\u001c4gu\u0001\"u.\u001e2mK\u0002j\u0004\u0005\r\u00181A*\u0001\u0003E\u000b\u0011!u\u0001zU\u000f\u001e7jKJ\u00043oY8sK\u0002\"\bN]3tQ>dG\r\t\u0015eK\u001a\fW\u000f\u001c;;AAr\u0003'\u000b\u0018!\u0013\u0012,g\u000e^5gS\u0016\u001c\b\u0005\u001e5fA=,H\u000f\\5feN\u0004s/\u001b;iA\u0005t\u0007e\\;uY&,'\u000fI:d_J,\u0007E\u0010\u0011dkR|gM\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1mC\n,G.\u001a:;A\u001d\u0013\u0018\r\u001d5BY\u001e|'/\u001b;i[\u0002T\u0001\u0005\t\u0016!Ai\u00023i\\7nk:LG/\u001f\u0011bY\u001e|'/\u001b;i[\u0002\"x\u000e\t:v]\u0002\"x\u000eI4fi\u0002b\u0017MY3mg\u0002BCm\\3tA9|G\u000f[5oO\u0002\u0012\u0017\u0010\t3fM\u0006,H\u000e\u001e\u0017!S:*g\u0006\f\u0011mC\n,Gn\u001d\u0011tQ>,H\u000e\u001a\u0006!A)\u0002\u0003\u0005\t\u0011cK\u0002\nGN]3bIf\u00043/\u001a;!_:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011he\u0006\u0004\b\u000e\f\u0011fSRDWM\u001d\u0011wS\u0006\u00043\r[1j]&tw\rI8sA\u0011,g-\u001b8fI\u0002\n7\u000f\t9s_B,'\u000f^5fg\u0002zg\r\t;iK\u0002\"\u0017\r^1*\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005I*uCR,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\bm\\;uY&,'o]2pe\u0016T\u0004\u0005R8vE2,\u0007M\u0003\u0011!U\u0001\u0002#\bI\"p[6,h.\u001b;z[\t\f7/\u001a3!_V$H.[3sAM\u001cwN]3!M>\u0014\bE^3si\u0016D(\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005K8oYf\u0004cm\u001c:!m\u0016\u0014H/\u001a=!gV\u001c\u0007\u000e\t;iCR\u0004\u0003m\\;uY&,'o]2pe\u0016\u0004c(\u0010\u0011dkR|gM\u001a1*\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u0010\t<feR,\u0007\u0010\t8b[\u0016\u0004\u0003\u0005\t\u0011!Aq\u0004s.\u001e;mS\u0016\u0014\be]2pe\u0016\u0004\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y*\u0001\u0003E\u000b\u0011!y6jS&L\u0017.[5jS&L\u0017.[5jS&\f?.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006 \u0006!A)\u0002\u0003\u0005`>t{\u0002t\u0017-\\3;AM#(/\u001b8hA\u0002b\be_:~A>,H\u000f\\5feN\u001cwN]3;A\u0011{WO\u00197fArT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/G>lW.\u001e8jiftC\nU!*\u0015\u0001\u0002#\u0006\t1aA*\u0001\u0003EK\u0018\u0002\t\r\u0013u\n\u0012\t\u0003\u0003\"\u00192\u0001C\u000fo!\tyG/D\u0001q\u0015\t\t(/\u0001\u0002j_*\t1/\u0001\u0003kCZ\f\u0017BA;q\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005aG\u0003\u0002!ysjDq!\f\u0006\u0011\u0002\u0003\u0007a\u0006C\u0004:\u0015A\u0005\t\u0019\u0001\u001e\t\u000fuR\u0001\u0013!a\u0001G\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'F\u0001~U\tqcpK\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%q$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0004\u0002\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!a\u0005+\u0005ir\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e!FA\u0012\u007f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016e\u0006!A.\u00198h\u0013\u0011\ty#!\u000b\u0003\r=\u0013'.Z2u\u0001")
public class CBOD
implements Generic {
    private final String label;
    private final double cutoff;
    private final Generic labeler;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Generic $lessinit$greater$default$3() {
        return CBOD$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return CBOD$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CBOD$.MODULE$.$lessinit$greater$default$1();
    }

    public static Generic apply$default$3() {
        return CBOD$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return CBOD$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return CBOD$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return this.labeler.apply(graph).step((Function1 & Serializable)vertex -> {
            CBOD.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            CBOD.$anonfun$apply$2(this, v);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            CBOD.$anonfun$tabularise$1(vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "outlierscore"})).filter((Function1<Row, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CBOD.$anonfun$tabularise$2(this, x$2)));
    }

    public static final /* synthetic */ void $anonfun$apply$1(CBOD $this, Vertex vertex) {
        long vlabel = BoxesRunTime.unboxToLong(((EntityVisitor)((Object)vertex)).getState($this.label, true));
        vertex.messageAllNeighbours(BoxesRunTime.boxToLong((long)vlabel), SchemaProviderInstances$.MODULE$.longSchemaProvider());
    }

    public static final /* synthetic */ void $anonfun$apply$2(CBOD $this, Vertex v) {
        long vlabel = BoxesRunTime.unboxToLong(((EntityVisitor)((Object)v)).getState($this.label, true));
        Seq neighborLabels = v.messageQueue();
        double outlierScore = 1.0 - (double)neighborLabels.count((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 == vlabel) / (double)neighborLabels.length();
        ((EntityVisitor)((Object)v)).setState("outlierscore", BoxesRunTime.boxToDouble((double)outlierScore));
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).getStateOrElse("name", vertex.name(vertex.name$default$1()), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$tabularise$2(CBOD $this, Row x$2) {
        return BoxesRunTime.unboxToDouble((Object)x$2.get("outlierscore")) >= $this.cutoff;
    }

    public CBOD(String label, double cutoff, Generic labeler) {
        this.label = label;
        this.cutoff = cutoff;
        this.labeler = labeler;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

