/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.VertexQuantileFilter$;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphstate.Accumulator;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphstate.Histogram;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.utils.Bounded;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * {s}`VertexQuantileFilter()`\n  * : Filtered view of the graph based on vertex state or property\n  *\n  *  This creates a filtered view of the graph where nodes are removed based on where their value of a given property/state lies in the global\n  *  distribution of vertex states, understood in this algorithm as percentiles. For example, one can create a view of the\n  *  graph including only the top 50% of vertices in terms of (say) degree. This algorithm does not return any output and is best used in composition\n  *  with other algorithms, using the Chain API. The algorithm is agnostic to whether the network is directed or undirected.\n  *\n  * ## Parameters\n  *\n  *  `lower: Float = 0.0f`\n  *  : The lower cutoff percentile below which nodes will be removed, a float with 0 <= lower <= upper <=1.0 with default value 0.0f\n  *\n  *  `upper: Float = 1.0f`\n  *  : The upper cutoff percentile above which nodes will be removed, a float with 0 <= lower <= upper <=1.0 with default value 1.0f\n  *\n  *  `weightString: String = \"weight\"`\n  *  : String name of the property/state, defaulting to \"weight\". As with other weighted algorithms in Raphtory, if no weight property\n  *  is there but multi-edges are present, the number of occurrences of each edge is treated as the weight.\n  *\n  *  `lowerExclusive: Boolean = \"false\"`\n  *  : whether the inequality on the threshold is strict or not at the lower end\n  *\n  *  `upperExclusive: Boolean = \"false\"`\n  *  : whether the inequality on the= threshold is strict or not at the upper end\n  *\n  *  `noBins: Int = 1000`\n  *  : Number of bins to be used in the histogram. The more the bins, the more precise the thresholds can be (depending on the underlying\n  *  distribution of the node property data) but the bigger the array being broadcast.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.EdgeQuantileFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u000f\u001f\u0001\u001dB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!1!Q\u0001\f5C\u0001\"\u0019\u0001\u0003\u0004\u0003\u0006YA\u0019\u0005\tQ\u0002\u0011\u0019\u0011)A\u0006S\")q\u000e\u0001C\u0001a\")Q\u0010\u0001C!}\u001e9\u00111\b\u0010\t\u0002\u0005ubAB\u000f\u001f\u0011\u0003\ty\u0004\u0003\u0004p\u001b\u0011\u0005\u0011q\u000b\u0005\u0007{6!\t!!\u0017\t\u0013\u0005\rU\"%A\u0005\u0002\u0005\u0015\u0005\"CAP\u001bE\u0005I\u0011AAQ\u0011%\t)+DI\u0001\n\u0003\t9\u000bC\u0005\u000206\t\n\u0011\"\u0001\u00022\"I\u0011\u0011X\u0007\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007fk\u0011\u0013!C\u0001\u0003\u0003D\u0011\"!3\u000e#\u0003%\t!a3\t\u0013\u0005=W\"%A\u0005\u0002\u0005E\u0007\"CAk\u001bE\u0005I\u0011AAl\u0011%\tY.DI\u0001\n\u0003\ti\u000eC\u0005\u0002b6\t\n\u0011\"\u0001\u0002d\"I\u0011q]\u0007\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[l\u0011\u0011!C\u0005\u0003_\u0014ACV3si\u0016D\u0018+^1oi&dWMR5mi\u0016\u0014(BA\u0010!\u0003\u001d1\u0017\u000e\u001c;feNT!!\t\u0012\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002$I\u0005A!/\u00199ii>\u0014\u0018PC\u0001&\u0003\r\u0019w.\\\u0002\u0001+\tA\u0003l\u0005\u0002\u0001SA\u0011!&L\u0007\u0002W)\u0011A\u0006I\u0001\bO\u0016tWM]5d\u0013\tq3F\u0001\u0005O_\u0012,G*[:u\u0003\u0015awn^3s!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u00151En\\1u\u0003\u0015)\b\u000f]3s\u00039\u0001(o\u001c9feRL8\u000b\u001e:j]\u001e\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e3\u001b\u0005a$BA\u001f'\u0003\u0019a$o\\8u}%\u0011qHM\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@e\u0005qAn\\<fe\u0016C8\r\\;tSZ,\u0007CA\u0019F\u0013\t1%GA\u0004C_>dW-\u00198\u0002\u001dU\u0004\b/\u001a:Fq\u000edWo]5wK\u00061an\u001c\"j]N\u0004\"!\r&\n\u0005-\u0013$aA%oi\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\u001bfK\u0004\u0002P#:\u00111\bU\u0005\u0002g%\u0011!KM\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0004Ok6,'/[2\u000b\u0005I\u0013\u0004CA,Y\u0019\u0001!Q!\u0017\u0001C\u0002i\u0013\u0011\u0001V\t\u00037z\u0003\"!\r/\n\u0005u\u0013$a\u0002(pi\"Lgn\u001a\t\u0003c}K!\u0001\u0019\u001a\u0003\u0007\u0005s\u00170\u0001\u0006fm&$WM\\2fII\u00022a\u00194W\u001b\u0005!'BA3#\u0003\u0015)H/\u001b7t\u0013\t9GMA\u0004C_VtG-\u001a3\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002k[Zk\u0011a\u001b\u0006\u0003YJ\nqA]3gY\u0016\u001cG/\u0003\u0002oW\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\bc^D\u0018P_>})\u0011\u0011H/\u001e<\u0011\u0007M\u0004a+D\u0001\u001f\u0011\u0015a%\u0002q\u0001N\u0011\u0015\t'\u0002q\u0001c\u0011\u0015A'\u0002q\u0001j\u0011\u001dy#\u0002%AA\u0002ABqA\u000e\u0006\u0011\u0002\u0003\u0007\u0001\u0007C\u00048\u0015A\u0005\t\u0019\u0001\u001d\t\u000f\rS\u0001\u0013!a\u0001\t\"9qI\u0003I\u0001\u0002\u0004!\u0005b\u0002%\u000b!\u0003\u0005\r!S\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u007f\u0006\r\u0001\u0003BA\u0001\u00037q1aVA\u0002\u0011\u001d\t)a\u0003a\u0001\u0003\u000f\tQa\u001a:ba\"\u0004B!!\u0003\u0002\u00185\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005he\u0006\u0004\bN^5fo*!\u0011\u0011CA\n\u0003!\tg.\u00197zg&\u001c(bAA\u000bE\u0005\u0019\u0011\r]5\n\t\u0005e\u00111\u0002\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016LA!!\b\u0002\u0018\t)qI]1qQ\":\u0001!!\t\u00026\u0005]\u0002\u0003BA\u0012\u0003ci!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\tg\u000e\fG.\u00193pG*!\u00111FA\u0017\u0003\u001d!\u0018m[3{_\u0016T1!a\f%\u0003\u00199\u0017\u000e\u001e5vE&!\u00111GA\u0013\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA\u001d\u00039evF\u000b\u0016\u000bA\u0001R\u0003e_:~AZ+'\u000f^3y#V\fg\u000e^5mK\u001aKG\u000e^3sQ%\u0002'\u0002\t\u0011+Ai\u0002c)\u001b7uKJ,G\r\t<jK^\u0004sN\u001a\u0011uQ\u0016\u0004sM]1qQ\u0002\u0012\u0017m]3eA=t\u0007E^3si\u0016D\be\u001d;bi\u0016\u0004sN\u001d\u0011qe>\u0004XM\u001d;z\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u000b[5tA\r\u0014X-\u0019;fg\u0002\n\u0007EZ5mi\u0016\u0014X\r\u001a\u0011wS\u0016<\be\u001c4!i\",\u0007e\u001a:ba\"\u0004s\u000f[3sK\u0002rw\u000eZ3tA\u0005\u0014X\r\t:f[>4X\r\u001a\u0011cCN,G\rI8oA]DWM]3!i\",\u0017N\u001d\u0011wC2,X\rI8gA\u0005\u0004s-\u001b<f]\u0002\u0002(o\u001c9feRLxf\u001d;bi\u0016\u0004C.[3tA%t\u0007\u0005\u001e5fA\u001ddwNY1m\u0015\u0001\u0002#\u0006\t\u0011eSN$(/\u001b2vi&|g\u000eI8gAY,'\u000f^3yAM$\u0018\r^3tY\u0001*h\u000eZ3sgR|w\u000e\u001a\u0011j]\u0002\"\b.[:!C2<wN]5uQ6\u0004\u0013m\u001d\u0011qKJ\u001cWM\u001c;jY\u0016\u001ch\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003e\u001c8fA\r\fg\u000eI2sK\u0006$X\rI1!m&,w\u000fI8gAQDWM\u0003\u0011!U\u0001\u0002sM]1qQ\u0002Jgn\u00197vI&tw\rI8oYf\u0004C\u000f[3!i>\u0004\b%\u000e\u0019&A=4\u0007E^3si&\u001cWm\u001d\u0011j]\u0002\"XM]7tA=4\u0007\u0005K:bs&\u0002C-Z4sK\u0016t\u0003\u0005\u00165jg\u0002\nGnZ8sSRDW\u000e\t3pKN\u0004cn\u001c;!e\u0016$XO\u001d8!C:L\be\\;uaV$\b%\u00198eA%\u001c\bEY3ti\u0002*8/\u001a3!S:\u00043m\\7q_NLG/[8o\u0015\u0001\u0002#\u0006\t\u0011xSRD\u0007e\u001c;iKJ\u0004\u0013\r\\4pe&$\b.\\:-AU\u001c\u0018N\\4!i\",\u0007e\u00115bS:\u0004\u0013\tU%/AQCW\rI1mO>\u0014\u0018\u000e\u001e5nA%\u001c\b%Y4o_N$\u0018n\u0019\u0011u_\u0002:\b.\u001a;iKJ\u0004C\u000f[3!]\u0016$xo\u001c:lA%\u001c\b\u0005Z5sK\u000e$X\r\u001a\u0011pe\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003\u0005U1sC6,G/\u001a:t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\r\\8xKJT\u0004E\u00127pCR\u0004S\b\t\u0019/a\u0019\u0004'\u0002\t\u0011+A\u0001R\u0004\u0005\u00165fA1|w/\u001a:!GV$xN\u001a4!a\u0016\u00148-\u001a8uS2,\u0007EY3m_^\u0004s\u000f[5dQ\u0002rw\u000eZ3tA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012d\u0003%\u0019\u0011gY>\fG\u000fI<ji\"\u0004\u0003\u0007\t\u001f>A1|w/\u001a:!yu\u0002S\u000f\u001d9fe\u0002bT(\r\u00181A]LG\u000f\u001b\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u00111]A2'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011akB\u0004XM\u001d\u001e!\r2|\u0017\r\u001e\u0011>AEr\u0003G\u001a1\u000bA\u0001R\u0003\u0005\t\u001e!)\",\u0007%\u001e9qKJ\u00043-\u001e;pM\u001a\u0004\u0003/\u001a:dK:$\u0018\u000e\\3!C\n|g/\u001a\u0011xQ&\u001c\u0007\u000e\t8pI\u0016\u001c\be^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0017!C\u00022Gn\\1uA]LG\u000f\u001b\u00111Aqj\u0004\u0005\\8xKJ\u0004C(\u0010\u0011vaB,'\u000f\t\u001f>c9\u0002\u0004e^5uQ\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002\nd\u0006\r4\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002w/Z5hQR\u001cFO]5oOj\u00023\u000b\u001e:j]\u001e\u0004S\b\t\u0012xK&<\u0007\u000e\u001e\u0012a\u0015\u0001\u0002#\u0006\t\u0011;AM#(/\u001b8hA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011qe>\u0004XM\u001d;z_M$\u0018\r^3-A\u0011,g-Y;mi&tw\r\t;pA\t:X-[4ii\nr\u0003%Q:!o&$\b\u000eI8uQ\u0016\u0014\be^3jO\"$X\r\u001a\u0011bY\u001e|'/\u001b;i[N\u0004\u0013N\u001c\u0011SCBDGo\u001c:zY\u0001Jg\r\t8pA],\u0017n\u001a5uAA\u0014x\u000e]3sifT\u0001\u0005\t\u0016!A%\u001c\b\u0005\u001e5fe\u0016\u0004#-\u001e;![VdG/[\u0017fI\u001e,7\u000fI1sK\u0002\u0002(/Z:f]Rd\u0003\u0005\u001e5fA9,XNY3sA=4\u0007e\\2dkJ\u0014XM\\2fg\u0002zg\rI3bG\"\u0004S\rZ4fA%\u001c\b\u0005\u001e:fCR,G\rI1tAQDW\rI<fS\u001eDGO\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001dwn^3s\u000bb\u001cG.^:jm\u0016T\u0004EQ8pY\u0016\fg\u000eI\u001f!E\u0019\fGn]3#A*\u0001\u0003E\u000b\u0011!u\u0001:\b.\u001a;iKJ\u0004C\u000f[3!S:,\u0017/^1mSRL\be\u001c8!i\",\u0007\u0005\u001e5sKNDw\u000e\u001c3!SN\u00043\u000f\u001e:jGR\u0004sN\u001d\u0011o_R\u0004\u0013\r\u001e\u0011uQ\u0016\u0004Cn\\<fe\u0002*g\u000e\u001a\u0006!A)R\u0001\u0005\t\u0016!A\u0001,\b\u000f]3s\u000bb\u001cG.^:jm\u0016T\u0004EQ8pY\u0016\fg\u000eI\u001f!E\u0019\fGn]3#A*\u0001\u0003E\u000b\u0011!u\u0001:\b.\u001a;iKJ\u0004C\u000f[3!S:,\u0017/^1mSRL\be\u001c8!i\",W\b\t;ie\u0016\u001c\bn\u001c7eA%\u001c\be\u001d;sS\u000e$\be\u001c:!]>$\b%\u0019;!i\",\u0007%\u001e9qKJ\u0004SM\u001c3\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002gn\u001c\"j]NT\u0004%\u00138uAu\u0002\u0013\u0007\r\u00191A*\u0001\u0003E\u000b\u0011!u\u0001rU/\u001c2fe\u0002zg\r\t2j]N\u0004Co\u001c\u0011cK\u0002*8/\u001a3!S:\u0004C\u000f[3!Q&\u001cHo\\4sC6t\u0003\u0005\u00165fA5|'/\u001a\u0011uQ\u0016\u0004#-\u001b8tY\u0001\"\b.\u001a\u0011n_J,\u0007\u0005\u001d:fG&\u001cX\r\t;iK\u0002\"\bN]3tQ>dGm\u001d\u0011dC:\u0004#-\u001a\u0011)I\u0016\u0004XM\u001c3j]\u001e\u0004sN\u001c\u0011uQ\u0016\u0004SO\u001c3fe2L\u0018N\\4\u000bA\u0001R\u0003\u0005\t3jgR\u0014\u0018NY;uS>t\u0007e\u001c4!i\",\u0007E\\8eK\u0002\u0002(o\u001c9feRL\b\u0005Z1uC&\u0002#-\u001e;!i\",\u0007EY5hO\u0016\u0014\b\u0005\u001e5fA\u0005\u0014(/Y=!E\u0016Lgn\u001a\u0011ce>\fGmY1ti:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018gS2$XM]:/\u000b\u0012<W-U;b]RLG.\u001a$jYR,'/\u000b\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001Rs&\u0001\u000bWKJ$X\r_)vC:$\u0018\u000e\\3GS2$XM\u001d\t\u0003g6\u0019R!DA!\u0003\u000f\u00022!MA\"\u0013\r\t)E\r\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005\u0011\u0011n\u001c\u0006\u0003\u0003#\nAA[1wC&!\u0011QKA&\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ti$\u0006\u0003\u0002\\\u0005\rDCDA/\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011\u0011\u000b\t\u0003?\n)'a\u001b\u0002rA!1\u000fAA1!\r9\u00161\r\u0003\u00063>\u0011\rA\u0017\u0005\n\u0003Oz\u0011\u0011!a\u0002\u0003S\n!\"\u001a<jI\u0016t7-\u001a\u00135!\u0011q5+!\u0019\t\u0013\u00055t\"!AA\u0004\u0005=\u0014AC3wS\u0012,gnY3%kA!1MZA1\u0011%\t\u0019hDA\u0001\u0002\b\t)(\u0001\u0006fm&$WM\\2fIY\u0002BA[7\u0002b!9qf\u0004I\u0001\u0002\u0004\u0001\u0004b\u0002\u001c\u0010!\u0003\u0005\r\u0001\r\u0005\bo=\u0001\n\u00111\u00019\u0011\u001d\u0019u\u0002%AA\u0002\u0011CqaR\b\u0011\u0002\u0003\u0007A\tC\u0004I\u001fA\u0005\t\u0019A%\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*B!a\"\u0002\u001eV\u0011\u0011\u0011\u0012\u0016\u0004a\u0005-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]%'\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000be\u0003\"\u0019\u0001.\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*B!a\"\u0002$\u0012)\u0011,\u0005b\u00015\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0003\u0002*\u00065VCAAVU\rA\u00141\u0012\u0003\u00063J\u0011\rAW\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU!\u00111WA\\+\t\t)LK\u0002E\u0003\u0017#Q!W\nC\u0002i\u000bq\"\u00199qYf$C-\u001a4bk2$H%N\u000b\u0005\u0003g\u000bi\fB\u0003Z)\t\u0007!,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137+\u0011\t\u0019-a2\u0016\u0005\u0005\u0015'fA%\u0002\f\u0012)\u0011,\u0006b\u00015\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*B!a\"\u0002N\u0012)\u0011L\u0006b\u00015\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*B!a\"\u0002T\u0012)\u0011l\u0006b\u00015\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!!+\u0002Z\u0012)\u0011\f\u0007b\u00015\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*B!a-\u0002`\u0012)\u0011,\u0007b\u00015\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*B!a-\u0002f\u0012)\u0011L\u0007b\u00015\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*B!a1\u0002l\u0012)\u0011l\u0007b\u00015\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001f\t\u0005\u0003g\fI0\u0004\u0002\u0002v*!\u0011q_A(\u0003\u0011a\u0017M\\4\n\t\u0005m\u0018Q\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class VertexQuantileFilter<T>
extends NodeList {
    private final float lower;
    private final float upper;
    private final String propertyString;
    private final boolean lowerExclusive;
    private final boolean upperExclusive;
    private final int noBins;
    private final Numeric<T> evidence$1;
    private final Bounded<T> evidence$2;

    public static <T> int $lessinit$greater$default$6() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> boolean $lessinit$greater$default$5() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> boolean $lessinit$greater$default$4() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> String $lessinit$greater$default$3() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> float $lessinit$greater$default$2() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> float $lessinit$greater$default$1() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int apply$default$6() {
        return VertexQuantileFilter$.MODULE$.apply$default$6();
    }

    public static <T> boolean apply$default$5() {
        return VertexQuantileFilter$.MODULE$.apply$default$5();
    }

    public static <T> boolean apply$default$4() {
        return VertexQuantileFilter$.MODULE$.apply$default$4();
    }

    public static <T> String apply$default$3() {
        return VertexQuantileFilter$.MODULE$.apply$default$3();
    }

    public static <T> float apply$default$2() {
        return VertexQuantileFilter$.MODULE$.apply$default$2();
    }

    public static <T> float apply$default$1() {
        return VertexQuantileFilter$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        if (this.lower < 0.0f || this.upper > 1.0f || this.lower > this.upper) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Lower and upper quantiles must be a floats with 0 <= lower < upper <= 1.0");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return graph.identity();
        }
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            VertexQuantileFilter.$anonfun$apply$1(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            VertexQuantileFilter.$anonfun$apply$2(this, vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            VertexQuantileFilter.$anonfun$apply$3(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            VertexQuantileFilter.$anonfun$apply$4(this, vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            VertexQuantileFilter.$anonfun$apply$5(this, state);
            return BoxedUnit.UNIT;
        }).vertexFilter((Function2 & Serializable)(vertex, state) -> BoxesRunTime.boxToBoolean((boolean)VertexQuantileFilter.$anonfun$apply$6(this, vertex, state)));
    }

    public static final /* synthetic */ void $anonfun$apply$1(VertexQuantileFilter $this, GraphState state) {
        state.newMin("propertyMin", true, $this.evidence$1, $this.evidence$2);
        state.newMax("propertyMax", true, $this.evidence$1, $this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$apply$2(VertexQuantileFilter $this, Vertex vertex, GraphState state) {
        state.apply("propertyMin").$plus$eq(((EntityVisitor)((Object)vertex)).getState($this.propertyString, true));
        state.apply("propertyMax").$plus$eq(((EntityVisitor)((Object)vertex)).getState($this.propertyString, true));
    }

    public static final /* synthetic */ void $anonfun$apply$3(VertexQuantileFilter $this, GraphState state) {
        Object propertyMin = state.apply("propertyMin").value();
        Object propertyMax = state.apply("propertyMax").value();
        state.newHistogram("propertyDist", $this.noBins, propertyMin, propertyMax, state.newHistogram$default$5(), $this.evidence$1);
    }

    public static final /* synthetic */ void $anonfun$apply$4(VertexQuantileFilter $this, Vertex vertex, GraphState state) {
        Accumulator histogram = state.apply("propertyDist");
        histogram.$plus$eq(((EntityVisitor)((Object)vertex)).getState($this.propertyString, ((EntityVisitor)((Object)vertex)).getState$default$2()));
    }

    public static final /* synthetic */ void $anonfun$apply$5(VertexQuantileFilter $this, GraphState state) {
        Histogram histogram = (Histogram)state.apply("propertyDist").value();
        state.newConstant("upperQuantile", BoxesRunTime.boxToFloat((float)histogram.quantile($this.upper)));
        state.newConstant("lowerQuantile", BoxesRunTime.boxToFloat((float)histogram.quantile($this.lower)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(VertexQuantileFilter $this, Vertex vertex, GraphState state) {
        boolean lowerExclusiveTest;
        float vertexProperty = Numeric.Implicits$.MODULE$.infixNumericOps(((EntityVisitor)((Object)vertex)).getState($this.propertyString, ((EntityVisitor)((Object)vertex)).getState$default$2()), $this.evidence$1).toFloat();
        float upperQuantile = BoxesRunTime.unboxToFloat(state.apply("upperQuantile").value());
        float lowerQuantile = BoxesRunTime.unboxToFloat(state.apply("lowerQuantile").value());
        boolean bl = $this.lowerExclusive ? vertexProperty > lowerQuantile : (lowerExclusiveTest = vertexProperty >= lowerQuantile);
        boolean upperExclusiveTest = $this.upperExclusive ? vertexProperty < upperQuantile : vertexProperty <= upperQuantile;
        return lowerExclusiveTest && upperExclusiveTest;
    }

    public VertexQuantileFilter(float lower, float upper, String propertyString, boolean lowerExclusive, boolean upperExclusive, int noBins, Numeric<T> evidence$1, Bounded<T> evidence$2, ClassTag<T> evidence$3) {
        this.lower = lower;
        this.upper = upper;
        this.propertyString = propertyString;
        this.lowerExclusive = lowerExclusive;
        this.upperExclusive = upperExclusive;
        this.noBins = noBins;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        super(NodeList$.MODULE$.$lessinit$greater$default$1(), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

