/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.Vertex;
import scala.Function2;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`VertexFilter(f: (Vertex, State) => Boolean)`\n  *   : Filtered view of the graph achieved by retaining vertices according to a predicate function {s}`f`\n  *\n  *   This transforms the graph by keeping only vertices for which {s}`f` returns true, where {s}`f` may depend on graph state.\n  *   This fits well within a chain of algorithms as a way of pruning the graph: for example, one could first filter out vertices\n  *   below a certain degree before running a chosen algorithm.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.VertexFilter)\n  * [](com.raphtory.algorithms.filters.VertexQuantileFilter)\n  * [](com.raphtory.algorithms.filters.EdgeFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005=4A!\u0003\u0006\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u00035\u0001\u0011\u0005Q\u0007C\u0003:\u0001\u0011\u0005#hB\u0003W\u0015!\u0005qKB\u0003\n\u0015!\u0005\u0001\fC\u00035\u000b\u0011\u0005A\rC\u0003:\u000b\u0011\u0005Q\rC\u0004h\u000b\u0005\u0005I\u0011\u00025\u0003-Y+'\u000f^3y\r&dG/\u001a:He\u0006\u0004\bn\u0015;bi\u0016T!a\u0003\u0007\u0002\u000f\u0019LG\u000e^3sg*\u0011QBD\u0001\u000bC2<wN]5uQ6\u001c(BA\b\u0011\u0003!\u0011\u0018\r\u001d5u_JL(\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\r\u0003\u001d9WM\\3sS\u000eL!!\u0007\f\u0003\u00119{G-\u001a'jgR\f\u0011A\u001a\t\u00069}\t3&M\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\tIa)\u001e8di&|gN\r\t\u0003E%j\u0011a\t\u0006\u0003I\u0015\nqA^5tSR|'O\u0003\u0002'O\u0005A\u0011M\\1msNL7O\u0003\u0002)\u001d\u0005\u0019\u0011\r]5\n\u0005)\u001a#A\u0002,feR,\u0007\u0010\u0005\u0002-_5\tQF\u0003\u0002/K\u0005QqM]1qQN$\u0018\r^3\n\u0005Aj#AC$sCBD7\u000b^1uKB\u0011ADM\u0005\u0003gu\u0011qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0003ma\u0002\"a\u000e\u0001\u000e\u0003)AQA\u0007\u0002A\u0002m\tQ!\u00199qYf$\"a\u000f \u0011\u0005q2eBA\u001f?\u0019\u0001AQaP\u0002A\u0002\u0001\u000bQa\u001a:ba\"\u0004\"!\u0011#\u000e\u0003\tS!aQ\u0013\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<\u0018BA#C\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002H\t\n)qI]1qQ\"\"\u0001!S*U!\tQ\u0015+D\u0001L\u0015\taU*\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tqu*A\u0004uC.,'p\\3\u000b\u0005A\u0003\u0012AB4ji\",(-\u0003\u0002S\u0017\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001V\u0003\u0015\u0005tF\u000b\u0016\u000bA\u0001R\u0003e_:~AZ+'\u000f^3y\r&dG/\u001a:)Mj\u0002\u0003FV3si\u0016DH\u0006I*uCR,\u0017\u0006I\u001f?A\t{w\u000e\\3b]&\u0002'\u0002\t\u0011+A\u0001\u0002#\b\t$jYR,'/\u001a3!m&,w\u000fI8gAQDW\rI4sCBD\u0007%Y2iS\u00164X\r\u001a\u0011cs\u0002\u0012X\r^1j]&tw\r\t<feRL7-Z:!C\u000e\u001cwN\u001d3j]\u001e\u0004Co\u001c\u0011bAA\u0014X\rZ5dCR,\u0007EZ;oGRLwN\u001c\u0011|gv\u0004g\r\u0019\u0006!A)R\u0001\u0005\t\u0016!A\u0001\"\u0006.[:!iJ\fgn\u001d4pe6\u001c\b\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!Ef\u00043.Z3qS:<\u0007e\u001c8ms\u00022XM\u001d;jG\u0016\u001c\bEZ8sA]D\u0017n\u00195!wNl\bM\u001a1!e\u0016$XO\u001d8tAQ\u0014X/\u001a\u0017!o\",'/\u001a\u0011|gv\u0004g\r\u0019\u0011nCf\u0004C-\u001a9f]\u0012\u0004sN\u001c\u0011he\u0006\u0004\b\u000eI:uCR,gF\u0003\u0011!U\u0001\u0002\u0003\u0005\u00165jg\u00022\u0017\u000e^:!o\u0016dG\u000eI<ji\"Lg\u000eI1!G\"\f\u0017N\u001c\u0011pM\u0002\nGnZ8sSRDWn\u001d\u0011bg\u0002\n\u0007e^1zA=4\u0007\u0005\u001d:v]&tw\r\t;iK\u0002:'/\u00199iu\u00012wN\u001d\u0011fq\u0006l\u0007\u000f\\3-A=tW\rI2pk2$\u0007EZ5sgR\u0004c-\u001b7uKJ\u0004s.\u001e;!m\u0016\u0014H/[2fg*\u0001\u0003E\u000b\u0011!A\t,Gn\\<!C\u0002\u001aWM\u001d;bS:\u0004C-Z4sK\u0016\u0004#-\u001a4pe\u0016\u0004#/\u001e8oS:<\u0007%\u0019\u0011dQ>\u001cXM\u001c\u0011bY\u001e|'/\u001b;i[:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018gS2$XM]:/-\u0016\u0014H/\u001a=GS2$XM]\u0015\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Ntc-\u001b7uKJ\u001chFV3si\u0016D\u0018+^1oi&dWMR5mi\u0016\u0014\u0018F\u0003\u0011!U\u0001ZV\fK2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u0019LG\u000e^3sg:*EmZ3GS2$XM]\u0015\u000bA\u0001R\u0003\u0005\u00191a\u0015\u0001\u0002#fL\u0001\u0017-\u0016\u0014H/\u001a=GS2$XM]$sCBD7\u000b^1uKB\u0011q'B\n\u0004\u000bec\u0006C\u0001\u000f[\u0013\tYVD\u0001\u0004B]f\u0014VM\u001a\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f!![8\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002/R\u0011aG\u001a\u0005\u00065\u001d\u0001\raG\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A\u000eY\u0001\u0005Y\u0006tw-\u0003\u0002oW\n1qJ\u00196fGR\u0004")
public class VertexFilterGraphState
extends NodeList {
    private final Function2<Vertex, GraphState, Object> f;

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.vertexFilter(this.f);
    }

    public VertexFilterGraphState(Function2<Vertex, GraphState, Object> f) {
        this.f = f;
        super(NodeList$.MODULE$.$lessinit$greater$default$1(), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

