/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.EdgeFilter$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Edge;
import com.typesafe.scalalogging.Logger;
import scala.Function1;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`EdgeFilter(f: (Vertex, State) => Boolean)`\n  *   : Filtered view of the graph achieved by retaining edges according to a predicate function {s}`f`\n  *\n  *   This transforms the graph by keeping only edges for which {s}`f` returns true.\n  *   This fits well within a chain of algorithms as a way of pruning the graph: for example, one could first filter out edges\n  *   below a certain weight before running a chosen algorithm.\n  *\n  * ## Parameters\n  *\n  * {s}`pruneNodes: Boolean=true`\n  *   : if this is {s}`true` then vertices which become isolated (have no incoming or outgoing edges)\n  *        after this filtering are also removed.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.VertexFilter)\n  * [](com.raphtory.algorithms.filters.EdgeQuantileFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005q4A\u0001D\u0007\u0001-!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00032\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015Y\u0004\u0001\"\u0011=\u000f\u0015AV\u0002#\u0001Z\r\u0015aQ\u0002#\u0001[\u0011\u0015)d\u0001\"\u0001d\u0011\u0015Yd\u0001\"\u0001e\u0011\u001d9g!%A\u0005\u0002!Dqa\u001d\u0004\u0012\u0002\u0013\u0005\u0001\u000eC\u0004u\r\u0005\u0005I\u0011B;\u0003\u0015\u0015#w-\u001a$jYR,'O\u0003\u0002\u000f\u001f\u00059a-\u001b7uKJ\u001c(B\u0001\t\u0012\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003%M\t\u0001B]1qQR|'/\u001f\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqR%D\u0001 \u0015\t\u0001\u0013%A\u0005bY\u001e|'/\u001b;i[*\u0011!eI\u0001\tC:\fG._:jg*\u0011A%E\u0001\u0004CBL\u0017B\u0001\u0014 \u0005\u001d9UM\\3sS\u000e\f\u0011A\u001a\t\u00051%Z\u0013'\u0003\u0002+3\tIa)\u001e8di&|g.\r\t\u0003Y=j\u0011!\f\u0006\u0003]\u0005\nqA^5tSR|'/\u0003\u00021[\t!Q\tZ4f!\tA\"'\u0003\u000243\t9!i\\8mK\u0006t\u0017A\u00039sk:,gj\u001c3fg\u00061A(\u001b8jiz\"2aN\u001d;!\tA\u0004!D\u0001\u000e\u0011\u001593\u00011\u0001)\u0011\u001d!4\u0001%AA\u0002E\nQ!\u00199qYf$\"!\u0010!\u0011\u0005yBeBA A\u0019\u0001AQ!\u0011\u0003A\u0002\t\u000bQa\u001a:ba\"\u0004\"a\u0011$\u000e\u0003\u0011S!!R\u0011\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<\u0018BA$E\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002J\r\n)qI]1qQ\"\"\u0001aS+W!\ta5+D\u0001N\u0015\tqu*\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\t\u0001\u0016+A\u0004uC.,'p\\3\u000b\u0005I\u001b\u0012AB4ji\",(-\u0003\u0002U\u001b\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001X\u0003\u0019erF\u000b\u0016\u000bA\u0001R\u0003e_:~A\u0016#w-\u001a$jYR,'\u000f\u000b4;A!2VM\u001d;fq2\u00023\u000b^1uK&\u0002SH\u0010\u0011C_>dW-\u00198*A*\u0001\u0003E\u000b\u0011!Ai\u0002c)\u001b7uKJ,G\r\t<jK^\u0004sN\u001a\u0011uQ\u0016\u0004sM]1qQ\u0002\n7\r[5fm\u0016$\u0007EY=!e\u0016$\u0018-\u001b8j]\u001e\u0004S\rZ4fg\u0002\n7mY8sI&tw\r\t;pA\u0005\u0004\u0003O]3eS\u000e\fG/\u001a\u0011gk:\u001cG/[8oAm\u001cX\u0010\u00194a\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\u0005\u00165jg\u0002\"(/\u00198tM>\u0014Xn\u001d\u0011uQ\u0016\u0004sM]1qQ\u0002\u0012\u0017\u0010I6fKBLgn\u001a\u0011p]2L\b%\u001a3hKN\u0004cm\u001c:!o\"L7\r\u001b\u0011|gv\u0004g\r\u0019\u0011sKR,(O\\:!iJ,XM\f\u0006!A)\u0002\u0003\u0005\t+iSN\u0004c-\u001b;tA],G\u000e\u001c\u0011xSRD\u0017N\u001c\u0011bA\rD\u0017-\u001b8!_\u001a\u0004\u0013\r\\4pe&$\b.\\:!CN\u0004\u0013\rI<bs\u0002zg\r\t9sk:Lgn\u001a\u0011uQ\u0016\u0004sM]1qQj\u0002cm\u001c:!Kb\fW\u000e\u001d7fY\u0001zg.\u001a\u0011d_VdG\r\t4jeN$\bEZ5mi\u0016\u0014\be\\;uA\u0015$w-Z:\u000bA\u0001R\u0003\u0005\t\u0011cK2|w\u000fI1!G\u0016\u0014H/Y5oA],\u0017n\u001a5uA\t,gm\u001c:fAI,hN\\5oO\u0002\n\u0007e\u00195pg\u0016t\u0007%\u00197h_JLG\u000f[7/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t)be\u0006lW\r^3sg*\u0001\u0003E\u000b\u0006!A)\u00023p]?aaJ,h.\u001a(pI\u0016\u001c(\b\t\"p_2,\u0017M\\\u001fueV,\u0007M\u0003\u0011!U\u0001\u0002\u0003E\u000f\u0011jM\u0002\"\b.[:!SN\u00043p]?aiJ,X\r\u0019\u0011uQ\u0016t\u0007E^3si&\u001cWm\u001d\u0011xQ&\u001c\u0007\u000e\t2fG>lW\rI5t_2\fG/\u001a3!Q!\fg/\u001a\u0011o_\u0002JgnY8nS:<\u0007e\u001c:!_V$xm\\5oO\u0002*GmZ3tS)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011bMR,'\u000f\t;iSN\u0004c-\u001b7uKJLgn\u001a\u0011be\u0016\u0004\u0013\r\\:pAI,Wn\u001c<fI:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018gS2$XM]:/-\u0016\u0014H/\u001a=GS2$XM]\u0015\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Ntc-\u001b7uKJ\u001ch&\u00123hKF+\u0018M\u001c;jY\u00164\u0015\u000e\u001c;fe&R\u0001\u0005\t\u0016!A\u0002\u0004'\u0002\t\u0011+_\u0005QQ\tZ4f\r&dG/\u001a:\u0011\u0005a21c\u0001\u0004\u00187B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0003S>T\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u0002c;\na1+\u001a:jC2L'0\u00192mKR\t\u0011\fF\u00028K\u001aDQa\n\u0005A\u0002!Bq\u0001\u000e\u0005\u0011\u0002\u0003\u0007\u0011'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005I'FA\u0019kW\u0005Y\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003%)hn\u00195fG.,GM\u0003\u0002q3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Il'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s~\u000bA\u0001\\1oO&\u00111\u0010\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class EdgeFilter
implements Generic {
    private final Function1<Edge, Object> f;
    private final boolean pruneNodes;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$2() {
        return EdgeFilter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean apply$default$2() {
        return EdgeFilter$.MODULE$.apply$default$2();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public Table tabularise(GraphPerspective graph) {
        return BaseAlgorithm.tabularise$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.edgeFilter(this.f, this.pruneNodes);
    }

    public EdgeFilter(Function1<Edge, Object> f, boolean pruneNodes) {
        this.f = f;
        this.pruneNodes = pruneNodes;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

