"use strict";
// Integration test to deploy some resources, create an alarm on it and create a dashboard.
//
// Because literally every other library is going to depend on @aws-cdk/aws-cloudwatch, we drop down
// to the very lowest level to create CloudFormation resources by hand, without even generated
// library support.
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudwatch = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudwatch');
const queue = new cdk.CfnResource(stack, 'queue', { type: 'AWS::SQS::Queue' });
const metric = new cloudwatch.Metric({
    namespace: 'AWS/SQS',
    metricName: 'ApproximateNumberOfMessagesVisible',
    dimensions: { QueueName: queue.getAtt('QueueName') },
});
const alarm = metric.createAlarm(stack, 'Alarm', {
    threshold: 100,
    evaluationPeriods: 3,
    datapointsToAlarm: 2,
});
const dashboard = new cloudwatch.Dashboard(stack, 'Dash', {
    dashboardName: 'MyCustomDashboardName',
    start: '-9H',
    end: '2018-12-17T06:00:00.000Z',
    periodOverride: cloudwatch.PeriodOverride.INHERIT,
});
dashboard.addWidgets(new cloudwatch.TextWidget({ markdown: '# This is my dashboard' }), new cloudwatch.TextWidget({ markdown: 'you like?' }));
dashboard.addWidgets(new cloudwatch.AlarmWidget({
    title: 'Messages in queue',
    alarm,
}));
dashboard.addWidgets(new cloudwatch.GraphWidget({
    title: 'More messages in queue with alarm annotation',
    left: [metric],
    leftAnnotations: [alarm.toAnnotation()],
}));
dashboard.addWidgets(new cloudwatch.SingleValueWidget({
    title: 'Current messages in queue',
    metrics: [metric],
}));
dashboard.addWidgets(new cloudwatch.LogQueryWidget({
    title: 'Errors in my log group',
    logGroupNames: ['my-log-group'],
    queryString: `fields @message
                | filter @message like /Error/`,
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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