# :building_construction: CodeStructure

> Extract code signatures without the code :snake:

[![PyPI](https://img.shields.io/pypi/v/codestructure)](https://pypi.org/project/codestructure/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/codestructure)](https://pypi.org/project/codestructure/)
[![PyPI - License](https://img.shields.io/pypi/l/codestructure)](https://pypi.org/project/codestructure/)
[![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/basnijholt/codestructure/pytest.yml)](https://github.com/basnijholt/codestructure/actions/workflows/pytest.yml)

This program extracts information about the structure of Python code by analyzing the abstract syntax tree (AST) of a given Python file.
It extracts information about classes, their attributes, and functions, as well as their signatures, parameters, return types, decorators, and docstrings.
The script then print this information in a human-readable format with syntax highlighting.
It can also copy the output to the clipboard.
It is particularly useful for understanding and documenting complex codebases and writing design docs or when pasting in some code in ChatGPT.

## :star: Features

- 🔎 Identifies class and function signatures without executing the code
  - 📝 Retrieves class attributes
  - 📚 Gathers function parameters and their corresponding types
  - 🔄 Determines function return types
  - 🎨 Recognizes decorators and docstrings
- 🌟 Presents the code in an easily understandable format with Syntax Highlighting
- ✅ Has 100% test coverage

## :books: Table of Contents

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->

- [:package: Installation](#package-installation)
- [:book: Usage](#book-usage)
- [:memo: Example](#memo-example)
- [:busts_in_silhouette: Contributing](#busts_in_silhouette-contributing)
- [:page_with_curl: License](#page_with_curl-license)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->


## :package: Installation

You can install CodeStructure via pip:

```bash
pip install codestructure
```

## :book: Usage

To use CodeStructure, simply run the script with the path to the Python file you want to analyze:

```bash
codestructure path/to/your/python_file.py
```

The script will output the analyzed code structure and copy it to the clipboard if the `pyperclip` package is installed.

Run the script with the `--help` flag to see all available options:

```bash
codestructure --help
```
Which outputs:

<!-- CODE:BASH:START -->
<!-- echo '```bash' -->
<!-- codestructure --help -->
<!-- echo '```' -->
<!-- CODE:END -->

<!-- OUTPUT:START -->
<!-- ⚠️ This content is auto-generated by `markdown-code-runner`. -->
```bash
usage: codestructure [-h] [--no-private] [--no-copy] [--backticks] [--no-rich]
                     [--line-numbers]
                     module_file_path

Analyze the code structure of a Python file.

positional arguments:
  module_file_path  Path to the Python file.

options:
  -h, --help        show this help message and exit
  --no-private      Do not print private functions.
  --no-copy         Do not copy the output to the clipboard.
  --backticks       Use backticks for code blocks.
  --no-rich         Do not use rich to print the output.
  --line-numbers    Print line numbers for the code blocks.
```

<!-- OUTPUT:END -->


## :memo: Example

Given a Python file (`tests/example.py`) with the following content:

<!-- CODE:BASH:START -->
<!-- echo '```python' -->
<!-- tail -n +2 tests/example.py -->
<!-- echo '```' -->
<!-- CODE:END -->

<!-- OUTPUT:START -->
<!-- ⚠️ This content is auto-generated by `markdown-code-runner`. -->
```python
class MyClass:
    my_attr: str
    _my_private_attr: int

    def my_method(self, arg1: int) -> bool:
        """My docstring."""
        x = 1 + 2
        ...


def my_function(arg2: float) -> None:
    arg2 = arg2 + 1
    return arg2**2


def _private_function():
    """My private function."""
    x = 1 + 2
    y = x + 4
    return y
```

<!-- OUTPUT:END -->

CodeStructure will output:

```bash
codestructure --no-private tests/example.py
```

<!-- CODE:BASH:START -->
<!-- codestructure --no-private --no-copy --backticks --no-rich tests/example.py -->
<!-- CODE:END -->
<!-- OUTPUT:START -->
<!-- ⚠️ This content is auto-generated by `markdown-code-runner`. -->
```python
class MyClass:
    my_attr: str
    def my_method(self, arg1: int) -> bool:
        """My docstring."""


def my_function(arg2: float) -> None:
    ...


```

<!-- OUTPUT:END -->

## :busts_in_silhouette: Contributing

We welcome contributions to CodeStructure! If you find a bug or have a feature request, please create an issue on the [GitHub repository](https://github.com/basnijholt/codestructure). If you would like to contribute code, please fork the repository and submit a pull request.

## :page_with_curl: License

CodeStructure is released under the Apache 2.0 License. For more information, please see the [LICENSE](LICENSE) file.
