"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnLoadBalancer = exports.toJson_CfnLoadBalancerPropsRandomSteering = exports.toJson_CfnLoadBalancerProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnLoadBalancerProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnLoadBalancerProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ZoneId': obj.zoneId,
        'Name': obj.name,
        'FallbackPool': obj.fallbackPool,
        'Description': obj.description,
        'Ttl': obj.ttl,
        'SteeringPolicy': obj.steeringPolicy,
        'Proxied': obj.proxied,
        'Enabled': obj.enabled,
        'DefaultPools': obj.defaultPools?.map(y => y),
        'RegionPools': obj.regionPools,
        'CountryPools': obj.countryPools,
        'PopPools': obj.popPools,
        'RandomSteering': toJson_CfnLoadBalancerPropsRandomSteering(obj.randomSteering),
        'SessionAffinity': obj.sessionAffinity,
        'SessionAffinityTtl': obj.sessionAffinityTtl,
        'SessionAffinityAttributes': obj.sessionAffinityAttributes,
        'Rules': obj.rules?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnLoadBalancerProps = toJson_CfnLoadBalancerProps;
/**
 * Converts an object of type 'CfnLoadBalancerPropsRandomSteering' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnLoadBalancerPropsRandomSteering(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DefaultWeight': obj.defaultWeight,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnLoadBalancerPropsRandomSteering = toJson_CfnLoadBalancerPropsRandomSteering;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Cloudflare::LoadBalancer::LoadBalancer`
 *
 * @cloudformationResource Cloudflare::LoadBalancer::LoadBalancer
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-cloudflare-resource-providers.git
 */
class CfnLoadBalancer extends cdk.CfnResource {
    /**
     * Create a new `Cloudflare::LoadBalancer::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLoadBalancer.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnLoadBalancerProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrModifiedOn = cdk.Token.asString(this.getAtt('ModifiedOn'));
        this.attrCreatedOn = cdk.Token.asString(this.getAtt('CreatedOn'));
    }
}
exports.CfnLoadBalancer = CfnLoadBalancer;
_a = JSII_RTTI_SYMBOL_1;
CfnLoadBalancer[_a] = { fqn: "@cdk-cloudformation/cloudflare-loadbalancer-loadbalancer.CfnLoadBalancer", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnLoadBalancer.CFN_RESOURCE_TYPE_NAME = "Cloudflare::LoadBalancer::LoadBalancer";
//# sourceMappingURL=data:application/json;base64,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