# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_widget_containers.ipynb (unless otherwise specified).

__all__ = ['WidgetContainer', 'Box', 'HBox', 'VBox', 'GridBox', 'WidgetList', 'WidgetRow', 'WidgetColumn',
           'SelectionContainer', 'SelectionBox', 'SelectionVBox', 'SelectionHBox', 'TabAcc', 'Tab', 'Accordion']

# Cell
from collections import namedtuple
import traitlets
from traitlets import Type, Unicode, observe, validate, Any, HasTraits, directional_link, link, Tuple, List, Instance
import ipywidgets as ipyw
import numpy as np

# Cell
from .items import Collection, Selection, ItemList, ItemArray
from .widgets import Widget, FloatText, IntText, Label, Grid, FloatSlider

# Cell
class WidgetContainer(Collection, Widget):

    children = ipyw.trait_types.TypedTuple(help="List of widget children").tag(sync=True, **ipyw.widget.widget_serialization)

class Box(WidgetContainer, ipyw.Box):
    pass

class HBox(WidgetContainer, ipyw.HBox):
    pass

class VBox(WidgetContainer, ipyw.VBox):
    pass

class GridBox(WidgetContainer, ipyw.GridBox):
    pass

# Cell
class WidgetList(WidgetContainer, ItemList, ipyw.Box):
    pass

class WidgetRow(WidgetList, ipyw.HBox):
    pass

class WidgetColumn(WidgetList, ipyw.VBox):
    pass

# Cell
class SelectionContainer(Selection, Widget):

    children = ipyw.trait_types.TypedTuple(help="List of widget children").tag(sync=True, **ipyw.widget.widget_serialization)

    def __init__(self, children=None, **kwargs):
        # because there is an optional name parameter from Selection parent and Widget
        if 'name' in kwargs:
            self.name = kwargs['name']
            del kwargs['name']
        if not children:
            children = tuple()
        super().__init__(children, **kwargs)

class SelectionBox(SelectionContainer, ipyw.Box):
    pass

class SelectionVBox(SelectionContainer, ipyw.VBox):
    pass

class SelectionHBox(SelectionContainer, ipyw.HBox):
    pass

# Cell
class TabAcc(Collection, Widget, ipyw.widget_selectioncontainer._SelectionContainer):

    children = ipyw.trait_types.TypedTuple(trait=Instance(ipyw.Widget), help="List of widget children").tag(sync=True, **ipyw.widget.widget_serialization)
    selected_name = Unicode(default_value=None, allow_none=True)
    selected = Any(default_value=None, allow_none=True)

    def __init__(self, children=None, **kwargs):
        super().__init__(**kwargs)
        self._names = {}
        self._indices = {}
        if children:
            self.children = children

    def _add_child(self, child):
        assert hasattr(child, 'name'), 'Children of Tab and Accordion must have a name attribute'
        self._names[self._size] = child.name
        self._indices[child.name] = self._size
        super()._add_child(child)

        self.set_title(self._size - 1, child.name)

    @observe('selected_index')
    def _observe_selected_index(self, change):
        if change['new']  is not None:
            self.selected_name = self._names[change['new']]
        else:
            self.selected_name = None
        return change['new']

    @observe('selected_name')
    def _observe_selected_name(self, change):
        if change['new'] is not None:
            self.selected_index = self._indices[change['new']]
        else:
            self.selected_index = None
        return change['new']

    @observe('_children')
    def _observe_children(self, change):
        self.children = change['new']
        return change['new']

class Tab(TabAcc, ipyw.Tab):
    pass

class Accordion(TabAcc, ipyw.Accordion):
    pass