# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/models.mod.ipynb (unless otherwise specified).

__all__ = ['VariableLandingModel', 'INIT_LEVEL', 'CONT', 'CATG', 'CONT_CATG_OPTS', 'FLOAT_TEXT_STEP',
           'DEFAULT_SD_VALUE', 'LEVEL_MAX', 'PROP_MIN', 'PROP_MAX', 'VariableModel', 'InteractionsModel',
           'ModerationLandingModel', 'PRED_MIN', 'PRED_MAX', 'COV_MIN', 'COV_MAX', 'ModerationModel']

# Cell
from traitlets import Unicode, Int, List, Float, Dict, link
from ..mvc import Model

# Cell
"""A predictor or covariate"""
INIT_LEVEL = 'Lvl'
CONT = 'Continuous'
CATG = 'Categorical'
CONT_CATG_OPTS = [CONT, CATG]
FLOAT_TEXT_STEP = 0.01
DEFAULT_SD_VALUE = 1
LEVEL_MAX = 6

PROP_MIN = 0
PROP_MAX = 1

from ..mvc import Model
from traitlets import Unicode, List, Int, Float, Bool

class VariableLandingModel(Model):

    name = Unicode()
    type = Unicode()
    levels = List()
    count = Int()
    min = Int()
    max = Int()

    # var_list
    is_level = Bool()
    level = Int()

    sd = Float()
    slope = Float()

    def __init__(self, name):
        self.name = name
        self.type = CONT
        self.count = 2
        self.levels = [name + INIT_LEVEL + str(i+1) for i in range(LEVEL_MAX)]

# Cell
class VariableModel(VariableLandingModel):

    sd = Float()
    slope = Float()
    cur_value = Float()
    props = List()
    slopes = List()
    cur_values = List()
    types = List()

    def __init__(self, name, **kwargs):
        super().__init__(name, **kwargs)

# Cell
class InteractionsModel(Model):

    terms = List()
    descriptions = Dict()
    included = Dict()
    slopes = Dict()
    var_lists = Dict()

    def __init__(self):
        self.reset()

    def reset(self):
        self.var_lists = {}
        self.included = {}
        self.slopes = {}
        self.terms = []
        self.descriptions = {}

    def add(self, term, var_list):
        self.terms.append(term)
        desc = term.replace('*','',1)  # Remove leading "*" from term
        self.descriptions[term] = desc
        self.var_lists[term] = var_list
        self.included[term] = True
        return desc

# Cell
PRED_MIN = 2
PRED_MAX = 5
COV_MIN = 0
COV_MAX = 20

class ModerationLandingModel(Model):
    """Values for moderation landing"""

    ''' landing traits '''
    standard = Unicode()
    dep_var = Unicode()
    num_pred = Int()
    betaStr = Unicode()
    total_cov = Int()
    pow_cov = Int()
    predictors = List()
    covariates = List()
    betaStr = Unicode()

    def __init__(self):
        self.observe(self.observeStandard, 'standard')
        self.setLanding()

    def setLanding(self):
        self.interactions = InteractionsModel()
        self.standard =  'Standardized'
        self.dep_var = 'Y'
        self.total_cov  = COV_MIN
        self.pow_cov = 0
        self.num_pred = PRED_MIN
        self.predictors = [VariableModel('X' + str(i+1)) for i in range(PRED_MAX)]
        self.covariates = [VariableModel('Cov' + str(i+1)) for i in range(COV_MAX)]

    def observeStandard(self, change):
        if change['new'] == 'Standardized':
            self.betaStr = u'𝛽'
        else:
            self.betaStr = u'𝑏'

# Cell
class ModerationModel(ModerationLandingModel):

    dep_var_sd = Float()
    b0 = Float()

    def __init__(self):
        super().__init__()

    def setEstimates(self):
        self.dep_var_sd = 1
        self.b0 = 0

    def run(self):
        return {}