# Generated by Django 2.2.3 on 2020-12-15 12:34

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='DRPaymentTypeModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(max_length=50, unique=True)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=9)),
                ('payment_plan', models.PositiveIntegerField(blank=True, null=True, unique=True)),
                ('currency', models.CharField(default='USD', max_length=3)),
                ('custom_logo', models.URLField(blank=True, max_length=500, null=True)),
                ('custom_title', models.CharField(blank=True, max_length=200, null=True)),
                ('pay_button_text', models.CharField(default='Sign Up', max_length=100)),
                ('payment_options', models.CharField(default='card', max_length=100)),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Payment Type',
                'verbose_name_plural': 'Payment Types',
            },
        ),
        migrations.CreateModel(
            name='DRTransactionModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('reference', models.CharField(max_length=200)),
                ('flutterwave_reference', models.CharField(max_length=200)),
                ('order_reference', models.CharField(max_length=200)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=9)),
                ('charged_amount', models.DecimalField(decimal_places=2, max_digits=9)),
                ('status', models.CharField(max_length=50)),
                ('payment_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dr_transactions', to='djangorave.DRPaymentTypeModel')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dr_transactions', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Transaction',
                'verbose_name_plural': 'Transactions',
            },
        ),
    ]
