# dedUCE

dedUCE is a tool for efficiently finding ultra-conserved elements across multiple genomes.

## Development tasks

It's recommended to set up a virtual environment to prevent installed dependencies polluting your global Python installation.

You can do this using:

```shell script
python3 -m venv env
source env/bin/activate
```

### Installing dependencies

`make setup` for runtime dependencies

`make setup-dev` for development tools

### Running dedUCE

`make install` will install the CLI program `deduce`.

Run `deduce -h` to see usage.

### Testing

All tests live in the `/tests` directory. Run them using `make test`.

### Documentation

Documentation is generated by Sphinx using `make docs`.

### Code standards

Please adhere to the code standards set by the [Black](https://github.com/psf/black) autoformatter. You can format all Python code with `make format`.