"""

Command line: /Volumes/workarea/venvs/genice2/bin/genice zeolite[BSV] -f python
Reshaping the unit cell.
  i:[1 0 0]
  j:[0 1 0]
  k:[0 0 1]
"""
import genice2.lattices
desc = {
    "ref": {
        "engel05": "Engel 2018",
        "BSV": "IZA Database"
    },
    "usage": "No options available.",
    "brief": "Hypothetical zeolitic ice of the gyroid structure."
}


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.bondlen = 0.3036000000000001
        self.coord = 'relative'
        from genice2.cell import cellvectors
        self.cell = cellvectors(a=1.62983310, b=1.62983310, c=1.62983310)
        self.density = 0.6627864013871365
        self.waters = """
    0.6362    0.5990    0.0060
    0.1362    0.0990    0.5060
    0.4940    0.3638    0.0990
    0.9940    0.8638    0.5990
    0.4010    0.5060    0.8638
    0.9010    0.0060    0.3638
    0.6362    0.0990    0.9940
    0.1362    0.5990    0.4940
    0.4940    0.8638    0.9010
    0.9940    0.3638    0.4010
    0.4010    0.0060    0.1362
    0.9010    0.5060    0.6362
    0.1362    0.4010    0.0060
    0.6362    0.9010    0.5060
    0.9940    0.6362    0.0990
    0.4940    0.1362    0.5990
    0.9010    0.4940    0.8638
    0.4010    0.9940    0.3638
    0.1362    0.9010    0.9940
    0.6362    0.4010    0.4940
    0.9940    0.1362    0.9010
    0.4940    0.6362    0.4010
    0.9010    0.9940    0.1362
    0.4010    0.4940    0.6362
    0.8490    0.8862    0.2560
    0.3490    0.3862    0.7560
    0.6138    0.7440    0.3490
    0.1138    0.2440    0.8490
    0.7560    0.6510    0.1138
    0.2560    0.1510    0.6138
    0.3490    0.8862    0.2440
    0.8490    0.3862    0.7440
    0.1138    0.7440    0.1510
    0.6138    0.2440    0.6510
    0.2560    0.6510    0.3862
    0.7560    0.1510    0.8862
    0.6510    0.3862    0.2560
    0.1510    0.8862    0.7560
    0.8862    0.2440    0.3490
    0.3862    0.7440    0.8490
    0.7440    0.1510    0.1138
    0.2440    0.6510    0.6138
    0.1510    0.3862    0.2440
    0.6510    0.8862    0.7440
    0.3862    0.2440    0.1510
    0.8862    0.7440    0.6510
    0.2440    0.1510    0.3862
    0.7440    0.6510    0.8862
    0.3638    0.4010    0.9940
    0.8638    0.9010    0.4940
    0.5060    0.6362    0.9010
    0.0060    0.1362    0.4010
    0.5990    0.4940    0.1362
    0.0990    0.9940    0.6362
    0.3638    0.9010    0.0060
    0.8638    0.4010    0.5060
    0.5060    0.1362    0.0990
    0.0060    0.6362    0.5990
    0.5990    0.9940    0.8638
    0.0990    0.4940    0.3638
    0.8638    0.5990    0.9940
    0.3638    0.0990    0.4940
    0.0060    0.3638    0.9010
    0.5060    0.8638    0.4010
    0.0990    0.5060    0.1362
    0.5990    0.0060    0.6362
    0.8638    0.0990    0.0060
    0.3638    0.5990    0.5060
    0.0060    0.8638    0.0990
    0.5060    0.3638    0.5990
    0.0990    0.0060    0.8638
    0.5990    0.5060    0.3638
    0.1510    0.1138    0.7440
    0.6510    0.6138    0.2440
    0.3862    0.2560    0.6510
    0.8862    0.7560    0.1510
    0.2440    0.3490    0.8862
    0.7440    0.8490    0.3862
    0.6510    0.1138    0.7560
    0.1510    0.6138    0.2560
    0.8862    0.2560    0.8490
    0.3862    0.7560    0.3490
    0.7440    0.3490    0.6138
    0.2440    0.8490    0.1138
    0.3490    0.6138    0.7440
    0.8490    0.1138    0.2440
    0.1138    0.7560    0.6510
    0.6138    0.2560    0.1510
    0.2560    0.8490    0.8862
    0.7560    0.3490    0.3862
    0.8490    0.6138    0.7560
    0.3490    0.1138    0.2560
    0.6138    0.7560    0.8490
    0.1138    0.2560    0.3490
    0.7560    0.8490    0.6138
    0.2560    0.3490    0.1138
"""
