# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (24,20,8,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        87 239
        201 297
        55 308
        174 312
        220 169
        120 192
        31 231
        200 57
        2 239
        80 223
        153 216
        110 79
        262 101
        155 299
        181 295
        72 191
        128 152
        27 9
        222 286
        143 192
        19 197
        238 162
        318 307
        135 145
        259 234
        281 2
        18 208
        20 210
        168 140
        275 302
        210 54
        259 116
        265 48
        158 270
        0 198
        316 233
        219 205
        223 255
        17 65
        182 32
        8 135
        101 252
        110 286
        18 60
        244 309
        41 116
        61 307
        138 276
        268 14
        181 217
        69 49
        258 55
        287 247
        299 305
        174 283
        29 294
        80 50
        84 285
        314 291
        317 293
        202 221
        147 21
        274 149
        258 91
        319 30
        16 300
        253 172
        26 13
        69 62
        301 39
        108 163
        267 309
        204 79
        111 116
        121 72
        174 10
        84 274
        193 276
        155 248
        263 142
        238 221
        57 155
        220 50
        301 164
        118 133
        73 291
        200 300
        158 148
        34 33
        126 260
        176 263
        88 224
        151 104
        130 233
        177 256
        31 304
        132 119
        25 104
        26 105
        312 36
        233 198
        199 234
        30 62
        201 225
        165 21
        6 68
        24 136
        92 225
        64 161
        278 257
        10 40
        12 41
        274 157
        296 178
        112 79
        42 293
        300 254
        63 131
        90 148
        218 70
        238 160
        189 141
        263 318
        50 68
        17 19
        201 43
        127 229
        7 123
        209 291
        289 199
        263 86
        64 211
        1 228
        137 140
        243 153
        48 85
        11 58
        259 136
        296 103
        243 166
        244 165
        111 51
        124 82
        187 156
        173 73
        109 146
        173 138
        53 49
        139 134
        3 240
        193 73
        65 52
        237 86
        163 172
        170 298
        24 41
        47 122
        46 123
        315 134
        210 184
        195 218
        128 303
        215 192
        241 232
        36 21
        313 292
        53 167
        130 284
        47 130
        249 257
        200 9
        109 245
        24 122
        120 105
        272 18
        273 20
        179 93
        150 277
        218 288
        26 112
        246 171
        303 311
        295 286
        290 220
        318 46
        175 114
        76 276
        147 145
        166 213
        28 182
        135 43
        268 117
        20 152
        137 85
        237 206
        304 156
        221 178
        5 300
        118 44
        101 222
        196 232
        44 249
        166 55
        308 72
        175 304
        3 235
        68 254
        68 255
        316 260
        56 137
        132 154
        281 59
        99 147
        26 292
        146 129
        188 50
        22 143
        297 284
        16 88
        167 204
        42 164
        27 161
        256 145
        273 171
        197 64
        33 32
        153 186
        118 85
        17 211
        289 160
        15 66
        113 295
        8 272
        165 255
        37 191
        97 206
        287 230
        247 211
        110 210
        89 262
        60 256
        99 190
        283 281
        113 261
        8 203
        275 271
        102 148
        301 7
        228 247
        100 288
        227 56
        247 52
        67 212
        100 121
        99 59
        242 46
        157 29
        58 62
        12 162
        187 78
        24 238
        209 104
        125 139
        106 65
        170 137
        124 29
        83 33
        25 81
        35 162
        277 52
        23 112
        75 116
        123 253
        87 248
        22 49
        25 45
        251 172
        219 78
        184 131
        278 235
        5 2
        303 146
        222 217
        114 306
        17 87
        89 23
        94 82
        92 2
        308 63
        23 102
        254 190
        252 192
        198 98
        276 95
        138 260
        214 288
        211 9
        27 290
        39 302
        250 194
        3 45
        207 234
        251 230
        266 147
        36 267
        31 118
        134 38
        179 227
        205 265
        113 215
        170 282
        280 190
        268 16
        241 189
        20 204
        241 60
        35 156
        188 182
        226 255
        13 144
        36 256
        43 234
        56 133
        152 53
        71 198
        96 308
        193 178
        226 299
        94 86
        11 195
        194 13
        3 269
        46 164
        121 216
        88 244
        319 217
        264 158
        0 141
        208 229
        58 70
        148 313
        126 160
        307 253
        162 284
        218 33
        41 205
        57 169
        251 7
        122 48
        173 141
        51 297
        169 254
        290 172
        107 297
        0 40
        168 219
        243 317
        298 269
        13 240
        272 189
        273 191
        4 283
        168 298
        314 141
        10 260
        317 142
        97 30
        151 44
        176 61
        290 14
        187 298
        10 177
        246 91
        6 182
        114 125
        22 110
        69 128
        275 153
        183 39
        89 212
        143 222
        6 277
        66 280
        206 115
        165 190
        285 313
        264 292
        273 96
        180 168
        154 81
        219 139
        92 15
        88 280
        179 215
        152 37
        187 45
        280 161
        119 189
        87 200
        84 319
        179 286
        29 115
        209 114
        243 72
        108 61
        49 184
        12 51
        221 95
        262 133
        150 305
        143 261
        151 306
        140 265
        77 81
        64 155
        44 103
        151 240
        1 186
        115 129
        32 253
        169 161
        117 223
        231 282
        45 265
        115 245
        47 35
        4 98
        83 214
        314 132
        163 287
        191 293
        117 244
        201 229
        120 144
        278 93
        107 259
        136 289
        63 70
        92 98
        42 157
        128 54
        196 76
        196 75
        289 316
        122 178
        109 131
        94 213
        185 149
        125 103
        12 78
        6 268
        250 125
        1 230
        170 304
        232 177
        279 34
        1 271
        299 228
        230 39
        193 38
        15 229
        310 77
        207 127
        175 296
        311 121
        285 212
        0 126
        174 239
        188 307
        186 183
        119 77
        272 40
        246 285
        185 42
        301 213
        203 196
        107 310
        262 231
        227 235
        108 57
        112 257
        34 183
        18 267
        19 267
        266 309
        102 204
        264 231
        106 21
        194 264
        315 205
        249 74
        202 291
        215 270
        127 60
        258 37
        131 62
        150 302
        91 53
        40 159
        237 236
        28 302
        250 249
        239 159
        167 313
        51 77
        195 123
        288 236
        47 73
        14 32
        188 214
        214 216
        181 245
        78 81
        117 52
        199 225
        129 236
        82 206
        180 278
        318 236
        28 216
        180 144
        71 284
        176 271
        294 67
        266 224
        89 292
        90 294
        296 85
        4 197
        37 311
        65 309
        111 43
        75 310
        93 79
        202 35
        95 126
        31 306
        171 124
        235 140
        76 134
        226 277
        19 159
        102 67
        317 94
        314 95
        154 139
        173 233
        242 157
        181 294
        212 217
        203 119
        23 74
        158 74
        25 315
        150 287
        4 66
        144 269
        220 61
        101 227
        38 104
        232 138
        319 261
        295 54
        185 258
        103 38
        209 154
        5 99
        76 132
        93 120
        180 250
        176 251
        228 223
        283 316
        160 71
        242 11
        130 136
        83 186
        163 9
        208 135
        266 208
        164 142
        107 127
        167 105
        175 202
        248 312
        82 149
        5 224
        66 59
        108 305
        207 59
        171 67
        242 129
        69 261
        27 16
        195 237
        197 312
        124 293
        80 14
        156 48
        30 245
        270 282
        96 184
        279 70
        15 224
        98 159
        71 225
        240 257
        241 310
        100 146
        282 252
        96 91
        279 311
        8 177
        271 305
        86 7
        80 83
        166 183
        207 145
        109 54
        185 213
        58 303
        97 11
        111 203
        194 306
        56 270
        279 55
        97 274
        84 90
        275 142
        246 149
        269 252
        90 113
        28 34
        74 133
        22 105
        315 75
        106 226
        281 199
        106 248
        100 63
        """

        self.waters = """
        0.80639 0.53211 0.06938
        0.5 0.83166 0.8963
        0.0 0.63359 0.28768
        0.5 0.28849 0.61427
        0.5 0.62182 0.20738
        0.0 0.66834 0.3963
        0.0 0.78849 0.61427
        0.69362 0.8958 0.16615
        0.0 0.5521 0.78986
        0.80944 0.7507 0.17711
        0.125 0.57356 0.99266
        0.81862 0.98459 0.36449
        0.875 0.42644 0.49266
        0.68444 0.24807 0.80211
        0.69057 0.80904 0.49214
        0.68444 0.62128 0.4274
        0.80944 0.73341 0.42711
        0.80944 0.69096 0.99214
        0.68139 0.59632 0.79073
        0.68444 0.64843 0.99267
        0.18139 0.09632 0.79073
        0.25 0.6739 0.74237
        0.625 0.14925 0.64941
        0.30944 0.19096 0.99214
        0.19362 0.43674 0.36802
        0.5 0.37818 0.70738
        0.625 0.20027 0.83561
        0.68444 0.75193 0.30211
        0.0 0.87818 0.70738
        0.18139 0.04425 0.17745
        0.625 0.05786 0.36455
        0.625 0.29625 0.14671
        0.81557 0.85157 0.49267
        0.69057 0.88497 0.57077
        0.81557 0.90363 0.69224
        0.68139 0.40368 0.29073
        0.375 0.64001 0.83728
        0.0 0.02114 0.80282
        0.31557 0.37872 0.9274
        0.81557 0.87872 0.9274
        0.875 0.57356 0.99266
        0.125 0.42644 0.49266
        0.0 0.98838 0.05282
        0.0 0.54115 0.57016
        0.31557 0.3042 0.98995
        0.5 0.3409 0.58417
        0.0 0.92875 0.24245
        0.5 0.42875 0.24245
        0.375 0.35999 0.33728
        0.69362 0.1042 0.66615
        0.30944 0.80904 0.49214
        0.80639 0.46789 0.56938
        0.81557 0.74807 0.80211
        0.81862 0.09632 0.79073
        0.18139 0.08554 0.53762
        0.69362 0.97757 0.78597
        0.18444 0.25193 0.30211
        0.19057 0.7507 0.17711
        0.81862 0.00097 0.48949
        0.31557 0.62128 0.4274
        0.5 0.57125 0.74245
        0.25 0.8261 0.24237
        0.69362 0.04756 0.48991
        0.5 0.99544 0.61622
        0.5 0.71151 0.11427
        0.875 0.70027 0.83561
        0.5 0.63799 0.36361
        0.30944 0.11504 0.07077
        0.18444 0.77054 0.55211
        0.81862 0.08554 0.53762
        0.69362 0.96789 0.56938
        0.80639 0.52243 0.28597
        0.30639 0.97757 0.78597
        0.5 0.43351 0.08404
        0.18444 0.22946 0.05211
        0.31862 0.45575 0.67745
        0.125 0.44215 0.86455
        0.68139 0.45575 0.67745
        0.80944 0.38497 0.57077
        0.25 0.1739 0.74237
        0.5 0.81698 0.58538
        0.68444 0.40363 0.69224
        0.5 0.00457 0.11622
        0.5 0.86039 0.63239
        0.81557 0.09637 0.19224
        0.25 0.3261 0.24237
        0.5 0.92313 0.18176
        0.0 0.68302 0.08538
        0.68444 0.69581 0.48995
        0.5 0.18302 0.08538
        0.0 0.12182 0.20738
        0.69362 0.06327 0.86802
        0.80944 0.60425 0.31765
        0.125 0.20375 0.64671
        0.5 0.95885 0.07016
        0.0 0.45885 0.07016
        0.5 0.0521 0.78986
        0.69362 0.02243 0.28597
        0.68444 0.59637 0.19224
        0.19057 0.65993 0.4909
        0.30639 0.96789 0.56938
        0.5 0.21423 0.36427
        0.18444 0.14843 0.99267
        0.19057 0.34008 0.9909
        0.5 0.36202 0.86361
        0.75 0.1739 0.74237
        0.125 0.70027 0.83561
        0.5 0.51162 0.55282
        0.125 0.79625 0.14671
        0.30639 0.04756 0.48991
        0.375 0.14925 0.64941
        0.0 0.49544 0.61622
        0.375 0.20027 0.83561
        0.0 0.13799 0.36361
        0.80944 0.34008 0.9909
        0.30639 0.02243 0.28597
        0.19362 0.46789 0.56938
        0.69057 0.7493 0.67711
        0.375 0.29625 0.14671
        0.80639 0.47757 0.78597
        0.875 0.20375 0.64671
        0.18139 0.95575 0.67745
        0.31862 0.40368 0.29073
        0.81862 0.90368 0.29073
        0.30639 0.03211 0.06938
        0.0 0.33166 0.8963
        0.0 0.50457 0.11622
        0.5 0.5665 0.58404
        0.0 0.0665 0.58404
        0.18139 0.98459 0.36449
        0.5 0.47886 0.30282
        0.5 0.04115 0.57016
        0.875 0.44215 0.86455
        0.30944 0.2507 0.17711
        0.19057 0.39575 0.81765
        0.0 0.57687 0.68176
        0.31862 0.48459 0.36449
        0.125 0.29973 0.33561
        0.31862 0.49903 0.98949
        0.0 0.36641 0.78768
        0.19057 0.30904 0.49214
        0.68139 0.49903 0.98949
        0.18139 0.91446 0.03762
        0.69057 0.15993 0.4909
        0.80944 0.2493 0.67711
        0.19362 0.6042 0.66615
        0.18139 0.00097 0.48949
        0.125 0.64925 0.64941
        0.0 0.15911 0.08417
        0.69362 0.03211 0.06938
        0.0 0.8135 0.89648
        0.5 0.3135 0.89648
        0.0 0.07125 0.74245
        0.30944 0.89575 0.81765
        0.80944 0.39575 0.81765
        0.31557 0.72946 0.05211
        0.625 0.35999 0.33728
        0.0 0.01757 0.17782
        0.0 0.21151 0.11427
        0.80944 0.61504 0.07077
        0.0 0.49965 0.24122
        0.5 0.72274 0.27035
        0.80639 0.43674 0.36802
        0.875 0.79625 0.14671
        0.0 0.93351 0.08404
        0.375 0.70375 0.64671
        0.625 0.94215 0.86455
        0.875 0.14001 0.83728
        0.0 0.31698 0.58538
        0.31557 0.75193 0.30211
        0.875 0.29973 0.33561
        0.375 0.07356 0.99266
        0.75 0.8261 0.24237
        0.5 0.48838 0.05282
        0.19057 0.61504 0.07077
        0.875 0.35075 0.14941
        0.375 0.85075 0.14941
        0.19362 0.56327 0.86802
        0.19362 0.3958 0.16615
        0.18444 0.19581 0.48995
        0.0 0.27712 0.70864
        0.30944 0.10425 0.31765
        0.0 0.8409 0.58417
        0.69057 0.89575 0.81765
        0.5 0.07687 0.68176
        0.81862 0.99903 0.98949
        0.5 0.86641 0.78768
        0.68444 0.35157 0.49267
        0.18444 0.85157 0.49267
        0.68139 0.51541 0.86449
        0.31557 0.69581 0.48995
        0.18139 0.01541 0.86449
        0.81557 0.19581 0.48995
        0.31862 0.41446 0.03762
        0.80944 0.26659 0.92711
        0.69362 0.93674 0.36802
        0.19362 0.47757 0.78597
        0.5 0.65911 0.08417
        0.68139 0.54425 0.17745
        0.125 0.55786 0.36455
        0.0 0.72288 0.20864
        0.80639 0.54756 0.48991
        0.80639 0.3958 0.16615
        0.0 0.50036 0.74122
        0.125 0.14001 0.83728
        0.19057 0.38497 0.57077
        0.5 0.99965 0.24122
        0.31862 0.58554 0.53762
        0.80639 0.6042 0.66615
        0.68444 0.37872 0.9274
        0.30639 0.1042 0.66615
        0.68444 0.72946 0.05211
        0.5 0.13962 0.13239
        0.69362 0.95244 0.98991
        0.30944 0.88497 0.57077
        0.0 0.1865 0.39648
        0.18444 0.90363 0.69224
        0.5 0.13359 0.28768
        0.625 0.92644 0.49266
        0.0 0.36039 0.63239
        0.375 0.79973 0.33561
        0.0 0.42313 0.18176
        0.5 0.16834 0.3963
        0.5 0.77712 0.70864
        0.80944 0.65993 0.4909
        0.875 0.55786 0.36455
        0.18444 0.74807 0.80211
        0.30944 0.23341 0.42711
        0.5 0.78577 0.86427
        0.68139 0.58554 0.53762
        0.69057 0.84008 0.9909
        0.69057 0.2507 0.17711
        0.31862 0.51541 0.86449
        0.5 0.51757 0.17782
        0.19362 0.54756 0.48991
        0.31557 0.27054 0.55211
        0.30639 0.93674 0.36802
        0.5 0.9479 0.28986
        0.0 0.4479 0.28986
        0.0 0.63962 0.13239
        0.5 0.27726 0.77035
        0.5 0.52114 0.80282
        0.0 0.97886 0.30282
        0.375 0.94215 0.86455
        0.625 0.70375 0.64671
        0.375 0.05786 0.36455
        0.625 0.07356 0.99266
        0.69057 0.76659 0.92711
        0.19057 0.69096 0.99214
        0.19057 0.26659 0.92711
        0.0 0.28577 0.86427
        0.625 0.85075 0.14941
        0.69057 0.23341 0.42711
        0.875 0.85999 0.33728
        0.19057 0.73341 0.42711
        0.30944 0.7493 0.67711
        0.31862 0.59632 0.79073
        0.31557 0.24807 0.80211
        0.81862 0.01541 0.86449
        0.31862 0.50097 0.48949
        0.19362 0.53211 0.06938
        0.81557 0.12128 0.4274
        0.5 0.22288 0.20864
        0.30639 0.8958 0.16615
        0.81557 0.22946 0.05211
        0.31557 0.35157 0.49267
        0.875 0.64925 0.64941
        0.625 0.64001 0.83728
        0.81557 0.77054 0.55211
        0.68444 0.27054 0.55211
        0.0 0.22274 0.27035
        0.30944 0.84008 0.9909
        0.80639 0.56327 0.86802
        0.30639 0.06327 0.86802
        0.81862 0.04425 0.17745
        0.18444 0.87872 0.9274
        0.19362 0.45244 0.98991
        0.0 0.77726 0.77035
        0.19057 0.2493 0.67711
        0.81862 0.95575 0.67745
        0.5 0.6865 0.39648
        0.19057 0.60425 0.31765
        0.81557 0.25193 0.30211
        0.31557 0.59637 0.19224
        0.68139 0.48459 0.36449
        0.69057 0.11504 0.07077
        0.30944 0.15993 0.4909
        0.81557 0.8042 0.98995
        0.375 0.92644 0.49266
        0.19362 0.52243 0.28597
        0.625 0.79973 0.33561
        0.68139 0.41446 0.03762
        0.69057 0.19096 0.99214
        0.18139 0.99903 0.98949
        0.18444 0.09637 0.19224
        0.18444 0.12128 0.4274
        0.125 0.35075 0.14941
        0.68139 0.50097 0.48949
        0.80944 0.30904 0.49214
        0.30944 0.76659 0.92711
        0.0 0.71423 0.36427
        0.81862 0.91446 0.03762
        0.0 0.86202 0.86361
        0.0 0.01162 0.55282
        0.75 0.3261 0.24237
        0.18444 0.8042 0.98995
        0.68444 0.3042 0.98995
        0.125 0.85999 0.33728
        0.5 0.00036 0.74122
        0.75 0.6739 0.74237
        0.5 0.48243 0.67782
        0.0 0.98243 0.67782
        0.31557 0.64843 0.99267
        0.81557 0.14843 0.99267
        0.80639 0.45244 0.98991
        0.31557 0.40363 0.69224
        0.31862 0.54425 0.17745
        0.30639 0.95244 0.98991
        0.18139 0.90368 0.29073
        0.69057 0.10425 0.31765
        """

        self.coord = "relative"

        self.cages = """
        12 -0.5 -0.07394 0.67845
        14 0.5 0.29248 0.36608
        15 0.5 0.44161 0.85892
        12 0.0 -0.25245 0.9904
        16 -0.5 -0.42258 0.99254
        12 1.0 0.60893 0.49421
        14 -0.5 -0.35793 0.61745
        12 1.0 0.57394 0.17845
        15 0.5 0.13304 0.87304
        12 0.22554 0.96724 1.1799
        15 0.0 0.05839 0.35892
        15 0.0 0.36696 0.37304
        14 1.0 0.79248 0.36608
        15 0.0 -0.05839 0.85892
        12 0.5 0.10893 0.49421
        12 0.0 -0.49016 0.92661
        14 0.26226 0.67574 1.23903
        16 0.5 0.42258 0.49254
        14 0.0 -0.28704 0.61292
        12 0.77446 0.96724 0.1799
        12 0.5 0.24755 0.9904
        14 0.0 0.14207 0.61745
        14 0.73774 0.67574 0.23903
        12 0.77446 0.03276 0.6799
        12 0.0 0.39107 0.99421
        14 0.73774 0.32426 0.73903
        12 0.22554 0.03276 0.6799
        12 0.5 0.75245 0.4904
        14 0.5 0.78704 0.11292
        12 0.0 0.42606 0.67845
        15 0.5 0.86696 0.37304
        14 0.26226 0.32426 0.73903
        14 0.5 0.35793 0.11745
        12 0.5 0.99016 0.42661
        14 0.5 0.21296 0.61292
        15 0.0 -0.36696 0.87304
        12 -0.5 -0.10893 0.99421
        14 0.23774 0.17574 0.23903
        12 0.27446 -0.46724 0.6799
        14 0.23774 -0.17574 0.73903
        12 0.0 0.25245 0.4904
        15 0.5 0.55839 0.35892
        14 1.0 0.85793 0.11745
        12 -0.27446 -0.46724 0.6799
        12 -0.27446 0.46724 1.1799
        14 -0.23774 -0.17574 0.73903
        12 0.5 0.00984 0.92661
        14 -0.23774 0.17574 1.23903
        12 0.27446 0.46724 0.1799
        12 0.0 0.49016 0.42661
        14 -0.5 -0.29248 0.86608
        16 1.0 0.92258 0.49254
        12 0.5 0.07394 0.17845
        16 0.0 0.07742 0.99254
        14 0.0 0.20752 0.86608
        14 0.0 0.28704 0.11292
        """

        self.bondlen = 3

        self.cell = """
        14.905144573524241 67.5212848021559 21.91947448011618
        """

        self.density = 0.4335854541833566

        self.cell = cellvectors(a=14.905144573524241,
                                b=67.5212848021559,
                                c=21.91947448011618)
