# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (22,4,4,8,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        184 31
        135 25
        131 72
        129 89
        193 78
        145 21
        104 188
        180 148
        151 59
        27 109
        132 143
        147 6
        196 167
        123 98
        2 5
        34 11
        120 2
        67 166
        167 164
        7 8
        49 111
        71 106
        31 187
        16 11
        162 200
        81 159
        9 32
        115 128
        138 54
        89 111
        84 188
        171 13
        57 153
        204 198
        214 203
        168 160
        160 98
        103 150
        205 208
        117 68
        127 210
        27 59
        73 144
        46 134
        106 78
        169 25
        207 130
        52 141
        161 32
        210 22
        177 158
        39 44
        13 167
        19 55
        3 8
        210 215
        95 49
        139 95
        43 123
        186 19
        37 189
        98 102
        47 149
        27 77
        88 87
        65 206
        8 153
        96 119
        28 54
        84 144
        0 11
        154 142
        212 94
        113 196
        115 90
        184 186
        42 69
        95 158
        199 105
        161 160
        136 26
        200 92
        145 138
        40 58
        84 190
        113 178
        45 191
        145 189
        114 143
        146 150
        112 135
        79 60
        70 182
        136 13
        53 213
        56 162
        151 186
        53 59
        37 22
        4 159
        134 133
        193 194
        179 180
        185 144
        108 74
        183 143
        67 173
        120 38
        57 74
        51 19
        28 1
        9 25
        174 201
        60 202
        161 197
        46 30
        4 184
        14 198
        212 6
        74 77
        4 178
        18 72
        176 196
        36 105
        79 148
        126 26
        168 21
        75 106
        94 156
        93 117
        126 186
        80 210
        137 112
        179 100
        162 207
        183 171
        3 116
        24 75
        136 176
        85 141
        154 109
        18 156
        23 175
        14 106
        129 124
        63 175
        168 83
        151 159
        43 99
        73 214
        137 164
        45 97
        91 105
        204 78
        185 181
        120 172
        213 157
        90 195
        207 117
        189 160
        0 152
        143 107
        88 38
        0 9
        17 47
        147 122
        151 74
        161 169
        201 12
        215 60
        10 152
        40 46
        48 206
        211 95
        103 203
        35 182
        77 55
        209 190
        66 110
        154 55
        108 167
        205 130
        142 28
        115 173
        52 78
        35 150
        195 80
        206 111
        64 158
        46 123
        34 5
        162 38
        204 49
        29 87
        56 51
        128 202
        209 101
        23 92
        163 209
        140 192
        29 90
        83 141
        114 122
        101 20
        136 67
        86 211
        79 163
        100 102
        194 149
        124 63
        134 70
        137 179
        131 94
        192 203
        55 1
        61 110
        37 197
        181 149
        41 119
        57 13
        15 69
        140 132
        0 139
        128 82
        174 54
        86 177
        154 157
        195 165
        29 93
        166 107
        85 20
        37 81
        73 70
        176 187
        26 39
        129 48
        118 38
        52 12
        194 71
        211 20
        108 121
        102 61
        135 75
        89 158
        100 215
        152 49
        155 33
        208 107
        104 73
        7 91
        2 182
        172 133
        184 1
        22 213
        62 133
        93 150
        65 116
        127 173
        26 31
        50 116
        24 196
        128 80
        180 202
        4 197
        92 117
        52 152
        170 177
        188 61
        120 192
        173 60
        138 81
        138 82
        191 130
        165 205
        183 90
        118 125
        75 12
        65 170
        140 208
        121 159
        91 19
        48 3
        129 7
        17 193
        178 187
        89 6
        104 149
        32 66
        118 68
        118 23
        80 179
        190 102
        185 76
        76 47
        124 50
        132 103
        127 165
        164 44
        109 97
        110 99
        16 41
        27 125
        146 131
        170 33
        200 63
        122 153
        181 123
        204 155
        35 133
        96 30
        10 119
        76 62
        69 107
        51 59
        193 20
        65 64
        165 166
        156 155
        140 88
        189 215
        31 164
        82 97
        195 44
        192 62
        21 110
        185 134
        72 86
        127 191
        10 206
        126 105
        42 177
        114 212
        112 163
        182 203
        172 30
        83 201
        53 81
        174 32
        18 144
        42 6
        132 29
        104 99
        141 119
        178 169
        53 97
        28 197
        135 101
        7 147
        71 188
        142 82
        58 70
        35 92
        113 121
        17 155
        36 116
        113 201
        166 39
        211 198
        15 114
        48 175
        194 209
        174 21
        8 77
        79 176
        51 157
        205 93
        58 5
        40 11
        85 25
        43 96
        16 30
        24 148
        100 163
        181 190
        68 87
        111 33
        156 214
        14 84
        88 130
        115 45
        3 125
        199 39
        98 66
        183 67
        96 5
        41 64
        40 66
        94 103
        50 91
        15 170
        121 54
        200 172
        2 23
        10 34
        17 86
        16 63
        145 202
        45 87
        43 168
        68 109
        207 157
        148 71
        139 41
        44 171
        112 187
        191 213
        146 62
        125 56
        126 57
        212 33
        214 47
        131 42
        69 199
        9 12
        83 169
        180 61
        147 199
        56 50
        139 85
        146 208
        72 76
        108 1
        142 22
        15 36
        137 24
        36 153
        58 99
        34 175
        14 101
        18 198
        122 171
        124 64
        """

        self.waters = """
        0.84205 0.25 0.30347
        0.86036 0.25 0.68775
        0.5995 0.9375 0.12012
        0.84248 0.9375 0.97578
        0.85631 0.5549 0.61193
        0.662 0.932 0.20865
        0.09502 0.25 0.00871
        0.93912 0.25 0.93006
        0.90659 0.0625 0.89682
        0.86117 0.25 0.39894
        0.83801 0.932 0.20865
        0.75 0.25 0.25939
        0.93993 0.057 0.42378
        0.09707 0.943 0.73064
        0.18993 0.25 0.34693
        0.09788 0.75 0.97436
        0.75 0.443 0.19538
        0.18589 0.75 0.21439
        0.25 0.25 0.21094
        0.84409 0.4299 0.8246
        0.07958 0.5701 0.32527
        0.625 0.932 0.47131
        0.57958 0.4299 0.67473
        0.66038 0.0625 0.05018
        0.125 0.068 0.5287
        0.93993 0.443 0.42378
        0.09707 0.557 0.73064
        0.75 0.9451 0.84578
        0.75 0.25 0.6288
        0.40051 0.0625 0.87989
        0.662 0.568 0.20865
        0.04543 0.432 0.65842
        0.75 0.25 0.45033
        0.09341 0.9375 0.10318
        0.75 0.057 0.19538
        0.50286 0.25 0.0744
        0.00286 0.75 0.9256
        0.64369 0.5549 0.61193
        0.59502 0.75 0.99129
        0.162 0.432 0.79135
        0.65795 0.25 0.30347
        0.83801 0.568 0.20865
        0.15752 0.4375 0.02422
        0.61036 0.75 0.34488
        0.18912 0.25 0.74397
        0.49796 0.875 0.78594
        0.59707 0.443 0.26936
        0.31412 0.75 0.21439
        0.83962 0.0625 0.05018
        0.99796 0.125 0.21407
        0.84248 0.5625 0.97578
        0.75 0.5549 0.84578
        0.95458 0.932 0.34158
        0.65995 0.75 0.73707
        0.75 0.0701 0.58379
        0.81412 0.25 0.78561
        0.75 0.625 0.94254
        0.00204 0.875 0.78594
        0.59707 0.057 0.26936
        0.75 0.75 0.78907
        0.36117 0.75 0.60106
        0.43507 0.125 0.45248
        0.40659 0.5625 0.10318
        0.75 0.375 0.09133
        0.90051 0.5625 0.12012
        0.93589 0.75 0.07896
        0.63883 0.25 0.39894
        0.25 0.75 0.74062
        0.59341 0.0625 0.89682
        0.16038 0.5625 0.94982
        0.50204 0.125 0.21407
        0.25 0.9299 0.41621
        0.25 0.4451 0.15422
        0.40416 0.0549 0.24514
        0.90416 0.9451 0.75487
        0.06493 0.125 0.45248
        0.34409 0.5701 0.17541
        0.84409 0.0701 0.8246
        0.07958 0.9299 0.32527
        0.25 0.75 0.54968
        0.38965 0.25 0.65513
        0.68993 0.75 0.65308
        0.57958 0.0701 0.67473
        0.82876 0.75 0.42322
        0.31007 0.25 0.34693
        0.95458 0.568 0.34158
        0.15591 0.5701 0.17541
        0.49553 0.9375 0.87118
        0.49714 0.75 0.9256
        0.99714 0.25 0.0744
        0.33801 0.068 0.79135
        0.90659 0.4375 0.89682
        0.59788 0.25 0.02564
        0.43589 0.25 0.92104
        0.25 0.125 0.05746
        0.99796 0.375 0.21407
        0.68912 0.75 0.25604
        0.59584 0.9451 0.75487
        0.56007 0.443 0.42378
        0.54543 0.932 0.34158
        0.375 0.432 0.5287
        0.14369 0.4451 0.38808
        0.43507 0.375 0.45248
        0.34248 0.0625 0.02422
        0.42043 0.9299 0.32527
        0.00447 0.5625 0.87118
        0.14369 0.0549 0.38808
        0.25 0.625 0.90867
        0.92043 0.0701 0.67473
        0.65591 0.0701 0.8246
        0.56007 0.057 0.42378
        0.99553 0.0625 0.12882
        0.125 0.432 0.5287
        0.93507 0.875 0.54753
        0.16038 0.9375 0.94982
        0.40294 0.943 0.73064
        0.90498 0.75 0.99129
        0.56089 0.25 0.93006
        0.65752 0.9375 0.97578
        0.81089 0.75 0.25604
        0.56412 0.75 0.07896
        0.85631 0.9451 0.61193
        0.0995 0.0625 0.87989
        0.54543 0.568 0.34158
        0.83962 0.4375 0.05018
        0.75 0.875 0.94254
        0.00204 0.625 0.78594
        0.40294 0.557 0.73064
        0.45458 0.068 0.65842
        0.90212 0.25 0.02564
        0.49553 0.5625 0.87118
        0.25 0.375 0.05746
        0.33962 0.9375 0.94982
        0.50447 0.4375 0.12882
        0.50204 0.375 0.21407
        0.06493 0.375 0.45248
        0.15795 0.75 0.69653
        0.17124 0.25 0.57678
        0.64369 0.9451 0.61193
        0.90294 0.443 0.26936
        0.40212 0.75 0.97436
        0.88965 0.75 0.34488
        0.63965 0.25 0.68775
        0.25 0.875 0.90867
        0.34005 0.25 0.26294
        0.56493 0.875 0.54753
        0.34248 0.4375 0.02422
        0.06412 0.25 0.92104
        0.25 0.943 0.50545
        0.36036 0.75 0.31225
        0.40498 0.25 0.00871
        0.84005 0.75 0.73707
        0.90294 0.057 0.26936
        0.00447 0.9375 0.87118
        0.68589 0.25 0.78561
        0.15591 0.9299 0.17541
        0.25 0.0549 0.15422
        0.65591 0.4299 0.8246
        0.99553 0.4375 0.12882
        0.81007 0.75 0.65308
        0.625 0.568 0.47131
        0.75 0.443 0.49456
        0.65752 0.5625 0.97578
        0.25 0.557 0.50545
        0.11036 0.25 0.65513
        0.33801 0.432 0.79135
        0.25 0.557 0.80462
        0.04543 0.068 0.65842
        0.67124 0.75 0.42322
        0.875 0.568 0.47131
        0.06089 0.75 0.06994
        0.162 0.068 0.79135
        0.5995 0.5625 0.12012
        0.34205 0.75 0.69653
        0.75 0.057 0.49456
        0.75 0.125 0.09133
        0.13883 0.75 0.60106
        0.09341 0.5625 0.10318
        0.93507 0.625 0.54753
        0.32876 0.25 0.57678
        0.375 0.068 0.5287
        0.42043 0.5701 0.32527
        0.50447 0.0625 0.12882
        0.25 0.943 0.80462
        0.92043 0.4299 0.67473
        0.40416 0.4451 0.24514
        0.90416 0.5549 0.75487
        0.06007 0.557 0.57622
        0.35631 0.0549 0.38808
        0.56493 0.625 0.54753
        0.35631 0.4451 0.38808
        0.49796 0.625 0.78594
        0.43912 0.75 0.06994
        0.13965 0.75 0.31225
        0.25 0.75 0.3712
        0.31089 0.25 0.74397
        0.06007 0.943 0.57622
        0.75 0.4299 0.58379
        0.15995 0.25 0.26294
        0.0995 0.4375 0.87989
        0.66038 0.4375 0.05018
        0.875 0.932 0.47131
        0.43993 0.943 0.57622
        0.40659 0.9375 0.10318
        0.09584 0.0549 0.24514
        0.40051 0.4375 0.87989
        0.90051 0.9375 0.12012
        0.59341 0.4375 0.89682
        0.33962 0.5625 0.94982
        0.25 0.5701 0.41621
        0.45458 0.432 0.65842
        0.09584 0.4451 0.24514
        0.15752 0.0625 0.02422
        0.59584 0.5549 0.75487
        0.34409 0.9299 0.17541
        0.43993 0.557 0.57622
        """

        self.coord = "relative"

        self.cages = """
        12 0.64152 0.25 0.16462
        16 -0.25 0.75 -0.90186
        12 -0.13009 0.75 -0.13297
        16 0.06504 0.75 -0.5465
        14 0.25 0.47799 0.64585
        12 -0.25 1.03041 -0.2889
        16 0.56504 0.25 0.5465
        12 -0.00972 0.75 -0.34097
        12 -0.36991 0.75 -0.13297
        12 0.00972 0.25 0.34097
        16 0.25 0.75 0.06205
        12 0.0 0.0 0.0
        12 0.25 -0.03041 0.2889
        12 0.13009 0.25 0.13297
        12 0.25 0.25 0.46893
        12 -0.25 -0.53041 -0.2889
        14 -0.25 0.52201 -0.64585
        12 0.0 0.5 0.0
        12 -0.25 0.75 -0.46893
        15 -0.49354 0.75 -0.7823
        12 -0.14152 0.25 0.16462
        15 -0.00646 0.75 -0.7823
        12 -0.49028 0.75 -0.34097
        12 0.49028 0.25 0.34097
        16 -0.56504 0.75 -0.5465
        16 -0.06504 0.25 0.5465
        16 0.25 0.25 0.90186
        15 0.49354 0.25 0.7823
        15 0.00646 0.25 0.7823
        12 -0.64152 0.75 -0.16462
        12 -0.5 1.0 0.0
        14 0.25 0.02201 0.64585
        12 0.25 0.53041 0.2889
        14 -0.25 -0.02201 -0.64585
        12 0.5 0.5 0.0
        12 0.36991 0.25 0.13297
        16 -0.25 1.25 -0.06205
        12 0.14152 0.75 -0.16462
        """

        self.bondlen = 3

        self.cell = """
        25.527123565841944 14.184590266925788 33.74962414567686
        """

        self.density = 0.5283210180344097

        self.cell = cellvectors(a=25.527123565841944,
                                b=14.184590266925788,
                                c=33.74962414567686)
