# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (30,12,12,6,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        15 329
        259 27
        265 325
        258 67
        87 25
        224 68
        331 143
        39 97
        256 310
        288 89
        239 65
        0 93
        108 116
        109 184
        59 289
        163 155
        306 328
        120 341
        212 277
        243 139
        192 315
        273 279
        62 300
        166 229
        294 337
        138 119
        120 83
        286 282
        30 168
        203 264
        197 82
        196 82
        261 224
        161 220
        297 36
        249 83
        252 168
        288 301
        21 18
        213 157
        28 72
        189 52
        177 254
        255 318
        57 18
        173 335
        182 174
        234 329
        179 115
        225 97
        298 187
        130 336
        163 84
        294 219
        48 40
        16 253
        129 275
        163 330
        261 62
        166 153
        253 159
        233 286
        296 238
        305 22
        193 77
        186 315
        271 147
        170 234
        105 257
        113 280
        30 226
        280 311
        216 26
        122 293
        83 327
        300 37
        126 325
        125 70
        334 102
        332 150
        38 247
        15 137
        22 37
        210 95
        207 194
        46 148
        251 139
        217 187
        162 224
        45 245
        90 332
        74 250
        240 307
        265 54
        149 189
        59 326
        56 209
        194 134
        332 324
        109 105
        213 108
        86 187
        3 147
        200 249
        7 160
        210 153
        162 66
        280 76
        271 186
        228 237
        61 10
        183 117
        125 213
        171 75
        99 329
        216 316
        7 104
        99 230
        120 269
        98 46
        152 51
        144 231
        206 221
        106 45
        86 21
        251 33
        242 268
        210 266
        135 35
        64 145
        318 261
        135 84
        242 93
        291 161
        292 249
        14 251
        103 248
        176 145
        271 73
        165 203
        303 51
        90 182
        177 26
        6 290
        199 262
        145 286
        135 131
        58 127
        231 194
        150 178
        128 177
        313 31
        90 67
        61 134
        223 192
        49 315
        152 312
        313 252
        13 172
        195 40
        3 127
        142 266
        96 84
        63 58
        4 268
        123 235
        285 77
        48 36
        269 78
        75 37
        283 8
        49 182
        270 83
        41 76
        252 244
        38 54
        53 117
        222 256
        158 133
        306 114
        11 98
        44 187
        270 119
        0 50
        331 181
        217 281
        243 338
        241 98
        64 293
        227 88
        105 75
        146 160
        144 156
        60 289
        12 48
        31 247
        51 46
        33 277
        340 66
        104 276
        223 133
        162 274
        85 68
        174 151
        331 298
        301 129
        88 158
        176 136
        180 219
        0 140
        7 125
        63 147
        198 38
        204 302
        149 93
        53 1
        99 258
        126 326
        225 179
        260 143
        103 102
        204 35
        320 171
        40 245
        337 153
        191 140
        309 246
        138 220
        73 231
        336 180
        150 161
        2 77
        243 250
        111 168
        287 333
        122 176
        128 56
        63 69
        230 108
        317 96
        182 178
        244 66
        166 205
        200 311
        174 192
        11 94
        87 159
        6 215
        253 23
        69 52
        22 33
        70 297
        233 201
        28 57
        269 130
        309 200
        121 181
        53 39
        47 195
        200 41
        29 279
        173 299
        258 212
        123 60
        45 322
        209 154
        52 298
        58 218
        14 322
        272 120
        79 340
        16 241
        267 116
        281 314
        303 333
        100 27
        282 136
        283 336
        55 65
        38 299
        107 164
        44 268
        123 232
        158 190
        16 317
        307 5
        284 330
        85 328
        44 183
        286 54
        198 335
        284 175
        190 248
        267 14
        144 132
        87 148
        202 291
        14 114
        79 328
        20 36
        76 293
        15 34
        243 322
        207 236
        231 28
        17 26
        128 8
        225 77
        167 259
        131 330
        41 327
        294 229
        112 168
        257 320
        217 242
        85 106
        29 97
        263 152
        196 264
        86 284
        321 79
        141 303
        112 307
        154 316
        115 285
        202 24
        279 104
        28 321
        169 296
        211 48
        99 54
        287 5
        287 4
        55 197
        234 226
        207 137
        184 139
        173 218
        36 24
        33 34
        9 92
        176 62
        323 10
        9 315
        165 278
        59 339
        170 230
        126 151
        320 72
        57 132
        211 45
        170 227
        338 245
        169 11
        170 255
        13 327
        309 183
        88 256
        115 248
        50 188
        1 29
        160 297
        59 285
        110 218
        25 251
        124 202
        226 274
        63 205
        100 339
        184 22
        103 62
        296 281
        138 327
        260 203
        223 228
        114 227
        113 177
        340 72
        12 160
        308 185
        324 172
        239 159
        214 141
        197 132
        280 20
        179 300
        142 5
        336 56
        214 81
        60 302
        130 13
        334 213
        9 207
        214 287
        110 91
        43 37
        111 10
        80 190
        294 84
        203 215
        273 278
        42 27
        267 277
        239 175
        250 91
        270 140
        299 92
        218 95
        255 158
        270 164
        338 335
        340 68
        16 74
        31 92
        43 34
        305 195
        114 319
        246 292
        53 41
        246 5
        210 313
        197 71
        221 188
        298 330
        247 274
        166 144
        118 74
        272 292
        148 101
        111 148
        42 172
        96 142
        319 101
        329 247
        264 131
        318 238
        240 72
        227 116
        306 94
        242 333
        225 146
        216 125
        318 226
        71 209
        141 312
        273 215
        17 334
        103 255
        290 264
        220 76
        311 254
        339 301
        12 277
        216 107
        332 32
        222 190
        193 289
        105 238
        121 2
        239 134
        273 154
        49 236
        131 143
        284 196
        43 236
        288 143
        321 241
        191 188
        66 91
        21 82
        61 137
        51 93
        334 185
        252 274
        39 293
        78 275
        6 232
        100 283
        118 139
        278 71
        122 161
        111 303
        44 181
        305 179
        309 4
        128 316
        1 278
        165 82
        215 235
        308 222
        20 60
        276 324
        228 173
        272 241
        27 19
        12 305
        188 181
        211 267
        89 219
        199 186
        1 13
        175 257
        196 65
        310 178
        50 268
        259 308
        167 339
        152 23
        19 222
        47 80
        65 23
        193 235
        123 297
        180 301
        17 221
        135 89
        151 19
        169 147
        325 8
        259 119
        238 3
        312 209
        201 40
        32 300
        199 88
        306 199
        113 233
        337 142
        169 189
        304 118
        321 94
        26 50
        257 314
        78 229
        124 157
        167 206
        133 3
        291 106
        275 52
        104 316
        73 205
        178 19
        237 195
        32 97
        323 141
        165 117
        102 145
        81 56
        295 110
        214 337
        49 262
        64 113
        253 46
        229 69
        208 119
        9 73
        80 151
        118 159
        254 4
        17 64
        244 307
        341 140
        78 180
        276 67
        186 133
        304 109
        212 108
        224 136
        325 233
        304 155
        31 137
        265 67
        217 189
        30 296
        291 310
        192 299
        341 275
        124 116
        295 74
        290 23
        288 289
        263 154
        122 32
        328 322
        295 96
        317 292
        110 266
        320 194
        313 10
        302 89
        121 260
        0 107
        208 70
        308 157
        102 230
        58 155
        121 117
        106 136
        282 245
        260 193
        201 326
        335 91
        146 279
        42 150
        302 311
        237 338
        15 25
        47 326
        167 191
        156 134
        11 101
        246 18
        138 42
        29 324
        290 35
        130 71
        220 24
        81 219
        310 262
        276 8
        109 127
        208 157
        331 129
        208 24
        223 80
        211 202
        7 212
        235 146
        263 6
        206 185
        258 34
        86 314
        240 314
        204 249
        317 35
        112 281
        201 20
        112 333
        92 95
        124 256
        319 234
        265 174
        2 221
        47 115
        30 101
        100 126
        85 262
        162 198
        295 155
        263 107
        185 248
        81 254
        55 312
        240 18
        87 61
        323 153
        272 57
        204 232
        164 70
        269 132
        206 285
        191 129
        163 69
        236 171
        79 250
        75 261
        55 156
        198 282
        25 319
        244 266
        271 94
        232 164
        323 156
        304 175
        2 39
        21 183
        149 341
        149 98
        283 172
        90 43
        184 237
        228 127
        95 205
        171 68
        """

        self.waters = """
        0.50775 0.41038 0.86041
        0.81516 0.06628 0.7628
        0.12357 0.27969 0.71302
        0.2923 0.52356 0.26963
        0.2143 0.07335 0.88894
        0.1283 0.97047 0.02422
        0.80329 0.43793 0.85302
        0.67979 0.32413 0.61124
        0.47477 0.0 0.66666
        0.55482 0.91542 0.26872
        0.50048 0.14166 0.13791
        0.55054 0.53808 0.15604
        0.88584 0.46939 0.53421
        0.71989 0.94072 0.77773
        0.7642 0.54066 0.35502
        0.62651 0.22712 0.32501
        0.84375 0.61679 0.07298
        0.31147 0.24597 0.66966
        0.94379 0.00975 0.02009
        0.52863 0.76396 0.55032
        0.0655 0.75403 0.66367
        0.97047 0.1283 0.97577
        0.93733 0.38132 0.40333
        0.77288 0.39939 0.99168
        0.84389 0.72032 0.62032
        0.67587 0.35566 0.27791
        0.38321 0.22697 0.73965
        0.54066 0.7642 0.64497
        0.77563 0.88908 0.12551
        0.80951 0.14128 0.67183
        0.37268 0.31758 0.20851
        0.4608 0.0558 0.2647
        0.92666 0.14096 0.5556
        0.80422 0.36025 0.40346
        0.7077 0.23126 0.39703
        0.94662 0.61833 0.93552
        0.93276 0.67075 0.62516
        0.92386 0.25283 0.40902
        0.32928 0.9882 0.38202
        0.02953 0.15782 0.69089
        0.07091 0.70223 0.51407
        0.93684 0.95111 0.77008
        0.66823 0.85872 0.66149
        0.77304 0.15625 0.40631
        0.18484 0.25112 0.90386
        0.93372 0.74888 0.42947
        0.63976 0.44398 0.07013
        0.20023 0.60449 0.51964
        0.94491 0.62732 0.54184
        0.67075 0.93276 0.37483
        0.36868 0.29777 0.81926
        0.56247 0.35076 0.9868
        0.35076 0.56247 0.0132
        0.95013 0.07975 0.7685
        0.3748 0.04136 0.46748
        0.69216 0.1477 0.00082
        0.46192 0.01246 0.82271
        0.80028 0.90482 0.03647
        0.22032 0.63908 0.18561
        0.22712 0.62651 0.67499
        0.05339 0.67171 0.73114
        0.63464 0.19671 0.18635
        0.11345 0.22438 0.45884
        0.34639 0.66313 0.13876
        0.19972 0.10454 0.6302
        0.80441 0.28546 0.02815
        0.07975 0.95013 0.23149
        0.58962 0.09738 0.52707
        0.93404 0.99026 0.31325
        0.32022 0.64434 0.05543
        0.71454 0.51895 0.69482
        0.68242 0.0551 0.87517
        0.91302 0.0 0.16667
        0.55886 0.83417 0.18811
        0.92909 0.63133 0.15259
        0.0 0.23125 0.33334
        0.99026 0.93404 0.68675
        0.0939 0.38826 0.67355
        0.47644 0.76874 0.9363
        0.85905 0.7857 0.22227
        0.31674 0.65361 0.47209
        0.33345 0.95865 0.86585
        0.87643 0.15611 0.95365
        0.75138 0.75084 0.84467
        0.1477 0.69216 0.99917
        0.84218 0.87171 0.35755
        0.05873 0.25025 0.03502
        0.68327 0.33688 0.19457
        0.53921 0.59501 0.40197
        0.16583 0.72469 0.85477
        0.70223 0.07091 0.48592
        0.06628 0.81516 0.23719
        0.43346 0.92871 0.2703
        0.49327 0.3918 0.95018
        0.6252 0.66655 0.19918
        0.35882 0.85834 0.19543
        0.06724 0.73799 0.0415
        0.94127 0.19152 0.63164
        0.61868 0.55601 0.07
        0.4674 0.17544 0.45056
        0.43753 0.78829 0.67986
        0.53061 0.41645 0.20087
        0.32376 0.25414 0.52528
        0.25414 0.32376 0.47472
        0.64924 0.21171 0.65346
        0.07614 0.32896 0.25764
        0.92025 0.87038 0.43517
        0.59574 0.39551 0.8137
        0.56207 0.36536 0.51968
        0.06267 0.44399 0.26334
        0.1294 0.79172 0.17598
        0.47137 0.23533 0.11634
        0.25112 0.18484 0.09614
        0.23125 0.0 0.66667
        0.64216 0.52392 0.32126
        0.17544 0.4674 0.54944
        0.64118 0.49953 0.47124
        0.0 0.157 0.83333
        0.90263 0.49225 0.19374
        0.65893 0.67072 0.71535
        0.67104 0.74718 0.9243
        0.10005 0.29098 0.79793
        0.98573 0.04889 0.56324
        0.91542 0.55482 0.73128
        0.65846 0.59972 0.51954
        0.60061 0.37349 0.65835
        0.36025 0.80422 0.59653
        0.19578 0.55603 0.2632
        0.44399 0.06267 0.73666
        0.36092 0.58124 0.85227
        0.63133 0.92909 0.8474
        0.07129 0.50474 0.93696
        0.68853 0.9345 0.997
        0.37349 0.60061 0.34165
        0.72469 0.16583 0.14523
        0.08458 0.6394 0.93538
        0.04889 0.98573 0.43675
        0.60953 0.13999 0.26682
        0.74976 0.80848 0.70168
        0.89853 0.50673 0.28351
        0.53808 0.55054 0.84395
        0.47608 0.11824 0.98793
        0.15611 0.87643 0.04635
        0.14166 0.50048 0.86209
        0.61833 0.94662 0.06447
        0.22438 0.11345 0.54115
        0.88176 0.35784 0.65459
        0.39551 0.59574 0.1863
        0.58124 0.36092 0.14773
        0.52523 0.52523 0.0
        0.74888 0.93372 0.57052
        0.41876 0.77969 0.51894
        0.64434 0.32022 0.94458
        0.40499 0.9442 0.06864
        0.63908 0.22032 0.81439
        0.11417 0.58356 0.13246
        0.6394 0.08458 0.06461
        0.59501 0.53921 0.59803
        0.39047 0.53046 0.39984
        0.79978 0.40426 0.14703
        0.83321 0.4233 0.61396
        0.87038 0.92025 0.56482
        0.15782 0.02953 0.30911
        0.16679 0.59009 0.0527
        0.70804 0.5326 0.78389
        0.89996 0.19093 0.86873
        0.46954 0.86001 0.06651
        0.40991 0.5767 0.71937
        0.33768 0.20828 0.15735
        0.41038 0.50775 0.13959
        0.44518 0.3606 0.39794
        0.89546 0.09518 0.29687
        0.65181 0.93712 0.7001
        0.23581 0.77647 0.31164
        0.46939 0.88584 0.46579
        0.95865 0.33345 0.13414
        0.08699 0.08699 0.5
        0.32896 0.07614 0.74236
        0.66232 0.8706 0.50931
        0.04136 0.3748 0.53252
        0.40426 0.79978 0.85297
        0.20828 0.33768 0.84265
        0.62732 0.94491 0.45815
        0.04987 0.12962 0.89815
        0.0 0.47477 0.33333
        0.3606 0.44518 0.60205
        0.51895 0.71454 0.30518
        0.19049 0.33177 0.99483
        0.31758 0.37268 0.79149
        0.3918 0.49327 0.04982
        0.36536 0.56207 0.48032
        0.41645 0.53061 0.79912
        0.4233 0.83321 0.38604
        0.0558 0.4608 0.7353
        0.74586 0.06962 0.19195
        0.09738 0.58962 0.47293
        0.9061 0.29436 0.99312
        0.73799 0.06724 0.95849
        0.19152 0.94127 0.36835
        0.61174 0.70564 0.34021
        0.0 0.91302 0.83333
        0.15625 0.77304 0.59369
        0.80907 0.70903 0.5354
        0.94126 0.34154 0.85288
        0.93038 0.67624 0.85862
        0.43793 0.80329 0.14699
        0.30784 0.45554 0.66584
        0.67171 0.05339 0.26886
        0.70564 0.61174 0.65978
        0.58356 0.11417 0.86754
        0.34154 0.94126 0.14712
        0.8706 0.66232 0.49068
        0.65361 0.31674 0.5279
        0.53046 0.39047 0.60016
        0.34108 0.0118 0.95132
        0.85834 0.35882 0.80457
        0.52356 0.2923 0.73036
        0.28531 0.34819 0.03344
        0.23604 0.76468 0.21699
        0.29196 0.82456 0.88277
        0.87171 0.84218 0.64244
        0.26201 0.32925 0.70817
        0.49953 0.64118 0.52876
        0.32413 0.67979 0.38876
        0.06596 0.05621 0.35342
        0.9882 0.32928 0.61798
        0.32925 0.26201 0.29183
        0.56655 0.49526 0.39636
        0.21171 0.64924 0.34653
        0.39939 0.77288 0.00832
        0.44115 0.27532 0.47856
        0.67624 0.93038 0.14138
        0.83417 0.55886 0.81189
        0.25283 0.92386 0.59097
        0.45554 0.30784 0.33415
        0.92871 0.43346 0.7297
        0.75403 0.0655 0.33633
        0.10147 0.6082 0.38315
        0.22697 0.38321 0.26035
        0.82456 0.29196 0.11722
        0.01428 0.06316 0.10342
        0.74718 0.67104 0.07569
        0.34819 0.28531 0.96656
        0.93712 0.65181 0.29989
        0.157 0.0 0.16667
        0.05928 0.77917 0.4444
        0.00974 0.94379 0.97991
        0.38826 0.0939 0.32645
        0.27532 0.44115 0.52144
        0.88908 0.77563 0.87448
        0.94072 0.71989 0.22226
        0.78829 0.43753 0.32013
        0.29098 0.10005 0.20207
        0.76874 0.47644 0.06369
        0.24862 0.99946 0.82199
        0.32829 0.38168 0.39781
        0.59972 0.65846 0.48045
        0.99946 0.24862 0.17801
        0.60449 0.20023 0.48036
        0.52392 0.64216 0.67874
        0.05874 0.40029 0.81379
        0.10454 0.19972 0.36981
        0.72032 0.84389 0.37968
        0.66313 0.34639 0.86124
        0.9442 0.40499 0.93136
        0.44946 0.98754 0.51062
        0.19093 0.89996 0.13126
        0.76396 0.52863 0.44967
        0.28011 0.22083 0.88893
        0.61679 0.84375 0.92702
        0.66655 0.6252 0.80081
        0.5326 0.70804 0.2161
        0.76876 0.76876 0.0
        0.76468 0.23604 0.783
        0.27969 0.12357 0.28699
        0.44398 0.63976 0.92987
        0.6082 0.10147 0.61684
        0.77969 0.41876 0.48106
        0.79172 0.1294 0.82401
        0.77647 0.23581 0.68835
        0.09518 0.89546 0.70314
        0.22083 0.28011 0.11107
        0.14096 0.92666 0.44439
        0.50673 0.89853 0.71648
        0.0118 0.34108 0.04868
        0.1956 0.48106 0.63852
        0.24916 0.00054 0.51134
        0.25025 0.05873 0.96498
        0.19671 0.63464 0.81365
        0.13999 0.60953 0.73317
        0.86001 0.46954 0.93349
        0.84301 0.84301 0.5
        0.90482 0.80028 0.96353
        0.05621 0.06596 0.64658
        0.28546 0.80441 0.97185
        0.0551 0.68242 0.12482
        0.29777 0.36868 0.18074
        0.8523 0.54446 0.66749
        0.22354 0.45934 0.97831
        0.35784 0.88176 0.34541
        0.00054 0.24916 0.48865
        0.33688 0.68327 0.80542
        0.06962 0.74586 0.80805
        0.45934 0.22354 0.02169
        0.01246 0.46192 0.17728
        0.98754 0.44946 0.48938
        0.67072 0.65893 0.28465
        0.12962 0.04987 0.10184
        0.49526 0.56655 0.60363
        0.06316 0.01427 0.89657
        0.70903 0.80907 0.46459
        0.11092 0.88655 0.79218
        0.59009 0.16679 0.94729
        0.40029 0.05874 0.18621
        0.07335 0.2143 0.11106
        0.54446 0.8523 0.33251
        0.55603 0.19578 0.7368
        0.9345 0.68853 0.00299
        0.24597 0.31147 0.33034
        0.5767 0.40991 0.28062
        0.88655 0.11092 0.20782
        0.75084 0.75138 0.15532
        0.85872 0.66823 0.3385
        0.50474 0.07129 0.06303
        0.71469 0.06288 0.63322
        0.38132 0.93733 0.59667
        0.23126 0.7077 0.60297
        0.7857 0.85905 0.77772
        0.80848 0.74976 0.29831
        0.48106 0.1956 0.36149
        0.11824 0.47608 0.01207
        0.23533 0.47137 0.88366
        0.77917 0.05928 0.55559
        0.33177 0.19049 0.00517
        0.38168 0.32829 0.60219
        0.14128 0.80951 0.32816
        0.49225 0.90263 0.80626
        0.29436 0.9061 0.00688
        0.06288 0.71469 0.36677
        0.35566 0.67587 0.72209
        0.95111 0.93684 0.22991
        0.55601 0.61868 0.93
        """

        self.coord = "relative"

        self.cages = """
        14 0.55103 0.04651 0.38799
        14 0.95349 0.50452 0.05465
        14 0.04651 0.55103 0.61201
        14 0.49548 0.44897 0.72132
        14 0.50452 0.95349 0.94534
        14 0.44897 0.49548 0.27867
        12 0.55398 0.0 0.16667
        12 0.0 0.55398 0.83333
        12 0.44602 0.44602 0.5
        15 0.11674 0.16521 0.23012
        15 0.83479 0.95153 0.89678
        15 0.16521 0.11674 0.76988
        15 0.04847 0.88326 0.56345
        15 0.95153 0.83479 0.10321
        15 0.88326 0.04847 0.43654
        12 0.30899 0.05827 0.07404
        12 0.94173 0.25072 0.7407
        12 0.05827 0.30899 0.92596
        12 0.74928 0.69101 0.40737
        12 0.25072 0.94173 0.25929
        12 0.69101 0.74928 0.59262
        12 0.43755 0.37467 0.08041
        12 0.62533 0.06288 0.74707
        12 0.37467 0.43755 0.91959
        12 0.93712 0.56245 0.41374
        12 0.06288 0.62533 0.25292
        12 0.56245 0.93712 0.58625
        15 0.18781 0.43934 0.13376
        15 0.56066 0.74847 0.80042
        15 0.43934 0.18781 0.86624
        15 0.25153 0.81219 0.46709
        15 0.74847 0.56066 0.19957
        15 0.81219 0.25153 0.5329
        16 0.15434 0.43282 0.39886
        16 0.56718 0.72152 0.06552
        16 0.43282 0.15434 0.60114
        16 0.27848 0.84566 0.73219
        16 0.72152 0.56718 0.93447
        16 0.84566 0.27848 0.2678
        12 0.14121 0.14121 0.0
        12 0.85879 0.0 0.66666
        12 0.0 0.85879 0.33333
        14 0.26383 0.15238 0.41369
        14 0.84762 0.11145 0.08035
        14 0.15238 0.26383 0.58631
        14 0.88855 0.73617 0.74702
        14 0.11145 0.84762 0.91964
        14 0.73617 0.88855 0.25297
        12 0.65148 0.27339 0.06608
        12 0.72661 0.37809 0.73274
        12 0.27339 0.65148 0.93392
        12 0.62191 0.34852 0.39941
        12 0.37809 0.72661 0.26725
        12 0.34852 0.62191 0.60058
        12 0.48745 0.23497 0.24484
        12 0.76503 0.25248 0.9115
        12 0.23497 0.48745 0.75516
        12 0.74752 0.51255 0.57817
        12 0.25248 0.76503 0.08849
        12 0.51255 0.74752 0.42182
        """

        self.bondlen = 3

        self.cell = """
        26.935331764866525 0.0 0.0
        -13.467665882433257 23.326681567736355 0.0
        2.258815726823271e-15 3.912383603793526e-15 36.8892602895128
        """

        self.density = 0.44104471589272415

        self.cell = cellvectors(a=26.935331764866525,
                                b=26.935331764866525,
                                c=36.8892602895128,
                                C=119.99999999999999)
