# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (44,8,8,16,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene. (I phase?)"
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        239 407
        88 177
        177 89
        299 197
        329 169
        131 308
        356 19
        341 253
        372 288
        202 383
        144 70
        289 244
        201 342
        109 220
        48 296
        183 322
        179 416
        84 332
        284 375
        199 277
        5 356
        333 3
        329 214
        223 281
        390 381
        392 405
        155 376
        159 307
        264 81
        372 229
        175 95
        28 245
        360 321
        153 193
        225 94
        126 30
        380 227
        107 184
        309 259
        346 8
        147 353
        102 105
        145 378
        68 56
        279 264
        27 296
        335 78
        119 256
        94 64
        314 275
        382 40
        299 327
        200 233
        23 413
        279 315
        15 290
        201 362
        396 385
        274 376
        207 247
        416 60
        420 342
        224 357
        431 153
        137 136
        293 218
        106 160
        161 373
        99 431
        200 330
        66 233
        236 254
        50 270
        128 305
        141 108
        270 273
        316 221
        367 304
        324 430
        116 257
        374 75
        231 306
        142 133
        33 299
        202 88
        7 90
        370 332
        101 55
        394 331
        333 265
        215 118
        157 64
        242 417
        121 142
        101 17
        319 9
        42 43
        399 398
        381 382
        311 310
        96 306
        117 120
        164 166
        59 192
        21 190
        371 155
        71 176
        311 111
        395 403
        114 43
        121 422
        160 419
        326 85
        70 31
        118 389
        231 44
        119 388
        132 195
        34 336
        206 414
        319 280
        230 354
        287 363
        333 40
        181 6
        208 357
        69 283
        76 103
        205 234
        261 360
        103 77
        402 338
        94 377
        132 33
        346 85
        93 100
        180 102
        428 311
        41 425
        131 86
        374 220
        49 170
        149 259
        266 152
        404 387
        250 370
        293 388
        233 320
        389 294
        125 332
        272 376
        38 169
        14 397
        52 16
        186 363
        217 91
        185 370
        211 95
        89 334
        338 100
        151 369
        117 92
        288 67
        93 326
        422 301
        391 81
        122 25
        420 322
        420 228
        50 179
        416 298
        309 400
        39 285
        390 276
        250 300
        105 379
        194 62
        412 110
        288 174
        152 151
        152 276
        125 92
        199 382
        290 119
        124 427
        15 151
        14 151
        398 375
        1 19
        12 31
        207 302
        156 3
        112 369
        212 60
        21 172
        248 278
        367 411
        65 370
        262 354
        124 253
        314 261
        87 321
        369 219
        97 174
        313 332
        344 309
        154 177
        198 212
        28 182
        124 309
        183 318
        122 81
        395 267
        238 301
        9 18
        349 266
        235 227
        104 53
        395 10
        6 75
        239 368
        248 138
        253 0
        224 39
        94 401
        197 81
        44 184
        291 145
        223 188
        93 64
        50 98
        427 395
        428 423
        364 417
        163 3
        365 418
        125 1
        271 269
        54 47
        91 424
        257 71
        62 109
        238 295
        337 351
        79 55
        194 30
        347 363
        362 322
        149 158
        164 40
        240 406
        393 36
        396 278
        255 305
        246 136
        318 361
        154 228
        246 138
        46 68
        107 299
        397 209
        153 212
        225 297
        325 150
        37 183
        343 279
        130 78
        292 63
        297 140
        341 149
        315 190
        375 243
        421 330
        201 29
        286 20
        334 373
        38 255
        271 317
        124 345
        323 298
        230 59
        115 327
        295 274
        366 12
        321 204
        391 409
        22 234
        172 39
        292 17
        366 7
        199 72
        396 408
        44 58
        285 316
        158 0
        90 430
        97 406
        245 193
        206 67
        33 130
        226 344
        65 1
        45 168
        252 54
        394 294
        280 173
        400 92
        292 79
        330 386
        336 60
        323 4
        14 119
        261 387
        426 348
        13 245
        359 76
        160 430
        14 244
        201 392
        274 350
        0 47
        204 243
        316 139
        157 69
        343 304
        249 266
        13 291
        99 72
        186 389
        76 256
        129 170
        52 417
        37 396
        126 419
        358 84
        347 137
        128 331
        197 407
        366 97
        306 168
        42 315
        281 321
        410 123
        68 87
        98 59
        273 143
        137 4
        106 109
        61 188
        224 220
        57 365
        13 319
        428 166
        108 379
        345 47
        121 219
        202 268
        228 187
        167 384
        53 350
        132 289
        335 96
        367 67
        195 364
        206 386
        207 386
        27 270
        115 424
        329 175
        173 18
        415 183
        262 408
        262 405
        25 209
        246 179
        72 85
        277 425
        185 351
        311 165
        271 187
        339 170
        168 133
        424 242
        342 171
        275 196
        391 194
        239 274
        126 25
        277 265
        329 267
        191 127
        207 288
        144 84
        36 375
        22 337
        163 244
        189 222
        275 56
        402 36
        120 302
        101 320
        340 232
        411 174
        157 237
        2 301
        275 283
        28 135
        184 83
        73 371
        381 399
        359 194
        66 189
        117 282
        260 429
        118 10
        272 407
        27 129
        325 17
        68 398
        162 89
        416 353
        376 190
        173 399
        177 161
        48 268
        102 389
        30 103
        343 430
        216 405
        96 388
        144 146
        349 256
        21 131
        158 287
        298 383
        420 260
        390 281
        210 78
        42 350
        150 320
        178 88
        114 374
        90 272
        422 58
        205 240
        254 182
        305 403
        258 425
        291 61
        215 0
        22 406
        46 36
        217 327
        282 31
        347 167
        231 424
        145 29
        385 429
        34 29
        328 351
        319 228
        348 263
        136 273
        374 172
        360 56
        8 164
        413 82
        368 352
        66 55
        108 362
        43 78
        7 155
        61 9
        185 232
        99 135
        336 80
        18 87
        314 276
        104 75
        359 388
        131 240
        91 156
        333 165
        355 361
        114 295
        21 410
        174 146
        23 412
        208 247
        49 54
        310 417
        211 214
        8 223
        408 255
        239 107
        313 418
        248 405
        383 192
        211 365
        150 307
        234 139
        385 354
        144 117
        186 4
        355 147
        300 175
        197 30
        258 326
        300 339
        412 89
        404 112
        198 110
        425 64
        120 24
        9 161
        252 339
        168 113
        129 74
        185 79
        304 308
        392 230
        79 241
        312 313
        73 86
        84 351
        211 136
        337 241
        249 281
        233 20
        192 60
        251 229
        23 192
        138 214
        200 222
        403 57
        345 384
        419 62
        205 176
        349 387
        328 234
        128 10
        135 148
        250 418
        142 112
        2 218
        322 268
        71 31
        249 164
        431 11
        172 421
        236 402
        45 52
        114 190
        308 315
        260 141
        208 414
        294 74
        253 127
        226 302
        325 232
        378 187
        316 35
        266 428
        189 241
        267 1
        223 18
        410 155
        226 20
        427 312
        390 196
        381 188
        340 55
        203 53
        317 147
        355 298
        167 54
        106 229
        32 138
        15 314
        246 323
        52 140
        377 242
        358 63
        410 406
        50 354
        415 408
        51 284
        210 58
        257 146
        258 148
        148 188
        115 184
        401 134
        67 26
        278 305
        171 429
        87 373
        37 260
        423 256
        297 237
        115 364
        41 166
        251 26
        236 243
        152 165
        398 196
        108 269
        142 44
        344 320
        287 118
        259 101
        73 203
        371 350
        162 317
        402 82
        5 292
        99 82
        414 12
        364 111
        8 258
        16 113
        105 278
        123 35
        134 16
        210 107
        162 393
        397 219
        346 382
        411 71
        28 326
        356 313
        216 362
        377 156
        341 92
        277 237
        289 111
        62 301
        39 123
        178 393
        380 421
        372 366
        213 180
        378 51
        385 80
        312 127
        421 86
        343 26
        178 284
        273 170
        340 307
        169 143
        426 95
        38 191
        51 399
        221 307
        324 352
        363 339
        287 384
        290 387
        267 191
        158 252
        198 353
        46 100
        45 91
        11 85
        130 83
        3 166
        264 272
        32 270
        22 35
        46 334
        48 318
        347 95
        122 352
        349 369
        283 16
        5 426
        162 198
        140 265
        214 403
        327 77
        380 203
        335 218
        129 186
        146 302
        215 191
        310 265
        69 204
        5 65
        171 230
        66 221
        251 264
        379 361
        340 149
        286 24
        86 222
        409 293
        415 294
        77 111
        175 65
        386 20
        235 160
        236 157
        145 431
        126 324
        335 133
        98 353
        367 12
        76 219
        132 217
        133 83
        205 222
        290 306
        247 24
        238 53
        195 83
        70 337
        338 72
        280 11
        176 241
        200 139
        120 159
        167 348
        104 2
        23 88
        404 134
        229 90
        156 140
        356 358
        397 293
        414 286
        225 56
        161 284
        303 6
        209 103
        227 357
        304 7
        141 187
        249 261
        380 75
        154 268
        208 372
        259 384
        303 109
        213 49
        41 310
        365 143
        297 283
        296 98
        221 24
        328 325
        181 2
        235 6
        97 70
        423 163
        61 51
        263 252
        282 286
        341 159
        216 415
        238 220
        271 178
        291 135
        204 196
        216 105
        254 334
        43 104
        176 63
        96 58
        130 368
        15 113
        34 429
        373 243
        231 404
        237 338
        202 269
        121 218
        206 227
        213 331
        232 263
        285 330
        73 123
        371 308
        116 400
        285 247
        328 63
        154 317
        215 394
        242 134
        426 418
        19 400
        150 139
        409 181
        412 182
        171 193
        345 10
        37 379
        254 93
        289 209
        210 295
        312 57
        199 148
        251 303
        48 147
        318 74
        32 262
        27 323
        344 159
        324 407
        346 173
        245 11
        179 80
        116 226
        248 80
        355 269
        279 352
        110 59
        280 378
        180 4
        42 368
        137 49
        413 393
        217 163
        358 257
        244 165
        41 377
        32 169
        189 35
        413 212
        336 392
        422 359
        427 19
        113 112
        141 29
        213 74
        182 82
        106 357
        47 331
        153 34
        409 25
        116 282
        394 255
        193 110
        391 303
        419 181
        360 401
        225 100
        102 128
        250 263
        38 57
        276 40
        69 401
        17 348
        411 240
        13 342
        180 361
        125 127
        224 203
        45 195
        296 383
        423 77
        300 143
        235 26
        122 33
        """

        self.waters = """
        0.19325 0.47582 0.61234
        0.5 0.44664 0.92213
        0.625 0.11959 0.5046
        0.0 0.94664 0.92213
        0.68176 0.57267 0.37596
        0.68176 0.42953 0.11609
        0.81991 0.16543 0.62209
        0.375 0.22515 0.99942
        0.1856 0.86507 0.80921
        0.3106 0.78264 0.62437
        0.68176 0.50704 0.69113
        0.0 0.77766 0.88923
        0.5 0.27766 0.88923
        0.3106 0.74522 0.81076
        0.81825 0.00704 0.69113
        0.81825 0.96271 0.5026
        0.625 0.94773 0.3063
        0.80509 0.4109 0.32128
        0.1856 0.82051 0.62258
        0.68176 0.42733 0.87596
        0.6856 0.32051 0.62258
        0.0 0.22263 0.23245
        0.19491 0.30733 0.20088
        0.5 0.72263 0.23245
        0.3144 0.32051 0.62258
        0.69491 0.0891 0.82128
        0.81991 0.2057 0.8116
        0.375 0.59784 0.28076
        0.3106 0.78291 0.99651
        0.68009 0.7057 0.8116
        0.30509 0.0891 0.82128
        0.5 0.31621 0.93544
        0.375 0.57424 0.0324
        0.875 0.07424 0.0324
        0.80509 0.69265 0.92195
        0.31991 0.2943 0.3116
        0.81991 0.7943 0.3116
        0.0 0.63763 0.70947
        0.19325 0.52493 0.89192
        0.1856 0.24193 0.43576
        0.875 0.90217 0.78076
        0.30676 0.91784 0.99052
        0.6894 0.14833 0.20161
        0.8144 0.13493 0.30921
        0.30676 0.04346 0.31556
        0.81825 0.99296 0.19113
        0.0 0.81471 0.31239
        0.0 0.49368 0.56251
        0.1894 0.64719 0.41849
        0.0 0.53739 0.39073
        0.125 0.61698 0.12394
        0.6894 0.78264 0.62437
        0.69325 0.95954 0.18069
        0.5 0.16664 0.37223
        0.0 0.49448 0.43751
        0.5 0.38257 0.3902
        0.0 0.88257 0.3902
        0.0 0.50552 0.93751
        0.18176 0.07267 0.37596
        0.3144 0.67949 0.12258
        0.6856 0.67949 0.12258
        0.5 0.78994 0.70284
        0.30509 0.13081 0.62989
        0.80509 0.36919 0.12989
        0.30509 0.86919 0.12989
        0.5 0.44509 0.0767
        0.5 0.33973 0.43561
        0.8106 0.24522 0.81076
        0.0 0.83973 0.43561
        0.5 0.88798 0.321
        0.3144 0.32194 0.99625
        0.6856 0.32194 0.99625
        0.8144 0.82194 0.99625
        0.5 0.23569 0.31071
        0.19325 0.58216 0.49052
        0.8144 0.17806 0.49625
        0.30676 0.04046 0.68069
        0.30676 0.02493 0.89192
        0.875 0.09784 0.28076
        0.5 0.38402 0.23494
        0.80509 0.62821 0.99923
        0.0 0.11743 0.8902
        0.625 0.77512 0.12157
        0.625 0.05528 0.19117
        0.125 0.38042 0.0046
        0.0 0.81621 0.93544
        0.6894 0.25479 0.31076
        0.18009 0.83314 0.49842
        0.5 0.72234 0.38923
        0.1894 0.75479 0.31076
        0.30509 0.19265 0.92195
        0.0 0.98666 0.12699
        0.375 0.40217 0.78076
        0.18009 0.83457 0.12209
        0.18009 0.899 0.19521
        0.68176 0.49296 0.19113
        0.0 0.05337 0.42213
        0.1894 0.28291 0.99651
        0.1894 0.64833 0.20161
        0.6894 0.78291 0.99651
        0.0 0.84146 0.18713
        0.68009 0.40129 0.4367
        0.68176 0.57047 0.61609
        0.375 0.05227 0.8063
        0.6894 0.14719 0.41849
        0.68009 0.601 0.69521
        0.30509 0.19267 0.70088
        0.25 0.08593 0.15683
        0.68009 0.66543 0.62209
        0.18009 0.16543 0.62209
        0.1894 0.71736 0.12437
        0.5 0.00552 0.93751
        0.5 0.99448 0.43751
        0.69325 0.97508 0.39192
        0.0 0.15878 0.30866
        0.30676 0.02418 0.11234
        0.6856 0.36507 0.80921
        0.3144 0.36507 0.80921
        0.5 0.51334 0.62699
        0.0 0.01334 0.62699
        0.1894 0.35167 0.70161
        0.5 0.05844 0.49098
        0.81991 0.09871 0.9367
        0.3106 0.25479 0.31076
        0.875 0.44473 0.69117
        0.31825 0.42733 0.87596
        0.5 0.11202 0.821
        0.19325 0.45654 0.81556
        0.80676 0.54046 0.68069
        0.31825 0.57267 0.37596
        0.75 0.08593 0.15683
        0.8144 0.2425 0.18576
        0.81825 0.03729 0.0026
        0.69325 0.04346 0.31556
        0.375 0.94773 0.3063
        0.5 0.78992 0.91821
        0.875 0.55528 0.19117
        0.80676 0.54346 0.31556
        0.625 0.57424 0.0324
        0.0 0.32728 0.37627
        0.81825 0.92953 0.11609
        0.80509 0.69267 0.70088
        0.5 0.03739 0.39073
        0.19325 0.52418 0.11234
        0.1894 0.35281 0.91849
        0.6894 0.74522 0.81076
        0.0 0.33336 0.87223
        0.0 0.66664 0.37223
        0.5 0.83336 0.87223
        0.375 0.42576 0.5324
        0.0 0.36642 0.42355
        0.69325 0.97582 0.61234
        0.625 0.94473 0.69117
        0.875 0.72515 0.99942
        0.1894 0.71709 0.49651
        0.3106 0.21736 0.12437
        0.0 0.94509 0.0767
        0.5 0.86237 0.20947
        0.31825 0.46271 0.5026
        0.125 0.38302 0.62394
        0.5 0.17303 0.74841
        0.375 0.77485 0.49942
        0.0 0.73569 0.31071
        0.0 0.98976 0.87699
        0.125 0.90217 0.78076
        0.69325 0.95654 0.81556
        0.18176 0.92733 0.87596
        0.80676 0.47508 0.39192
        0.81825 0.00475 0.31613
        0.31825 0.53729 0.0026
        0.19325 0.54346 0.31556
        0.19491 0.69265 0.92195
        0.0 0.22234 0.38923
        0.0 0.81447 0.68392
        0.0 0.28992 0.91821
        0.5 0.48666 0.12699
        0.68009 0.33457 0.12209
        0.3144 0.74193 0.43576
        0.6856 0.74193 0.43576
        0.875 0.61698 0.12394
        0.80676 0.58216 0.49052
        0.69491 0.13081 0.62989
        0.375 0.77512 0.12157
        0.19491 0.63081 0.62989
        0.375 0.05528 0.19117
        0.31991 0.399 0.19521
        0.5 0.55337 0.42213
        0.875 0.72488 0.62157
        0.5 0.83367 0.75008
        0.5 0.31471 0.31239
        0.0 0.18553 0.18392
        0.31825 0.49525 0.81613
        0.5 0.68553 0.18392
        0.125 0.72515 0.99942
        0.18009 0.101 0.69521
        0.69325 0.02418 0.11234
        0.69491 0.87179 0.49923
        0.18009 0.09871 0.9367
        0.0 0.71006 0.20284
        0.6894 0.85281 0.91849
        0.80509 0.30735 0.42195
        0.5 0.68529 0.81239
        0.5 0.6838 0.43544
        0.5 0.21008 0.41821
        0.5 0.86642 0.42355
        0.80509 0.30733 0.20088
        0.6856 0.2575 0.68576
        0.0 0.28994 0.70284
        0.3144 0.2575 0.68576
        0.625 0.05227 0.8063
        0.125 0.09784 0.28076
        0.80676 0.52418 0.11234
        0.8106 0.71736 0.12437
        0.0 0.55844 0.49098
        0.68176 0.53729 0.0026
        0.31825 0.50704 0.69113
        0.5 0.61598 0.73494
        0.0 0.01369 0.00199
        0.69325 0.08216 0.49052
        0.5 0.03284 0.60129
        0.1856 0.17806 0.49625
        0.31991 0.33314 0.49842
        0.68009 0.2943 0.3116
        0.3106 0.85167 0.70161
        0.3106 0.21709 0.49651
        0.0 0.88402 0.23494
        0.8106 0.35167 0.70161
        0.625 0.22488 0.62157
        0.125 0.72488 0.62157
        0.18009 0.2057 0.8116
        0.31991 0.66686 0.99842
        0.18176 0.00475 0.31613
        0.19491 0.4109 0.32128
        0.68009 0.33314 0.49842
        0.0 0.32697 0.24841
        0.69491 0.19267 0.70088
        0.5 0.82697 0.24841
        0.69491 0.86919 0.12989
        0.3106 0.14719 0.41849
        0.375 0.11698 0.12394
        0.875 0.27512 0.12157
        0.5 0.34146 0.18713
        0.30676 0.95954 0.18069
        0.5 0.82728 0.37627
        0.81825 0.99525 0.81613
        0.1856 0.75808 0.93576
        0.75 0.58593 0.15683
        0.1894 0.28264 0.62437
        0.68009 0.59871 0.9367
        0.25 0.91407 0.65683
        0.19325 0.45954 0.18069
        0.0 0.18529 0.81239
        0.19325 0.47508 0.39192
        0.125 0.44473 0.69117
        0.30509 0.80733 0.20088
        0.125 0.55227 0.8063
        0.18176 0.00704 0.69113
        0.8106 0.35281 0.91849
        0.3106 0.85281 0.91849
        0.625 0.42576 0.5324
        0.0 0.67303 0.74841
        0.125 0.92576 0.5324
        0.31991 0.59871 0.9367
        0.125 0.44773 0.3063
        0.0 0.16028 0.93561
        0.69325 0.91784 0.99052
        0.375 0.94473 0.69117
        0.5 0.48976 0.87699
        0.3144 0.67806 0.49625
        0.6856 0.67806 0.49625
        0.25 0.58593 0.15683
        0.8106 0.71709 0.49651
        0.18009 0.16686 0.99842
        0.125 0.55528 0.19117
        0.3106 0.14833 0.20161
        0.81991 0.90129 0.4367
        0.75 0.91407 0.65683
        0.625 0.88042 0.0046
        0.80509 0.5891 0.82128
        0.81991 0.16686 0.99842
        0.0 0.77737 0.73245
        0.375 0.88302 0.62394
        0.5 0.34122 0.80866
        0.69491 0.9109 0.32128
        0.625 0.77485 0.49942
        0.125 0.27485 0.49942
        0.5 0.31447 0.68392
        0.5 0.48631 0.50199
        0.0 0.26431 0.81071
        0.69325 0.02493 0.89192
        0.0 0.98631 0.50199
        0.5 0.76431 0.81071
        0.68009 0.399 0.19521
        0.81825 0.07047 0.61609
        0.31825 0.57047 0.61609
        0.1856 0.13493 0.30921
        0.3144 0.63493 0.30921
        0.81991 0.899 0.19521
        0.6856 0.63493 0.30921
        0.125 0.07424 0.0324
        0.31825 0.49296 0.19113
        0.375 0.11959 0.5046
        0.0 0.33367 0.75008
        0.0 0.15854 0.68713
        0.625 0.22515 0.99942
        0.875 0.55227 0.8063
        0.0 0.01024 0.37699
        0.19491 0.37179 0.49923
        0.6894 0.21736 0.12437
        0.75 0.41407 0.65683
        0.5 0.94156 0.99098
        0.5 0.96261 0.89073
        0.0 0.46261 0.89073
        0.0 0.44156 0.99098
        0.875 0.92576 0.5324
        0.8144 0.17949 0.12258
        0.19491 0.30735 0.42195
        0.0 0.71008 0.41821
        0.125 0.61959 0.5046
        0.1856 0.7575 0.68576
        0.80509 0.37179 0.49923
        0.30509 0.87179 0.49923
        0.31991 0.66543 0.62209
        0.625 0.59784 0.28076
        0.5 0.13358 0.92355
        0.0 0.38798 0.321
        0.1856 0.82194 0.99625
        0.18176 0.03729 0.0026
        0.0 0.36237 0.20947
        0.5 0.51369 0.00199
        0.875 0.27485 0.49942
        0.0 0.53284 0.60129
        0.19325 0.41784 0.99052
        0.81825 0.92733 0.87596
        0.18009 0.7943 0.3116
        0.81825 0.07267 0.37596
        0.68009 0.66686 0.99842
        0.31991 0.33457 0.12209
        0.81991 0.83457 0.12209
        0.31825 0.50475 0.31613
        0.31991 0.40129 0.4367
        0.25 0.41407 0.65683
        0.31991 0.7057 0.8116
        0.69491 0.19265 0.92195
        0.875 0.38302 0.62394
        0.80676 0.47582 0.61234
        0.0 0.84122 0.80866
        0.68176 0.50475 0.31613
        0.875 0.44773 0.3063
        0.30676 0.97582 0.61234
        0.5 0.16633 0.25008
        0.19491 0.36919 0.12989
        0.69491 0.12821 0.99923
        0.0 0.66633 0.25008
        0.19491 0.62821 0.99923
        0.8106 0.64719 0.41849
        0.80676 0.41784 0.99052
        0.375 0.22488 0.62157
        0.875 0.38042 0.0046
        0.18176 0.07047 0.61609
        0.18009 0.90129 0.4367
        0.875 0.61959 0.5046
        0.5 0.65854 0.68713
        0.5 0.51024 0.37699
        0.5 0.00632 0.06251
        0.0 0.50632 0.06251
        0.3144 0.25808 0.93576
        0.6856 0.25808 0.93576
        0.625 0.11698 0.12394
        0.5 0.99368 0.56251
        0.31825 0.42953 0.11609
        0.5 0.21006 0.20284
        0.1894 0.24522 0.81076
        0.30509 0.80735 0.42195
        0.0 0.1838 0.43544
        0.69491 0.80735 0.42195
        0.1856 0.17949 0.12258
        0.18176 0.92953 0.11609
        0.8144 0.7575 0.68576
        0.80509 0.63081 0.62989
        0.6894 0.21709 0.49651
        0.6894 0.85167 0.70161
        0.8144 0.86507 0.80921
        0.5 0.65878 0.30866
        0.68176 0.46271 0.5026
        0.0 0.63358 0.92355
        0.8106 0.28264 0.62437
        0.18176 0.96271 0.5026
        0.0 0.05491 0.5767
        0.5 0.55491 0.5767
        0.625 0.88302 0.62394
        0.0 0.11598 0.73494
        0.5 0.66028 0.93561
        0.8106 0.75479 0.31076
        0.19325 0.54046 0.68069
        0.68176 0.49525 0.81613
        0.0 0.61202 0.821
        0.69325 0.04046 0.68069
        0.81991 0.83314 0.49842
        0.8144 0.82051 0.62258
        0.625 0.40217 0.78076
        0.30509 0.9109 0.32128
        0.69491 0.80733 0.20088
        0.80676 0.52493 0.89192
        0.30676 0.97508 0.39192
        0.5 0.61743 0.8902
        0.125 0.27512 0.12157
        0.30509 0.12821 0.99923
        0.19491 0.5891 0.82128
        0.81991 0.101 0.69521
        0.1856 0.2425 0.18576
        0.8106 0.28291 0.99651
        0.3144 0.7425 0.18576
        0.6856 0.7425 0.18576
        0.5 0.27737 0.73245
        0.31991 0.601 0.69521
        0.8106 0.64833 0.20161
        0.5 0.96716 0.10129
        0.0 0.46716 0.10129
        0.5 0.13763 0.70947
        0.19491 0.69267 0.70088
        0.8144 0.24193 0.43576
        0.30676 0.08216 0.49052
        0.18176 0.99525 0.81613
        0.18176 0.99296 0.19113
        0.375 0.88042 0.0046
        0.80676 0.45954 0.18069
        0.80676 0.45654 0.81556
        0.30676 0.95654 0.81556
        0.0 0.67272 0.87627
        0.5 0.17272 0.87627
        0.8144 0.75808 0.93576
        """

        self.coord = "relative"

        self.cages = """
        15 0.0 0.42917 0.50021
        12 -0.24239 0.19623 1.31087
        12 -0.5 -0.17206 0.5655
        14 0.5 0.45214 0.69707
        12 -0.27965 -0.35428 0.81424
        16 0.0 0.11844 0.49592
        12 0.27965 0.35428 0.31424
        12 0.5 0.0858 0.6553
        12 0.24239 0.19623 0.31087
        12 -0.27965 0.35428 1.31424
        12 0.5 0.17329 0.55409
        12 0.77965 0.14572 0.81424
        16 0.0 0.22428 0.6241
        14 0.0 -0.12423 0.61696
        12 0.0 0.32671 0.05409
        12 0.25761 0.69623 1.31087
        12 0.5 0.77262 0.31108
        16 0.0 0.22543 0.99699
        16 1.0 0.77572 0.1241
        16 0.5 0.27457 0.49699
        12 0.27298 0.52358 1.49776
        12 0.5 0.9142 0.1553
        12 0.22035 0.14572 0.81424
        12 -0.22702 -0.02358 0.99776
        15 1.0 0.57083 0.00021
        16 0.5 0.61844 0.49592
        12 0.5 0.22738 0.81108
        12 0.22035 0.85428 1.31424
        14 0.0 0.04786 0.19707
        12 0.0 -0.32671 0.55409
        12 0.22702 -0.02358 0.99776
        14 0.0 0.12423 0.11696
        16 -0.5 -0.44595 0.81537
        12 0.72702 0.52358 0.49776
        12 0.0 0.27262 0.31108
        16 0.0 0.05405 0.81537
        15 0.0 0.39919 0.81309
        16 0.0 -0.11844 0.99592
        16 1.0 0.94595 0.31537
        15 -0.5 -0.07083 0.50021
        12 0.0 0.32794 0.5655
        16 1.0 0.77457 0.49699
        14 0.0 -0.04786 0.69707
        12 0.27298 0.47642 0.99776
        12 0.77965 0.85428 0.31424
        12 0.0 0.4142 0.1553
        12 1.0 0.5016 0.25432
        14 0.5 0.54786 0.19707
        16 -0.5 -0.27457 0.99699
        12 1.0 0.67206 0.0655
        15 0.5 0.07083 0.00021
        12 -0.24239 -0.19623 0.81087
        15 1.0 0.60081 0.31309
        12 0.22702 0.02358 0.49776
        16 0.5 0.27572 0.1241
        12 -0.5 -0.0016 0.75432
        12 0.74239 0.30377 0.81087
        15 -0.5 -0.10081 0.81309
        12 -0.22702 0.02358 1.49776
        12 0.74239 0.69623 0.31087
        12 0.0 -0.4142 0.6553
        12 0.5 0.0016 0.25432
        12 0.0 -0.27262 0.81108
        12 0.5 0.17206 0.0655
        12 0.27965 -0.35428 0.81424
        16 -0.5 -0.27572 0.6241
        14 0.5 0.37577 0.61696
        12 0.72702 0.47642 0.99776
        14 0.5 0.62423 0.11696
        15 0.5 0.10081 0.31309
        16 0.5 0.38156 0.99592
        12 0.25761 0.30377 0.81087
        12 0.5 0.82671 0.05409
        12 0.0 0.4984 0.75432
        12 0.24239 -0.19623 0.81087
        16 0.5 0.44595 0.31537
        """

        self.bondlen = 3

        self.cell = """
        13.731569829815731 77.03407388750867 22.594324078914617
        """

        self.density = 0.5402727849311529

        self.cell = cellvectors(a=13.731569829815731,
                                b=77.03407388750867,
                                c=22.594324078914617)
