import xml.etree.ElementTree as etree
from types import TracebackType
from typing import Any, Optional, Type

class Node:
    def __init__(self, builder: etree.TreeBuilder) -> None: ...

class Tag(Node):
    name: Any = ...
    attrs: Any = ...
    def __init__(self, builder: etree.TreeBuilder, name: str, **attrs: str) -> None: ...
    def __enter__(self) -> Tag: ...
    def __exit__(
        self,
        type: Optional[Type[BaseException]],
        value: Optional[BaseException],
        traceback: Optional[TracebackType],
    ) -> None: ...

class Text(Node):
    def __init__(self, builder: etree.TreeBuilder, data: str) -> None: ...

class Builder:
    def __init__(self) -> None: ...
    def tag(self, name: str, **attrs: str) -> Tag: ...
    def text(self, data: str) -> Text: ...
    def build(self) -> etree.Element: ...
