/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.plantuml.StringUtils;

public enum DayOfWeek {
    MONDAY(2),
    TUESDAY(3),
    WEDNESDAY(4),
    THURSDAY(5),
    FRIDAY(6),
    SATURDAY(7),
    SUNDAY(1);

    private static final Calendar gmt;
    private static final SimpleDateFormat dateFormatGmt;
    private final int legacy;

    private DayOfWeek(int legacy) {
        this.legacy = legacy;
    }

    public int getLegacyJavaValue() {
        return this.legacy;
    }

    public static synchronized DayOfWeek fromTime(long time) {
        gmt.setTimeInMillis(time);
        int result = gmt.get(7);
        if (result == 1) {
            return SUNDAY;
        }
        return DayOfWeek.values()[result - 2];
    }

    public static synchronized String timeToString(long value) {
        gmt.setTimeInMillis(value);
        return DayOfWeek.fromTime(value).shortName() + " " + dateFormatGmt.format(gmt.getTime());
    }

    public static String getRegexString() {
        StringBuilder sb = new StringBuilder();
        for (DayOfWeek day : DayOfWeek.values()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(day.name().substring(0, 3) + "[a-z]*");
        }
        return sb.toString();
    }

    public static DayOfWeek fromString(String value) {
        value = StringUtils.goUpperCase(value).substring(0, 3);
        for (DayOfWeek day : DayOfWeek.values()) {
            if (!day.name().startsWith(value)) continue;
            return day;
        }
        throw new IllegalArgumentException();
    }

    public DayOfWeek next() {
        return DayOfWeek.values()[(this.ordinal() + 1) % 7];
    }

    public static DayOfWeek fromH(int h) {
        return DayOfWeek.values()[(h + 5) % 7];
    }

    public String shortName() {
        return StringUtils.capitalize(this.name().substring(0, 2));
    }

    static {
        gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateFormatGmt = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS", Locale.US);
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

