/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.lang.ComplementClose;
import net.sourceforge.plantuml.project.lang.ComplementInColors2;
import net.sourceforge.plantuml.project.lang.ComplementNamed;
import net.sourceforge.plantuml.project.lang.ComplementOpen;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SubjectDaysAsDates
implements Subject {
    @Override
    public IRegex toRegex() {
        return new RegexOr(this.regexTo(), this.regexAnd(), this.regexThen());
    }

    private IRegex regexTo() {
        return new RegexConcat(new RegexLeaf("YEAR1", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH1", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY1", "([\\d]{1,2})"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("to"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("YEAR2", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH2", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY2", "([\\d]{1,2})"));
    }

    private IRegex regexAnd() {
        return new RegexConcat(new RegexLeaf("YEAR3", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH3", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY3", "([\\d]{1,2})"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("COUNT_AND", "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"));
    }

    private IRegex regexThen() {
        return new RegexConcat(new RegexLeaf("then"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("COUNT_THEN", "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"));
    }

    public Failable<DaysAsDates> getMe(GanttDiagram project, RegexResult arg) {
        String countAnd = arg.get("COUNT_AND", 0);
        if (countAnd != null) {
            Day date3 = this.getDate(arg, "3");
            int nb = Integer.parseInt(countAnd);
            return Failable.ok(new DaysAsDates(project, date3, nb));
        }
        String countThen = arg.get("COUNT_THEN", 0);
        if (countThen != null) {
            Day date3 = project.getThenDate();
            int nb = Integer.parseInt(countThen);
            return Failable.ok(new DaysAsDates(project, date3, nb));
        }
        Day date1 = this.getDate(arg, "1");
        Day date2 = this.getDate(arg, "2");
        return Failable.ok(new DaysAsDates(date1, date2));
    }

    private Day getDate(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DAY" + suffix, 0));
        int month = Integer.parseInt(arg.get("MONTH" + suffix, 0));
        int year = Integer.parseInt(arg.get("YEAR" + suffix, 0));
        return Day.create(year, month, day);
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new Close(), new Open(), new InColor(), new Named());
    }

    class Named
    extends SentenceSimple {
        public Named() {
            super(SubjectDaysAsDates.this, Verbs.isOrAreNamed(), new ComplementNamed());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            String name = (String)complement;
            DaysAsDates days = (DaysAsDates)subject;
            for (Day d : days) {
                project.nameDay(d, name);
            }
            return CommandExecutionResult.ok();
        }
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectDaysAsDates.this, Verbs.isOrAre(), new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            for (Day d : (DaysAsDates)subject) {
                project.colorDay(d, color);
            }
            return CommandExecutionResult.ok();
        }
    }

    class Open
    extends SentenceSimple {
        public Open() {
            super(SubjectDaysAsDates.this, Verbs.isOrAre(), new ComplementOpen());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            for (Day d : (DaysAsDates)subject) {
                project.openDayAsDate(d);
            }
            return CommandExecutionResult.ok();
        }
    }

    class Close
    extends SentenceSimple {
        public Close() {
            super(SubjectDaysAsDates.this, Verbs.isOrAre(), new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            for (Day d : (DaysAsDates)subject) {
                project.closeDayAsDate(d);
            }
            return CommandExecutionResult.ok();
        }
    }
}

