/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class PSystemDedication
extends PlainDiagram {
    private final BufferedImage img;

    public PSystemDedication(BufferedImage img) {
        this.img = Objects.requireNonNull(img);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug.draw(new UImage(new PixelImage(PSystemDedication.this.img, AffineTransformType.TYPE_BILINEAR)));
            }
        };
    }

    public static BufferedImage getBufferedImage(InputStream is) {
        try {
            Class<?> clVP8Decoder = Class.forName("net.sourceforge.plantuml.webp.VP8Decoder");
            Object vp8Decoder = clVP8Decoder.newInstance();
            Method decodeFrame = clVP8Decoder.getMethod("decodeFrame", ImageInputStream.class);
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            decodeFrame.invoke(vp8Decoder, iis);
            iis.close();
            Object frame = clVP8Decoder.getMethod("getFrame", new Class[0]).invoke(vp8Decoder, new Object[0]);
            return (BufferedImage)frame.getClass().getMethod("getBufferedImage", new Class[0]).invoke(frame, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Dedication)");
    }
}

