/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class CommandCreoleSprite
implements Command {
    private final Pattern2 pattern;
    private final HColorSet colorSet;
    private final ThemeStyle themeStyle;

    private CommandCreoleSprite(ThemeStyle themeStyle, HColorSet colorSet, String p) {
        this.pattern = MyPattern.cmpile(p);
        this.colorSet = colorSet;
        this.themeStyle = themeStyle;
    }

    public static Command create(ThemeStyle themeStyle, HColorSet colorSet) {
        return new CommandCreoleSprite(themeStyle, colorSet, "^(?i)(\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String src = m.group(2);
        double scale = Parser.getScale(m.group(3), 1.0);
        String colorName = Parser.getColor(m.group(3));
        HColor color = null;
        if (colorName != null) {
            color = this.colorSet.getColorOrWhite(this.themeStyle, colorName);
        }
        stripe.addSprite(src, scale, color);
        return line.substring(m.group(1).length());
    }
}

